/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.abilities;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.stats.PlayerStats;
import net.minecraft.class_1657;

public abstract class Ability {
    protected final String id;
    protected final String name;
    protected final String description;
    protected final int manaCost;
    protected final int staminaCost;
    protected final int cooldownTicks;
    protected final PlayerStats.ClassType requiredClass;

    public Ability(String id, String name, String description, int manaCost, int staminaCost, int cooldownTicks, PlayerStats.ClassType requiredClass) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.manaCost = manaCost;
        this.staminaCost = staminaCost;
        this.cooldownTicks = cooldownTicks;
        this.requiredClass = requiredClass;
    }

    public boolean canUse(class_1657 player, char key) {
        if (!(player instanceof TessarectedPlayerStatsHolder)) {
            return false;
        }
        TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
        PlayerStats stats = holder.tessarected_getStats();
        if (stats.getClassType() != this.requiredClass && this.requiredClass != PlayerStats.ClassType.NONE) {
            return false;
        }
        return stats.canCastSpell(key, this.manaCost, this.staminaCost, this.cooldownTicks);
    }

    public boolean use(class_1657 player, char key) {
        if (!this.canUse(player, key)) {
            return false;
        }
        if (!(player instanceof TessarectedPlayerStatsHolder)) {
            return false;
        }
        TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
        PlayerStats stats = holder.tessarected_getStats();
        if (stats.getClassType() == PlayerStats.ClassType.ECHO && player.method_37908().field_9229.method_43057() < 0.15f) {
            this.executeAbility(player, stats);
            stats.setAbilityCooldown(key, this.cooldownTicks);
            return true;
        }
        stats.castSpell(key, this.manaCost, this.staminaCost, this.cooldownTicks, player);
        this.executeAbility(player, stats);
        return true;
    }

    protected abstract void executeAbility(class_1657 var1, PlayerStats var2);

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public int getStaminaCost() {
        return this.staminaCost;
    }

    public int getCooldownTicks() {
        return this.cooldownTicks;
    }

    public PlayerStats.ClassType getRequiredClass() {
        return this.requiredClass;
    }

    public String getTooltip() {
        return String.format("%s\n%s\nMana: %d | Stamina: %d | Cooldown: %.1fs", this.name, this.description, this.manaCost, this.staminaCost, Float.valueOf((float)this.cooldownTicks / 20.0f));
    }
}

