/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.abilities;

import com.tessarected.abilities.Ability;
import com.tessarected.abilities.echo.ChaosWaveAbility;
import com.tessarected.abilities.echo.MindBreakAbility;
import com.tessarected.abilities.echo.ShadowStrikeAbility;
import com.tessarected.abilities.echo.VoidEmbraceAbility;
import com.tessarected.abilities.guardian.AegisAbility;
import com.tessarected.abilities.guardian.FortressAbility;
import com.tessarected.abilities.guardian.ShieldBashAbility;
import com.tessarected.abilities.guardian.TauntAbility;
import com.tessarected.abilities.harvester.EnergyBoltAbility;
import com.tessarected.abilities.harvester.OverloadAbility;
import com.tessarected.abilities.harvester.PowerDrainAbility;
import com.tessarected.abilities.harvester.RealityRiftAbility;
import com.tessarected.abilities.mender.DivineLightAbility;
import com.tessarected.abilities.mender.HealAbility;
import com.tessarected.abilities.mender.PurifyAbility;
import com.tessarected.abilities.mender.SanctuaryAbility;
import com.tessarected.stats.PlayerStats;
import java.util.HashMap;
import java.util.Map;

public class AbilityRegistry {
    private static final Map<String, Ability> ABILITIES = new HashMap<String, Ability>();
    private static final Map<PlayerStats.ClassType, Ability[]> CLASS_ABILITIES = new HashMap<PlayerStats.ClassType, Ability[]>();

    private static void registerAbilities() {
        HealAbility heal = new HealAbility();
        SanctuaryAbility sanctuary = new SanctuaryAbility();
        PurifyAbility purify = new PurifyAbility();
        DivineLightAbility divineLight = new DivineLightAbility();
        EnergyBoltAbility energyBolt = new EnergyBoltAbility();
        PowerDrainAbility powerDrain = new PowerDrainAbility();
        OverloadAbility overload = new OverloadAbility();
        RealityRiftAbility realityRift = new RealityRiftAbility();
        ShadowStrikeAbility shadowStrike = new ShadowStrikeAbility();
        ChaosWaveAbility chaosWave = new ChaosWaveAbility();
        MindBreakAbility mindBreak = new MindBreakAbility();
        VoidEmbraceAbility voidEmbrace = new VoidEmbraceAbility();
        ShieldBashAbility shieldBash = new ShieldBashAbility();
        AegisAbility aegis = new AegisAbility();
        TauntAbility taunt = new TauntAbility();
        FortressAbility fortress = new FortressAbility();
        ABILITIES.put(heal.getId(), heal);
        ABILITIES.put(sanctuary.getId(), sanctuary);
        ABILITIES.put(purify.getId(), purify);
        ABILITIES.put(divineLight.getId(), divineLight);
        ABILITIES.put(energyBolt.getId(), energyBolt);
        ABILITIES.put(powerDrain.getId(), powerDrain);
        ABILITIES.put(overload.getId(), overload);
        ABILITIES.put(realityRift.getId(), realityRift);
        ABILITIES.put(shadowStrike.getId(), shadowStrike);
        ABILITIES.put(chaosWave.getId(), chaosWave);
        ABILITIES.put(mindBreak.getId(), mindBreak);
        ABILITIES.put(voidEmbrace.getId(), voidEmbrace);
        ABILITIES.put(shieldBash.getId(), shieldBash);
        ABILITIES.put(aegis.getId(), aegis);
        ABILITIES.put(taunt.getId(), taunt);
        ABILITIES.put(fortress.getId(), fortress);
        CLASS_ABILITIES.put(PlayerStats.ClassType.MENDER, new Ability[]{heal, sanctuary, purify, divineLight});
        CLASS_ABILITIES.put(PlayerStats.ClassType.HARVESTER, new Ability[]{energyBolt, powerDrain, overload, realityRift});
        CLASS_ABILITIES.put(PlayerStats.ClassType.ECHO, new Ability[]{shadowStrike, chaosWave, mindBreak, voidEmbrace});
        CLASS_ABILITIES.put(PlayerStats.ClassType.GUARDIAN, new Ability[]{shieldBash, aegis, taunt, fortress});
        CLASS_ABILITIES.put(PlayerStats.ClassType.NONE, new Ability[0]);
    }

    public static Ability getAbility(String id) {
        return ABILITIES.get(id);
    }

    public static Ability[] getClassAbilities(PlayerStats.ClassType classType) {
        return CLASS_ABILITIES.getOrDefault((Object)classType, new Ability[0]);
    }

    public static Ability getAbilityForKey(PlayerStats.ClassType classType, char key) {
        int index;
        Ability[] abilities = AbilityRegistry.getClassAbilities(classType);
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < abilities.length) {
            return abilities[index];
        }
        return null;
    }

    static {
        AbilityRegistry.registerAbilities();
    }
}

