/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.abilities;

import com.tessarected.abilities.Ability;
import com.tessarected.abilities.SpellAbilityManager;
import com.tessarected.combat.SpellSystem;
import com.tessarected.stats.PlayerStats;

public class SpellAbilityBridge {
    public static SpellSystem.SpellType getSpellTypeForAbility(Ability ability) {
        if (ability == null) {
            return null;
        }
        return SpellSystem.getSpellTypeFromAbilityId(ability.getId());
    }

    public static Ability getAbilityForSpellType(SpellSystem.SpellType spellType) {
        if (spellType == null) {
            return null;
        }
        return spellType.getAbility();
    }

    public static boolean areEquivalent(Ability ability, SpellSystem.SpellType spellType) {
        if (ability == null || spellType == null) {
            return false;
        }
        return ability.getId().equals(spellType.getAbilityId()) && ability.getManaCost() == spellType.getManaCost() && ability.getStaminaCost() == spellType.getStaminaCost() && ability.getCooldownTicks() == spellType.getCooldownTicks();
    }

    public static AbilityData getAbilityData(PlayerStats.ClassType classType, char key) {
        SpellSystem.SpellType spellType = SpellAbilityManager.getSpellTypeForKey(classType, key);
        if (spellType == null) {
            return null;
        }
        Ability ability = spellType.getAbility();
        return new AbilityData(spellType.getDisplayName(), ability != null ? ability.getDescription() : "Class ability", spellType.getManaCost(), spellType.getStaminaCost(), spellType.getCooldownTicks(), spellType.getAbilityId());
    }

    public static class AbilityData {
        public final String name;
        public final String description;
        public final int manaCost;
        public final int staminaCost;
        public final int cooldownTicks;
        public final String abilityId;

        public AbilityData(String name, String description, int manaCost, int staminaCost, int cooldownTicks, String abilityId) {
            this.name = name;
            this.description = description;
            this.manaCost = manaCost;
            this.staminaCost = staminaCost;
            this.cooldownTicks = cooldownTicks;
            this.abilityId = abilityId;
        }

        public String getTooltip() {
            return String.format("%s\n%s\nMana: %d | Stamina: %d | Cooldown: %.1fs", this.name, this.description, this.manaCost, this.staminaCost, Float.valueOf((float)this.cooldownTicks / 20.0f));
        }
    }
}

