/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.abilities;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.abilities.Ability;
import com.tessarected.combat.SpellSystem;
import com.tessarected.stats.PlayerStats;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SpellAbilityManager {
    public static boolean useSpellAbility(class_1657 player, char key) {
        SpellSystem.Spell spell;
        if (!(player instanceof TessarectedPlayerStatsHolder)) {
            return false;
        }
        TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
        PlayerStats stats = holder.tessarected_getStats();
        if (!stats.hasChosenClass()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You must choose a class first!"), false);
            }
            return false;
        }
        if (!stats.isAbilityUnlocked(key)) {
            int requiredLevel = SpellAbilityManager.getRequiredLevelForKey(key);
            if ((key == 'x' || key == 'X') && stats.isSkillNodeUnlocked("ability_unlock_x") && stats.getLevel() >= 3) {
                stats.setAbilityUnlocked(key, true, player);
            } else if ((key == 'c' || key == 'C') && stats.isSkillNodeUnlocked("ability_unlock_c") && stats.getLevel() >= 7) {
                stats.setAbilityUnlocked(key, true, player);
            } else {
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("Ability %c unlocks at level %d", Character.valueOf(Character.toUpperCase(key)), requiredLevel)), false);
                }
                return false;
            }
        }
        if ((spell = SpellSystem.createSpell(stats.getClassType(), key, player, stats)) == null) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"No ability assigned to this key!"), false);
            }
            return false;
        }
        if (stats.getAbilityCooldown(key) > 0) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                SpellSystem.SpellType spellType = SpellAbilityManager.getSpellTypeForKey(stats.getClassType(), key);
                if (spellType != null) {
                    float cooldownSeconds = (float)stats.getAbilityCooldown(key) / 20.0f;
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("%s on cooldown: %.1f seconds", spellType.getDisplayName(), Float.valueOf(cooldownSeconds))), true);
                }
            }
            return false;
        }
        boolean success = spell.cast(key);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            SpellSystem.SpellType spellType = SpellAbilityManager.getSpellTypeForKey(stats.getClassType(), key);
            if (spellType != null) {
                if (!success) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)String.format("Not enough resources! Need %d mana, %d stamina", spellType.getManaCost(), spellType.getStaminaCost())), true);
                } else {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Used: " + spellType.getDisplayName())), true);
                }
            }
        }
        return success;
    }

    public static SpellSystem.SpellType getSpellTypeForKey(PlayerStats.ClassType classType, char key) {
        int index;
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(classType);
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < spells.length) {
            return spells[index];
        }
        return null;
    }

    private static int getRequiredLevelForKey(char key) {
        return switch (Character.toLowerCase(key)) {
            case 'z' -> 1;
            case 'x' -> 5;
            case 'c' -> 10;
            case 'v' -> 15;
            default -> 999;
        };
    }

    public static String getAbilityTooltip(PlayerStats stats, char key) {
        SpellSystem.SpellType spellType = SpellAbilityManager.getSpellTypeForKey(stats.getClassType(), key);
        if (spellType == null) {
            return "No ability assigned";
        }
        Ability ability = spellType.getAbility();
        if (ability != null) {
            return ability.getTooltip();
        }
        ability = spellType.createAbilityInstance();
        if (ability != null) {
            return ability.getTooltip();
        }
        return String.format("%s\n%s\nMana: %d | Stamina: %d | Cooldown: %.1fs", spellType.getDisplayName(), "Individual ability class: " + spellType.getAbilityClass().getSimpleName(), spellType.getManaCost(), spellType.getStaminaCost(), Float.valueOf((float)spellType.getCooldownTicks() / 20.0f));
    }

    public static boolean canUseAbility(PlayerStats stats, char key) {
        SpellSystem.SpellType spellType = SpellAbilityManager.getSpellTypeForKey(stats.getClassType(), key);
        if (spellType == null) {
            return false;
        }
        return stats.canCastSpell(key, spellType.getManaCost(), spellType.getStaminaCost(), spellType.getCooldownTicks());
    }
}

