/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.combat;

import com.tessarected.DirectDamageAccess;
import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.combat.damage.DamageType;
import com.tessarected.stats.PlayerStats;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1657;

public class CombatSystem {
    public static CombatResult calculateDamage(class_1309 attacker, class_1309 target, float baseDamage, DamageType damageType, PlayerStats attackerStats) {
        Random random = new Random();
        PlayerStats targetStats = null;
        if (target instanceof class_1657 && target instanceof TessarectedPlayerStatsHolder) {
            TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)target;
            targetStats = holder.tessarected_getStats();
        }
        boolean wasDodged = false;
        if (targetStats != null) {
            float dodgeChance = targetStats.getDodgeChance();
            if (random.nextFloat() * 100.0f < dodgeChance) {
                wasDodged = true;
                return new CombatResult(0.0f, false, true, false, damageType);
            }
        }
        boolean wasCritical = false;
        float damage = baseDamage;
        if (attackerStats != null) {
            float critChance = attackerStats.getCriticalChance();
            if (random.nextFloat() * 100.0f < critChance) {
                wasCritical = true;
                damage *= attackerStats.getCriticalDamage();
            }
        }
        if (targetStats != null) {
            float typeModifier = targetStats.getDamageTypeModifier(damageType.getDisplayName());
            damage *= typeModifier;
        }
        boolean wasBlocked = false;
        if (targetStats != null) {
            float originalDamage = damage;
            boolean bl = wasBlocked = (damage = targetStats.takeDamage(damage, (class_1657)target)) < originalDamage * 0.8f;
        }
        if (attackerStats != null && attackerStats.getClassType() == PlayerStats.ClassType.HARVESTER && damage > 0.0f) {
            int manaGain = (int)(damage * 0.2f);
            attackerStats.setMana(attackerStats.getMana() + (float)manaGain, (class_1657)attacker);
        }
        return new CombatResult(damage, wasCritical, wasDodged, wasBlocked, damageType);
    }

    public static CombatResult dealDamage(class_1309 attacker, class_1309 target, float baseDamage, DamageType damageType, PlayerStats attackerStats) {
        CombatResult result = CombatSystem.calculateDamage(attacker, target, baseDamage, damageType, attackerStats);
        if (result.finalDamage > 0.0f && target instanceof DirectDamageAccess) {
            DirectDamageAccess directAccess = (DirectDamageAccess)target;
            directAccess.tessarected_directDamage(CombatSystem.getDamageSource(attacker, damageType), result.finalDamage);
        }
        return result;
    }

    private static class_1282 getDamageSource(class_1309 attacker, DamageType damageType) {
        return switch (damageType) {
            case DamageType.PHYSICAL -> attacker.method_48923().method_48802((class_1657)attacker);
            case DamageType.FIRE -> attacker.method_48923().method_48813();
            case DamageType.LIGHTNING -> attacker.method_48923().method_48809();
            case DamageType.ENERGY, DamageType.DARK, DamageType.HOLY, DamageType.CORRUPTION, DamageType.PSYCHIC, DamageType.VOID -> attacker.method_48923().method_48831();
            case DamageType.COLD -> attacker.method_48923().method_48836();
            default -> attacker.method_48923().method_48830();
        };
    }

    public static CombatResult performMeleeAttack(class_1657 player, class_1309 target, float weaponDamage) {
        if (!(player instanceof TessarectedPlayerStatsHolder)) {
            return new CombatResult(weaponDamage, false, false, false, DamageType.PHYSICAL);
        }
        TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
        PlayerStats stats = holder.tessarected_getStats();
        float finalDamage = stats.calculatePhysicalDamage(weaponDamage);
        return CombatSystem.calculateDamage((class_1309)player, target, finalDamage, DamageType.PHYSICAL, stats);
    }

    public static CombatResult performRangedAttack(class_1657 player, class_1309 target, float projectileDamage) {
        if (!(player instanceof TessarectedPlayerStatsHolder)) {
            return new CombatResult(projectileDamage, false, false, false, DamageType.PHYSICAL);
        }
        TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
        PlayerStats stats = holder.tessarected_getStats();
        float finalDamage = stats.calculatePhysicalDamage(projectileDamage * 0.8f);
        return CombatSystem.calculateDamage((class_1309)player, target, finalDamage, DamageType.PHYSICAL, stats);
    }

    public static class CombatResult {
        public final float finalDamage;
        public final boolean wasCritical;
        public final boolean wasDodged;
        public final boolean wasBlocked;
        public final DamageType damageType;

        public CombatResult(float finalDamage, boolean wasCritical, boolean wasDodged, boolean wasBlocked, DamageType damageType) {
            this.finalDamage = finalDamage;
            this.wasCritical = wasCritical;
            this.wasDodged = wasDodged;
            this.wasBlocked = wasBlocked;
            this.damageType = damageType;
        }
    }
}

