/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.combat;

import com.tessarected.Tessarected;
import com.tessarected.abilities.Ability;
import com.tessarected.abilities.AbilityRegistry;
import com.tessarected.abilities.echo.ChaosWaveAbility;
import com.tessarected.abilities.echo.MindBreakAbility;
import com.tessarected.abilities.echo.ShadowStrikeAbility;
import com.tessarected.abilities.echo.VoidEmbraceAbility;
import com.tessarected.abilities.guardian.AegisAbility;
import com.tessarected.abilities.guardian.FortressAbility;
import com.tessarected.abilities.guardian.ShieldBashAbility;
import com.tessarected.abilities.guardian.TauntAbility;
import com.tessarected.abilities.harvester.EnergyBoltAbility;
import com.tessarected.abilities.harvester.OverloadAbility;
import com.tessarected.abilities.harvester.PowerDrainAbility;
import com.tessarected.abilities.harvester.RealityRiftAbility;
import com.tessarected.abilities.mender.DivineLightAbility;
import com.tessarected.abilities.mender.HealAbility;
import com.tessarected.abilities.mender.PurifyAbility;
import com.tessarected.abilities.mender.SanctuaryAbility;
import com.tessarected.combat.damage.DamageType;
import com.tessarected.stats.PlayerStats;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class SpellSystem {
    public static SpellType[] getClassSpells(PlayerStats.ClassType classType) {
        SpellType[] spellTypeArray;
        switch (classType) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case MENDER: {
                SpellType[] spellTypeArray2 = new SpellType[4];
                spellTypeArray2[0] = SpellType.HEAL;
                spellTypeArray2[1] = SpellType.SANCTUARY;
                spellTypeArray2[2] = SpellType.PURIFY;
                spellTypeArray = spellTypeArray2;
                spellTypeArray2[3] = SpellType.DIVINE_LIGHT;
                break;
            }
            case HARVESTER: {
                SpellType[] spellTypeArray3 = new SpellType[4];
                spellTypeArray3[0] = SpellType.ENERGY_BOLT;
                spellTypeArray3[1] = SpellType.POWER_DRAIN;
                spellTypeArray3[2] = SpellType.OVERLOAD;
                spellTypeArray = spellTypeArray3;
                spellTypeArray3[3] = SpellType.REALITY_RIFT;
                break;
            }
            case ECHO: {
                SpellType[] spellTypeArray4 = new SpellType[4];
                spellTypeArray4[0] = SpellType.SHADOW_STRIKE;
                spellTypeArray4[1] = SpellType.CHAOS_WAVE;
                spellTypeArray4[2] = SpellType.MIND_BREAK;
                spellTypeArray = spellTypeArray4;
                spellTypeArray4[3] = SpellType.VOID_EMBRACE;
                break;
            }
            case GUARDIAN: {
                SpellType[] spellTypeArray5 = new SpellType[4];
                spellTypeArray5[0] = SpellType.SHIELD_BASH;
                spellTypeArray5[1] = SpellType.AEGIS;
                spellTypeArray5[2] = SpellType.TAUNT;
                spellTypeArray = spellTypeArray5;
                spellTypeArray5[3] = SpellType.FORTRESS;
                break;
            }
            case NONE: {
                spellTypeArray = new SpellType[]{};
            }
        }
        return spellTypeArray;
    }

    public static Ability[] getClassAbilities(PlayerStats.ClassType classType) {
        SpellType[] spells = SpellSystem.getClassSpells(classType);
        Ability[] abilities = new Ability[spells.length];
        for (int i = 0; i < spells.length; ++i) {
            abilities[i] = spells[i].getAbility();
            if (abilities[i] != null) continue;
            abilities[i] = spells[i].createAbilityInstance();
        }
        return abilities;
    }

    public static SpellType getSpellTypeFromAbilityId(String abilityId) {
        for (SpellType spellType : SpellType.values()) {
            if (!spellType.getAbilityId().equals(abilityId)) continue;
            return spellType;
        }
        return null;
    }

    public static Spell createSpell(PlayerStats.ClassType classType, char key, class_1657 caster, PlayerStats stats) {
        int index;
        SpellType[] spells = SpellSystem.getClassSpells(classType);
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < spells.length) {
            return new Spell(spells[index], caster, stats);
        }
        return null;
    }

    public static void verifyAbilityClasses() {
        Tessarected.LOGGER.info("Verifying individual ability classes...");
        for (SpellType spellType : SpellType.values()) {
            try {
                Ability ability = spellType.createAbilityInstance();
                if (ability != null) {
                    Tessarected.LOGGER.info("\u2713 " + spellType.getAbilityId() + " -> " + spellType.getAbilityClass().getSimpleName());
                    continue;
                }
                Tessarected.LOGGER.info("\u2717 " + spellType.getAbilityId() + " -> Failed to create instance");
            }
            catch (Exception e) {
                Tessarected.LOGGER.info("\u2717 " + spellType.getAbilityId() + " -> " + e.getMessage());
            }
        }
        Tessarected.LOGGER.info("Ability verification complete.");
    }

    public static enum SpellType {
        HEAL("Restoration", 25, 0, 100, DamageType.HEALING, "heal", HealAbility.class),
        SANCTUARY("Sacred Ground", 40, 0, 200, DamageType.HEALING, "sanctuary", SanctuaryAbility.class),
        PURIFY("Cleanse Corruption", 30, 15, 150, DamageType.HOLY, "purify", PurifyAbility.class),
        DIVINE_LIGHT("Radiant Burst", 50, 0, 300, DamageType.HOLY, "divine_light", DivineLightAbility.class),
        ENERGY_BOLT("Tesseract Bolt", 15, 5, 80, DamageType.ENERGY, "energy_bolt", EnergyBoltAbility.class),
        POWER_DRAIN("Siphon Energy", 20, 10, 120, DamageType.ENERGY, "power_drain", PowerDrainAbility.class),
        OVERLOAD("Energy Overload", 35, 20, 250, DamageType.ENERGY, "overload", OverloadAbility.class),
        REALITY_RIFT("Dimensional Tear", 60, 30, 400, DamageType.VOID, "reality_rift", RealityRiftAbility.class),
        SHADOW_STRIKE("Dark Impulse", 20, 15, 100, DamageType.DARK, "shadow_strike", ShadowStrikeAbility.class),
        CHAOS_WAVE("Corruption Pulse", 30, 20, 180, DamageType.CORRUPTION, "chaos_wave", ChaosWaveAbility.class),
        MIND_BREAK("Psychic Shatter", 25, 25, 200, DamageType.PSYCHIC, "mind_break", MindBreakAbility.class),
        VOID_EMBRACE("Embrace the Void", 45, 35, 350, DamageType.VOID, "void_embrace", VoidEmbraceAbility.class),
        SHIELD_BASH("Protective Strike", 10, 20, 60, DamageType.PHYSICAL, "shield_bash", ShieldBashAbility.class),
        AEGIS("Barrier of Light", 30, 15, 150, DamageType.PROTECTION, "aegis", AegisAbility.class),
        TAUNT("Challenge", 15, 10, 100, DamageType.NONE, "taunt", TauntAbility.class),
        FORTRESS("Unbreakable Will", 40, 25, 300, DamageType.PROTECTION, "fortress", FortressAbility.class);

        private final String displayName;
        private final int manaCost;
        private final int staminaCost;
        private final int cooldownTicks;
        private final DamageType damageType;
        private final String abilityId;
        private final Class<? extends Ability> abilityClass;

        private SpellType(String displayName, int manaCost, int staminaCost, int cooldownTicks, DamageType damageType, String abilityId, Class<? extends Ability> abilityClass) {
            this.displayName = displayName;
            this.manaCost = manaCost;
            this.staminaCost = staminaCost;
            this.cooldownTicks = cooldownTicks;
            this.damageType = damageType;
            this.abilityId = abilityId;
            this.abilityClass = abilityClass;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public int getManaCost() {
            return this.manaCost;
        }

        public int getStaminaCost() {
            return this.staminaCost;
        }

        public int getCooldownTicks() {
            return this.cooldownTicks;
        }

        public DamageType getDamageType() {
            return this.damageType;
        }

        public String getAbilityId() {
            return this.abilityId;
        }

        public Class<? extends Ability> getAbilityClass() {
            return this.abilityClass;
        }

        public Ability getAbility() {
            return AbilityRegistry.getAbility(this.abilityId);
        }

        public Ability createAbilityInstance() {
            try {
                return this.abilityClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.err.println("Failed to create ability instance for " + this.abilityId + ": " + e.getMessage());
                return null;
            }
        }
    }

    public static class Spell {
        private final SpellType spellType;
        private final class_1657 caster;
        private final PlayerStats stats;
        private final class_1937 world;
        private final Ability ability;

        public Spell(SpellType spellType, class_1657 caster, PlayerStats stats) {
            this.spellType = spellType;
            this.caster = caster;
            this.stats = stats;
            this.world = caster.method_37908();
            this.ability = spellType.getAbility() != null ? spellType.getAbility() : spellType.createAbilityInstance();
        }

        public boolean cast(char abilityKey) {
            if (this.ability != null) {
                return this.ability.use(this.caster, abilityKey);
            }
            System.err.println("Warning: No individual ability found for " + this.spellType.getAbilityId() + ", using legacy system");
            return this.castLegacySpell(abilityKey);
        }

        private boolean castLegacySpell(char abilityKey) {
            if (!this.stats.canCastSpell(abilityKey, this.spellType.getManaCost(), this.spellType.getStaminaCost(), this.spellType.getCooldownTicks())) {
                return false;
            }
            if (this.stats.getClassType() == PlayerStats.ClassType.ECHO) {
                Random random = new Random();
                if (random.nextFloat() < 0.15f) {
                    this.executeLegacySpellEffect();
                    this.stats.setAbilityCooldown(abilityKey, this.spellType.getCooldownTicks());
                    return true;
                }
            }
            this.stats.castSpell(abilityKey, this.spellType.getManaCost(), this.spellType.getStaminaCost(), this.spellType.getCooldownTicks(), this.caster);
            this.executeLegacySpellEffect();
            return true;
        }

        private void executeLegacySpellEffect() {
            System.err.println("Using legacy spell effect for " + this.spellType.getDisplayName() + " - consider implementing individual ability class");
            float spellPower = this.stats.getSpellPower();
            switch (this.spellType) {
                case HEAL: {
                    float healAmount = 8.0f + spellPower * 0.3f;
                    this.caster.method_6025(healAmount);
                    this.spawnParticles((class_2394)class_2398.field_11201, 10);
                    this.playSound(class_3417.field_14703);
                    break;
                }
                case SANCTUARY: {
                    float healAmount = 3.0f + spellPower * 0.1f;
                    List nearbyEntities = this.world.method_8390(class_1309.class, this.caster.method_5829().method_1014(8.0), entity -> entity instanceof class_1657);
                    for (class_1309 entity2 : nearbyEntities) {
                        entity2.method_6025(healAmount);
                    }
                    this.spawnParticles((class_2394)class_2398.field_11215, 20);
                    this.playSound(class_3417.field_15045);
                    break;
                }
                default: {
                    System.err.println("No legacy implementation for " + this.spellType.getDisplayName());
                    this.spawnParticles((class_2394)class_2398.field_11251, 5);
                    this.playSound((class_3414)class_3417.field_14622.comp_349());
                }
            }
        }

        private List<class_1309> getTargetsInRange(double range) {
            return this.world.method_8390(class_1309.class, this.caster.method_5829().method_1014(range), entity -> entity != this.caster && !entity.method_5722((class_1297)this.caster));
        }

        private class_1309 getTargetInLookDirection(double range) {
            class_243 start = this.caster.method_33571();
            class_243 direction = this.caster.method_5720();
            List entities = this.world.method_8390(class_1309.class, this.caster.method_5829().method_18804(direction.method_1021(range)).method_1014(1.0), entity -> entity != this.caster && !entity.method_5722((class_1297)this.caster));
            return entities.isEmpty() ? null : (class_1309)entities.get(0);
        }

        private void spawnParticles(class_2394 particle, int count) {
            if (this.world.field_9236) {
                return;
            }
            for (int i = 0; i < count; ++i) {
                double x = this.caster.method_23317() + (this.world.field_9229.method_43058() - 0.5) * 2.0;
                double y = this.caster.method_23318() + this.world.field_9229.method_43058() * 2.0;
                double z = this.caster.method_23321() + (this.world.field_9229.method_43058() - 0.5) * 2.0;
                ((class_3218)this.world).method_14199(particle, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            }
        }

        private void playSound(class_3414 sound) {
            this.world.method_8396(null, this.caster.method_24515(), sound, class_3419.field_15248, 1.0f, 1.0f);
        }
    }
}

