/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.combat.ability;

import com.tessarected.combat.SpellSystem;
import com.tessarected.stats.PlayerStats;
import net.minecraft.class_1657;

public class AbilityManager {
    private final class_1657 player;
    private final PlayerStats stats;
    private final SpellSystem.SpellType[] classSpells;

    public AbilityManager(class_1657 player, PlayerStats stats) {
        this.player = player;
        this.stats = stats;
        this.classSpells = SpellSystem.getClassSpells(stats.getClassType());
    }

    public boolean useAbility(char key) {
        if (!this.stats.isAbilityUnlocked(key)) {
            return false;
        }
        SpellSystem.SpellType spellType = this.getSpellForKey(key);
        if (spellType == null) {
            return false;
        }
        SpellSystem.Spell spell = new SpellSystem.Spell(spellType, this.player, this.stats);
        return spell.cast(key);
    }

    private SpellSystem.SpellType getSpellForKey(char key) {
        int index;
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < this.classSpells.length) {
            return this.classSpells[index];
        }
        return null;
    }

    public String getAbilityName(char key) {
        SpellSystem.SpellType spell = this.getSpellForKey(key);
        return spell != null ? spell.getDisplayName() : "None";
    }

    public String getAbilityDescription(char key) {
        SpellSystem.SpellType spell = this.getSpellForKey(key);
        if (spell == null) {
            return "No ability assigned";
        }
        return String.format("%s\nMana: %d | Stamina: %d | Cooldown: %.1fs", spell.getDisplayName(), spell.getManaCost(), spell.getStaminaCost(), Float.valueOf((float)spell.getCooldownTicks() / 20.0f));
    }

    public boolean canUseAbility(char key) {
        SpellSystem.SpellType spell = this.getSpellForKey(key);
        if (spell == null) {
            return false;
        }
        return this.stats.canCastSpell(key, spell.getManaCost(), spell.getStaminaCost(), spell.getCooldownTicks());
    }

    public float getCooldownProgress(char key) {
        int currentCooldown = this.stats.getAbilityCooldown(key);
        SpellSystem.SpellType spell = this.getSpellForKey(key);
        if (spell == null || currentCooldown <= 0) {
            return 1.0f;
        }
        return 1.0f - (float)currentCooldown / (float)spell.getCooldownTicks();
    }
}

