/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.entity;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.entity.ai.SunderedWraithAttackGoal;
import com.tessarected.entity.ai.SunderedWraithSummonSoulFireGoal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1331;
import net.minecraft.class_1333;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1432;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_8111;

public class SunderedWraithEntity
extends class_1588
implements class_1432 {
    private static final class_2940<Integer> ANIMATION_STATE = class_2945.method_12791(SunderedWraithEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_CHARGING = class_2945.method_12791(SunderedWraithEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> ATTACK_ANIMATION_PROGRESS = class_2945.method_12791(SunderedWraithEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> IS_CASTING_SOUL_FIRE = class_2945.method_12791(SunderedWraithEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Float> SOUL_FIRE_CAST_ANIMATION_PROGRESS = class_2945.method_12791(SunderedWraithEntity.class, (class_2941)class_2943.field_13320);
    public static final int ANIMATION_IDLE = 0;
    public static final int ANIMATION_ATTACK = 1;
    public static final int ANIMATION_SUMMON_SOUL_FIRE = 2;
    public static final int ANIMATION_FLY_TO_PLAYER = 3;
    public static final int ANIMATION_FLY = 4;
    private int attackCooldown = 0;
    private int soulFireCooldown = 0;
    private int stateTimer = 0;
    private int phaseCooldown = 0;
    private static final int ATTACK_ANIMATION_TICKS = 10;
    private static final int SOUL_FIRE_ANIMATION_TICKS = 24;

    public SunderedWraithEntity(class_1299<? extends SunderedWraithEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.field_6194 = 15;
        this.field_6207 = new class_1331((class_1308)this, 20, true);
        this.field_6206 = new class_1333((class_1308)this);
        this.method_5875(true);
        this.field_5960 = false;
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new SunderedWraithSummonSoulFireGoal(this));
        this.field_6201.method_6277(1, (class_1352)new SunderedWraithAttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new FlyAroundGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    public static class_5132.class_5133 createSunderedWraithAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, 0.5).method_26868(class_5134.field_23720, 1.6).method_26868(class_5134.field_23721, 6.0).method_26868(class_5134.field_23717, 35.0);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(ANIMATION_STATE, (Object)4);
        this.field_6011.method_12784(IS_CHARGING, (Object)false);
        this.field_6011.method_12784(ATTACK_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(IS_CASTING_SOUL_FIRE, (Object)false);
        this.field_6011.method_12784(SOUL_FIRE_CAST_ANIMATION_PROGRESS, (Object)Float.valueOf(0.0f));
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("AnimationState", this.getAnimationState());
        nbt.method_10556("IsCharging", this.isCharging());
        nbt.method_10569("AttackCooldown", this.attackCooldown);
        nbt.method_10569("SoulFireCooldown", this.soulFireCooldown);
        nbt.method_10548("AttackAnimationProgress", this.getAttackAnimationProgress());
        nbt.method_10556("IsCastingSoulFire", this.isCastingSoulFire());
        nbt.method_10548("SoulFireCastAnimationProgress", this.getSoulFireCastAnimationProgress());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setAnimationState(nbt.method_10550("AnimationState"));
        this.setCharging(nbt.method_10577("IsCharging"));
        this.attackCooldown = nbt.method_10550("AttackCooldown");
        this.soulFireCooldown = nbt.method_10550("SoulFireCooldown");
        this.setAttackAnimationProgress(nbt.method_10583("AttackAnimationProgress"));
        this.setCastingSoulFire(nbt.method_10577("IsCastingSoulFire"));
        this.setSoulFireCastAnimationProgress(nbt.method_10583("SoulFireCastAnimationProgress"));
    }

    public int getAnimationState() {
        return (Integer)this.field_6011.method_12789(ANIMATION_STATE);
    }

    public void setAnimationState(int state) {
        this.field_6011.method_12778(ANIMATION_STATE, (Object)state);
        this.stateTimer = 0;
    }

    public boolean isCharging() {
        return (Boolean)this.field_6011.method_12789(IS_CHARGING);
    }

    public void setCharging(boolean charging) {
        this.field_6011.method_12778(IS_CHARGING, (Object)charging);
    }

    public float getAttackAnimationProgress() {
        return ((Float)this.field_6011.method_12789(ATTACK_ANIMATION_PROGRESS)).floatValue();
    }

    public void setAttackAnimationProgress(float progress) {
        this.field_6011.method_12778(ATTACK_ANIMATION_PROGRESS, (Object)Float.valueOf(progress));
    }

    public boolean isCastingSoulFire() {
        return (Boolean)this.field_6011.method_12789(IS_CASTING_SOUL_FIRE);
    }

    public void setCastingSoulFire(boolean casting) {
        this.field_6011.method_12778(IS_CASTING_SOUL_FIRE, (Object)casting);
    }

    public float getSoulFireCastAnimationProgress() {
        return ((Float)this.field_6011.method_12789(SOUL_FIRE_CAST_ANIMATION_PROGRESS)).floatValue();
    }

    public void setSoulFireCastAnimationProgress(float progress) {
        this.field_6011.method_12778(SOUL_FIRE_CAST_ANIMATION_PROGRESS, (Object)Float.valueOf(progress));
    }

    public boolean method_6510() {
        return this.getAnimationState() == 1 || this.getAnimationState() == 2;
    }

    public int getAttackCooldown() {
        return this.attackCooldown;
    }

    public void setAttackCooldown(int cooldown) {
        this.attackCooldown = cooldown;
    }

    public int getSoulFireCooldown() {
        return this.soulFireCooldown;
    }

    public void setSoulFireCooldown(int cooldown) {
        this.soulFireCooldown = cooldown;
    }

    public int getStateTimer() {
        return this.stateTimer;
    }

    public void method_5773() {
        super.method_5773();
        this.method_5875(true);
        this.field_5960 = true;
        ++this.stateTimer;
        if (!this.method_37908().field_9236) {
            if (this.phaseCooldown > 0) {
                --this.phaseCooldown;
            } else if (this.method_5968() != null && !this.method_6057((class_1297)this.method_5968())) {
                this.phase();
                this.phaseCooldown = 100;
            }
        }
        if (this.attackCooldown > 0) {
            --this.attackCooldown;
        }
        if (this.soulFireCooldown > 0) {
            --this.soulFireCooldown;
        }
        switch (this.getAnimationState()) {
            case 1: {
                if (this.stateTimer < 10) break;
                this.setAnimationState(4);
                break;
            }
            case 2: {
                if (this.stateTimer < 24) break;
                this.setAnimationState(4);
                break;
            }
            case 3: {
                if (this.method_5968() != null && this.isCharging()) break;
                this.setAnimationState(4);
                this.setCharging(false);
                break;
            }
            case 4: {
                break;
            }
        }
        if (this.method_37908().field_9236) {
            this.addParticleEffects();
        }
    }

    public float getCurrentAnimationProgress() {
        return switch (this.getAnimationState()) {
            case 1 -> Math.min(1.0f, (float)this.stateTimer / 10.0f);
            case 2 -> Math.min(1.0f, (float)this.stateTimer / 24.0f);
            case 0, 3, 4 -> (float)(this.stateTimer % 40) / 40.0f;
            default -> 0.0f;
        };
    }

    public boolean isCurrentAnimationComplete() {
        return switch (this.getAnimationState()) {
            case 1 -> {
                if (this.stateTimer >= 10) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                if (this.stateTimer >= 24) {
                    yield true;
                }
                yield false;
            }
            case 0, 3, 4 -> false;
            default -> false;
        };
    }

    private void addParticleEffects() {
        if (this.method_6051().method_43048(4) == 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_22246, this.method_23317() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681(), this.method_23318() + this.method_6051().method_43058() * (double)this.method_17682(), this.method_23321() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681(), 0.0, 0.1, 0.0);
        }
        if (this.method_6051().method_43048(8) == 0) {
            this.method_37908().method_8406((class_2394)class_2398.field_23114, this.method_23317() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 2.0, this.method_23318() + this.method_6051().method_43058() * (double)this.method_17682(), this.method_23321() + (this.method_6051().method_43058() - 0.5) * (double)this.method_17681() * 2.0, 0.0, 0.05, 0.0);
        }
    }

    public boolean method_17326() {
        return false;
    }

    public boolean method_5974(double distanceSquared) {
        return distanceSquared > 16384.0;
    }

    public boolean method_5696() {
        return true;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 state, class_2338 pos) {
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14812;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15072;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14964;
    }

    public boolean method_5753() {
        return true;
    }

    protected float method_6107() {
        return 0.6f;
    }

    public boolean method_5679(class_1282 damageSource) {
        return super.method_5679(damageSource) || damageSource.method_49708(class_8111.field_42340);
    }

    public boolean method_5776() {
        return this.field_6012 % 20 < 10;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    private void phase() {
        class_1309 target = this.method_5968();
        if (target == null) {
            return;
        }
        class_2338 targetPos = target.method_24515();
        for (int i = 0; i < 10; ++i) {
            class_2338 pos = targetPos.method_10069(this.field_5974.method_39332(-2, 2), this.field_5974.method_39332(-1, 1), this.field_5974.method_39332(-2, 2));
            if (!this.method_37908().method_22347(pos)) continue;
            this.method_5859((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            this.method_37908().method_43128(null, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_14879, class_3419.field_15251, 1.0f, 1.0f);
            break;
        }
    }

    private void applyPlayerScaling() {
        class_1324 attackDamageAttribute;
        if (this.method_37908().field_9236) {
            return;
        }
        ArrayList<Object> nearbyPlayers = new ArrayList<Object>();
        for (Object player : this.method_37908().method_18456()) {
            if (!(player.method_5858((class_1297)this) <= 4096.0)) continue;
            nearbyPlayers.add(player);
        }
        if (nearbyPlayers.isEmpty()) {
            return;
        }
        int totalPlayerLevel = 0;
        for (class_1657 class_16572 : nearbyPlayers) {
            if (!(class_16572 instanceof TessarectedPlayerStatsHolder)) continue;
            TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)class_16572;
            totalPlayerLevel += holder.tessarected_getStats().getLevel();
        }
        double averagePlayerLevel = (double)totalPlayerLevel / (double)nearbyPlayers.size();
        Random random = new Random();
        int levelModifier = random.nextInt(7) - 3;
        double effectiveLevel = Math.max(1.0, averagePlayerLevel + (double)levelModifier);
        double healthScaleFactor = 1.0 + effectiveLevel * 0.05;
        double damageScaleFactor = 1.0 + effectiveLevel * 0.03;
        class_1324 maxHealthAttribute = this.method_5996(class_5134.field_23716);
        if (maxHealthAttribute != null) {
            maxHealthAttribute.method_6192(maxHealthAttribute.method_6201() * healthScaleFactor);
            this.method_6033((float)maxHealthAttribute.method_6201());
        }
        if ((attackDamageAttribute = this.method_5996(class_5134.field_23721)) != null) {
            attackDamageAttribute.method_6192(attackDamageAttribute.method_6201() * damageScaleFactor);
        }
    }

    public class FlyAroundGoal
    extends class_1352 {
        private final SunderedWraithEntity wraith;
        private class_2338 targetBlock = null;
        private int idleTicks = 0;

        public FlyAroundGoal(SunderedWraithEntity wraith) {
            this.wraith = wraith;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.wraith.method_5968() == null && !this.wraith.method_6510() && !this.wraith.method_5962().method_6241() && this.wraith.method_6051().method_43048(20) == 0;
        }

        public boolean method_6266() {
            return this.wraith.method_5968() == null && !this.wraith.method_6510() && this.targetBlock != null && !this.wraith.method_24515().method_19771((class_2382)this.targetBlock, 1.0);
        }

        public void method_6269() {
            this.idleTicks = 0;
            this.targetBlock = this.getRandomNearbyAirBlock(this.wraith.method_24515(), 10, 5);
            if (this.targetBlock != null) {
                this.wraith.method_5962().method_6239((double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, 1.0);
                this.wraith.setAnimationState(4);
            } else {
                this.wraith.setAnimationState(0);
            }
        }

        public void method_6270() {
            this.targetBlock = null;
            this.wraith.setAnimationState(0);
        }

        public void method_6268() {
            class_2338 newTarget;
            if (this.targetBlock == null || this.wraith.method_24515().method_19771((class_2382)this.targetBlock, 1.0) || !this.wraith.method_5962().method_6241()) {
                ++this.idleTicks;
                if (this.idleTicks > 10) {
                    this.targetBlock = this.getRandomNearbyAirBlock(this.wraith.method_24515(), 10, 5);
                    this.idleTicks = 0;
                    if (this.targetBlock != null) {
                        this.wraith.method_5962().method_6239((double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, 1.0);
                        this.wraith.setAnimationState(4);
                    } else {
                        this.wraith.setAnimationState(0);
                    }
                }
            } else if (this.wraith.method_6051().method_43048(60) == 0 && (newTarget = this.getRandomNearbyAirBlock(this.wraith.method_24515(), 10, 5)) != null) {
                this.targetBlock = newTarget;
                this.wraith.method_5962().method_6239((double)this.targetBlock.method_10263() + 0.5, (double)this.targetBlock.method_10264() + 0.5, (double)this.targetBlock.method_10260() + 0.5, 1.0);
                this.wraith.setAnimationState(4);
            }
        }

        private class_2338 getRandomNearbyAirBlock(class_2338 center, int horizontalRadius, int verticalRadius) {
            for (int i = 0; i < 30; ++i) {
                double theta = this.wraith.method_6051().method_43058() * Math.PI * 2.0;
                double phi = this.wraith.method_6051().method_43058() * Math.PI;
                double r = this.wraith.method_6051().method_43058() * (double)horizontalRadius;
                int x = center.method_10263() + (int)Math.round(r * Math.sin(phi) * Math.cos(theta));
                int y = center.method_10264() + (int)Math.round((this.wraith.method_6051().method_43058() - 0.5) * 2.0 * (double)verticalRadius);
                int z = center.method_10260() + (int)Math.round(r * Math.sin(phi) * Math.sin(theta));
                class_2338 randomPos = new class_2338(x, y, z);
                if (!this.wraith.method_37908().method_22347(randomPos) || !this.wraith.method_37908().method_22347(randomPos.method_10084())) continue;
                return randomPos;
            }
            return null;
        }
    }
}

