/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.entity.ai;

import com.tessarected.entity.SunderedWraithEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;

public class SunderedWraithSummonSoulFireGoal
extends class_1352 {
    private final SunderedWraithEntity wraith;
    private int effectTime;
    private List<class_2338> soulFirePositions;
    private boolean hasExecutedAttack;

    public SunderedWraithSummonSoulFireGoal(SunderedWraithEntity wraith) {
        this.wraith = wraith;
        this.soulFirePositions = new ArrayList<class_2338>();
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        class_1309 target = this.wraith.method_5968();
        return target != null && target.method_5805() && this.wraith.method_6057((class_1297)target) && this.wraith.getSoulFireCooldown() <= 0 && !this.wraith.method_6510() && this.wraith.method_5858((class_1297)target) <= 400.0 && this.wraith.method_6051().method_43048(60) < 10;
    }

    public boolean method_6266() {
        return this.wraith.getAnimationState() == 2 || this.effectTime > 0;
    }

    public void method_6269() {
        class_1309 target = this.wraith.method_5968();
        if (target != null) {
            this.wraith.setAnimationState(2);
            this.wraith.setCastingSoulFire(true);
            this.wraith.setSoulFireCastAnimationProgress(0.0f);
            this.effectTime = 60;
            this.hasExecutedAttack = false;
            this.soulFirePositions.clear();
            this.wraith.method_5783(class_3417.field_14792, 0.8f, 1.5f);
        }
    }

    public void method_6270() {
        this.wraith.setSoulFireCooldown(160);
        this.wraith.setCastingSoulFire(false);
        this.wraith.setSoulFireCastAnimationProgress(0.0f);
        this.effectTime = 0;
        this.hasExecutedAttack = false;
        this.cleanupSoulFire();
    }

    public void method_6268() {
        class_1309 target = this.wraith.method_5968();
        if (target == null) {
            return;
        }
        this.wraith.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        this.wraith.method_5962().method_6239(this.wraith.method_23317(), this.wraith.method_23318(), this.wraith.method_23321(), 0.0);
        if (this.wraith.getAnimationState() == 2) {
            float progress = this.wraith.getCurrentAnimationProgress();
            this.wraith.setSoulFireCastAnimationProgress(progress);
            class_1937 class_19372 = this.wraith.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_243 pos = this.wraith.method_19538();
                for (int i = 0; i < 3; ++i) {
                    serverWorld.method_14199((class_2394)class_2398.field_23114, pos.field_1352 + (serverWorld.field_9229.method_43058() - 0.5) * 2.0, pos.field_1351 + serverWorld.field_9229.method_43058() * (double)this.wraith.method_17682(), pos.field_1350 + (serverWorld.field_9229.method_43058() - 0.5) * 2.0, 1, 0.0, 0.1, 0.0, 0.02);
                }
            }
            if (!this.hasExecutedAttack && this.wraith.getStateTimer() >= 22) {
                this.generateSoulFirePositions();
                this.executeSoulFireAttack();
                this.hasExecutedAttack = true;
            }
        } else if (this.effectTime > 0) {
            --this.effectTime;
            this.tickSoulFire();
        }
    }

    private void generateSoulFirePositions() {
        class_1937 world = this.wraith.method_37908();
        class_1309 target = this.wraith.method_5968();
        if (target == null) {
            return;
        }
        class_2338 playerPos = target.method_24515();
        class_2338 groundPos = this.findGroundBlock(world, playerPos);
        if (groundPos != null) {
            this.soulFirePositions.add(groundPos.method_10084());
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 potentialPos;
                if (x == 0 && z == 0 || (groundPos = this.findGroundBlock(world, potentialPos = playerPos.method_10069(x, 0, z))) == null) continue;
                this.soulFirePositions.add(groundPos.method_10084());
            }
        }
    }

    private class_2338 findGroundBlock(class_1937 world, class_2338 startPos) {
        for (int i = 0; i < 5; ++i) {
            class_2338 checkPos = startPos.method_10087(i);
            if (world.method_8320(checkPos).method_26215()) continue;
            return checkPos;
        }
        return null;
    }

    private void executeSoulFireAttack() {
        class_1937 world = this.wraith.method_37908();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            for (class_2338 pos : this.soulFirePositions) {
                serverWorld.method_8501(pos, class_2246.field_10036.method_9564());
            }
            for (class_2338 pos : this.soulFirePositions) {
                serverWorld.method_14199((class_2394)class_2398.field_22246, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.1, (double)pos.method_10260() + 0.5, 10, 0.3, 0.1, 0.3, 0.02);
            }
        }
        this.wraith.method_5783(class_3417.field_15102, 1.0f, 0.8f);
    }

    private void tickSoulFire() {
        class_1937 world = this.wraith.method_37908();
        for (class_2338 pos : this.soulFirePositions) {
            if (!world.method_8320(pos).method_27852(class_2246.field_10036)) continue;
            class_238 box = new class_238(pos);
            world.method_8390(class_1309.class, box, entity -> entity != this.wraith && entity.method_5805()).forEach(entity -> {
                entity.method_5643(entity.method_48923().method_48812((class_1309)this.wraith), 3.0f);
                entity.method_5639(3);
            });
        }
    }

    private void cleanupSoulFire() {
        class_1937 world = this.wraith.method_37908();
        for (class_2338 pos : this.soulFirePositions) {
            if (!world.method_8320(pos).method_27852(class_2246.field_10036)) continue;
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
        this.soulFirePositions.clear();
    }
}

