/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.event;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.combat.damage.DamageType;
import com.tessarected.stats.PlayerStats;
import com.tessarected.stats.PlayerStatsSyncPacket;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.server.MinecraftServer;

public class ResourceHandler {
    private static final Map<UUID, PlayerResourceState> playerStates = new HashMap<UUID, PlayerResourceState>();
    private static final int TICKS_PER_SECOND = 20;
    private static final int STAMINA_REGEN_DELAY_SECONDS = 2;
    private static final int STAMINA_REGEN_DELAY_TICKS = 40;

    public static void initialize() {
        ServerTickEvents.END_SERVER_TICK.register(ResourceHandler::onEndServerTick);
    }

    private static void onEndServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            float regenAmount;
            TessarectedPlayerStatsHolder holder;
            PlayerStats stats;
            if (!(player instanceof TessarectedPlayerStatsHolder) || (stats = (holder = (TessarectedPlayerStatsHolder)player).tessarected_getStats()) == null) continue;
            UUID playerId = player.method_5667();
            PlayerResourceState state = playerStates.computeIfAbsent(playerId, k -> new PlayerResourceState());
            boolean isSprinting = player.method_5624();
            boolean statsChanged = false;
            if (isSprinting) {
                float decayAmount = 0.05f;
                if (stats.getStamina() > 0.0f) {
                    newStamina = Math.max(0.0f, stats.getStamina() - decayAmount);
                    stats.setStamina(newStamina, (class_1657)player);
                    statsChanged = true;
                }
                state.staminaExhaustionTimer = 0;
            } else {
                ++state.staminaExhaustionTimer;
                if (state.staminaExhaustionTimer >= 40) {
                    regenAmount = 0.1f;
                    if (stats.getStamina() < stats.getMaxStamina()) {
                        newStamina = Math.min(stats.getMaxStamina(), stats.getStamina() + regenAmount);
                        stats.setStamina(newStamina, (class_1657)player);
                        statsChanged = true;
                    }
                }
            }
            if (player.field_6012 % 20 == 0) {
                if (stats.getMana() < stats.getMaxMana()) {
                    regenAmount = 1.0f;
                    float newMana = Math.min(stats.getMaxMana(), stats.getMana() + regenAmount);
                    stats.setMana(newMana, (class_1657)player);
                    statsChanged = true;
                }
                stats.triggerPassiveAbility((class_1657)player);
                ResourceHandler.applyStatAttributes(player, stats);
            }
            stats.tickCooldowns();
            if (!statsChanged && player.field_6012 % 2 != 0) continue;
            PlayerStatsSyncPacket.sendTo((class_1657)player, stats);
        }
    }

    private static void applyStatAttributes(class_3222 player, PlayerStats stats) {
        System.out.println("Applying stats for player " + player.method_5477().getString() + ":");
        System.out.println("  Strength: " + stats.getStrength() + ", Agility: " + stats.getAgility() + ", Vitality: " + stats.getVitality() + ", Intelligence: " + stats.getIntelligence());
        System.out.println("  MaxMana: " + stats.getMaxMana() + ", MaxStamina: " + stats.getMaxStamina() + ", Defense: " + stats.getDefense() + ", MagicDefense: " + stats.getMagicDefense());
        double baseAttack = 1.0;
        double strengthBonus = (double)stats.getStrength() * 0.2;
        player.method_5996(class_5134.field_23721).method_6192(baseAttack + strengthBonus);
        double baseSpeed = 0.1;
        double agilityBonus = (double)stats.getAgility() * 0.002;
        player.method_5996(class_5134.field_23719).method_6192(baseSpeed + agilityBonus);
        double baseHealth = 20.0;
        double vitalityBonus = (double)stats.getVitality() * 0.5;
        player.method_5996(class_5134.field_23716).method_6192(baseHealth + vitalityBonus);
        int classBaseMaxMana = switch (stats.getClassType()) {
            case PlayerStats.ClassType.MENDER -> 150;
            case PlayerStats.ClassType.HARVESTER -> 80;
            case PlayerStats.ClassType.ECHO -> 120;
            case PlayerStats.ClassType.GUARDIAN -> 100;
            default -> 100;
        };
        int intelligenceBonus = stats.getIntelligence() * 1;
        int newMaxMana = classBaseMaxMana + intelligenceBonus;
        stats.setMaxMana(newMaxMana, (class_1657)player);
        int baseDefense = stats.getMaxDefense();
        int defenseBonus = stats.getDefense() * 2;
        player.method_5996(class_5134.field_23724).method_6192((double)(baseDefense + defenseBonus));
        int magicDefenseBonus = stats.getMagicDefense();
        double magicReduction = Math.min((double)magicDefenseBonus * 0.05, 0.25);
        block9: for (DamageType type : DamageType.values()) {
            switch (type) {
                case FIRE: 
                case COLD: 
                case LIGHTNING: 
                case ENERGY: 
                case DARK: 
                case HOLY: 
                case CORRUPTION: 
                case PSYCHIC: 
                case VOID: 
                case TESSARECTION: {
                    stats.setMagicDamageReduction(type, magicReduction);
                    continue block9;
                }
                default: {
                    stats.setMagicDamageReduction(type, 0.0);
                }
            }
        }
        if (stats.getAgility() >= 15 && !player.method_6059(class_1294.field_5904)) {
            player.method_6092(new class_1293(class_1294.field_5904, 120, 0, false, false, false));
        }
        if (stats.getVitality() >= 15 && !player.method_6059(class_1294.field_5898)) {
            player.method_6092(new class_1293(class_1294.field_5898, 120, 0, false, false, false));
        }
        if (stats.getDefense() >= 8 && !player.method_6059(class_1294.field_5907)) {
            player.method_6092(new class_1293(class_1294.field_5907, 120, 0, false, false, false));
        }
        if (stats.getStrength() >= 15 && !player.method_6059(class_1294.field_5910)) {
            player.method_6092(new class_1293(class_1294.field_5910, 120, 0, false, false, false));
        }
    }

    private static class PlayerResourceState {
        public int staminaExhaustionTimer = 0;

        private PlayerResourceState() {
        }
    }
}

