/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.gui;

import com.tessarected.abilities.SpellAbilityBridge;
import com.tessarected.abilities.SpellAbilityManager;
import com.tessarected.gui.PlayerStatsHudOverlay;
import com.tessarected.stats.PlayerStats;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;

public class AbilityHudOverlay {
    private static final class_310 mc = class_310.method_1551();

    public static void render(class_332 context, float tickDelta) {
        if (AbilityHudOverlay.mc.field_1724 == null || AbilityHudOverlay.mc.field_1690.field_1866) {
            return;
        }
        PlayerStats stats = PlayerStatsHudOverlay.clientStats;
        if (stats == null || !stats.hasChosenClass()) {
            return;
        }
        AbilityHudOverlay.renderAbilityBar(context, stats, tickDelta);
    }

    private static void renderAbilityBar(class_332 context, PlayerStats stats, float tickDelta) {
        int screenWidth = mc.method_22683().method_4486();
        int screenHeight = mc.method_22683().method_4502();
        int slotSize = 32;
        int slotSpacing = 6;
        int slotCount = 4;
        int barPadding = 8;
        int barHeight = slotSize + barPadding * 2;
        int barWidth = slotCount * slotSize + (slotCount - 1) * slotSpacing + barPadding * 2;
        int marginRight = 8;
        int marginBottom = 20;
        int barX = screenWidth - barWidth - marginRight;
        int barY = screenHeight - barHeight - marginBottom;
        int bgColor = AbilityHudOverlay.getClassBackgroundColor(stats.getClassType());
        AbilityHudOverlay.drawRoundedRect(context, barX, barY, barWidth, barHeight, 6, bgColor);
        context.method_49601(barX, barY, barWidth, barHeight, -7829368);
        char[] keys = new char[]{'Z', 'X', 'C', 'V'};
        int startX = barX + barPadding;
        int slotY = barY + barPadding;
        for (int i = 0; i < slotCount; ++i) {
            boolean hasResources;
            int slotX = startX + i * (slotSize + slotSpacing);
            char key = keys[i];
            SpellAbilityBridge.AbilityData abilityData = SpellAbilityBridge.getAbilityData(stats.getClassType(), key);
            boolean isUnlocked = abilityData != null && stats.isAbilityUnlocked(key);
            float cooldownFloat = stats.getAbilityCooldownFloat(key);
            boolean isReady = isUnlocked && cooldownFloat <= 0.0f && SpellAbilityManager.canUseAbility(stats, key);
            boolean isOnCooldown = isUnlocked && cooldownFloat > 0.0f;
            boolean bl = hasResources = isUnlocked && SpellAbilityManager.canUseAbility(stats, key);
            int slotColor = !isUnlocked ? -870178262 : (isReady ? -869348288 : (isOnCooldown ? -855679394 : -855647898));
            AbilityHudOverlay.drawRoundedRect(context, slotX, slotY, slotSize, slotSize, 5, slotColor);
            context.method_49601(slotX, slotY, slotSize, slotSize, -4473925);
            context.method_27535(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)String.valueOf(key)).method_27692(class_124.field_1068), slotX + 2, slotY + 2, -1);
            if (abilityData == null) continue;
            if (isUnlocked) {
                class_2960 iconTexture = AbilityHudOverlay.getAbilityIconTexture(abilityData.abilityId, stats.getClassType());
                if (iconTexture != null) {
                    if (isOnCooldown || !hasResources) {
                        context.method_51422(0.6f, 0.6f, 0.6f, 0.8f);
                        context.method_25290(iconTexture, slotX + 1, slotY + 1, 0.0f, 0.0f, 30, 30, 32, 32);
                        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                    } else {
                        context.method_25290(iconTexture, slotX + 1, slotY + 1, 0.0f, 0.0f, 30, 30, 32, 32);
                    }
                } else {
                    String iconText = AbilityHudOverlay.getAbilityIconFallback(abilityData.abilityId, stats.getClassType());
                    context.method_27534(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)iconText).method_27692(class_124.field_1068), slotX + slotSize / 2, slotY + slotSize / 2 - 4, -1);
                }
            } else {
                class_2960 lockedTexture = new class_2960("tessarected", "textures/gui/abilities/locked.png");
                try {
                    context.method_51422(0.4f, 0.4f, 0.4f, 1.0f);
                    context.method_25290(lockedTexture, slotX + 1, slotY + 1, 0.0f, 0.0f, 30, 30, 32, 32);
                    context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                }
                catch (Exception e) {
                    context.method_27534(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)"\ud83d\udd12").method_27692(class_124.field_1063), slotX + slotSize / 2, slotY + slotSize / 2 - 4, -10066330);
                }
            }
            if (cooldownFloat > 0.0f && isUnlocked) {
                float totalDuration = stats.getAbilityCooldownDuration(key);
                if (totalDuration > 0.0f) {
                    float progress;
                    int overlayHeight;
                    float adjustedCooldown = cooldownFloat;
                    if (tickDelta > 0.0f && tickDelta < 1.0f) {
                        adjustedCooldown = cooldownFloat - tickDelta * 0.05f;
                        adjustedCooldown = Math.max(0.0f, adjustedCooldown);
                    }
                    if ((overlayHeight = (int)((float)slotSize * (progress = adjustedCooldown / totalDuration))) > 0) {
                        context.method_25294(slotX + 1, slotY + 1, slotX + slotSize - 1, slotY + 1 + overlayHeight, -1157627904);
                    }
                }
                String cooldownText = AbilityHudOverlay.formatCooldownDisplay(cooldownFloat);
                int textWidth = AbilityHudOverlay.mc.field_1772.method_1727(cooldownText);
                int textX = slotX + slotSize / 2 - textWidth / 2;
                int textY = slotY + slotSize - 12;
                context.method_25294(textX - 2, textY - 1, textX + textWidth + 2, textY + 9, -872415232);
                class_124 textColor = cooldownFloat <= 1.0f ? class_124.field_1054 : (cooldownFloat <= 3.0f ? class_124.field_1065 : class_124.field_1061);
                context.method_27535(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)cooldownText).method_27692(textColor), textX, textY, -1);
            }
            if (isUnlocked && !isOnCooldown && !hasResources) {
                long time = System.currentTimeMillis();
                float pulse = (float)(Math.sin((double)time * 0.01) * 0.3 + 0.7);
                int alpha = (int)(pulse * 255.0f);
                int pulseColor = alpha << 24 | 0xFFD700;
                context.method_27535(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)"!").method_27692(class_124.field_1065), slotX + slotSize - 8, slotY + slotSize - 12, pulseColor);
            }
            if (isUnlocked) continue;
            int reqLevel = AbilityHudOverlay.getRequiredLevelForKey(key);
            if (stats.getLevel() >= reqLevel) continue;
            String levelText = "Lv." + reqLevel;
            int levelWidth = AbilityHudOverlay.mc.field_1772.method_1727(levelText);
            int levelX = slotX + slotSize / 2 - levelWidth / 2;
            int levelY = slotY + slotSize - 12;
            context.method_25294(levelX - 1, levelY - 1, levelX + levelWidth + 1, levelY + 9, -872415232);
            context.method_27535(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)levelText).method_27692(class_124.field_1061), levelX, levelY, -39322);
        }
        String classInfo = String.format("%s (Lv.%d)", stats.getPlayerClass(), stats.getLevel());
        int classInfoWidth = AbilityHudOverlay.mc.field_1772.method_1727(classInfo);
        int classInfoX = barX + barWidth - classInfoWidth - 6;
        int classInfoY = barY - 14;
        context.method_25294(classInfoX - 2, classInfoY - 1, classInfoX + classInfoWidth + 2, classInfoY + 10, -2013265920);
        context.method_27535(AbilityHudOverlay.mc.field_1772, (class_2561)class_2561.method_43470((String)classInfo).method_27692(AbilityHudOverlay.getClassTextColor(stats.getClassType())), classInfoX, classInfoY, -1);
    }

    private static void drawRoundedRect(class_332 context, int x, int y, int width, int height, int radius, int color) {
        context.method_25294(x + radius, y, x + width - radius, y + height, color);
        context.method_25294(x, y + radius, x + radius, y + height - radius, color);
        context.method_25294(x + width - radius, y + radius, x + width, y + height - radius, color);
        context.method_25294(x, y, x + radius, y + radius, color);
        context.method_25294(x + width - radius, y, x + width, y + radius, color);
        context.method_25294(x, y + height - radius, x + radius, y + height, color);
        context.method_25294(x + width - radius, y + height - radius, x + width, y + height, color);
    }

    private static class_2960 getAbilityIconTexture(String abilityId, PlayerStats.ClassType classType) {
        String texturePath = "textures/gui/abilities/" + abilityId.toLowerCase() + ".png";
        return new class_2960("tessarected", texturePath);
    }

    private static String getAbilityIconFallback(String abilityId, PlayerStats.ClassType classType) {
        return switch (abilityId.toLowerCase()) {
            case "heal" -> "\u2764";
            case "sanctuary" -> "\u271a";
            case "purify" -> "\u2600";
            case "divine_light" -> "\u2726";
            case "energy_bolt" -> "\u26a1";
            case "power_drain" -> "\ud83d\udd0b";
            case "overload" -> "\ud83d\udca5";
            case "reality_rift" -> "\ud83c\udf00";
            case "shadow_strike" -> "\ud83d\udde1";
            case "chaos_wave" -> "\ud83c\udf0a";
            case "mind_break" -> "\ud83e\udde0";
            case "void_embrace" -> "\ud83d\udd73";
            case "shield_bash" -> "\ud83d\udee1";
            case "aegis" -> "\u2694";
            case "taunt" -> "\ud83d\udce2";
            case "fortress" -> "\ud83c\udff0";
            default -> "?";
        };
    }

    private static String formatCooldownDisplay(float cooldown) {
        if (cooldown <= 0.0f) {
            return "READY";
        }
        if (cooldown < 1.0f) {
            return String.format("%.1f", Float.valueOf(cooldown));
        }
        if (cooldown < 10.0f) {
            return String.format("%.1f", Float.valueOf(cooldown));
        }
        if (cooldown < 60.0f) {
            return String.format("%.0f", Float.valueOf(cooldown));
        }
        int minutes = (int)(cooldown / 60.0f);
        int seconds = (int)(cooldown % 60.0f);
        return String.format("%dm%02ds", minutes, seconds);
    }

    private static int getClassBackgroundColor(PlayerStats.ClassType classType) {
        return switch (classType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStats.ClassType.MENDER -> -870702210;
            case PlayerStats.ClassType.HARVESTER -> -855675136;
            case PlayerStats.ClassType.ECHO -> -865461350;
            case PlayerStats.ClassType.GUARDIAN -> -872380037;
            case PlayerStats.ClassType.NONE -> -869912008;
        };
    }

    private static class_124 getClassTextColor(PlayerStats.ClassType classType) {
        return switch (classType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStats.ClassType.MENDER -> class_124.field_1075;
            case PlayerStats.ClassType.HARVESTER -> class_124.field_1065;
            case PlayerStats.ClassType.ECHO -> class_124.field_1076;
            case PlayerStats.ClassType.GUARDIAN -> class_124.field_1060;
            case PlayerStats.ClassType.NONE -> class_124.field_1080;
        };
    }

    private static int getRequiredLevelForKey(char key) {
        return switch (Character.toLowerCase(key)) {
            case 'z' -> 1;
            case 'x' -> 5;
            case 'c' -> 10;
            case 'v' -> 15;
            default -> 999;
        };
    }

    public static void renderTooltip(class_332 context, int mouseX, int mouseY, PlayerStats stats) {
        if (stats == null || !stats.hasChosenClass()) {
            return;
        }
        int screenWidth = context.method_51421();
        int screenHeight = context.method_51443();
        int slotSize = 32;
        int slotSpacing = 6;
        int slotCount = 4;
        int barPadding = 8;
        int barHeight = slotSize + barPadding * 2;
        int barWidth = slotCount * slotSize + (slotCount - 1) * slotSpacing + barPadding * 2;
        int marginRight = 8;
        int marginBottom = 20;
        int barX = screenWidth - barWidth - marginRight;
        int barY = screenHeight - barHeight - marginBottom;
        if (mouseX >= barX && mouseX <= barX + barWidth && mouseY >= barY && mouseY <= barY + barHeight) {
            int startX = barX + barPadding;
            int slotY = barY + barPadding;
            char[] keys = new char[]{'Z', 'X', 'C', 'V'};
            for (int i = 0; i < slotCount; ++i) {
                float duration;
                int slotX = startX + i * (slotSize + slotSpacing);
                if (mouseX < slotX || mouseX > slotX + slotSize || mouseY < slotY || mouseY > slotY + slotSize) continue;
                SpellAbilityBridge.AbilityData abilityData = SpellAbilityBridge.getAbilityData(stats.getClassType(), keys[i]);
                if (abilityData == null) break;
                StringBuilder tooltipBuilder = new StringBuilder();
                tooltipBuilder.append(abilityData.getTooltip());
                float cooldown = stats.getAbilityCooldownFloat(keys[i]);
                if (cooldown > 0.0f) {
                    tooltipBuilder.append("\n\u00a7e").append(AbilityHudOverlay.formatCooldownDisplay(cooldown)).append(" remaining");
                    float percentage = stats.getAbilityCooldownPercentage(keys[i]);
                    if (percentage > 0.0f) {
                        tooltipBuilder.append(" (").append(String.format("%.0f", Float.valueOf(percentage * 100.0f))).append("%)");
                    }
                } else if (stats.isAbilityUnlocked(keys[i])) {
                    tooltipBuilder.append("\n\u00a7aREADY");
                } else {
                    int reqLevel = AbilityHudOverlay.getRequiredLevelForKey(keys[i]);
                    tooltipBuilder.append("\n\u00a7cRequires Level ").append(reqLevel);
                }
                if (cooldown > 0.0f && (duration = stats.getAbilityCooldownDuration(keys[i])) > 0.0f) {
                    tooltipBuilder.append("\n\u00a77Total Duration: ").append(AbilityHudOverlay.formatCooldownDisplay(duration));
                }
                String tooltip = tooltipBuilder.toString();
                String[] lines = tooltip.split("\n");
                int tooltipWidth = 0;
                for (String line : lines) {
                    int lineWidth = AbilityHudOverlay.mc.field_1772.method_1727(line);
                    if (lineWidth <= tooltipWidth) continue;
                    tooltipWidth = lineWidth;
                }
                tooltipWidth += 16;
                int n = lines.length;
                Objects.requireNonNull(AbilityHudOverlay.mc.field_1772);
                int tooltipHeight = n * (9 + 2) + 10;
                int tooltipX = mouseX + 12;
                int tooltipY = mouseY - tooltipHeight - 8;
                if (tooltipX + tooltipWidth > screenWidth) {
                    tooltipX = screenWidth - tooltipWidth - 4;
                }
                if (tooltipY < 0) {
                    tooltipY = mouseY + 12;
                }
                if (tooltipY + tooltipHeight > barY && tooltipY < barY + barHeight && (tooltipY = barY - tooltipHeight - 4) < 0) {
                    tooltipY = barY + barHeight + 4;
                }
                AbilityHudOverlay.drawRoundedRect(context, tooltipX, tooltipY, tooltipWidth, tooltipHeight, 5, -299752926);
                context.method_49601(tooltipX, tooltipY, tooltipWidth, tooltipHeight, -7829368);
                for (int lineIndex = 0; lineIndex < lines.length; ++lineIndex) {
                    class_327 class_3272 = AbilityHudOverlay.mc.field_1772;
                    class_5250 class_52502 = class_2561.method_43470((String)lines[lineIndex]);
                    Objects.requireNonNull(AbilityHudOverlay.mc.field_1772);
                    context.method_27535(class_3272, (class_2561)class_52502, tooltipX + 8, tooltipY + 6 + lineIndex * (9 + 2), -1);
                }
                break;
            }
        }
    }

    public static int getChatYOffset() {
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null) {
            return 0;
        }
        PlayerStats stats = PlayerStatsHudOverlay.clientStats;
        if (stats == null || !stats.hasChosenClass()) {
            return 0;
        }
        int slotSize = 32;
        int barPadding = 8;
        int barHeight = slotSize + barPadding * 2;
        int marginBottom = 20;
        int statsHeight = PlayerStatsHudOverlay.getUIHeight();
        return Math.max(barHeight + marginBottom + 5, statsHeight + 5);
    }
}

