/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.gui;

import com.tessarected.combat.SpellSystem;
import com.tessarected.stats.PlayerStats;
import com.tessarected.stats.PlayerStatsUpdatePacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5481;

public class ClassSelectionScreen
extends class_437 {
    private final OnClassChosen onClassChosen;
    private final class_310 mc = class_310.method_1551();
    private PlayerStats.ClassType[] availableClasses;
    private ClassInfo[] classInfos;

    public ClassSelectionScreen(OnClassChosen onClassChosen) {
        super((class_2561)class_2561.method_43470((String)"Choose Your Class"));
        this.onClassChosen = onClassChosen;
    }

    protected void method_25426() {
        PlayerStats.ClassType[] allClasses = PlayerStats.ClassType.values();
        ArrayList<PlayerStats.ClassType> classList = new ArrayList<PlayerStats.ClassType>();
        for (PlayerStats.ClassType classType : allClasses) {
            if (classType == PlayerStats.ClassType.NONE) continue;
            classList.add(classType);
        }
        this.availableClasses = classList.toArray(new PlayerStats.ClassType[0]);
        this.classInfos = new ClassInfo[this.availableClasses.length];
        for (int i = 0; i < this.availableClasses.length; ++i) {
            this.classInfos[i] = this.createClassInfo(this.availableClasses[i]);
        }
        int baseButtonWidth = 160;
        int baseButtonHeight = 40;
        double scale = Math.min((double)this.field_22789 / 1920.0, (double)this.field_22790 / 1080.0);
        scale = Math.max(0.7, Math.min(1.2, scale));
        int buttonWidth = (int)((double)baseButtonWidth * scale);
        int buttonHeight = (int)((double)baseButtonHeight * scale);
        int gap = (int)(30.0 * scale);
        int verticalSpacing = (int)(120.0 * scale);
        int columns = Math.min(2, this.availableClasses.length);
        int rows = (int)Math.ceil((double)this.availableClasses.length / (double)columns);
        int totalWidth = columns * buttonWidth + (columns - 1) * gap;
        int totalHeight = rows * buttonHeight + (rows - 1) * verticalSpacing;
        int startX = (this.field_22789 - totalWidth) / 2;
        int startY = (this.field_22790 - totalHeight) / 2;
        startY = Math.max((int)(80.0 * scale), startY);
        for (int i = 0; i < this.availableClasses.length; ++i) {
            PlayerStats.ClassType classType = this.availableClasses[i];
            int column = i % columns;
            int row = i / columns;
            int buttonX = startX + column * (buttonWidth + gap);
            int buttonY = startY + row * (buttonHeight + verticalSpacing);
            class_4185 button = class_4185.method_46430((class_2561)class_2561.method_43470((String)this.formatClassName(classType.name())), b -> this.selectClass(classType)).method_46434(buttonX, buttonY, buttonWidth, buttonHeight).method_46431();
            this.method_37063((class_364)button);
        }
    }

    private ClassInfo createClassInfo(PlayerStats.ClassType classType) {
        ClassInfo info = new ClassInfo();
        info.name = this.formatClassName(classType.name());
        info.abilities = this.getClassAbilities(classType);
        info.stats = this.getClassStats(classType);
        info.playstyle = this.getClassPlaystyle(classType);
        return info;
    }

    private AbilityInfo[] getClassAbilities(PlayerStats.ClassType classType) {
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(classType);
        AbilityInfo[] abilities = new AbilityInfo[spells.length];
        for (int i = 0; i < spells.length; ++i) {
            abilities[i] = new AbilityInfo();
            abilities[i].key = (new char[]{'Z', 'X', 'C', 'V'})[i];
            abilities[i].name = spells[i].getDisplayName();
            abilities[i].description = this.getAbilityDescription(spells[i]);
            abilities[i].unlockLevel = this.getAbilityUnlockLevel(i);
            abilities[i].manaCost = spells[i].getManaCost();
            abilities[i].staminaCost = spells[i].getStaminaCost();
        }
        return abilities;
    }

    private String getAbilityDescription(SpellSystem.SpellType spellType) {
        return switch (spellType) {
            case SpellSystem.SpellType.HEAL -> "Restore health to yourself instantly";
            case SpellSystem.SpellType.SANCTUARY -> "Create healing ground for you and allies";
            case SpellSystem.SpellType.PURIFY -> "Damage enemies with holy light";
            case SpellSystem.SpellType.DIVINE_LIGHT -> "Massive area-of-effect holy damage";
            case SpellSystem.SpellType.ENERGY_BOLT -> "Fire energy projectile at enemies";
            case SpellSystem.SpellType.POWER_DRAIN -> "Drain enemy energy to restore your own";
            case SpellSystem.SpellType.OVERLOAD -> "Explosive area damage at cost of health";
            case SpellSystem.SpellType.REALITY_RIFT -> "Tear reality for massive void damage";
            case SpellSystem.SpellType.SHADOW_STRIKE -> "Strike from shadows, teleport behind target";
            case SpellSystem.SpellType.CHAOS_WAVE -> "Unleash chaotic energy with random effects";
            case SpellSystem.SpellType.MIND_BREAK -> "Shatter enemy minds with psychic force";
            case SpellSystem.SpellType.VOID_EMBRACE -> "Become one with void, damage and heal";
            case SpellSystem.SpellType.SHIELD_BASH -> "Strike with shield, knockback enemies";
            case SpellSystem.SpellType.AEGIS -> "Create protective barrier reducing damage";
            case SpellSystem.SpellType.TAUNT -> "Force enemies to focus attacks on you";
            case SpellSystem.SpellType.FORTRESS -> "Become nearly invulnerable temporarily";
            default -> "A powerful class ability";
        };
    }

    private int getAbilityUnlockLevel(int abilityIndex) {
        return switch (abilityIndex) {
            case 0 -> 1;
            case 1 -> 5;
            case 2 -> 10;
            case 3 -> 15;
            default -> 1;
        };
    }

    private ClassStats getClassStats(PlayerStats.ClassType classType) {
        ClassStats stats = new ClassStats();
        stats.specialty = this.getClassSpecialty(classType);
        stats.difficulty = this.getClassDifficulty(classType);
        return stats;
    }

    private String getClassSpecialty(PlayerStats.ClassType classType) {
        return switch (classType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStats.ClassType.MENDER -> "Healing & Support";
            case PlayerStats.ClassType.HARVESTER -> "Raw Power & Energy";
            case PlayerStats.ClassType.ECHO -> "Chaos & Debuffs";
            case PlayerStats.ClassType.GUARDIAN -> "Defense & Control";
            case PlayerStats.ClassType.NONE -> "";
        };
    }

    private String getClassDifficulty(PlayerStats.ClassType classType) {
        return switch (classType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStats.ClassType.MENDER -> "Easy";
            case PlayerStats.ClassType.HARVESTER -> "Medium";
            case PlayerStats.ClassType.ECHO -> "Hard";
            case PlayerStats.ClassType.GUARDIAN -> "Easy";
            case PlayerStats.ClassType.NONE -> "";
        };
    }

    private String getClassPlaystyle(PlayerStats.ClassType classType) {
        return switch (classType) {
            default -> throw new IncompatibleClassChangeError();
            case PlayerStats.ClassType.MENDER -> "Support your team with powerful healing abilities and protective magic.";
            case PlayerStats.ClassType.HARVESTER -> "Overwhelm enemies with raw power and energy manipulation.";
            case PlayerStats.ClassType.ECHO -> "Master of unpredictable chaos magic and shadow manipulation.";
            case PlayerStats.ClassType.GUARDIAN -> "Tank damage and protect allies with defensive abilities.";
            case PlayerStats.ClassType.NONE -> "";
        };
    }

    private void selectClass(PlayerStats.ClassType classType) {
        try {
            if (this.mc.field_1724 != null) {
                this.mc.field_1724.method_5783((class_3414)class_3417.field_15015.comp_349(), 1.0f, 1.0f);
            }
            PlayerStatsUpdatePacket.sendClassSelection(classType.name());
            if (this.onClassChosen != null) {
                this.onClassChosen.choose(classType);
            }
            this.method_25419();
        }
        catch (Exception e) {
            System.err.println("Failed to select class: " + e.getMessage());
        }
    }

    private String formatClassName(String className) {
        if (className == null || className.isEmpty()) {
            return "Unknown";
        }
        return className.substring(0, 1).toUpperCase() + className.substring(1).toLowerCase();
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.method_25420(context);
        try {
            class_2960 bg = new class_2960("tessarected", "textures/gui/class_selection.png");
            context.method_25290(bg, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, this.field_22789, this.field_22790);
        }
        catch (Exception e) {
            context.method_25294(0, 0, this.field_22789, this.field_22790, -16777216);
        }
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1441722095);
        double scale = Math.min((double)this.field_22789 / 1920.0, (double)this.field_22790 / 1080.0);
        scale = Math.max(0.7, Math.min(1.2, scale));
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, (int)(30.0 * scale), class_124.field_1065.method_532().intValue());
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Choose your path and unlock your destiny"), this.field_22789 / 2, (int)(50.0 * scale), -3355444);
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderEnhancedTooltip(context, mouseX, mouseY);
    }

    private void renderEnhancedTooltip(class_332 context, int mouseX, int mouseY) {
        for (int i = 0; i < this.availableClasses.length; ++i) {
            class_4185 button;
            Object e;
            if (i >= this.method_25396().size() || !((e = this.method_25396().get(i)) instanceof class_4185) || !(button = (class_4185)e).method_49606()) continue;
            ClassInfo classInfo = this.classInfos[i];
            List<class_5481> tooltipLines = this.buildTooltipLines(classInfo);
            context.method_51447(this.field_22793, tooltipLines, mouseX, mouseY);
            break;
        }
    }

    private List<class_5481> buildTooltipLines(ClassInfo classInfo) {
        ArrayList<class_5481> lines = new ArrayList<class_5481>();
        lines.add(class_2561.method_43470((String)classInfo.name).method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_10852((class_2561)class_2561.method_43470((String)(" (" + classInfo.stats.difficulty + ")")).method_27692(class_124.field_1080)).method_30937());
        lines.add(class_2561.method_43470((String)classInfo.stats.specialty).method_27692(class_124.field_1063).method_30937());
        lines.add(class_2561.method_43473().method_30937());
        lines.add(class_2561.method_43470((String)"Playstyle:").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067}).method_30937());
        lines.add(class_2561.method_43470((String)classInfo.playstyle).method_27692(class_124.field_1068).method_30937());
        lines.add(class_2561.method_43473().method_30937());
        lines.add(class_2561.method_43470((String)"Base Stats:").method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}).method_30937());
        lines.add(class_2561.method_43473().method_30937());
        lines.add(class_2561.method_43470((String)"Abilities:").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}).method_30937());
        for (AbilityInfo ability : classInfo.abilities) {
            class_5250 costText = class_2561.method_43470((String)"").method_27692(class_124.field_1063);
            Object costs = "";
            if (ability.manaCost > 0) {
                costs = (String)costs + ability.manaCost + " MP";
            }
            if (ability.staminaCost > 0) {
                if (!((String)costs).isEmpty()) {
                    costs = (String)costs + ", ";
                }
                costs = (String)costs + ability.staminaCost + " SP";
            }
            if (!((String)costs).isEmpty()) {
                costText.method_10852((class_2561)class_2561.method_43470((String)("(" + (String)costs + ") ")));
            }
            lines.add(class_2561.method_43470((String)(ability.key + ": ")).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)ability.name).method_27692(class_124.field_1076)).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)costText).method_10852((class_2561)class_2561.method_43470((String)("(Lv." + ability.unlockLevel + ")")).method_27692(class_124.field_1080)).method_30937());
            lines.add(class_2561.method_43470((String)("  " + ability.description)).method_27692(class_124.field_1080).method_30937());
        }
        lines.add(class_2561.method_43473().method_30937());
        lines.add(class_2561.method_43470((String)"Click to select this class!").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067}).method_30937());
        return lines;
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        super.method_25419();
    }

    public boolean method_25422() {
        return false;
    }

    public static interface OnClassChosen {
        public void choose(PlayerStats.ClassType var1);
    }

    private static class ClassInfo {
        String name;
        AbilityInfo[] abilities;
        ClassStats stats;
        String playstyle;

        private ClassInfo() {
        }
    }

    private static class AbilityInfo {
        char key;
        String name;
        String description;
        int unlockLevel;
        int manaCost;
        int staminaCost;

        private AbilityInfo() {
        }
    }

    private static class ClassStats {
        String specialty;
        String difficulty;

        private ClassStats() {
        }
    }
}

