/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.gui;

import com.tessarected.stats.PlayerStats;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;

public class PlayerStatsHudOverlay {
    public static PlayerStats clientStats = new PlayerStats();
    private static long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 1000L;

    public static void render(class_332 context) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null || clientStats == null || !clientStats.hasChosenClass()) {
            return;
        }
        PlayerStats stats = clientStats;
        class_327 textRenderer = client.field_1772;
        int screenWidth = client.method_22683().method_4486();
        int screenHeight = client.method_22683().method_4502();
        int barWidth = 110;
        int barHeight = 8;
        int barPadding = 4;
        int sectionPadding = 6;
        int textPadding = 2;
        int x = 8;
        int y = screenHeight - 3 * (barHeight + barPadding) - sectionPadding - 20;
        int panelWidth = barWidth + 16;
        int panelHeight = 3 * (barHeight + barPadding) + sectionPadding + 16;
        int panelX = x - 8;
        int panelY = y - 10;
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -2013265920);
        String levelText = "Lv." + stats.getLevel();
        int levelTextWidth = textRenderer.method_1727(levelText);
        int levelX = panelX + (panelWidth - levelTextWidth) / 2;
        int levelY = panelY + 4;
        context.method_51433(textRenderer, levelText, levelX, levelY, class_124.field_1065.method_532().intValue(), false);
        int manaColor = stats.getManaBarColor();
        float mana = stats.getMana();
        float maxMana = stats.getMaxMana();
        int manaBar = maxMana > 0.0f ? (int)(mana / maxMana * (float)barWidth) : 0;
        Objects.requireNonNull(textRenderer);
        int manaBarY = levelY + 9 + sectionPadding;
        context.method_25294(x - 1, manaBarY - 1, x + barWidth + 1, manaBarY + barHeight + 1, -1442840576);
        context.method_25294(x, manaBarY, x + barWidth, manaBarY + barHeight, -14540220);
        context.method_25294(x, manaBarY, x + manaBar, manaBarY + barHeight, manaColor);
        String manaText = "Mana " + (int)mana + "/" + (int)maxMana;
        int manaTextWidth = textRenderer.method_1727(manaText);
        int manaTextX = x + (barWidth - manaTextWidth) / 2;
        Objects.requireNonNull(textRenderer);
        int manaTextY = manaBarY + (barHeight - 9) / 2;
        context.method_51433(textRenderer, manaText, manaTextX, manaTextY, -16777216, false);
        int staminaColor = stats.getStaminaBarColor();
        int stamina = (int)stats.getStamina();
        int maxStamina = (int)stats.getMaxStamina();
        int staminaBar = maxStamina > 0 ? stamina * barWidth / maxStamina : 0;
        int staminaBarY = manaBarY + barHeight + barPadding;
        context.method_25294(x - 1, staminaBarY - 1, x + barWidth + 1, staminaBarY + barHeight + 1, -1442840576);
        context.method_25294(x, staminaBarY, x + barWidth, staminaBarY + barHeight, -12303838);
        context.method_25294(x, staminaBarY, x + staminaBar, staminaBarY + barHeight, staminaColor);
        String staminaText = "Stamina " + stamina + "/" + maxStamina;
        int staminaTextWidth = textRenderer.method_1727(staminaText);
        int staminaTextX = x + (barWidth - staminaTextWidth) / 2;
        Objects.requireNonNull(textRenderer);
        int staminaTextY = staminaBarY + (barHeight - 9) / 2;
        context.method_51433(textRenderer, staminaText, staminaTextX, staminaTextY, -16777216, false);
        int xp = stats.getXp();
        int xpToNextLevel = stats.getXpToNextLevel();
        int xpBarWidth = barWidth;
        int xpBarHeight = 6;
        int xpBarY = staminaBarY + barHeight + barPadding;
        float xpProgress = xpToNextLevel > 0 ? (float)xp / (float)xpToNextLevel : 1.0f;
        int filledXpBar = (int)(xpProgress * (float)xpBarWidth);
        context.method_25294(x - 1, xpBarY - 1, x + xpBarWidth + 1, xpBarY + xpBarHeight + 1, -1442840576);
        context.method_25294(x, xpBarY, x + xpBarWidth, xpBarY + xpBarHeight, -14540254);
        context.method_25294(x, xpBarY, x + filledXpBar, xpBarY + xpBarHeight, -16733441);
        String xpText = Math.round(xpProgress * 100.0f) + "%";
        int xpTextWidth = textRenderer.method_1727(xpText);
        int xpTextX = x + (xpBarWidth - xpTextWidth) / 2;
        Objects.requireNonNull(textRenderer);
        int xpTextY = xpBarY + (xpBarHeight - 9) / 2;
        context.method_51433(textRenderer, xpText, xpTextX, xpTextY, -5181185, false);
    }

    public static int getUIHeight() {
        if (clientStats == null || !clientStats.hasChosenClass()) {
            return 0;
        }
        int barHeight = 8;
        int barPadding = 4;
        int sectionPadding = 6;
        int xpBarHeight = 6;
        return 25 + sectionPadding + barHeight + barPadding + barHeight + barPadding + xpBarHeight + 20;
    }
}

