/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tessarected.gui.PlayerStatsHudOverlay;
import com.tessarected.skills.SkillTreeSystem;
import com.tessarected.stats.PlayerStats;
import com.tessarected.stats.PlayerStatsUpdatePacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class SkillTreeScreen
extends class_437 {
    private PlayerStats stats;
    private final class_310 mc = class_310.method_1551();
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 10L;
    private List<SkillNode> nodes = new ArrayList<SkillNode>();
    private SkillNode hoveredNode = null;
    private SkillNode selectedNode = null;
    private class_4185 resetButton;
    private class_4185 centerButton;
    private class_4185 filterButton;
    private float scrollX = 0.0f;
    private float scrollY = 0.0f;
    private double lastMouseX = 0.0;
    private double lastMouseY = 0.0;
    private boolean dragging = false;
    private float zoom = 1.0f;
    private static final float MIN_ZOOM = 0.3f;
    private static final float MAX_ZOOM = 3.0f;
    private static final float ZOOM_STEP = 0.15f;
    private float targetScrollX = 0.0f;
    private float targetScrollY = 0.0f;
    private float targetZoom = 1.0f;
    private static final float SCROLL_SMOOTH_FACTOR = 0.15f;
    private static final float ZOOM_SMOOTH_FACTOR = 0.2f;
    private float minTreeX = Float.MAX_VALUE;
    private float maxTreeX = Float.MIN_VALUE;
    private float minTreeY = Float.MAX_VALUE;
    private float maxTreeY = Float.MIN_VALUE;
    private long unlockAnimStart = 0L;
    private String animatingNodeId = null;
    private Map<String, Float> nodePulseAnimations = new HashMap<String, Float>();
    private long lastPulseUpdate = 0L;
    private boolean showOnlyAvailable = false;
    private long lastHoverTime = 0L;
    private static final long TOOLTIP_DELAY = 300L;
    private boolean showMinimap = true;
    private static final int MINIMAP_SIZE = 120;
    private static final int MINIMAP_MARGIN = 10;
    private List<SkillNode> visibleNodes = new ArrayList<SkillNode>();
    private boolean needsVisibilityUpdate = true;
    private long lastVisibilityUpdate = 0L;
    private static final long VISIBILITY_UPDATE_INTERVAL = 100L;

    public SkillTreeScreen(PlayerStats stats) {
        super((class_2561)class_2561.method_43470((String)"Skill Tree"));
        this.stats = stats != null ? stats : PlayerStatsHudOverlay.clientStats;
        this.lastUpdateTime = System.currentTimeMillis();
    }

    private boolean isMouseOverNodeOptimized(SkillNode node, double worldX, double worldY) {
        int radius = 30;
        double dx = Math.abs(worldX - (double)(node.x + (float)radius));
        double dy = Math.abs(worldY - (double)(node.y + (float)radius));
        return dx <= (double)radius && dy <= (double)radius;
    }

    protected void method_25426() {
        this.initializeSkillTree();
        this.updateNodeStates();
        this.calculateTreeBounds();
        this.initializeAnimations();
        int buttonWidth = 80;
        int buttonHeight = 20;
        int buttonSpacing = 5;
        int startX = this.field_22789 - buttonWidth - 10;
        int startY = 10;
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset").method_27692(class_124.field_1061), button -> this.resetSkillTree(this.mc.field_1724)).method_46434(startX, startY, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.centerButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Center").method_27692(class_124.field_1075), button -> this.centerView()).method_46434(startX, startY + buttonHeight + buttonSpacing, buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.centerButton);
        this.filterButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.showOnlyAvailable ? "Show All" : "Available")).method_27692(class_124.field_1054), button -> this.toggleFilter()).method_46434(startX, startY + 2 * (buttonHeight + buttonSpacing), buttonWidth, buttonHeight).method_46431();
        this.method_37063((class_364)this.filterButton);
    }

    private void initializeAnimations() {
        this.nodePulseAnimations.clear();
        for (SkillNode node : this.nodes) {
            if (!node.available || node.unlocked) continue;
            this.nodePulseAnimations.put(node.id, Float.valueOf((float)(Math.random() * Math.PI * 2.0)));
        }
    }

    private void centerView() {
        this.targetScrollX = 0.0f;
        this.targetScrollY = 0.0f;
        this.targetZoom = 1.0f;
    }

    private void toggleFilter() {
        this.showOnlyAvailable = !this.showOnlyAvailable;
        this.filterButton.method_25355((class_2561)class_2561.method_43470((String)(this.showOnlyAvailable ? "Show All" : "Available")).method_27692(class_124.field_1054));
    }

    private void resetSkillTree(class_746 player) {
        if (this.stats == null) {
            return;
        }
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_5783(class_3417.field_14785, 0.8f, 0.9f);
            if (this.mc.field_1687 != null) {
                double x = this.mc.field_1724.method_23317();
                double y = this.mc.field_1724.method_23318() + 1.0;
                double z = this.mc.field_1724.method_23321();
                for (int i = 0; i < 50; ++i) {
                    this.mc.field_1687.method_8406((class_2394)class_2398.field_11205, x, y, z, (Math.random() - 0.5) * 1.5, Math.random() * 1.5, (Math.random() - 0.5) * 1.5);
                    this.mc.field_1687.method_8406((class_2394)class_2398.field_11251, x, y, z, (Math.random() - 0.5) * 1.0, Math.random() * 1.0, (Math.random() - 0.5) * 1.0);
                }
            }
        }
        PlayerStatsUpdatePacket.sendSkillTreeReset();
        this.mc.execute(() -> this.mc.execute(() -> {
            this.initializeSkillTree();
            this.updateNodeStates();
            this.calculateTreeBounds();
            this.initializeAnimations();
        }));
    }

    private void initializeSkillTree() {
        this.nodes.clear();
        for (String nodeId : SkillTreeSystem.getAllSkillIds()) {
            SkillTreeSystem.SkillNodeData nodeData = SkillTreeSystem.getSkillNode(nodeId);
            if (nodeData == null) continue;
            SkillNode visualNode = this.createVisualNode(nodeData);
            this.nodes.add(visualNode);
        }
        this.setupConnections();
    }

    private SkillNode createVisualNode(SkillTreeSystem.SkillNodeData nodeData) {
        class_241 position = this.calculateNodePosition(nodeData);
        return new SkillNode(nodeData.id, position.field_1343, position.field_1342, this.convertNodeType(nodeData.type), nodeData.name, nodeData.description, nodeData.cost, nodeData.maxRank);
    }

    private class_241 calculateNodePosition(SkillTreeSystem.SkillNodeData nodeData) {
        return switch (nodeData.type) {
            default -> throw new IncompatibleClassChangeError();
            case SkillTreeSystem.SkillNodeType.ROOT -> this.calculateRootPosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.ATTRIBUTE -> this.calculateAttributePosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.COMBAT -> this.calculateCombatPosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.MAGIC -> this.calculateMagicPosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.DEFENSE -> this.calculateDefensePosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.UTILITY -> this.calculateUtilityPosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.MASTERY -> this.calculateMasteryPosition(nodeData.id);
            case SkillTreeSystem.SkillNodeType.ULTIMATE -> new class_241(0.0f, 700.0f);
        };
    }

    private class_241 calculateRootPosition(String nodeId) {
        return switch (nodeId) {
            case "root" -> new class_241(0.0f, 0.0f);
            case "combat_path" -> new class_241(-200.0f, 100.0f);
            case "magic_path" -> new class_241(200.0f, 100.0f);
            case "agility_path" -> new class_241(-200.0f, -100.0f);
            case "defense_path" -> new class_241(200.0f, -100.0f);
            default -> new class_241(0.0f, 100.0f);
        };
    }

    private class_241 calculateAttributePosition(String nodeId) {
        return switch (nodeId) {
            case "strength_1" -> new class_241(-200.0f, 200.0f);
            case "intelligence_1" -> new class_241(200.0f, 200.0f);
            case "agility_1" -> new class_241(-200.0f, -200.0f);
            case "vitality_1" -> new class_241(200.0f, -200.0f);
            default -> new class_241(0.0f, 200.0f);
        };
    }

    private class_241 calculateCombatPosition(String nodeId) {
        return switch (nodeId) {
            case "critical_mastery" -> new class_241(-100.0f, 300.0f);
            case "weapon_expertise" -> new class_241(-300.0f, 300.0f);
            case "berserker_rage" -> new class_241(-300.0f, 400.0f);
            default -> new class_241(-200.0f, 300.0f);
        };
    }

    private class_241 calculateMagicPosition(String nodeId) {
        return switch (nodeId) {
            case "mana_mastery" -> new class_241(200.0f, 300.0f);
            case "spell_power" -> new class_241(100.0f, 400.0f);
            case "mana_efficiency" -> new class_241(300.0f, 400.0f);
            case "arcane_mastery" -> new class_241(200.0f, 500.0f);
            default -> new class_241(200.0f, 300.0f);
        };
    }

    private class_241 calculateDefensePosition(String nodeId) {
        return switch (nodeId) {
            case "armor_mastery" -> new class_241(200.0f, -300.0f);
            case "magical_ward" -> new class_241(100.0f, -400.0f);
            case "fortress" -> new class_241(300.0f, -400.0f);
            default -> new class_241(200.0f, -300.0f);
        };
    }

    private class_241 calculateUtilityPosition(String nodeId) {
        return switch (nodeId) {
            case "health_regen" -> new class_241(100.0f, -300.0f);
            case "stamina_mastery" -> new class_241(-100.0f, -300.0f);
            case "second_wind" -> new class_241(0.0f, -400.0f);
            case "ability_unlock_x" -> new class_241(-400.0f, 0.0f);
            case "ability_unlock_c" -> new class_241(400.0f, 0.0f);
            default -> new class_241(0.0f, -300.0f);
        };
    }

    private class_241 calculateMasteryPosition(String nodeId) {
        return switch (nodeId) {
            case "mender_mastery" -> new class_241(350.0f, 600.0f);
            case "harvester_mastery" -> new class_241(-350.0f, 600.0f);
            case "echo_mastery" -> new class_241(350.0f, -600.0f);
            case "guardian_mastery" -> new class_241(-350.0f, -600.0f);
            default -> new class_241(0.0f, 600.0f);
        };
    }

    private NodeType convertNodeType(SkillTreeSystem.SkillNodeType systemType) {
        return switch (systemType) {
            default -> throw new IncompatibleClassChangeError();
            case SkillTreeSystem.SkillNodeType.ROOT -> NodeType.ROOT;
            case SkillTreeSystem.SkillNodeType.ATTRIBUTE -> NodeType.ATTRIBUTE;
            case SkillTreeSystem.SkillNodeType.COMBAT -> NodeType.COMBAT;
            case SkillTreeSystem.SkillNodeType.MAGIC -> NodeType.MAGIC;
            case SkillTreeSystem.SkillNodeType.DEFENSE -> NodeType.DEFENSE;
            case SkillTreeSystem.SkillNodeType.UTILITY -> NodeType.UTILITY;
            case SkillTreeSystem.SkillNodeType.MASTERY -> NodeType.MASTERY;
            case SkillTreeSystem.SkillNodeType.ULTIMATE -> NodeType.ULTIMATE;
        };
    }

    private void setupConnections() {
        for (SkillNode node : this.nodes) {
            List<String> prerequisites = SkillTreeSystem.getPrerequisites(node.id);
            for (String prereqId : prerequisites) {
                SkillNode prereqNode = this.findNodeById(prereqId);
                if (prereqNode == null) continue;
                this.connectNodes(prereqNode, node);
            }
        }
    }

    private void connectNodes(SkillNode parent, SkillNode child) {
        parent.children.add(child);
        child.parents.add(parent);
    }

    private SkillNode findNodeById(String id) {
        return this.nodes.stream().filter(node -> node.id.equals(id)).findFirst().orElse(null);
    }

    private void updateNodeStates() {
        if (this.stats == null) {
            return;
        }
        for (SkillNode node : this.nodes) {
            boolean wasAvailable = node.available;
            node.unlocked = this.stats.isSkillNodeUnlocked(node.id);
            node.currentRank = SkillTreeSystem.getSkillRank(node.id, this.stats);
            node.available = SkillTreeSystem.canUnlockSkill(node.id, this.stats);
            if (wasAvailable || !node.available || node.unlocked) continue;
            this.nodePulseAnimations.put(node.id, Float.valueOf(0.0f));
        }
    }

    private void calculateTreeBounds() {
        this.minTreeX = Float.MAX_VALUE;
        this.maxTreeX = Float.MIN_VALUE;
        this.minTreeY = Float.MAX_VALUE;
        this.maxTreeY = Float.MIN_VALUE;
        for (SkillNode node : this.nodes) {
            this.minTreeX = Math.min(this.minTreeX, node.x);
            this.maxTreeX = Math.max(this.maxTreeX, node.x);
            this.minTreeY = Math.min(this.minTreeY, node.y);
            this.maxTreeY = Math.max(this.maxTreeY, node.y);
        }
        float padding = 300.0f;
        this.minTreeX -= padding;
        this.maxTreeX += padding;
        this.minTreeY -= padding;
        this.maxTreeY += padding;
    }

    public void method_25393() {
        long elapsed;
        long currentTime;
        super.method_25393();
        float scrollDelta = Math.abs(this.targetScrollX - this.scrollX) + Math.abs(this.targetScrollY - this.scrollY);
        float zoomDelta = Math.abs(this.targetZoom - this.zoom);
        if (scrollDelta > 0.1f || zoomDelta > 0.01f) {
            this.scrollX += (this.targetScrollX - this.scrollX) * 0.15f;
            this.scrollY += (this.targetScrollY - this.scrollY) * 0.15f;
            this.zoom += (this.targetZoom - this.zoom) * 0.2f;
            this.needsVisibilityUpdate = true;
        }
        if ((currentTime = System.currentTimeMillis()) - this.lastUpdateTime >= 10L) {
            this.updateStats();
            this.lastUpdateTime = currentTime;
        }
        if (this.needsVisibilityUpdate && currentTime - this.lastVisibilityUpdate >= 100L) {
            this.updateVisibleNodes();
            this.needsVisibilityUpdate = false;
            this.lastVisibilityUpdate = currentTime;
        }
        if (currentTime - this.lastPulseUpdate >= 100L) {
            this.updatePulseAnimationsOptimized();
            this.lastPulseUpdate = currentTime;
        }
        if (this.animatingNodeId != null && (elapsed = System.currentTimeMillis() - this.unlockAnimStart) >= 800L) {
            this.animatingNodeId = null;
        }
    }

    private void updateVisibleNodes() {
        this.visibleNodes.clear();
        float screenLeft = -this.scrollX - (float)this.field_22789 / (2.0f * this.zoom);
        float screenRight = -this.scrollX + (float)this.field_22789 / (2.0f * this.zoom);
        float screenTop = -this.scrollY - (float)this.field_22790 / (2.0f * this.zoom);
        float screenBottom = -this.scrollY + (float)this.field_22790 / (2.0f * this.zoom);
        float padding = 100.0f / this.zoom;
        screenLeft -= padding;
        screenRight += padding;
        screenTop -= padding;
        screenBottom += padding;
        for (SkillNode node : this.nodes) {
            if (this.showOnlyAvailable && !node.unlocked && !node.available || !(node.x >= screenLeft) || !(node.x <= screenRight) || !(node.y >= screenTop) || !(node.y <= screenBottom)) continue;
            this.visibleNodes.add(node);
        }
    }

    private void updatePulseAnimationsOptimized() {
        Iterator<Map.Entry<String, Float>> iterator = this.nodePulseAnimations.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Float> entry = iterator.next();
            SkillNode node = this.findNodeById(entry.getKey());
            if (node == null || node.unlocked || !node.available) {
                iterator.remove();
                continue;
            }
            if (!this.visibleNodes.contains(node)) continue;
            entry.setValue(Float.valueOf(entry.getValue().floatValue() + 0.08f));
        }
    }

    private void updateStats() {
        if (this.stats == null || this.stats != PlayerStatsHudOverlay.clientStats) {
            this.stats = PlayerStatsHudOverlay.clientStats;
            this.updateNodeStates();
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0) {
            class_241 worldPos = this.screenToWorld(mouseX, mouseY);
            for (SkillNode node : this.nodes) {
                if (!this.isMouseOverNode(node, worldPos.field_1343, worldPos.field_1342) || !this.tryUnlockNode(node)) continue;
                this.selectedNode = node;
                return true;
            }
            this.selectedNode = null;
        } else if (button == 1) {
            this.dragging = true;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private boolean tryUnlockNode(SkillNode node) {
        if (this.stats == null) {
            return false;
        }
        if (!SkillTreeSystem.canUnlockSkill(node.id, this.stats)) {
            this.showUnlockFailureReason(node);
            return false;
        }
        class_2487 nbt = new class_2487();
        nbt.method_10582("nodeId", node.id);
        try {
            PlayerStatsUpdatePacket.sendToServer("unlock_skill_tree_node", nbt);
        }
        catch (Exception e) {
            System.err.println("Failed to send skill unlock packet: " + e.getMessage());
        }
        this.playUnlockEffects(node);
        this.updateNodeStates();
        this.initializeAnimations();
        return true;
    }

    private void showUnlockFailureReason(SkillNode node) {
        if (this.mc.field_1724 != null) {
            if (this.stats.getSkillPoints() < node.cost) {
                this.mc.field_1724.method_5783((class_3414)class_3417.field_14624.comp_349(), 0.8f, 0.5f);
            } else {
                this.mc.field_1724.method_5783((class_3414)class_3417.field_18310.comp_349(), 0.8f, 0.8f);
            }
        }
    }

    private void playUnlockEffects(SkillNode node) {
        if (this.mc.field_1724 != null) {
            this.mc.field_1724.method_5783(class_3417.field_15195, 1.0f, 1.2f);
        }
        this.unlockAnimStart = System.currentTimeMillis();
        this.animatingNodeId = node.id;
        this.nodePulseAnimations.remove(node.id);
        if (this.mc.field_1687 != null) {
            class_241 screenPos = this.worldToScreen(node.x, node.y);
            this.spawnUnlockParticles(this.mc.field_1687, screenPos.field_1343, screenPos.field_1342);
        }
    }

    private void spawnUnlockParticles(class_638 world, double x, double y) {
        for (int i = 0; i < 30; ++i) {
            double spread = 2.0;
            double px = x + (Math.random() - 0.5) * 60.0 * spread;
            double py = y + (Math.random() - 0.5) * 60.0 * spread;
            double vx = (Math.random() - 0.5) * 1.2;
            double vy = (Math.random() - 0.5) * 1.2;
            world.method_8406((class_2394)class_2398.field_11248, px, py, 0.0, vx, vy, 0.0);
            world.method_8406((class_2394)class_2398.field_11207, px, py, 0.0, vx * 0.5, vy * 0.5, 0.0);
            world.method_8406((class_2394)class_2398.field_11215, px, py, 0.0, vx * 0.3, vy * 0.3, 0.0);
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.dragging) {
            float sensitivity = 1.0f / this.zoom;
            this.targetScrollX += (float)(mouseX - this.lastMouseX) * sensitivity;
            this.targetScrollY += (float)(mouseY - this.lastMouseY) * sensitivity;
            this.lastMouseX = mouseX;
            this.lastMouseY = mouseY;
            this.clampScroll();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (button == 1) {
            this.dragging = false;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        float oldZoom = this.targetZoom;
        this.targetZoom = amount > 0.0 ? Math.min(3.0f, this.targetZoom + 0.15f) : Math.max(0.3f, this.targetZoom - 0.15f);
        if (this.targetZoom != oldZoom) {
            float zoomRatio = oldZoom / this.targetZoom;
            this.targetScrollX = (this.targetScrollX + (float)this.field_22789 / (2.0f * oldZoom) - (float)mouseX / zoomRatio) * (this.targetZoom / oldZoom) - (float)this.field_22789 / (2.0f * this.targetZoom) + (float)mouseX / this.targetZoom;
            this.targetScrollY = (this.targetScrollY + (float)this.field_22790 / (2.0f * oldZoom) - (float)mouseY / zoomRatio) * (this.targetZoom / oldZoom) - (float)this.field_22790 / (2.0f * this.targetZoom) + (float)mouseY / this.targetZoom;
            this.clampScroll();
        }
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        float panAmount = 100.0f / this.targetZoom;
        switch (keyCode) {
            case 262: {
                this.targetScrollX -= panAmount;
                break;
            }
            case 263: {
                this.targetScrollX += panAmount;
                break;
            }
            case 264: {
                this.targetScrollY += panAmount;
                break;
            }
            case 265: {
                this.targetScrollY -= panAmount;
                break;
            }
            case 82: {
                this.centerView();
                break;
            }
            case 77: {
                this.showMinimap = !this.showMinimap;
                break;
            }
            case 70: {
                this.toggleFilter();
                break;
            }
            default: {
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        }
        this.clampScroll();
        return true;
    }

    private void clampScroll() {
        float visibleWidthLogical = (float)this.field_22789 / this.targetZoom;
        float visibleHeightLogical = (float)this.field_22790 / this.targetZoom;
        float treeWidth = this.maxTreeX - this.minTreeX;
        float treeHeight = this.maxTreeY - this.minTreeY;
        float maxScrollX = Math.max(0.0f, (treeWidth - visibleWidthLogical) / 2.0f + 100.0f);
        float maxScrollY = Math.max(0.0f, (treeHeight - visibleHeightLogical) / 2.0f + 100.0f);
        this.targetScrollX = Math.max(-maxScrollX, Math.min(maxScrollX, this.targetScrollX));
        this.targetScrollY = Math.max(-maxScrollY, Math.min(maxScrollY, this.targetScrollY));
    }

    private class_241 screenToWorld(double screenX, double screenY) {
        float centerX = (float)this.field_22789 / 2.0f;
        float centerY = (float)this.field_22790 / 2.0f;
        float worldX = ((float)screenX - centerX - this.scrollX * this.zoom) / this.zoom + centerX;
        float worldY = ((float)screenY - centerY - this.scrollY * this.zoom) / this.zoom + centerY;
        return new class_241(worldX, worldY);
    }

    private class_241 worldToScreen(float worldX, float worldY) {
        float centerX = (float)this.field_22789 / 2.0f;
        float centerY = (float)this.field_22790 / 2.0f;
        float screenX = (worldX - centerX) * this.zoom + centerX + this.scrollX * this.zoom;
        float screenY = (worldY - centerY) * this.zoom + centerY + this.scrollY * this.zoom;
        return new class_241(screenX, screenY);
    }

    private boolean isMouseOverNode(SkillNode node, double worldX, double worldY) {
        int radius = 30;
        double dx = worldX - (double)(node.x + (float)radius);
        double dy = worldY - (double)(node.y + (float)radius);
        return dx * dx + dy * dy <= (double)(radius * radius);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.clampScroll();
        this.method_25420(context);
        this.setupRenderTransform(context);
        this.renderConnections(context);
        this.renderFilteredNodes(context);
        context.method_51448().method_22909();
        RenderSystem.restoreProjectionMatrix();
        this.updateHoveredNode(mouseX, mouseY);
        this.renderUIOverlay(context, mouseX, mouseY);
        if (this.showMinimap) {
            this.renderMinimap(context);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        this.renderEnhancedTooltip(context, mouseX, mouseY);
    }

    private void renderFilteredNodes(class_332 context) {
        List<SkillNode> nodesToRender = this.visibleNodes;
        ArrayList<SkillNode> lockedNodes = new ArrayList<SkillNode>();
        ArrayList<SkillNode> availableNodes = new ArrayList<SkillNode>();
        ArrayList<SkillNode> unlockedNodes = new ArrayList<SkillNode>();
        for (SkillNode node2 : nodesToRender) {
            if (node2.unlocked) {
                unlockedNodes.add(node2);
                continue;
            }
            if (node2.available) {
                availableNodes.add(node2);
                continue;
            }
            lockedNodes.add(node2);
        }
        lockedNodes.forEach(node -> this.renderNodeOptimized(context, (SkillNode)node));
        availableNodes.forEach(node -> this.renderNodeOptimized(context, (SkillNode)node));
        unlockedNodes.forEach(node -> this.renderNodeOptimized(context, (SkillNode)node));
    }

    private void renderMinimap(class_332 context) {
        int minimapX = this.field_22789 - 120 - 10;
        int minimapY = this.field_22790 - 120 - 10;
        context.method_25294(minimapX - 2, minimapY - 2, minimapX + 120 + 2, minimapY + 120 + 2, -16777216);
        context.method_25294(minimapX, minimapY, minimapX + 120, minimapY + 120, -2011028958);
        float treeWidth = this.maxTreeX - this.minTreeX;
        float treeHeight = this.maxTreeY - this.minTreeY;
        float scale = Math.min(120.0f / treeWidth, 120.0f / treeHeight) * 0.8f;
        for (SkillNode node : this.nodes) {
            int nodeX = minimapX + (int)((node.x - this.minTreeX) * scale);
            int nodeY = minimapY + (int)((node.y - this.minTreeY) * scale);
            int color = node.unlocked ? -16711936 : (node.available ? -256 : -10066330);
            context.method_25294(nodeX - 1, nodeY - 1, nodeX + 2, nodeY + 2, color);
        }
        float viewWidth = (float)this.field_22789 / this.zoom;
        float viewHeight = (float)this.field_22790 / this.zoom;
        int viewX1 = minimapX + (int)((-this.scrollX - viewWidth / 2.0f - this.minTreeX) * scale);
        int viewY1 = minimapY + (int)((-this.scrollY - viewHeight / 2.0f - this.minTreeY) * scale);
        int viewX2 = minimapX + (int)((-this.scrollX + viewWidth / 2.0f - this.minTreeX) * scale);
        int viewY2 = minimapY + (int)((-this.scrollY + viewHeight / 2.0f - this.minTreeY) * scale);
        context.method_49601(viewX1, viewY1, viewX2 - viewX1, viewY2 - viewY1, -1);
    }

    private void renderUIOverlay(class_332 context, int mouseX, int mouseY) {
        if (this.stats != null) {
            String skillPointsText = "Skill Points: " + this.stats.getSkillPoints();
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)skillPointsText).method_27692(class_124.field_1065), 10, 10, -1);
            String zoomText = String.format("Zoom: %.1fx", Float.valueOf(this.zoom));
            context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)zoomText).method_27692(class_124.field_1080), 10, 25, -3355444);
            if (this.hoveredNode == null) {
                String[] controls = new String[]{"Controls:", "Left Click - Unlock skill", "Right Click + Drag - Pan view", "Mouse Wheel - Zoom", "Arrow Keys - Pan view", "R - Center view", "M - Toggle minimap", "F - Toggle filter"};
                int n = controls.length;
                Objects.requireNonNull(this.field_22793);
                int helpY = this.field_22790 - n * (9 + 2) - 10;
                for (int i = 0; i < controls.length; ++i) {
                    class_124 color = i == 0 ? class_124.field_1054 : class_124.field_1080;
                    class_5250 class_52502 = class_2561.method_43470((String)controls[i]).method_27692(color);
                    Objects.requireNonNull(this.field_22793);
                    context.method_27535(this.field_22793, (class_2561)class_52502, 10, helpY + i * (9 + 2), -1);
                }
            }
        }
    }

    private void renderEnhancedTooltip(class_332 context, int mouseX, int mouseY) {
        int n;
        if (this.hoveredNode == null) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastHoverTime < 300L) {
            return;
        }
        ArrayList<Object> tooltipLines = new ArrayList<Object>();
        class_124 nameColor = this.hoveredNode.unlocked ? class_124.field_1060 : (this.hoveredNode.available ? class_124.field_1054 : class_124.field_1061);
        tooltipLines.add("\u00a7l" + nameColor.toString() + this.hoveredNode.name);
        tooltipLines.add("\u00a78" + this.formatNodeType(this.hoveredNode.type));
        tooltipLines.add("");
        String description = this.hoveredNode.description;
        List<String> wrappedDesc = this.wrapText(description, 300);
        tooltipLines.addAll(wrappedDesc);
        tooltipLines.add("");
        if (!this.hoveredNode.unlocked) {
            List<String> prereqs;
            tooltipLines.add("\u00a76Cost: \u00a7f" + this.hoveredNode.cost + " skill points");
            if (this.stats != null && this.stats.getSkillPoints() < this.hoveredNode.cost) {
                tooltipLines.add("\u00a7cInsufficient skill points!");
            }
            if (!(prereqs = SkillTreeSystem.getPrerequisites(this.hoveredNode.id)).isEmpty()) {
                tooltipLines.add("");
                tooltipLines.add("\u00a7eRequires:");
                for (String string : prereqs) {
                    SkillNode prereqNode = this.findNodeById(string);
                    if (prereqNode == null) continue;
                    boolean hasPrereq = prereqNode.unlocked;
                    String statusColor = hasPrereq ? "\u00a7a" : "\u00a7c";
                    String statusSymbol = hasPrereq ? "\u2713" : "\u2717";
                    tooltipLines.add("  " + statusColor + statusSymbol + " " + prereqNode.name);
                }
            }
        } else if (this.hoveredNode.maxRank > 1) {
            tooltipLines.add("\u00a7bRank: \u00a7f" + this.hoveredNode.currentRank + "/" + this.hoveredNode.maxRank);
            if (this.hoveredNode.currentRank < this.hoveredNode.maxRank) {
                tooltipLines.add("\u00a76Next rank cost: \u00a7f" + this.hoveredNode.cost + " skill points");
            }
        } else {
            tooltipLines.add("\u00a7aUnlocked");
        }
        int maxWidth = 0;
        for (String string : tooltipLines) {
            int lineWidth = this.field_22793.method_1727(string.replaceAll("\u00a7.", ""));
            maxWidth = Math.max(maxWidth, lineWidth);
        }
        maxWidth = Math.max(200, maxWidth + 20);
        int n2 = tooltipLines.size();
        Objects.requireNonNull(this.field_22793);
        int tooltipHeight = n2 * (9 + 2) + 10;
        int n3 = mouseX + 15;
        int tooltipY = mouseY - tooltipHeight / 2;
        if (n3 + maxWidth > this.field_22789 - 10) {
            n = mouseX - maxWidth - 15;
        }
        if (tooltipY + tooltipHeight > this.field_22790 - 10) {
            tooltipY = this.field_22790 - tooltipHeight - 10;
        }
        if (tooltipY < 10) {
            tooltipY = 10;
        }
        context.method_25294(n - 2, tooltipY - 2, n + maxWidth + 2, tooltipY + tooltipHeight + 2, -16777216);
        context.method_25294(n, tooltipY, n + maxWidth, tooltipY + tooltipHeight, -300279270);
        int borderColor = this.getTypeColor(this.hoveredNode.type, 1.0f);
        context.method_49601(n, tooltipY, maxWidth, tooltipHeight, borderColor);
        int textY = tooltipY + 5;
        for (String string : tooltipLines) {
            if (!string.isEmpty()) {
                context.method_27535(this.field_22793, (class_2561)class_2561.method_43470((String)string), n + 10, textY, -1);
            }
            Objects.requireNonNull(this.field_22793);
            textY += 9 + 2;
        }
    }

    private List<String> wrapText(String text, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.length() == 0 ? word : currentLine + " " + word;
            if (this.field_22793.method_1727(testLine) <= maxWidth) {
                currentLine.append((String)(currentLine.length() == 0 ? word : " " + word));
                continue;
            }
            if (currentLine.length() > 0) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (currentLine.length() > 0) {
            lines.add(currentLine.toString());
        }
        return lines;
    }

    private String formatNodeType(NodeType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NodeType.ROOT -> "Core Skill";
            case NodeType.ATTRIBUTE -> "Attribute";
            case NodeType.COMBAT -> "Combat Skill";
            case NodeType.MAGIC -> "Magic Skill";
            case NodeType.DEFENSE -> "Defense Skill";
            case NodeType.UTILITY -> "Utility Skill";
            case NodeType.MASTERY -> "Mastery Skill";
            case NodeType.ULTIMATE -> "Ultimate Skill";
        };
    }

    public void method_25420(class_332 context) {
        RenderSystem.enableBlend();
        float parallaxFactor1 = 0.1f;
        int bgOffsetX1 = (int)(this.scrollX * parallaxFactor1);
        int bgOffsetY1 = (int)(this.scrollY * parallaxFactor1);
        context.method_25294(0, 0, this.field_22789, this.field_22790, -16119281);
        this.renderAnimatedBackground(context);
        this.renderBackgroundGrid(context, bgOffsetX1, bgOffsetY1);
    }

    private void renderAnimatedBackground(class_332 context) {
        long time = System.currentTimeMillis();
        Random random = new Random(12345L);
        for (int i = 0; i < 20; ++i) {
            float x = random.nextFloat() * (float)this.field_22789 * 2.0f % (float)this.field_22789;
            float y = random.nextFloat() * (float)this.field_22790 * 2.0f % (float)this.field_22790;
            if ((time + (long)(i * 200)) % 2000L >= 1000L) continue;
            int alpha = 80;
            int starColor = alpha << 24 | 0xFFFFFF;
            context.method_25294((int)x, (int)y, (int)x + 1, (int)y + 1, starColor);
        }
    }

    private void renderBackgroundGrid(class_332 context, int offsetX, int offsetY) {
        int gridSize = 120;
        int gridColor = 0x10FFFFFF;
        if (this.zoom < 0.5f) {
            return;
        }
        for (int x = -gridSize + offsetX % gridSize; x < this.field_22789 + gridSize; x += gridSize) {
            if (x % (gridSize * 2) != 0) continue;
            context.method_25294(x, 0, x + 1, this.field_22790, gridColor);
        }
        for (int y = -gridSize + offsetY % gridSize; y < this.field_22790 + gridSize; y += gridSize) {
            if (y % (gridSize * 2) != 0) continue;
            context.method_25294(0, y, this.field_22789, y + 1, gridColor);
        }
    }

    private void setupRenderTransform(class_332 context) {
        RenderSystem.backupProjectionMatrix();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.method_51448().method_22903();
        context.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 0.0f);
        context.method_51448().method_46416(this.scrollX * this.zoom, this.scrollY * this.zoom, 0.0f);
        context.method_51448().method_22905(this.zoom, this.zoom, 1.0f);
        context.method_51448().method_46416((float)(-this.field_22789) / 2.0f, (float)(-this.field_22790) / 2.0f, 0.0f);
    }

    private void renderConnections(class_332 context) {
        for (SkillNode node : this.visibleNodes) {
            for (SkillNode child : node.children) {
                if (!this.visibleNodes.contains(child)) continue;
                this.renderConnectionOptimized(context, node, child);
            }
        }
    }

    private void renderConnectionOptimized(class_332 context, SkillNode parent, SkillNode child) {
        float x1 = parent.x + 30.0f;
        float y1 = parent.y + 30.0f;
        float x2 = child.x + 30.0f;
        float y2 = child.y + 30.0f;
        int lineColor = child.unlocked && parent.unlocked ? -16720640 : (child.available && parent.unlocked ? -22016 : -12303292);
        this.drawLineOptimized(context, (int)x1, (int)y1, (int)x2, (int)y2, lineColor);
        if ((lineColor & 0xFF00DD00) == -16720640 && System.currentTimeMillis() % 100L < 50L) {
            long time = System.currentTimeMillis();
            float progress = (float)(time % 3000L) / 3000.0f;
            int flowX = (int)(x1 + (x2 - x1) * progress);
            int flowY = (int)(y1 + (y2 - y1) * progress);
            context.method_25294(flowX - 2, flowY - 2, flowX + 2, flowY + 2, -2013200385);
        }
    }

    private void drawLineOptimized(class_332 context, int x1, int y1, int x2, int y2, int color) {
        int dx = Math.abs(x2 - x1);
        int dy = Math.abs(y2 - y1);
        int sx = x1 < x2 ? 1 : -1;
        int sy = y1 < y2 ? 1 : -1;
        int err = dx - dy;
        int cx = x1;
        int cy = y1;
        boolean drawPixel = true;
        while (true) {
            if (drawPixel) {
                context.method_25294(cx, cy, cx + 2, cy + 2, color);
            }
            boolean bl = drawPixel = !drawPixel;
            if (cx == x2 && cy == y2) break;
            int e2 = 2 * err;
            if (e2 > -dy) {
                err -= dy;
                cx += sx;
            }
            if (e2 >= dx) continue;
            err += dx;
            cy += sy;
        }
    }

    private void renderNodeOptimized(class_332 context, SkillNode node) {
        long elapsed;
        boolean isAnimating;
        int nodeSize = 60;
        int x = (int)node.x;
        int y = (int)node.y;
        float scale = 1.0f;
        boolean bl = isAnimating = this.animatingNodeId != null && this.animatingNodeId.equals(node.id);
        if (isAnimating && (elapsed = System.currentTimeMillis() - this.unlockAnimStart) < 800L) {
            float progress = (float)elapsed / 800.0f;
            scale = 1.0f + 0.3f * (float)Math.sin((double)progress * Math.PI * 2.0) * (1.0f - progress);
        }
        if (this.nodePulseAnimations.containsKey(node.id)) {
            float pulsePhase = this.nodePulseAnimations.get(node.id).floatValue();
            scale *= 1.0f + (float)Math.sin(pulsePhase) * 0.05f;
        }
        int scaledSize = (int)((float)nodeSize * scale);
        int offsetX = (nodeSize - scaledSize) / 2;
        int offsetY = (nodeSize - scaledSize) / 2;
        int bgColor = this.getNodeBackgroundColor(node);
        context.method_25294(x + offsetX, y + offsetY, x + offsetX + scaledSize, y + offsetY + scaledSize, bgColor);
        int borderColor = this.getNodeBorderColor(node);
        context.method_49601(x + offsetX, y + offsetY, scaledSize, scaledSize, borderColor);
        String icon = this.getNodeIcon(node);
        int iconColor = this.getNodeIconColor(node);
        class_5250 class_52502 = class_2561.method_43470((String)icon);
        int n = x + nodeSize / 2;
        int n2 = y + nodeSize / 2;
        Objects.requireNonNull(this.field_22793);
        context.method_27534(this.field_22793, (class_2561)class_52502, n, n2 - 9 / 2, iconColor);
        if (node.maxRank > 1 && node.unlocked && node.currentRank > 0) {
            String rankText = node.currentRank + "/" + node.maxRank;
            class_5250 class_52503 = class_2561.method_43470((String)rankText);
            int n3 = x + nodeSize - this.field_22793.method_1727(rankText) - 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27535(this.field_22793, (class_2561)class_52503, n3, y + nodeSize - 9 - 2, node.currentRank == node.maxRank ? -10496 : -1);
        }
        if (node.available && !node.unlocked) {
            String costText = String.valueOf(node.cost);
            boolean canAfford = this.stats != null && this.stats.getSkillPoints() >= node.cost;
            int costTextColor = canAfford ? -16711936 : -48060;
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)costText), x + nodeSize / 2, y + nodeSize + 8, costTextColor);
        }
    }

    private int getNodeBackgroundColor(SkillNode node) {
        if (node.unlocked) {
            return this.getTypeColor(node.type, 0.9f);
        }
        if (node.available) {
            return this.getTypeColor(node.type, 0.5f);
        }
        return -14013910;
    }

    private int getNodeBorderColor(SkillNode node) {
        if (this.hoveredNode == node) {
            return -1;
        }
        if (this.selectedNode == node) {
            return -16711681;
        }
        if (node.unlocked) {
            return this.getTypeColor(node.type, 1.0f);
        }
        if (node.available) {
            return -22016;
        }
        return -10066330;
    }

    private int getNodeIconColor(SkillNode node) {
        if (node.unlocked) {
            return -1;
        }
        if (node.available) {
            return -2236963;
        }
        return -7829368;
    }

    private int getTypeColor(NodeType type, float alpha) {
        int baseColor = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case NodeType.ROOT -> 16766720;
            case NodeType.ATTRIBUTE -> 5025616;
            case NodeType.COMBAT -> 16007990;
            case NodeType.MAGIC -> 4149685;
            case NodeType.DEFENSE -> 16750592;
            case NodeType.UTILITY -> 48340;
            case NodeType.MASTERY -> 10233776;
            case NodeType.ULTIMATE -> 16766720;
        };
        int alphaValue = (int)(alpha * 255.0f);
        return alphaValue << 24 | baseColor;
    }

    private String getNodeIcon(SkillNode node) {
        return switch (node.type) {
            default -> throw new IncompatibleClassChangeError();
            case NodeType.ROOT -> "\u2b50";
            case NodeType.ATTRIBUTE -> {
                switch (node.id) {
                    case "strength_1": {
                        yield "\u2694";
                    }
                    case "agility_1": {
                        yield "\u26a1";
                    }
                    case "vitality_1": {
                        yield "\u2764";
                    }
                    case "intelligence_1": {
                        yield "\ud83e\udde0";
                    }
                }
                yield "\ud83d\udcc8";
            }
            case NodeType.COMBAT -> "\u2694";
            case NodeType.MAGIC -> "\ud83d\udd2e";
            case NodeType.DEFENSE -> "\ud83d\udee1";
            case NodeType.UTILITY -> "\ud83d\udd27";
            case NodeType.MASTERY -> "\ud83d\udc51";
            case NodeType.ULTIMATE -> "\u2728";
        };
    }

    private void updateHoveredNode(int mouseX, int mouseY) {
        SkillNode oldHovered = this.hoveredNode;
        this.hoveredNode = null;
        class_241 worldPos = this.screenToWorld(mouseX, mouseY);
        for (SkillNode node : this.visibleNodes) {
            if (!this.isMouseOverNodeOptimized(node, worldPos.field_1343, worldPos.field_1342)) continue;
            this.hoveredNode = node;
            break;
        }
        if (this.hoveredNode != oldHovered) {
            this.lastHoverTime = System.currentTimeMillis();
        }
    }

    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        super.method_25419();
    }

    private static class SkillNode {
        String id;
        float x;
        float y;
        NodeType type;
        String name;
        String description;
        int cost;
        int currentRank;
        int maxRank;
        boolean unlocked;
        boolean available;
        List<SkillNode> parents = new ArrayList<SkillNode>();
        List<SkillNode> children = new ArrayList<SkillNode>();

        SkillNode(String id, float x, float y, NodeType type, String name, String description, int cost, int maxRank) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.type = type;
            this.name = name;
            this.description = description;
            this.cost = cost;
            this.maxRank = maxRank;
        }
    }

    private static enum NodeType {
        ROOT,
        ATTRIBUTE,
        COMBAT,
        MAGIC,
        DEFENSE,
        UTILITY,
        MASTERY,
        ULTIMATE;

    }
}

