/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.mixin;

import com.tessarected.DirectDamageAccess;
import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.combat.CombatSystem;
import com.tessarected.combat.damage.DamageType;
import com.tessarected.stats.PlayerStats;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8111;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public class EnhancedCombatMixin
implements DirectDamageAccess {
    @Unique
    private boolean tessarected_directDamageFlag = false;

    @Inject(method={"damage"}, at={@At(value="HEAD")}, cancellable=true)
    private void tessarected_enhancedCombat(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        PlayerStats defenderStats;
        float modifiedDamage;
        class_3222 defender;
        TessarectedPlayerStatsHolder holder;
        class_1309 target = (class_1309)this;
        if (this.tessarected_directDamageFlag) {
            return;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_3222) {
            class_3222 attacker = (class_3222)class_12972;
            if (!(attacker instanceof TessarectedPlayerStatsHolder)) {
                return;
            }
            holder = (TessarectedPlayerStatsHolder)attacker;
            PlayerStats attackerStats = holder.tessarected_getStats();
            if (!attackerStats.hasChosenClass()) {
                return;
            }
            DamageType damageType = this.getDamageTypeFromSource(source);
            float enhancedDamage = this.applySkillBonuses(amount, attackerStats, attacker);
            CombatSystem.CombatResult result = CombatSystem.calculateDamage((class_1309)attacker, target, enhancedDamage, damageType, attackerStats);
            cir.setReturnValue((Object)false);
            if (result.finalDamage > 0.0f) {
                this.tessarected_directDamageFlag = true;
                boolean success = target.method_5643(source, result.finalDamage);
                this.tessarected_directDamageFlag = false;
                this.sendEnhancedCombatFeedback(attacker, result);
                cir.setReturnValue((Object)success);
            } else {
                if (result.wasDodged) {
                    this.sendEnhancedCombatFeedback(attacker, result);
                }
                cir.setReturnValue((Object)false);
            }
        } else if (target instanceof class_3222 && (defender = (class_3222)target) instanceof TessarectedPlayerStatsHolder && (modifiedDamage = this.applyDefensiveBonuses(amount, source, defenderStats = (holder = (TessarectedPlayerStatsHolder)defender).tessarected_getStats())) != amount) {
            cir.setReturnValue((Object)false);
            this.tessarected_directDamageFlag = true;
            boolean success = target.method_5643(source, modifiedDamage);
            this.tessarected_directDamageFlag = false;
            cir.setReturnValue((Object)success);
        }
    }

    @Unique
    private float applySkillBonuses(float damage, PlayerStats stats, class_3222 attacker) {
        float enhancedDamage = damage;
        if (stats.isSkillNodeUnlocked("combat_mastery")) {
            enhancedDamage *= 1.15f;
        }
        if (stats.isSkillNodeUnlocked("critical_hit") && attacker.method_37908().field_9229.method_43057() < 0.05f) {
            enhancedDamage *= 1.5f;
            attacker.method_7353((class_2561)class_2561.method_43470((String)"Enhanced Critical Hit!").method_27692(class_124.field_1065), true);
        }
        return enhancedDamage;
    }

    @Unique
    private float applyDefensiveBonuses(float damage, class_1282 source, PlayerStats stats) {
        float modifiedDamage = damage;
        if (stats.isSkillNodeUnlocked("magic_resistance") && (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329))) {
            modifiedDamage *= 0.75f;
        }
        if (stats.isSkillNodeUnlocked("damage_reduction")) {
            modifiedDamage *= 0.9f;
        }
        return modifiedDamage;
    }

    @Unique
    private DamageType getDamageTypeFromSource(class_1282 source) {
        if (source.method_49708(class_8111.field_42337) || source.method_49708(class_8111.field_42335)) {
            return DamageType.FIRE;
        }
        if (source.method_49708(class_8111.field_42336)) {
            return DamageType.LIGHTNING;
        }
        if (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329)) {
            return DamageType.ENERGY;
        }
        if (source.method_49708(class_8111.field_42354)) {
            return DamageType.COLD;
        }
        return DamageType.PHYSICAL;
    }

    @Unique
    private void sendEnhancedCombatFeedback(class_3222 player, CombatSystem.CombatResult result) {
        Object message = String.format("%.1f %s damage", Float.valueOf(result.finalDamage), result.damageType.getDisplayName());
        class_124 color = class_124.field_1068;
        if (result.wasCritical) {
            message = (String)message + " (CRITICAL!)";
            color = class_124.field_1065;
        }
        if (result.wasDodged) {
            message = "DODGED!";
            color = class_124.field_1080;
        }
        if (result.wasBlocked) {
            message = (String)message + " (Blocked)";
            color = class_124.field_1078;
        }
        player.method_7353((class_2561)class_2561.method_43470((String)message).method_27692(color), true);
    }

    @Override
    public void tessarected_directDamage(class_1282 source, float amount) {
        class_1309 entity = (class_1309)this;
        this.tessarected_directDamageFlag = true;
        entity.method_5643(source, amount);
        this.tessarected_directDamageFlag = false;
    }
}

