/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.mixin;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.util.IMobScaledEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1308.class})
public abstract class MobEntityMixin
extends class_1309
implements IMobScaledEntity {
    private static final class_2940<Integer> SCALED_LEVEL = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> IS_MODDED_MOB = class_2945.method_12791(class_1308.class, (class_2941)class_2943.field_13323);
    @Unique
    private boolean tessarected_hasScaled = false;

    protected MobEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    private void tessarected_initDataTracker(CallbackInfo ci) {
        this.field_6011.method_12784(SCALED_LEVEL, (Object)1);
        this.field_6011.method_12784(IS_MODDED_MOB, (Object)(!this.method_5864().method_5882().startsWith("entity.minecraft.") ? 1 : 0));
    }

    @Override
    public int tessarected_getScaledLevel() {
        return (Integer)this.field_6011.method_12789(SCALED_LEVEL);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void tessarected_writeLevel(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10569("TessarectedScaledLevel", ((Integer)this.field_6011.method_12789(SCALED_LEVEL)).intValue());
        nbt.method_10556("TessarectedHasScaled", this.tessarected_hasScaled);
        nbt.method_10556("TessarectedIsModded", ((Boolean)this.field_6011.method_12789(IS_MODDED_MOB)).booleanValue());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void tessarected_readLevel(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("TessarectedScaledLevel")) {
            this.field_6011.method_12778(SCALED_LEVEL, (Object)nbt.method_10550("TessarectedScaledLevel"));
        }
        if (nbt.method_10545("TessarectedHasScaled")) {
            this.tessarected_hasScaled = nbt.method_10577("TessarectedHasScaled");
        }
        if (nbt.method_10545("TessarectedIsModded")) {
            this.field_6011.method_12778(IS_MODDED_MOB, (Object)nbt.method_10577("TessarectedIsModded"));
        }
    }

    @Inject(method={"initialize"}, at={@At(value="TAIL")})
    private void tessarected_scaleOnInitialize(class_5425 serverWorld, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityNbt, CallbackInfoReturnable<class_1315> cir) {
        if (this.method_37908().field_9236 || this.tessarected_hasScaled) {
            return;
        }
        this.tessarected_applyScalingFromNearbyPlayers();
    }

    @Inject(method={"getXpToDrop"}, at={@At(value="HEAD")}, cancellable=true)
    private void tessarected_scaleXP(CallbackInfoReturnable<Integer> cir) {
        int baseXP;
        int level = this.tessarected_getScaledLevel();
        int n = baseXP = this.method_6109() ? level * 2 : level * 5;
        if (((Boolean)this.field_6011.method_12789(IS_MODDED_MOB)).booleanValue()) {
            baseXP = (int)((double)baseXP * 1.5);
        }
        cir.setReturnValue((Object)baseXP);
    }

    @Unique
    private void tessarected_applyScalingFromNearbyPlayers() {
        class_1324 attack;
        class_1937 world = this.method_37908();
        if (world == null || world.field_9236) {
            return;
        }
        List players = world.method_8390(class_1657.class, class_238.method_29968((class_243)this.method_19538()).method_1014(64.0), p -> true);
        if (players.isEmpty()) {
            this.field_6011.method_12778(SCALED_LEVEL, (Object)1);
            this.tessarected_hasScaled = true;
            return;
        }
        int total = 0;
        for (class_1657 p2 : players) {
            if (p2 instanceof TessarectedPlayerStatsHolder) {
                TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)p2;
                total += holder.tessarected_getStats().getLevel();
                continue;
            }
            ++total;
        }
        double avg = (double)total / (double)players.size();
        Random rand = new Random();
        int modifier = rand.nextInt(7) - 3;
        int level = (int)Math.max(1L, Math.round(avg + (double)modifier));
        this.field_6011.method_12778(SCALED_LEVEL, (Object)level);
        double healthScale = 1.0 + (double)level * 0.05;
        double damageScale = 1.0 + (double)level * 0.03;
        class_1324 maxHealth = this.method_5996(class_5134.field_23716);
        if (maxHealth != null) {
            maxHealth.method_6192(maxHealth.method_6201() * healthScale);
            this.method_6033((float)maxHealth.method_6201());
        }
        if ((attack = this.method_5996(class_5134.field_23721)) != null) {
            attack.method_6192(attack.method_6201() * damageScale);
        }
        this.tessarected_hasScaled = true;
    }
}

