/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.mixin;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.abilities.SpellAbilityManager;
import com.tessarected.combat.SpellSystem;
import com.tessarected.stats.PlayerStats;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3222.class})
public abstract class ServerPlayerEntityMixin
implements TessarectedPlayerStatsHolder {
    @Unique
    private PlayerStats tessarected_stats = new PlayerStats();
    @Unique
    private boolean tessarectedReceivedStarterKit = false;

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="HEAD")})
    private void tessarected_writeStats(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10566("TessarectedPlayerStats", (class_2520)this.tessarected_stats.toNbt());
        nbt.method_10556("TessarectedReceivedStarterKit", this.tessarectedReceivedStarterKit);
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    private void tessarected_readStats(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10545("TessarectedPlayerStats")) {
            this.tessarected_stats.fromNbt(nbt.method_10562("TessarectedPlayerStats"));
        }
        if (nbt.method_10545("TessarectedReceivedStarterKit")) {
            this.tessarectedReceivedStarterKit = nbt.method_10577("TessarectedReceivedStarterKit");
        }
    }

    @Inject(method={"copyFrom"}, at={@At(value="TAIL")})
    private void tessarected_copyPlayerStats(class_3222 oldPlayer, boolean alive, CallbackInfo ci) {
        if (oldPlayer instanceof TessarectedPlayerStatsHolder) {
            TessarectedPlayerStatsHolder oldHolder = (TessarectedPlayerStatsHolder)oldPlayer;
            this.tessarected_stats.fromNbt(oldHolder.tessarected_getStats().toNbt());
            this.tessarectedReceivedStarterKit = oldHolder.tessarected_hasReceivedStarterKit();
        }
    }

    @Unique
    private void tessarected_onCooldownComplete(PlayerStats stats, char key) {
        class_3222 player = (class_3222)this;
        try {
            stats.onAbilityCooldownComplete(key);
            player.method_5783((class_3414)class_3417.field_14725.comp_349(), 0.3f, 1.8f);
            if (key == 'V') {
                player.method_7353((class_2561)class_2561.method_43470((String)("Ultimate ability " + key + " is ready!")).method_27692(class_124.field_1065), true);
                class_1937 class_19372 = player.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)class_19372;
                    serverWorld.method_14199((class_2394)class_2398.field_11211, player.method_23317(), player.method_23318() + 1.5, player.method_23321(), 3, 0.3, 0.3, 0.3, 0.1);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error in cooldown completion handler for key " + key + ": " + e.getMessage());
        }
    }

    @Unique
    private static String tessarected_formatCooldownDisplay(float cooldown) {
        if (cooldown <= 0.0f) {
            return "READY";
        }
        if (cooldown < 1.0f) {
            return String.format("%.1fs", Float.valueOf(cooldown));
        }
        if (cooldown < 60.0f) {
            return String.format("%.0fs", Float.valueOf(cooldown));
        }
        int minutes = (int)(cooldown / 60.0f);
        int seconds = (int)(cooldown % 60.0f);
        return String.format("%dm%02ds", minutes, seconds);
    }

    @Unique
    private static class_2561 tessarected_getCooldownDisplayText(char ability, float cooldown) {
        String displayText = ServerPlayerEntityMixin.tessarected_formatCooldownDisplay(cooldown);
        if (cooldown <= 0.0f) {
            return class_2561.method_43470((String)displayText).method_27692(class_124.field_1060);
        }
        if (cooldown <= 1.0f) {
            return class_2561.method_43470((String)displayText).method_27692(class_124.field_1054);
        }
        return class_2561.method_43470((String)displayText).method_27692(class_124.field_1061);
    }

    @Unique
    private boolean tessarected_isPlayerInCombat(class_3222 player) {
        return !player.method_37908().method_8390(class_1588.class, player.method_5829().method_1014(10.0), entity -> entity.method_5968() == player).isEmpty();
    }

    @Unique
    private void tessarected_forceAbilityCheck(class_3222 player) {
        TessarectedPlayerStatsHolder holder;
        PlayerStats stats;
        if (player instanceof TessarectedPlayerStatsHolder && (stats = (holder = (TessarectedPlayerStatsHolder)player).tessarected_getStats()).hasChosenClass()) {
            this.tessarected_validateAbilityUnlocks(player, stats);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private void tessarected_handleAbilityLevelUp(class_3222 player, PlayerStats stats, class_2487 nbt) {
        boolean canUnlock;
        int newLevel = stats.getLevel();
        if (!stats.hasChosenClass()) {
            return;
        }
        boolean anyUnlocked = false;
        ArrayList<Object> unlockedAbilities = new ArrayList<Object>();
        if (newLevel >= 1 && !stats.isAbilityUnlocked('z')) {
            stats.setAbilityUnlocked('z', true, (class_1657)player);
            stats.setAbilityUnlocked('Z', true, (class_1657)player);
            unlockedAbilities.add("Z");
            anyUnlocked = true;
        }
        if (!stats.isAbilityUnlocked('x')) {
            canUnlock = false;
            String string = "";
            if (stats.isSkillNodeUnlocked("ability_unlock_x") && newLevel >= 3) {
                canUnlock = true;
                String string2 = " (Early Unlock)";
            } else if (newLevel >= 5) {
                canUnlock = true;
            }
            if (canUnlock) {
                void var8_11;
                stats.setAbilityUnlocked('x', true, (class_1657)player);
                stats.setAbilityUnlocked('X', true, (class_1657)player);
                unlockedAbilities.add("X" + (String)var8_11);
                anyUnlocked = true;
            }
        }
        if (!stats.isAbilityUnlocked('c')) {
            canUnlock = false;
            String string = "";
            if (stats.isSkillNodeUnlocked("ability_unlock_c") && newLevel >= 7) {
                canUnlock = true;
                String string3 = " (Early Unlock)";
            } else if (newLevel >= 10) {
                canUnlock = true;
            }
            if (canUnlock) {
                void var8_14;
                stats.setAbilityUnlocked('c', true, (class_1657)player);
                stats.setAbilityUnlocked('C', true, (class_1657)player);
                unlockedAbilities.add("C" + (String)var8_14);
                anyUnlocked = true;
            }
        }
        if (newLevel >= 15 && !stats.isAbilityUnlocked('v')) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
            unlockedAbilities.add("V");
            anyUnlocked = true;
        }
        if (anyUnlocked) {
            for (String string : unlockedAbilities) {
                SpellSystem.SpellType spell = this.getSpellForKey(stats.getClassType(), string.charAt(0));
                if (spell == null) continue;
                player.method_7353((class_2561)class_2561.method_43470((String)("\ud83d\udd13 Ability " + string + " Unlocked: " + spell.getDisplayName())).method_27692(class_124.field_1060), false);
            }
            player.method_5783(class_3417.field_15195, 1.0f, 1.2f);
            this.spawnAbilityUnlockParticles(player);
            this.tessarected_showPlayerAbilities(player, stats);
            stats.syncToClient((class_1657)player);
        }
        this.tessarected_validateAbilityUnlocks(player, stats);
    }

    @Unique
    private SpellSystem.SpellType getSpellForKey(PlayerStats.ClassType classType, char key) {
        int index;
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(classType);
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < spells.length) {
            return spells[index];
        }
        return null;
    }

    @Unique
    private void tessarected_showPlayerAbilities(class_3222 player, PlayerStats stats) {
        player.method_7353((class_2561)class_2561.method_43470((String)("\u2550\u2550\u2550 " + stats.getPlayerClass() + " Abilities \u2550\u2550\u2550")).method_27692(class_124.field_1065), false);
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(stats.getClassType());
        char[] keys = new char[]{'Z', 'X', 'C', 'V'};
        int[] unlockLevels = new int[]{1, 5, 10, 15};
        for (int i = 0; i < Math.min(spells.length, keys.length); ++i) {
            char key = keys[i];
            SpellSystem.SpellType spell = spells[i];
            int reqLevel = unlockLevels[i];
            if (i == 1 && stats.isSkillNodeUnlocked("ability_unlock_x")) {
                reqLevel = 3;
            } else if (i == 2 && stats.isSkillNodeUnlocked("ability_unlock_c")) {
                reqLevel = 7;
            }
            if (stats.isAbilityUnlocked(key)) {
                float cooldown;
                Object costText = "";
                if (spell.getManaCost() > 0) {
                    costText = (String)costText + spell.getManaCost() + " MP";
                }
                if (spell.getStaminaCost() > 0) {
                    if (!((String)costText).isEmpty()) {
                        costText = (String)costText + ", ";
                    }
                    costText = (String)costText + spell.getStaminaCost() + " SP";
                }
                if (!((String)costText).isEmpty()) {
                    costText = " (" + (String)costText + ")";
                }
                String cooldownText = (cooldown = stats.getAbilityCooldownFloat(key)) > 0.0f ? " [" + ServerPlayerEntityMixin.tessarected_formatCooldownDisplay(cooldown) + "]" : " [READY]";
                player.method_7353((class_2561)class_2561.method_43470((String)("  \u2713 " + key + ": " + spell.getDisplayName() + (String)costText + cooldownText)).method_27692(cooldown > 0.0f ? class_124.field_1054 : class_124.field_1060), false);
                continue;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("  \u2717 " + key + ": " + spell.getDisplayName() + " (Level " + reqLevel + ")")).method_27692(class_124.field_1080), false);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("  \u25c9 Passive: " + this.getPassiveAbilityName(stats.getClassType()))).method_27692(class_124.field_1078), false);
    }

    @Unique
    private String getPassiveAbilityName(PlayerStats.ClassType classType) {
        return switch (classType) {
            case PlayerStats.ClassType.MENDER -> "Regeneration Aura";
            case PlayerStats.ClassType.HARVESTER -> "Energy Drain";
            case PlayerStats.ClassType.ECHO -> "Chaos Field";
            case PlayerStats.ClassType.GUARDIAN -> "Stalwart Defense";
            default -> "None";
        };
    }

    @Unique
    private void tessarected_validateAbilityUnlocks(class_3222 player, PlayerStats stats) {
        boolean shouldHaveC;
        boolean shouldHaveX;
        int level = stats.getLevel();
        boolean needsSync = false;
        if (level >= 1 && !stats.isAbilityUnlocked('z')) {
            stats.setAbilityUnlocked('z', true, (class_1657)player);
            stats.setAbilityUnlocked('Z', true, (class_1657)player);
            needsSync = true;
        }
        boolean bl = shouldHaveX = level >= 5 || stats.isSkillNodeUnlocked("ability_unlock_x") && level >= 3;
        if (shouldHaveX && !stats.isAbilityUnlocked('x')) {
            stats.setAbilityUnlocked('x', true, (class_1657)player);
            stats.setAbilityUnlocked('X', true, (class_1657)player);
            needsSync = true;
        }
        boolean bl2 = shouldHaveC = level >= 10 || stats.isSkillNodeUnlocked("ability_unlock_c") && level >= 7;
        if (shouldHaveC && !stats.isAbilityUnlocked('c')) {
            stats.setAbilityUnlocked('c', true, (class_1657)player);
            stats.setAbilityUnlocked('C', true, (class_1657)player);
            needsSync = true;
        }
        if (level >= 15 && !stats.isAbilityUnlocked('v')) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
            needsSync = true;
        }
        if (needsSync) {
            stats.syncToClient((class_1657)player);
        }
    }

    @Unique
    private void spawnAbilityUnlockParticles(class_3222 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 30; ++i) {
                double angle = Math.PI * 2 * (double)i / 30.0;
                double radius = 1.5;
                double x = player.method_23317() + Math.cos(angle) * radius;
                double y = player.method_23318() + 1.0 + Math.random() * 2.0;
                double z = player.method_23321() + Math.sin(angle) * radius;
                serverWorld.method_14199((class_2394)class_2398.field_11207, x, y, z, 1, 0.0, 0.2, 0.0, 0.1);
            }
            serverWorld.method_14199((class_2394)class_2398.field_11220, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
        }
    }

    @Override
    public PlayerStats tessarected_getStats() {
        return this.tessarected_stats;
    }

    @Override
    public boolean tessarected_hasReceivedStarterKit() {
        return this.tessarectedReceivedStarterKit;
    }

    @Override
    public void tessarected_setReceivedStarterKit(boolean value) {
        this.tessarectedReceivedStarterKit = value;
    }

    @Unique
    private static void handleSpellAbilityPacket(class_3222 player, String action, class_2487 data) {
        String keyStr;
        if ("use_spell_ability".equals(action) && data.method_10545("abilityKey") && !(keyStr = data.method_10558("abilityKey")).isEmpty()) {
            char key = keyStr.charAt(0);
            SpellAbilityManager.useSpellAbility((class_1657)player, key);
        }
    }
}

