/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.skills;

import com.tessarected.stats.PlayerStats;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_746;

public class SkillTreeSystem {
    private static final Map<String, SkillNodeData> SKILL_NODES = new HashMap<String, SkillNodeData>();
    private static final Map<String, List<String>> SKILL_PREREQUISITES = new HashMap<String, List<String>>();
    private static final Map<String, Map<String, Float>> PLAYER_CUSTOM_EFFECTS;

    private static void initializeSkillTree() {
        SkillTreeSystem.addSkillNode("root", "Origin", "The beginning of your journey", 0, SkillNodeType.ROOT, 1, (stats, player, rank) -> stats.setSkillPoints(stats.getSkillPoints() + 0, (class_1657)player));
        SkillTreeSystem.addSkillNode("combat_path", "Path of War", "Begin your combat training", 1, SkillNodeType.ROOT, 1, (stats, player, rank) -> {
            stats.addStrength(1);
            stats.addVitality(1);
            player.method_7353((class_2561)class_2561.method_43470((String)"Combat training unlocked!").method_27692(class_124.field_1061), false);
        });
        SkillTreeSystem.addSkillNode("magic_path", "Path of Arcane", "Begin your magical studies", 1, SkillNodeType.ROOT, 1, (stats, player, rank) -> {
            stats.addIntelligence(2);
            stats.addMaxMana(20);
            player.method_7353((class_2561)class_2561.method_43470((String)"Arcane knowledge unlocked!").method_27692(class_124.field_1078), false);
        });
        SkillTreeSystem.addSkillNode("agility_path", "Path of Swiftness", "Begin your agility training", 1, SkillNodeType.ROOT, 1, (stats, player, rank) -> {
            stats.addAgility(2);
            player.method_7353((class_2561)class_2561.method_43470((String)"Swift movement unlocked!").method_27692(class_124.field_1060), false);
        });
        SkillTreeSystem.addSkillNode("defense_path", "Path of Protection", "Begin your defensive training", 1, SkillNodeType.ROOT, 1, (stats, player, rank) -> {
            stats.addVitality(2);
            stats.addDefense(1);
            player.method_7353((class_2561)class_2561.method_43470((String)"Defensive stance unlocked!").method_27692(class_124.field_1054), false);
        });
        SkillTreeSystem.addSkillNode("strength_1", "Warrior's Might", "Increase strength by 2", 1, SkillNodeType.ATTRIBUTE, 3, (stats, player, rank) -> stats.addStrength(2));
        SkillTreeSystem.addSkillNode("agility_1", "Swift Reflexes", "Increase agility by 2", 1, SkillNodeType.ATTRIBUTE, 3, (stats, player, rank) -> stats.addAgility(2));
        SkillTreeSystem.addSkillNode("vitality_1", "Iron Constitution", "Increase vitality by 2", 1, SkillNodeType.ATTRIBUTE, 3, (stats, player, rank) -> stats.addVitality(2));
        SkillTreeSystem.addSkillNode("intelligence_1", "Keen Mind", "Increase intelligence by 2", 1, SkillNodeType.ATTRIBUTE, 3, (stats, player, rank) -> stats.addIntelligence(2));
        SkillTreeSystem.addSkillNode("critical_mastery", "Critical Mastery", "Improve critical hit chance and damage", 2, SkillNodeType.COMBAT, 5, (stats, player, rank) -> stats.addAgility(1));
        SkillTreeSystem.addSkillNode("weapon_expertise", "Weapon Expertise", "Increase physical damage and attack speed", 3, SkillNodeType.COMBAT, 3, (stats, player, rank) -> stats.addStrength(2));
        SkillTreeSystem.addSkillNode("berserker_rage", "Berserker's Rage", "Gain damage bonus when health is low", 4, SkillNodeType.COMBAT, 1, (stats, player, rank) -> player.method_7353((class_2561)class_2561.method_43470((String)"Berserker's Rage: Deal 50% more damage when below 25% health!").method_27692(class_124.field_1079), false));
        SkillTreeSystem.addSkillNode("mana_mastery", "Mana Mastery", "Increase mana and health", 2, SkillNodeType.MAGIC, 5, (stats, player, rank) -> {
            stats.addMaxMana(15 * rank);
            stats.addVitality(2);
        });
        SkillTreeSystem.addSkillNode("spell_power", "Arcane Amplification", "Increase spell damage", 3, SkillNodeType.MAGIC, 3, (stats, player, rank) -> stats.addIntelligence(3));
        SkillTreeSystem.addSkillNode("mana_efficiency", "Efficient Casting", "Reduce spell costs", 3, SkillNodeType.MAGIC, 3, (stats, player, rank) -> {
            stats.addIntelligence(2);
            player.method_7353((class_2561)class_2561.method_43470((String)"Mana Efficiency: Spells cost 20% less mana!").method_27692(class_124.field_1078), false);
        });
        SkillTreeSystem.addSkillNode("arcane_mastery", "Arcane Mastery", "Spells have chance to not consume mana", 5, SkillNodeType.MAGIC, 1, (stats, player, rank) -> player.method_7353((class_2561)class_2561.method_43470((String)"Arcane Mastery: 20% chance spells cost no mana!").method_27692(class_124.field_1076), false));
        SkillTreeSystem.addSkillNode("armor_mastery", "Armor Mastery", "Increase defense and damage reduction", 2, SkillNodeType.DEFENSE, 5, (stats, player, rank) -> {
            stats.addDefense(2);
            stats.addVitality(1);
        });
        SkillTreeSystem.addSkillNode("magical_ward", "Magical Ward", "Resistance to magical damage", 3, SkillNodeType.DEFENSE, 3, (stats, player, rank) -> stats.addMagicDefense(5 * rank));
        SkillTreeSystem.addSkillNode("fortress", "Living Fortress", "Massive defensive bonuses", 4, SkillNodeType.DEFENSE, 1, (stats, player, rank) -> {
            stats.addDefense(10);
            stats.addVitality(5);
            player.method_7353((class_2561)class_2561.method_43470((String)"Living Fortress: Massive defense but slower movement!").method_27692(class_124.field_1065), false);
        });
        SkillTreeSystem.addSkillNode("health_regen", "Regeneration", "Passive health regeneration", 2, SkillNodeType.UTILITY, 5, (stats, player, rank) -> stats.addHealthRegen(0.5f * (float)rank));
        SkillTreeSystem.addSkillNode("stamina_mastery", "Endurance Training", "Increase stamina and regeneration", 2, SkillNodeType.UTILITY, 5, (stats, player, rank) -> {
            stats.addMaxStamina(20 * rank);
            stats.addStaminaRegen(1.0f);
        });
        SkillTreeSystem.addSkillNode("second_wind", "Second Wind", "Emergency resource restoration", 4, SkillNodeType.UTILITY, 1, (stats, player, rank) -> {
            stats.enableSecondWind();
            player.method_7353((class_2561)class_2561.method_43470((String)"Second Wind: Restore resources when critically low!").method_27692(class_124.field_1075), false);
        });
        SkillTreeSystem.addSkillNode("mender_mastery", "Divine Mastery", "Enhanced healing and support abilities", 6, SkillNodeType.MASTERY, 1, (stats, player, rank) -> {
            if (stats.getClassType() == PlayerStats.ClassType.MENDER) {
                stats.addIntelligence(5);
                stats.addMaxMana(50);
                player.method_7353((class_2561)class_2561.method_43470((String)"Divine Mastery: Healing abilities greatly enhanced!").method_27692(class_124.field_1075), false);
            }
        });
        SkillTreeSystem.addSkillNode("harvester_mastery", "Energy Mastery", "Enhanced energy manipulation", 6, SkillNodeType.MASTERY, 1, (stats, player, rank) -> {
            if (stats.getClassType() == PlayerStats.ClassType.HARVESTER) {
                stats.addStrength(3);
                stats.addIntelligence(3);
                player.method_7353((class_2561)class_2561.method_43470((String)"Energy Mastery: Energy abilities greatly enhanced!").method_27692(class_124.field_1065), false);
            }
        });
        SkillTreeSystem.addSkillNode("echo_mastery", "Chaos Mastery", "Enhanced chaos and corruption abilities", 6, SkillNodeType.MASTERY, 1, (stats, player, rank) -> {
            if (stats.getClassType() == PlayerStats.ClassType.ECHO) {
                stats.addAgility(5);
                player.method_7353((class_2561)class_2561.method_43470((String)"Chaos Mastery: Chaos abilities greatly enhanced!").method_27692(class_124.field_1064), false);
            }
        });
        SkillTreeSystem.addSkillNode("guardian_mastery", "Aegis Mastery", "Enhanced protection abilities", 6, SkillNodeType.MASTERY, 1, (stats, player, rank) -> {
            if (stats.getClassType() == PlayerStats.ClassType.GUARDIAN) {
                stats.addVitality(5);
                stats.addDefense(5);
                player.method_7353((class_2561)class_2561.method_43470((String)"Aegis Mastery: Protection abilities greatly enhanced!").method_27692(class_124.field_1060), false);
            }
        });
        SkillTreeSystem.addSkillNode("transcendence", "Transcendence", "Become one with your class power", 10, SkillNodeType.ULTIMATE, 1, (stats, player, rank) -> {
            switch (stats.getClassType()) {
                case MENDER: {
                    stats.addIntelligence(10);
                    stats.addMaxMana(100);
                    break;
                }
                case HARVESTER: {
                    stats.addStrength(8);
                    stats.addIntelligence(8);
                    break;
                }
                case ECHO: {
                    stats.addAgility(15);
                    break;
                }
                case GUARDIAN: {
                    stats.addVitality(15);
                    stats.addDefense(10);
                }
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"TRANSCENDENCE ACHIEVED!").method_27695(new class_124[]{class_124.field_1076, class_124.field_1067}), false);
        });
        SkillTreeSystem.addSkillNode("ability_unlock_x", "Early Mastery", "Unlock X ability at level 3", 2, SkillNodeType.UTILITY, 1, (stats, player, rank) -> {
            if (stats.getLevel() >= 3) {
                stats.setAbilityUnlocked('x', true, (class_1657)player);
                stats.setAbilityUnlocked('X', true, (class_1657)player);
            }
        });
        SkillTreeSystem.addSkillNode("ability_unlock_c", "Advanced Training", "Unlock C ability at level 7", 4, SkillNodeType.UTILITY, 1, (stats, player, rank) -> {
            if (stats.getLevel() >= 7) {
                stats.setAbilityUnlocked('c', true, (class_1657)player);
                stats.setAbilityUnlocked('C', true, (class_1657)player);
            }
        });
        SkillTreeSystem.setPrerequisites("combat_path", "root");
        SkillTreeSystem.setPrerequisites("magic_path", "root");
        SkillTreeSystem.setPrerequisites("agility_path", "root");
        SkillTreeSystem.setPrerequisites("defense_path", "root");
        SkillTreeSystem.setPrerequisites("strength_1", "combat_path");
        SkillTreeSystem.setPrerequisites("vitality_1", "defense_path");
        SkillTreeSystem.setPrerequisites("agility_1", "agility_path");
        SkillTreeSystem.setPrerequisites("intelligence_1", "magic_path");
        SkillTreeSystem.setPrerequisites("critical_mastery", "strength_1", "agility_1");
        SkillTreeSystem.setPrerequisites("weapon_expertise", "strength_1");
        SkillTreeSystem.setPrerequisites("berserker_rage", "weapon_expertise");
        SkillTreeSystem.setPrerequisites("mana_mastery", "intelligence_1");
        SkillTreeSystem.setPrerequisites("spell_power", "mana_mastery");
        SkillTreeSystem.setPrerequisites("mana_efficiency", "mana_mastery");
        SkillTreeSystem.setPrerequisites("arcane_mastery", "spell_power", "mana_efficiency");
        SkillTreeSystem.setPrerequisites("armor_mastery", "vitality_1");
        SkillTreeSystem.setPrerequisites("magical_ward", "armor_mastery");
        SkillTreeSystem.setPrerequisites("fortress", "armor_mastery");
        SkillTreeSystem.setPrerequisites("health_regen", "vitality_1");
        SkillTreeSystem.setPrerequisites("stamina_mastery", "agility_1");
        SkillTreeSystem.setPrerequisites("second_wind", "health_regen", "stamina_mastery");
        SkillTreeSystem.setPrerequisites("mender_mastery", "arcane_mastery", "health_regen");
        SkillTreeSystem.setPrerequisites("harvester_mastery", "berserker_rage", "mana_efficiency");
        SkillTreeSystem.setPrerequisites("echo_mastery", "critical_mastery", "arcane_mastery");
        SkillTreeSystem.setPrerequisites("guardian_mastery", "fortress", "second_wind");
        SkillTreeSystem.setPrerequisites("transcendence", "mender_mastery", "harvester_mastery", "echo_mastery", "guardian_mastery");
    }

    private static void addSkillNode(String id, String name, String description, int cost, SkillNodeType type, int maxRank, SkillEffect effect) {
        SKILL_NODES.put(id, new SkillNodeData(id, name, description, cost, type, maxRank, effect));
    }

    private static void setPrerequisites(String nodeId, String ... prerequisites) {
        SKILL_PREREQUISITES.put(nodeId, Arrays.asList(prerequisites));
    }

    public static boolean canUnlockSkill(String nodeId, PlayerStats stats) {
        SkillNodeData node = SKILL_NODES.get(nodeId);
        if (node == null) {
            return false;
        }
        int currentRank = SkillTreeSystem.getSkillRank(nodeId, stats);
        if (currentRank >= node.maxRank) {
            return false;
        }
        if (node.maxRank == 1 && stats.isSkillNodeUnlocked(nodeId)) {
            return false;
        }
        if (stats.getSkillPoints() < node.cost) {
            return false;
        }
        List<String> prerequisites = SKILL_PREREQUISITES.get(nodeId);
        if (prerequisites != null) {
            for (String prereq : prerequisites) {
                if (stats.isSkillNodeUnlocked(prereq)) continue;
                return false;
            }
        }
        if (node.type == SkillNodeType.MASTERY) {
            return SkillTreeSystem.checkClassRequirement(nodeId, stats.getClassType());
        }
        return true;
    }

    public static boolean unlockSkill(String nodeId, PlayerStats stats, class_3222 player) {
        if (!SkillTreeSystem.canUnlockSkill(nodeId, stats)) {
            return false;
        }
        SkillNodeData node = SKILL_NODES.get(nodeId);
        if (node == null) {
            return false;
        }
        stats.setSkillPoints(stats.getSkillPoints() - node.cost, (class_1657)player);
        stats.unlockSkillNode(nodeId, (class_1657)player);
        int newRank = SkillTreeSystem.getSkillRank(nodeId, stats);
        node.effect.apply(stats, player, newRank);
        player.method_7353((class_2561)class_2561.method_43470((String)("Unlocked: " + node.name + (String)(node.maxRank > 1 ? " (Rank " + newRank + ")" : ""))).method_27692(SkillTreeSystem.getTypeColor(node.type)), false);
        return true;
    }

    public static int getSkillRank(String nodeId, PlayerStats stats) {
        return Collections.frequency(new ArrayList<String>(stats.getUnlockedSkillNodes()), nodeId);
    }

    public static SkillNodeData getSkillNode(String nodeId) {
        return SKILL_NODES.get(nodeId);
    }

    public static Set<String> getAllSkillIds() {
        return SKILL_NODES.keySet();
    }

    public static List<String> getPrerequisites(String nodeId) {
        return SKILL_PREREQUISITES.getOrDefault(nodeId, new ArrayList());
    }

    private static boolean checkClassRequirement(String nodeId, PlayerStats.ClassType classType) {
        return switch (nodeId) {
            case "mender_mastery" -> {
                if (classType == PlayerStats.ClassType.MENDER) {
                    yield true;
                }
                yield false;
            }
            case "harvester_mastery" -> {
                if (classType == PlayerStats.ClassType.HARVESTER) {
                    yield true;
                }
                yield false;
            }
            case "echo_mastery" -> {
                if (classType == PlayerStats.ClassType.ECHO) {
                    yield true;
                }
                yield false;
            }
            case "guardian_mastery" -> {
                if (classType == PlayerStats.ClassType.GUARDIAN) {
                    yield true;
                }
                yield false;
            }
            default -> true;
        };
    }

    private static class_124 getTypeColor(SkillNodeType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case SkillNodeType.ROOT -> class_124.field_1068;
            case SkillNodeType.ATTRIBUTE -> class_124.field_1060;
            case SkillNodeType.COMBAT -> class_124.field_1061;
            case SkillNodeType.MAGIC -> class_124.field_1078;
            case SkillNodeType.DEFENSE -> class_124.field_1054;
            case SkillNodeType.UTILITY -> class_124.field_1075;
            case SkillNodeType.MASTERY -> class_124.field_1076;
            case SkillNodeType.ULTIMATE -> class_124.field_1065;
        };
    }

    public static void applyCustomEffect(class_3222 player, String effectId, float value) {
        String playerId = player.method_5845();
        PLAYER_CUSTOM_EFFECTS.computeIfAbsent(playerId, k -> new HashMap()).put(effectId, Float.valueOf(value));
    }

    public static float getCustomEffect(class_3222 player, String effectId) {
        String playerId = player.method_5845();
        return ((Map)PLAYER_CUSTOM_EFFECTS.getOrDefault(playerId, new HashMap())).getOrDefault(effectId, Float.valueOf(0.0f)).floatValue();
    }

    public static boolean hasCustomEffect(class_3222 player, String effectId) {
        return SkillTreeSystem.getCustomEffect(player, effectId) > 0.0f;
    }

    public static void clearCustomEffects(class_746 player) {
        PLAYER_CUSTOM_EFFECTS.remove(player.method_5845());
    }

    public static void resetSkillTree(PlayerStats stats, class_746 player) {
        int totalRefund = 0;
        for (String nodeId : stats.getUnlockedSkillNodes()) {
            SkillNodeData node = SKILL_NODES.get(nodeId);
            if (node == null) continue;
            int currentRank = SkillTreeSystem.getSkillRank(nodeId, stats);
            totalRefund += node.cost * currentRank;
        }
        stats.getUnlockedSkillNodes().clear();
        stats.setSkillPoints(stats.getSkillPoints() + totalRefund, (class_1657)player);
        stats.setClassType(stats.getClassType(), (class_1657)player);
        switch (stats.getClassType()) {
            case MENDER: {
                stats.setStrength(3, (class_1657)player);
                stats.setAgility(4, (class_1657)player);
                stats.setVitality(8, (class_1657)player);
                stats.setIntelligence(12, (class_1657)player);
                stats.setMagicDefense(5);
                break;
            }
            case HARVESTER: {
                stats.setStrength(8, (class_1657)player);
                stats.setAgility(8, (class_1657)player);
                stats.setVitality(7, (class_1657)player);
                stats.setIntelligence(4, (class_1657)player);
                stats.setMagicDefense(3);
                break;
            }
            case ECHO: {
                stats.setStrength(5, (class_1657)player);
                stats.setAgility(10, (class_1657)player);
                stats.setVitality(6, (class_1657)player);
                stats.setIntelligence(8, (class_1657)player);
                stats.setMagicDefense(4);
                break;
            }
            case GUARDIAN: {
                stats.setStrength(10, (class_1657)player);
                stats.setAgility(5, (class_1657)player);
                stats.setVitality(12, (class_1657)player);
                stats.setIntelligence(3, (class_1657)player);
                stats.setMagicDefense(2);
                break;
            }
            case NONE: {
                stats.setStrength(5, (class_1657)player);
                stats.setAgility(5, (class_1657)player);
                stats.setVitality(5, (class_1657)player);
                stats.setIntelligence(5, (class_1657)player);
                stats.setMagicDefense(0);
            }
        }
        stats.setAbilityUnlocked('z', true, (class_1657)player);
        stats.setAbilityUnlocked('Z', true, (class_1657)player);
        stats.setAbilityUnlocked('x', false, (class_1657)player);
        stats.setAbilityUnlocked('X', false, (class_1657)player);
        stats.setAbilityUnlocked('c', false, (class_1657)player);
        stats.setAbilityUnlocked('C', false, (class_1657)player);
        stats.setAbilityUnlocked('v', false, (class_1657)player);
        stats.setAbilityUnlocked('V', false, (class_1657)player);
        if (stats.getLevel() >= 5) {
            stats.setAbilityUnlocked('x', true, (class_1657)player);
            stats.setAbilityUnlocked('X', true, (class_1657)player);
        }
        if (stats.getLevel() >= 10) {
            stats.setAbilityUnlocked('c', true, (class_1657)player);
            stats.setAbilityUnlocked('C', true, (class_1657)player);
        }
        if (stats.getLevel() >= 15) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("Skill tree reset! Refunded " + totalRefund + " skill points.")).method_27692(class_124.field_1065), false);
    }

    public static void resetSkillTreeServer(PlayerStats stats, class_3222 player) {
        int totalRefund = 0;
        for (String nodeId : stats.getUnlockedSkillNodes()) {
            SkillNodeData node = SKILL_NODES.get(nodeId);
            if (node == null) continue;
            int currentRank = SkillTreeSystem.getSkillRank(nodeId, stats);
            totalRefund += node.cost * currentRank;
        }
        stats.getUnlockedSkillNodes().clear();
        PLAYER_CUSTOM_EFFECTS.remove(player.method_5845());
        stats.setSkillPoints(stats.getSkillPoints() + totalRefund, (class_1657)player);
        stats.setClassType(stats.getClassType(), (class_1657)player);
        switch (stats.getClassType()) {
            case MENDER: {
                stats.setStrength(3, (class_1657)player);
                stats.setAgility(4, (class_1657)player);
                stats.setVitality(8, (class_1657)player);
                stats.setIntelligence(12, (class_1657)player);
                stats.setMagicDefense(5);
                break;
            }
            case HARVESTER: {
                stats.setStrength(8, (class_1657)player);
                stats.setAgility(8, (class_1657)player);
                stats.setVitality(7, (class_1657)player);
                stats.setIntelligence(4, (class_1657)player);
                stats.setMagicDefense(3);
                break;
            }
            case ECHO: {
                stats.setStrength(5, (class_1657)player);
                stats.setAgility(10, (class_1657)player);
                stats.setVitality(6, (class_1657)player);
                stats.setIntelligence(8, (class_1657)player);
                stats.setMagicDefense(4);
                break;
            }
            case GUARDIAN: {
                stats.setStrength(10, (class_1657)player);
                stats.setAgility(5, (class_1657)player);
                stats.setVitality(12, (class_1657)player);
                stats.setIntelligence(3, (class_1657)player);
                stats.setMagicDefense(2);
                break;
            }
            case NONE: {
                stats.setStrength(5, (class_1657)player);
                stats.setAgility(5, (class_1657)player);
                stats.setVitality(5, (class_1657)player);
                stats.setIntelligence(5, (class_1657)player);
                stats.setMagicDefense(0);
            }
        }
        stats.setAbilityUnlocked('z', true, (class_1657)player);
        stats.setAbilityUnlocked('Z', true, (class_1657)player);
        stats.setAbilityUnlocked('x', false, (class_1657)player);
        stats.setAbilityUnlocked('X', false, (class_1657)player);
        stats.setAbilityUnlocked('c', false, (class_1657)player);
        stats.setAbilityUnlocked('C', false, (class_1657)player);
        stats.setAbilityUnlocked('v', false, (class_1657)player);
        stats.setAbilityUnlocked('V', false, (class_1657)player);
        if (stats.getLevel() >= 5) {
            stats.setAbilityUnlocked('x', true, (class_1657)player);
            stats.setAbilityUnlocked('X', true, (class_1657)player);
        }
        if (stats.getLevel() >= 10) {
            stats.setAbilityUnlocked('c', true, (class_1657)player);
            stats.setAbilityUnlocked('C', true, (class_1657)player);
        }
        if (stats.getLevel() >= 15) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
        }
        player.method_7353((class_2561)class_2561.method_43470((String)("Skill tree reset! Refunded " + totalRefund + " skill points.")).method_27692(class_124.field_1065), false);
        player.method_5783(class_3417.field_19344, 1.0f, 0.8f);
    }

    static {
        SkillTreeSystem.initializeSkillTree();
        PLAYER_CUSTOM_EFFECTS = new HashMap<String, Map<String, Float>>();
    }

    public static enum SkillNodeType {
        ROOT,
        ATTRIBUTE,
        COMBAT,
        MAGIC,
        DEFENSE,
        UTILITY,
        MASTERY,
        ULTIMATE;

    }

    @FunctionalInterface
    public static interface SkillEffect {
        public void apply(PlayerStats var1, class_3222 var2, int var3);
    }

    public static class SkillNodeData {
        public final String id;
        public final String name;
        public final String description;
        public final int cost;
        public final SkillNodeType type;
        public final int maxRank;
        public final SkillEffect effect;

        public SkillNodeData(String id, String name, String description, int cost, SkillNodeType type, int maxRank, SkillEffect effect) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.cost = cost;
            this.type = type;
            this.maxRank = maxRank;
            this.effect = effect;
        }
    }
}

