/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.stats;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.combat.SpellSystem;
import com.tessarected.combat.damage.DamageType;
import com.tessarected.skills.SkillTreeSystem;
import com.tessarected.stats.PlayerStatsSyncPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_746;

public class PlayerStats {
    private float mana;
    private float stamina;
    private float maxMana;
    private float maxStamina;
    private int strength = 0;
    private int agility = 0;
    private int vitality = 0;
    private int intelligence = 0;
    private boolean hasChosenClass = false;
    private int xp = 0;
    private int level = 1;
    private int attributePoints = 0;
    private int skillPoints = 0;
    private boolean abilityZUnlocked = true;
    private boolean abilityXUnlocked = false;
    private boolean abilityCUnlocked = false;
    private boolean abilityVUnlocked = false;
    private final Map<Character, Float> abilityCooldowns = new HashMap<Character, Float>();
    private final Map<Character, Float> abilityCooldownDurations = new HashMap<Character, Float>();
    private final Map<Character, Long> abilityLastUsed = new HashMap<Character, Long>();
    private Set<String> unlockedSkillNodes = new HashSet<String>();
    private ClassType classType;
    private float healthRegen;
    private boolean secondWindEnabled;
    private int defense;
    private int secondWindCooldown;
    private int magicDefense;

    public PlayerStats() {
        this.setClassType(ClassType.NONE);
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            this.abilityCooldowns.put(Character.valueOf(key), Float.valueOf(0.0f));
            this.abilityCooldownDurations.put(Character.valueOf(key), Float.valueOf(0.0f));
            this.abilityLastUsed.put(Character.valueOf(key), 0L);
        }
    }

    public float getAbilityCooldownFloat(char key) {
        return this.abilityCooldowns.getOrDefault(Character.valueOf(Character.toUpperCase(key)), Float.valueOf(0.0f)).floatValue();
    }

    public int getAbilityCooldown(char key) {
        return (int)(this.getAbilityCooldownFloat(key) * 20.0f);
    }

    public void setAbilityCooldownFloat(char key, float cooldownSeconds) {
        char upperKey = Character.toUpperCase(key);
        float clampedCooldown = Math.max(0.0f, cooldownSeconds);
        this.abilityCooldowns.put(Character.valueOf(upperKey), Float.valueOf(clampedCooldown));
        if (clampedCooldown > 0.0f) {
            this.abilityLastUsed.put(Character.valueOf(upperKey), System.currentTimeMillis());
        }
    }

    public void setAbilityCooldown(char key, int cooldownTicks) {
        this.setAbilityCooldownFloat(key, (float)cooldownTicks / 20.0f);
    }

    public void startAbilityCooldown(char key, float durationInSeconds) {
        char upperKey = Character.toUpperCase(key);
        this.setAbilityCooldownFloat(upperKey, durationInSeconds);
        this.abilityCooldownDurations.put(Character.valueOf(upperKey), Float.valueOf(durationInSeconds));
        this.abilityLastUsed.put(Character.valueOf(upperKey), System.currentTimeMillis());
    }

    public float getAbilityCooldownDuration(char key) {
        return this.abilityCooldownDurations.getOrDefault(Character.valueOf(Character.toUpperCase(key)), Float.valueOf(0.0f)).floatValue();
    }

    public boolean isAbilityReady(char key) {
        return this.getAbilityCooldownFloat(key) <= 0.0f;
    }

    public float getAbilityCooldownPercentage(char key) {
        float duration = this.getAbilityCooldownDuration(key);
        if (duration <= 0.0f) {
            return 0.0f;
        }
        float remaining = this.getAbilityCooldownFloat(key);
        return Math.max(0.0f, Math.min(1.0f, remaining / duration));
    }

    public void tickCooldowns() {
        boolean anyChanged = false;
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            float currentCooldown = this.getAbilityCooldownFloat(key);
            if (!(currentCooldown > 0.0f)) continue;
            float newCooldown = Math.max(0.0f, currentCooldown - 0.05f);
            this.abilityCooldowns.put(Character.valueOf(key), Float.valueOf(newCooldown));
            anyChanged = true;
            if (!(newCooldown <= 0.0f) || !(currentCooldown > 0.0f)) continue;
            this.onAbilityCooldownComplete(key);
        }
        if (this.secondWindCooldown > 0) {
            --this.secondWindCooldown;
        }
        if (anyChanged) {
            // empty if block
        }
    }

    public void reduceCooldowns(float reductionInSeconds) {
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            float currentCooldown = this.getAbilityCooldownFloat(key);
            if (!(currentCooldown > 0.0f)) continue;
            this.setAbilityCooldownFloat(key, currentCooldown - reductionInSeconds);
        }
    }

    public void clearAllCooldowns() {
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            this.abilityCooldowns.put(Character.valueOf(key), Float.valueOf(0.0f));
            this.abilityCooldownDurations.put(Character.valueOf(key), Float.valueOf(0.0f));
            this.abilityLastUsed.put(Character.valueOf(key), 0L);
        }
    }

    public Map<Character, Float> getActiveCooldowns() {
        HashMap<Character, Float> activeCooldowns = new HashMap<Character, Float>();
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            float cooldown = this.getAbilityCooldownFloat(key);
            if (!(cooldown > 0.0f)) continue;
            activeCooldowns.put(Character.valueOf(key), Float.valueOf(cooldown));
        }
        return activeCooldowns;
    }

    public void onAbilityCooldownComplete(char key) {
        System.out.println("Ability " + key + " is ready!");
    }

    public boolean canCastSpell(char abilityKey, int manaCost, int staminaCost, float cooldownSeconds) {
        if (!this.isAbilityUnlocked(abilityKey)) {
            return false;
        }
        if (!this.isAbilityReady(abilityKey)) {
            return false;
        }
        return !(this.mana < (float)manaCost) && !(this.stamina < (float)staminaCost);
    }

    public void castSpell(char abilityKey, int manaCost, int staminaCost, float cooldownSeconds, class_1657 player) {
        if (this.canCastSpell(abilityKey, manaCost, staminaCost, cooldownSeconds)) {
            this.setMana(this.mana - (float)manaCost, player);
            this.setStamina(this.stamina - (float)staminaCost, player);
            this.startAbilityCooldown(abilityKey, cooldownSeconds);
            this.syncToClient(player);
        }
    }

    public boolean canCastSpell(char abilityKey, int manaCost, int staminaCost, int cooldownTicks) {
        return this.canCastSpell(abilityKey, manaCost, staminaCost, (float)cooldownTicks / 20.0f);
    }

    public void castSpell(char abilityKey, int manaCost, int staminaCost, int cooldownTicks, class_1657 player) {
        this.castSpell(abilityKey, manaCost, staminaCost, (float)cooldownTicks / 20.0f, player);
    }

    public class_2487 serializeCooldowns() {
        class_2487 cooldownTag = new class_2487();
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            String keyStr = String.valueOf(key);
            cooldownTag.method_10548(keyStr + "_cooldown", this.getAbilityCooldownFloat(key));
            cooldownTag.method_10548(keyStr + "_duration", this.getAbilityCooldownDuration(key));
            cooldownTag.method_10544(keyStr + "_last_used", this.abilityLastUsed.getOrDefault(Character.valueOf(key), 0L).longValue());
        }
        return cooldownTag;
    }

    public void deserializeCooldowns(class_2487 cooldownTag) {
        for (char key : new char[]{'Z', 'X', 'C', 'V'}) {
            String keyStr = String.valueOf(key);
            if (cooldownTag.method_10545(keyStr + "_cooldown")) {
                this.setAbilityCooldownFloat(key, cooldownTag.method_10583(keyStr + "_cooldown"));
            }
            if (cooldownTag.method_10545(keyStr + "_duration")) {
                this.abilityCooldownDurations.put(Character.valueOf(key), Float.valueOf(cooldownTag.method_10583(keyStr + "_duration")));
            }
            if (!cooldownTag.method_10545(keyStr + "_last_used")) continue;
            this.abilityLastUsed.put(Character.valueOf(key), cooldownTag.method_10537(keyStr + "_last_used"));
        }
    }

    public float getMana() {
        return this.mana;
    }

    public float getStamina() {
        return this.stamina;
    }

    public float getMaxMana() {
        return this.maxMana;
    }

    public float getMaxStamina() {
        return this.maxStamina;
    }

    public int getStrength() {
        return this.strength;
    }

    public int getAgility() {
        return this.agility;
    }

    public int getVitality() {
        return this.vitality;
    }

    public int getIntelligence() {
        return this.intelligence;
    }

    public boolean hasChosenClass() {
        return this.hasChosenClass;
    }

    public int getXp() {
        return this.xp;
    }

    public int getLevel() {
        return this.level;
    }

    public int getAttributePoints() {
        return this.attributePoints;
    }

    public int getSkillPoints() {
        return this.skillPoints;
    }

    public ClassType getClassType() {
        return this.classType;
    }

    public String getClassLore() {
        return this.classType.getLore();
    }

    public Set<String> getUnlockedSkillNodes() {
        return this.unlockedSkillNodes;
    }

    public boolean isSkillNodeUnlocked(String id) {
        return this.unlockedSkillNodes.contains(id);
    }

    public void setHasChosenClass(boolean chosen) {
        this.hasChosenClass = chosen;
    }

    public void setMana(float mana, class_1657 player) {
        this.mana = Math.max(0.0f, Math.min(mana, this.maxMana));
        this.syncToClient(player);
    }

    public void setStamina(float stamina, class_1657 player) {
        this.stamina = Math.max(0.0f, Math.min(stamina, this.maxStamina));
        this.syncToClient(player);
    }

    public void setMaxMana(float maxMana, class_1657 player) {
        this.maxMana = maxMana;
        if (this.mana > maxMana) {
            this.mana = maxMana;
        }
        this.syncToClient(player);
    }

    public void setMaxStamina(float maxStamina, class_1657 player) {
        this.maxStamina = maxStamina;
        if (this.stamina > maxStamina) {
            this.stamina = maxStamina;
        }
        this.syncToClient(player);
    }

    public void setStrength(int strength, class_1657 player) {
        this.strength = Math.max(0, strength);
        this.syncToClient(player);
    }

    public void setAgility(int agility, class_1657 player) {
        this.agility = Math.max(0, agility);
        this.syncToClient(player);
    }

    public void setVitality(int vitality, class_1657 player) {
        this.vitality = Math.max(0, vitality);
        this.syncToClient(player);
    }

    public void setIntelligence(int intelligence, class_1657 player) {
        this.intelligence = Math.max(0, intelligence);
        this.syncToClient(player);
    }

    public void setAttributePoints(int points, class_1657 player) {
        this.attributePoints = points;
        this.syncToClient(player);
    }

    public void setSkillPoints(int points, class_1657 player) {
        this.skillPoints = points;
        this.syncToClient(player);
    }

    public void setClassType(ClassType classType, class_1657 player) {
        this.setClassType(classType);
        this.syncToClient(player);
    }

    public void setMana(float mana) {
        this.mana = Math.max(0.0f, Math.min(mana, this.maxMana));
    }

    public void setStamina(float stamina) {
        this.stamina = Math.max(0.0f, Math.min(stamina, this.maxStamina));
    }

    public void setStrength(int strength) {
        this.strength = Math.max(0, strength);
    }

    public void setAgility(int agility) {
        this.agility = Math.max(0, agility);
    }

    public void setVitality(int vitality) {
        this.vitality = Math.max(0, vitality);
    }

    public void setIntelligence(int intelligence) {
        this.intelligence = Math.max(0, intelligence);
    }

    public void setAttributePoints(int points) {
        this.attributePoints = points;
    }

    public void setSkillPoints(int points) {
        this.skillPoints = points;
    }

    public void setClassType(ClassType classType) {
        this.classType = classType;
        switch (classType) {
            case MENDER: {
                this.setMaxMana(150.0f, null);
                this.setMaxStamina(80.0f, null);
                this.setStrength(3);
                this.setAgility(4);
                this.setVitality(8);
                this.setIntelligence(12);
                break;
            }
            case HARVESTER: {
                this.setMaxMana(80.0f, null);
                this.setMaxStamina(150.0f, null);
                this.setStrength(8);
                this.setAgility(8);
                this.setVitality(7);
                this.setIntelligence(4);
                break;
            }
            case ECHO: {
                this.setMaxMana(120.0f, null);
                this.setMaxStamina(120.0f, null);
                this.setStrength(5);
                this.setAgility(10);
                this.setVitality(6);
                this.setIntelligence(8);
                break;
            }
            case GUARDIAN: {
                this.setMaxMana(100.0f, null);
                this.setMaxStamina(200.0f, null);
                this.setStrength(10);
                this.setAgility(5);
                this.setVitality(12);
                this.setIntelligence(3);
                break;
            }
            default: {
                this.setMaxMana(100.0f, null);
                this.setMaxStamina(100.0f, null);
                this.setStrength(5);
                this.setAgility(5);
                this.setVitality(5);
                this.setIntelligence(5);
            }
        }
        this.mana = this.maxMana;
        this.stamina = this.maxStamina;
    }

    public void setAbilityUnlocked(char key, boolean unlocked) {
        switch (key) {
            case 'Z': 
            case 'z': {
                this.abilityZUnlocked = unlocked;
                break;
            }
            case 'X': 
            case 'x': {
                this.abilityXUnlocked = unlocked;
                break;
            }
            case 'C': 
            case 'c': {
                this.abilityCUnlocked = unlocked;
                break;
            }
            case 'V': 
            case 'v': {
                this.abilityVUnlocked = unlocked;
            }
        }
    }

    public void setAbilityUnlocked(char key, boolean unlocked, class_1657 player) {
        this.setAbilityUnlocked(key, unlocked);
        this.syncToClient(player);
    }

    public boolean isAbilityUnlocked(char key) {
        return switch (key) {
            case 'Z', 'z' -> this.abilityZUnlocked;
            case 'X', 'x' -> this.abilityXUnlocked;
            case 'C', 'c' -> this.abilityCUnlocked;
            case 'V', 'v' -> this.abilityVUnlocked;
            default -> false;
        };
    }

    public void unlockAbilitiesForLevel() {
        if (this.level >= 1) {
            this.abilityZUnlocked = true;
        }
        if (this.level >= 5) {
            this.abilityXUnlocked = true;
        }
        if (this.level >= 10) {
            this.abilityCUnlocked = true;
        }
        if (this.level >= 15) {
            this.abilityVUnlocked = true;
        }
    }

    public void unlockSkillNode(String id) {
        this.unlockedSkillNodes.add(id);
    }

    public void unlockSkillNode(String id, class_1657 player) {
        if (!this.unlockedSkillNodes.contains(id)) {
            this.unlockedSkillNodes.add(id);
            this.applySkillNodeEffect(id, player);
        }
    }

    public void applySkillNodeEffect(String id, class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            SkillTreeSystem.SkillNodeData node = SkillTreeSystem.getSkillNode(id);
            if (node != null) {
                int rank = SkillTreeSystem.getSkillRank(id, this);
                node.effect.apply(this, serverPlayer, rank);
                return;
            }
        }
        switch (id) {
            case "health1": 
            case "health2": {
                this.setVitality(this.getVitality() + 2, player);
                break;
            }
            case "str1": 
            case "str2": {
                this.setStrength(this.getStrength() + 1, player);
                break;
            }
            case "agi1": {
                this.setAgility(this.getAgility() + 1, player);
                break;
            }
            case "def1": {
                this.setAttributePoints(this.getAttributePoints() + 1, player);
                break;
            }
            case "mana1": {
                this.setMaxMana(this.getMaxMana() + 10.0f, player);
                break;
            }
            case "sta1": {
                this.setMaxStamina(this.getMaxStamina() + 10.0f, player);
                break;
            }
            case "root": {
                this.setSkillPoints(this.getSkillPoints() + 1, player);
                break;
            }
            case "critical_hit": {
                this.setAgility(this.getAgility() + 2, player);
                break;
            }
            case "damage_reduction": {
                this.setIntelligence(this.getIntelligence() + 3, player);
                break;
            }
            case "spell_power": {
                this.setIntelligence(this.getIntelligence() + 3, player);
                break;
            }
            case "energy_efficiency": {
                this.addMaxMana(10);
                break;
            }
            case "healing_boost": {
                this.addHealthRegen(1.0f);
                break;
            }
            case "combat_mastery": {
                this.setStrength(this.getStrength() + 2, player);
                this.setAgility(this.getAgility() + 1, player);
                break;
            }
            case "magic_resistance": {
                this.setIntelligence(this.getIntelligence() + 2, player);
                break;
            }
            case "ability_unlock_x": {
                if (this.level >= 3) {
                    this.abilityXUnlocked = true;
                }
                this.syncToClient(player);
                break;
            }
            case "ability_unlock_c": {
                if (this.level >= 7) {
                    this.abilityCUnlocked = true;
                }
                this.syncToClient(player);
            }
        }
    }

    public boolean canUnlockSkill(String nodeId) {
        return SkillTreeSystem.canUnlockSkill(nodeId, this);
    }

    public boolean unlockSkill(String nodeId, class_3222 player) {
        return SkillTreeSystem.unlockSkill(nodeId, this, player);
    }

    public void resetSkillTree(class_746 player) {
        SkillTreeSystem.resetSkillTree(this, player);
    }

    public int getXpToNextLevel() {
        return 100 + (this.level - 1) * 50;
    }

    public float getSpellPower() {
        float basePower = (float)this.intelligence * 2.0f;
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.MENDER -> basePower * 1.3f;
            case ClassType.HARVESTER -> basePower * 1.1f;
            case ClassType.ECHO -> basePower * 1.2f;
            case ClassType.GUARDIAN -> basePower * 0.9f;
            case ClassType.NONE -> basePower;
        };
    }

    public float getManaEfficiency() {
        float baseEfficiency = 1.0f + (float)this.intelligence * 0.02f;
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.MENDER -> baseEfficiency * 1.15f;
            case ClassType.HARVESTER -> baseEfficiency * 0.95f;
            case ClassType.ECHO -> baseEfficiency;
            case ClassType.GUARDIAN -> baseEfficiency * 1.05f;
            case ClassType.NONE -> baseEfficiency;
        };
    }

    public float calculatePhysicalDamage(float baseDamage) {
        float strengthBonus = (float)this.strength * 0.5f;
        float classModifier = switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.HARVESTER -> 1.2f;
            case ClassType.GUARDIAN -> 1.1f;
            case ClassType.MENDER -> 0.9f;
            case ClassType.ECHO -> 1.0f;
            case ClassType.NONE -> 1.0f;
        };
        return (baseDamage + strengthBonus) * classModifier;
    }

    public float getCriticalChance() {
        float baseCrit = (float)this.agility * 0.5f;
        float classCrit = switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.ECHO -> baseCrit + 5.0f;
            case ClassType.HARVESTER -> baseCrit + 2.0f;
            case ClassType.MENDER -> baseCrit - 2.0f;
            case ClassType.GUARDIAN -> baseCrit;
            case ClassType.NONE -> baseCrit;
        };
        return Math.max(0.0f, Math.min(classCrit, 95.0f));
    }

    public float getCriticalDamage() {
        float baseCritDamage = 1.5f + (float)this.agility * 0.02f;
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.ECHO -> baseCritDamage + 0.3f;
            case ClassType.HARVESTER -> baseCritDamage + 0.1f;
            case ClassType.MENDER, ClassType.GUARDIAN -> baseCritDamage;
            case ClassType.NONE -> baseCritDamage;
        };
    }

    public float getDamageReduction() {
        float vitalityReduction = (float)this.vitality * 0.3f;
        float defenseReduction = (float)this.defense * 0.5f;
        float classReduction = switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.GUARDIAN -> 5.0f;
            case ClassType.MENDER -> 5.0f;
            case ClassType.HARVESTER, ClassType.ECHO -> 0.0f;
            case ClassType.NONE -> 0.0f;
        };
        float totalReduction = vitalityReduction + defenseReduction + classReduction;
        return Math.min(totalReduction, 80.0f);
    }

    public float getDodgeChance() {
        float baseDodge = (float)this.agility * 0.3f;
        float classDodge = switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.ECHO -> baseDodge + 8.0f;
            case ClassType.HARVESTER -> baseDodge + 3.0f;
            case ClassType.MENDER -> baseDodge + 2.0f;
            case ClassType.GUARDIAN -> baseDodge - 2.0f;
            case ClassType.NONE -> baseDodge;
        };
        return Math.max(0.0f, Math.min(classDodge, 75.0f));
    }

    public float takeDamage(float incomingDamage, class_1657 player) {
        Random random = new Random();
        if (random.nextFloat() * 100.0f < this.getDodgeChance()) {
            return 0.0f;
        }
        float damageReduction = this.getDamageReduction() / 100.0f;
        float finalDamage = incomingDamage * (1.0f - damageReduction);
        if (this.classType == ClassType.GUARDIAN && this.stamina >= 10.0f) {
            finalDamage *= 0.8f;
            this.setStamina(this.stamina - 5.0f, player);
        }
        return Math.max(1.0f, finalDamage);
    }

    public float getDamageTypeModifier(String damageType) {
        return switch (this.classType) {
            case ClassType.MENDER -> {
                switch (damageType.toLowerCase()) {
                    case "corruption": 
                    case "dark": {
                        yield 0.7f;
                    }
                    case "fire": 
                    case "physical": {
                        yield 1.2f;
                    }
                }
                yield 1.0f;
            }
            case ClassType.HARVESTER -> {
                switch (damageType.toLowerCase()) {
                    case "fire": 
                    case "lightning": {
                        yield 0.8f;
                    }
                    case "cold": 
                    case "water": {
                        yield 1.3f;
                    }
                }
                yield 1.0f;
            }
            case ClassType.ECHO -> {
                switch (damageType.toLowerCase()) {
                    case "psychic": 
                    case "dark": {
                        yield 0.6f;
                    }
                    case "light": 
                    case "holy": {
                        yield 1.4f;
                    }
                }
                yield 1.0f;
            }
            case ClassType.GUARDIAN -> {
                switch (damageType.toLowerCase()) {
                    case "physical": 
                    case "fire": {
                        yield 0.8f;
                    }
                    case "corruption": 
                    case "psychic": {
                        yield 1.2f;
                    }
                }
                yield 1.0f;
            }
            default -> 1.0f;
        };
    }

    public boolean canActivateSecondWind() {
        return this.secondWindEnabled && this.secondWindCooldown <= 0 && (this.mana <= this.maxMana * 0.2f || this.stamina <= this.maxStamina * 0.2f);
    }

    public void activateSecondWind(class_1657 player) {
        if (this.canActivateSecondWind()) {
            this.setMana(this.maxMana / 2.0f, player);
            this.setStamina(this.maxStamina / 2.0f, player);
            player.method_6025(10.0f);
            this.secondWindCooldown = 6000;
            this.syncToClient(player);
        }
    }

    public int getSecondWindCooldownSeconds() {
        return this.secondWindCooldown / 20;
    }

    public int getCombatRating() {
        return this.strength * 3 + this.agility * 2 + this.vitality * 2 + this.intelligence * 2 + this.defense;
    }

    public boolean hasResourcesForCombat() {
        return this.mana > 0.0f || this.stamina > 10.0f;
    }

    public float getAttackSpeedModifier() {
        float baseSpeed = 1.0f + (float)this.agility * 0.02f;
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.ECHO -> baseSpeed * 1.15f;
            case ClassType.HARVESTER -> baseSpeed * 1.05f;
            case ClassType.GUARDIAN -> baseSpeed * 0.95f;
            case ClassType.MENDER -> baseSpeed;
            case ClassType.NONE -> baseSpeed;
        };
    }

    public String getPassiveAbilityDescription() {
        return switch (this.classType) {
            case ClassType.MENDER -> "Regeneration Aura: Slowly heal nearby allies and yourself when not at full health";
            case ClassType.HARVESTER -> "Energy Drain: Gain mana when dealing damage to enemies";
            case ClassType.ECHO -> "Chaos Field: Random chance for a random buff or debuff every second";
            case ClassType.GUARDIAN -> "Stalwart Defense: Moderate damage reduction and resource recovery when stationary";
            default -> "No passive ability";
        };
    }

    public void addHealthRegen(float amount) {
        this.healthRegen += amount;
    }

    public void addStrength(int amount) {
        this.strength += amount;
    }

    public void addAgility(int amount) {
        this.agility += amount;
    }

    public void addVitality(int amount) {
        this.vitality += amount;
    }

    public void addDefense(int amount) {
        this.defense += amount;
    }

    public void addIntelligence(int amount) {
        this.intelligence += amount;
    }

    public void enableSecondWind() {
        this.secondWindEnabled = true;
        this.secondWindCooldown = 0;
    }

    public int getManaBarColor() {
        return this.classType.getManaColor();
    }

    public int getStaminaBarColor() {
        return this.classType.getStaminaColor();
    }

    public String getPlayerClass() {
        return switch (this.classType) {
            case ClassType.MENDER -> "Mender";
            case ClassType.HARVESTER -> "Harvester";
            case ClassType.ECHO -> "Echo";
            case ClassType.GUARDIAN -> "Guardian";
            default -> "None";
        };
    }

    public void syncToClient(class_1657 player) {
        if (player instanceof class_3222) {
            PlayerStatsSyncPacket.sendTo(player, this);
        }
    }

    public class_2487 toNbt() {
        class_2487 nbt = new class_2487();
        nbt.method_10556("AbilityZUnlocked", this.abilityZUnlocked);
        nbt.method_10556("AbilityXUnlocked", this.abilityXUnlocked);
        nbt.method_10556("AbilityCUnlocked", this.abilityCUnlocked);
        nbt.method_10556("AbilityVUnlocked", this.abilityVUnlocked);
        nbt.method_10556("HasChosenClass", this.hasChosenClass);
        nbt.method_10569("XP", this.xp);
        nbt.method_10569("Level", this.level);
        nbt.method_10569("AttributePoints", this.attributePoints);
        nbt.method_10569("SkillPoints", this.skillPoints);
        nbt.method_10548("Mana", this.mana);
        nbt.method_10548("Stamina", this.stamina);
        nbt.method_10548("MaxMana", this.maxMana);
        nbt.method_10548("MaxStamina", this.maxStamina);
        nbt.method_10569("Strength", this.strength);
        nbt.method_10569("Agility", this.agility);
        nbt.method_10569("Vitality", this.vitality);
        nbt.method_10569("Intelligence", this.intelligence);
        nbt.method_10582("ClassType", this.classType.name());
        nbt.method_10548("HealthRegen", this.healthRegen);
        nbt.method_10556("SecondWindEnabled", this.secondWindEnabled);
        nbt.method_10569("Defense", this.defense);
        nbt.method_10569("MagicDefense", this.magicDefense);
        if (this.secondWindCooldown < 0) {
            this.secondWindCooldown = 0;
        }
        nbt.method_10569("SecondWindCooldown", this.secondWindCooldown);
        class_2499 unlocked = new class_2499();
        for (String id : this.unlockedSkillNodes) {
            unlocked.add((Object)class_2519.method_23256((String)id));
        }
        nbt.method_10566("UnlockedSkillNodes", (class_2520)unlocked);
        nbt.method_10566("Cooldowns", (class_2520)this.serializeCooldowns());
        return nbt;
    }

    public void fromNbt(class_2487 nbt) {
        if (nbt.method_10545("AbilityZUnlocked")) {
            this.abilityZUnlocked = nbt.method_10577("AbilityZUnlocked");
        }
        if (nbt.method_10545("AbilityXUnlocked")) {
            this.abilityXUnlocked = nbt.method_10577("AbilityXUnlocked");
        }
        if (nbt.method_10545("AbilityCUnlocked")) {
            this.abilityCUnlocked = nbt.method_10577("AbilityCUnlocked");
        }
        if (nbt.method_10545("AbilityVUnlocked")) {
            this.abilityVUnlocked = nbt.method_10577("AbilityVUnlocked");
        }
        if (nbt.method_10545("HasChosenClass")) {
            this.hasChosenClass = nbt.method_10577("HasChosenClass");
        }
        if (nbt.method_10545("XP")) {
            this.xp = nbt.method_10550("XP");
        }
        if (nbt.method_10545("Level")) {
            this.level = nbt.method_10550("Level");
        }
        if (nbt.method_10545("AttributePoints")) {
            this.attributePoints = nbt.method_10550("AttributePoints");
        }
        if (nbt.method_10545("SkillPoints")) {
            this.skillPoints = nbt.method_10550("SkillPoints");
        }
        if (nbt.method_10545("Mana")) {
            this.mana = nbt.method_10550("Mana");
        }
        if (nbt.method_10545("Stamina")) {
            this.stamina = nbt.method_10550("Stamina");
        }
        if (nbt.method_10545("MaxMana")) {
            this.maxMana = nbt.method_10550("MaxMana");
        }
        if (nbt.method_10545("MaxStamina")) {
            this.maxStamina = nbt.method_10550("MaxStamina");
        }
        if (nbt.method_10545("Strength")) {
            this.strength = nbt.method_10550("Strength");
        }
        if (nbt.method_10545("Agility")) {
            this.agility = nbt.method_10550("Agility");
        }
        if (nbt.method_10545("Vitality")) {
            this.vitality = nbt.method_10550("Vitality");
        }
        if (nbt.method_10545("Intelligence")) {
            this.intelligence = nbt.method_10550("Intelligence");
        }
        this.magicDefense = nbt.method_10545("MagicDefense") ? nbt.method_10550("MagicDefense") : 0;
        if (nbt.method_10545("ClassType")) {
            try {
                this.classType = ClassType.valueOf(nbt.method_10558("ClassType"));
            }
            catch (IllegalArgumentException e) {
                this.classType = ClassType.NONE;
            }
        }
        if (nbt.method_10545("HealthRegen")) {
            this.healthRegen = nbt.method_10583("HealthRegen");
        }
        if (nbt.method_10545("SecondWindEnabled")) {
            this.secondWindEnabled = nbt.method_10577("SecondWindEnabled");
        }
        if (nbt.method_10545("Defense")) {
            this.defense = nbt.method_10550("Defense");
        }
        if (nbt.method_10545("SecondWindCooldown")) {
            this.secondWindCooldown = nbt.method_10550("SecondWindCooldown");
        }
        this.unlockedSkillNodes.clear();
        if (nbt.method_10573("UnlockedSkillNodes", 9)) {
            class_2499 unlocked = nbt.method_10554("UnlockedSkillNodes", 8);
            for (int i = 0; i < unlocked.size(); ++i) {
                this.unlockedSkillNodes.add(unlocked.method_10608(i));
            }
        }
        if (nbt.method_10545("Cooldowns")) {
            this.deserializeCooldowns(nbt.method_10562("Cooldowns"));
        }
    }

    public void addMaxMana(int i) {
        this.maxMana += (float)i;
        if (this.mana > this.maxMana) {
            this.mana = this.maxMana;
        }
        this.syncToClient(null);
    }

    public void addStamina(int i) {
        this.stamina += (float)i;
        if (this.stamina > this.maxStamina) {
            this.stamina = this.maxStamina;
        }
        this.syncToClient(null);
    }

    public void addMaxStamina(int amount) {
        this.maxStamina += (float)amount;
        if (this.stamina > this.maxStamina) {
            this.stamina = this.maxStamina;
        }
        this.syncToClient(null);
    }

    public int getMaxDefense() {
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.MENDER -> 1;
            case ClassType.HARVESTER -> 3;
            case ClassType.ECHO -> 2;
            case ClassType.GUARDIAN -> 4;
            case ClassType.NONE -> 0;
        };
    }

    public int getDefense() {
        return this.defense;
    }

    public boolean addStaminaRegen(float f) {
        if (f < 0.0f) {
            return false;
        }
        this.syncToClient(null);
        return true;
    }

    public Object addMagicDefense(int i) {
        if (i < 0) {
            return false;
        }
        this.magicDefense += i;
        this.syncToClient(null);
        return true;
    }

    public int getMagicDefense() {
        return this.magicDefense;
    }

    public boolean setMagicDefense(int i) {
        if (i < 0) {
            return false;
        }
        this.magicDefense = i;
        this.syncToClient(null);
        return true;
    }

    public void addXp(int amount, class_1657 player) {
        int oldLevel = this.level;
        this.xp += amount;
        while (this.xp >= this.getXpToNextLevel()) {
            this.xp -= this.getXpToNextLevel();
            ++this.level;
            this.attributePoints += 2;
            ++this.skillPoints;
            this.syncToClient(player);
            if (!(player instanceof class_3222)) continue;
            class_3222 serverPlayer = (class_3222)player;
            this.checkAbilityUnlocks(serverPlayer, oldLevel, this.level);
        }
        this.syncToClient(player);
    }

    private void checkAbilityUnlocks(class_3222 player, int oldLevel, int newLevel) {
        if (newLevel > oldLevel && this.hasChosenClass && player instanceof TessarectedPlayerStatsHolder) {
            class_2487 nbt = new class_2487();
            nbt.method_10569("oldLevel", oldLevel);
            nbt.method_10569("newLevel", newLevel);
            this.handleAbilityLevelUp(player, this, nbt);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void handleAbilityLevelUp(class_3222 player, PlayerStats stats, class_2487 nbt) {
        boolean canUnlock;
        int newLevel = stats.getLevel();
        if (!stats.hasChosenClass()) {
            return;
        }
        boolean anyUnlocked = false;
        ArrayList<Object> unlockedAbilities = new ArrayList<Object>();
        if (newLevel >= 1 && !stats.isAbilityUnlocked('z')) {
            stats.setAbilityUnlocked('z', true, (class_1657)player);
            stats.setAbilityUnlocked('Z', true, (class_1657)player);
            unlockedAbilities.add("Z");
            anyUnlocked = true;
        }
        if (!stats.isAbilityUnlocked('x')) {
            canUnlock = false;
            String string = "";
            if (stats.isSkillNodeUnlocked("ability_unlock_x") && newLevel >= 3) {
                canUnlock = true;
                String string2 = " (Early Unlock)";
            } else if (newLevel >= 5) {
                canUnlock = true;
            }
            if (canUnlock) {
                void var8_11;
                stats.setAbilityUnlocked('x', true, (class_1657)player);
                stats.setAbilityUnlocked('X', true, (class_1657)player);
                unlockedAbilities.add("X" + (String)var8_11);
                anyUnlocked = true;
            }
        }
        if (!stats.isAbilityUnlocked('c')) {
            canUnlock = false;
            String string = "";
            if (stats.isSkillNodeUnlocked("ability_unlock_c") && newLevel >= 7) {
                canUnlock = true;
                String string3 = " (Early Unlock)";
            } else if (newLevel >= 10) {
                canUnlock = true;
            }
            if (canUnlock) {
                void var8_14;
                stats.setAbilityUnlocked('c', true, (class_1657)player);
                stats.setAbilityUnlocked('C', true, (class_1657)player);
                unlockedAbilities.add("C" + (String)var8_14);
                anyUnlocked = true;
            }
        }
        if (newLevel >= 15 && !stats.isAbilityUnlocked('v')) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
            unlockedAbilities.add("V");
            anyUnlocked = true;
        }
        if (anyUnlocked) {
            for (String string : unlockedAbilities) {
                SpellSystem.SpellType spell = this.getSpellForKey(stats.getClassType(), string.charAt(0));
                if (spell == null) continue;
                player.method_7353((class_2561)class_2561.method_43470((String)("\ud83d\udd13 Ability " + string + " Unlocked: " + spell.getDisplayName())).method_27692(class_124.field_1060), false);
            }
            player.method_5783(class_3417.field_15195, 1.0f, 1.2f);
            this.spawnAbilityUnlockParticles(player);
            this.showPlayerAbilities(player, stats);
            stats.syncToClient((class_1657)player);
        }
    }

    private SpellSystem.SpellType getSpellForKey(ClassType classType, char key) {
        int index;
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(classType);
        switch (Character.toLowerCase(key)) {
            case 'z': {
                int n = 0;
                break;
            }
            case 'x': {
                int n = 1;
                break;
            }
            case 'c': {
                int n = 2;
                break;
            }
            case 'v': {
                int n = 3;
                break;
            }
            default: {
                int n = index = -1;
            }
        }
        if (index >= 0 && index < spells.length) {
            return spells[index];
        }
        return null;
    }

    private void showPlayerAbilities(class_3222 player, PlayerStats stats) {
        player.method_7353((class_2561)class_2561.method_43470((String)("\u2550\u2550\u2550 " + stats.getPlayerClass() + " Abilities \u2550\u2550\u2550")).method_27692(class_124.field_1065), false);
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(stats.getClassType());
        char[] keys = new char[]{'Z', 'X', 'C', 'V'};
        int[] unlockLevels = new int[]{1, 5, 10, 15};
        for (int i = 0; i < Math.min(spells.length, keys.length); ++i) {
            char key = keys[i];
            SpellSystem.SpellType spell = spells[i];
            int reqLevel = unlockLevels[i];
            if (i == 1 && stats.isSkillNodeUnlocked("ability_unlock_x")) {
                reqLevel = 3;
            } else if (i == 2 && stats.isSkillNodeUnlocked("ability_unlock_c")) {
                reqLevel = 7;
            }
            if (stats.isAbilityUnlocked(key)) {
                Object costText = "";
                if (spell.getManaCost() > 0) {
                    costText = (String)costText + spell.getManaCost() + " MP";
                }
                if (spell.getStaminaCost() > 0) {
                    if (!((String)costText).isEmpty()) {
                        costText = (String)costText + ", ";
                    }
                    costText = (String)costText + spell.getStaminaCost() + " SP";
                }
                if (!((String)costText).isEmpty()) {
                    costText = " (" + (String)costText + ")";
                }
                player.method_7353((class_2561)class_2561.method_43470((String)("  \u2713 " + key + ": " + spell.getDisplayName() + (String)costText)).method_27692(class_124.field_1060), false);
                continue;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)("  \u2717 " + key + ": " + spell.getDisplayName() + " (Level " + reqLevel + ")")).method_27692(class_124.field_1080), false);
        }
        String passiveName = switch (stats.getClassType()) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.MENDER -> "Regeneration Aura";
            case ClassType.HARVESTER -> "Energy Drain";
            case ClassType.ECHO -> "Chaos Field";
            case ClassType.GUARDIAN -> "Stalwart Defense (Nerfed)";
            case ClassType.NONE -> "None";
        };
        player.method_7353((class_2561)class_2561.method_43470((String)("  \u25c9 Passive: " + passiveName)).method_27692(class_124.field_1078), false);
    }

    private void spawnAbilityUnlockParticles(class_3222 player) {
        class_1937 class_19372 = player.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (int i = 0; i < 30; ++i) {
                double angle = Math.PI * 2 * (double)i / 30.0;
                double radius = 1.5;
                double x = player.method_23317() + Math.cos(angle) * radius;
                double y = player.method_23318() + 1.0 + Math.random() * 2.0;
                double z = player.method_23321() + Math.sin(angle) * radius;
                serverWorld.method_14199((class_2394)class_2398.field_11207, x, y, z, 1, 0.0, 0.2, 0.0, 0.1);
            }
            serverWorld.method_14199((class_2394)class_2398.field_11220, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 20, 0.5, 1.0, 0.5, 0.1);
        }
    }

    public static PlayerStats getPlayerStats(class_746 player) {
        if (player instanceof TessarectedPlayerStatsHolder) {
            TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
            return holder.tessarected_getStats();
        }
        return null;
    }

    public void setMagicDamageReduction(DamageType type, double magicReduction) {
        if (type == null) {
            return;
        }
        switch (type) {
            case FIRE: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case COLD: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case LIGHTNING: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case DARK: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case HOLY: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case TESSARECTION: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case ENERGY: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case CORRUPTION: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case PSYCHIC: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
            case VOID: {
                this.magicDefense = (int)((double)this.magicDefense * (1.0 - magicReduction));
                break;
            }
        }
        this.syncToClient(null);
    }

    public boolean canStartSprinting() {
        return this.getStamina() > 0.0f;
    }

    public int getSprintDurationTicks() {
        if (this.getStamina() <= 0.0f) {
            return 0;
        }
        return (int)(this.getStamina() * 20.0f);
    }

    public void triggerPassiveAbility(class_1657 player) {
        block19: {
            if (player == null) {
                return;
            }
            switch (this.classType) {
                case MENDER: {
                    if (!(this.getMana() >= 8.0f) || !(player.method_6032() < player.method_6063())) break;
                    player.method_6025(1.0f);
                    this.setMana(this.getMana() - 3.0f, player);
                    if (!(player instanceof class_3222)) break;
                    class_3222 serverPlayer = (class_3222)player;
                    this.healNearbyPlayers(serverPlayer, 2.0, 0.5f);
                    break;
                }
                case HARVESTER: {
                    this.reduceCooldowns(0.2f);
                    if (!(player.method_6032() > player.method_6063() * 0.8f)) break;
                    this.setMana(Math.min(this.getMaxMana(), this.getMana() + 2.0f), player);
                    break;
                }
                case ECHO: {
                    Random rand = new Random();
                    int effect = rand.nextInt(6);
                    switch (effect) {
                        case 0: {
                            this.setMana(Math.min(this.getMaxMana(), this.getMana() + 5.0f), player);
                            break;
                        }
                        case 1: {
                            this.setStamina(Math.min(this.getMaxStamina(), this.getStamina() + 10.0f), player);
                            break;
                        }
                        case 2: {
                            this.reduceCooldowns(0.5f);
                            break;
                        }
                        case 3: {
                            player.method_6025(0.5f);
                            break;
                        }
                        case 4: {
                            if (rand.nextFloat() < 0.3f) {
                                break;
                            }
                            break block19;
                        }
                        case 5: {
                            this.setMana(Math.max(0.0f, this.getMana() - 2.0f), player);
                            this.setStamina(Math.max(0.0f, this.getStamina() - 3.0f), player);
                        }
                    }
                    break;
                }
                case GUARDIAN: {
                    player.method_6073(Math.min(player.method_6063() * 0.1f, player.method_6067() + 0.5f));
                    if (!(player.method_18798().method_1027() < 0.01)) break;
                    if (this.getStamina() < this.getMaxStamina()) {
                        this.setStamina(Math.min(this.getMaxStamina(), this.getStamina() + 5.0f), player);
                    }
                    if (!(this.getMana() < this.getMaxMana()) || !(this.getMana() < this.getMaxMana() * 0.5f)) break;
                    this.setMana(Math.min(this.getMaxMana(), this.getMana() + 3.0f), player);
                    break;
                }
                case NONE: {
                    if (this.getMana() < this.getMaxMana()) {
                        this.setMana(this.getMaxMana(), player);
                    }
                    if (!(this.getStamina() < this.getMaxStamina())) break;
                    this.setStamina(this.getMaxStamina(), player);
                }
            }
        }
    }

    private void healNearbyPlayers(class_3222 centerPlayer, double radius, float healAmount) {
        centerPlayer.method_37908().method_8335((class_1297)centerPlayer, centerPlayer.method_5829().method_1014(radius)).stream().filter(entity -> entity instanceof class_3222).map(entity -> (class_3222)entity).forEach(player -> {
            if (player.method_6032() < player.method_6063()) {
                player.method_6025(healAmount);
                class_1937 patt52326$temp = centerPlayer.method_37908();
                if (patt52326$temp instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)patt52326$temp;
                    serverWorld.method_14199((class_2394)class_2398.field_11201, player.method_23317(), player.method_23318() + 1.0, player.method_23321(), 2, 0.3, 0.3, 0.3, 0.1);
                }
            }
        });
    }

    public float getResourceEfficiency() {
        return switch (this.classType) {
            default -> throw new IncompatibleClassChangeError();
            case ClassType.MENDER -> 1.2f;
            case ClassType.GUARDIAN -> 1.1f;
            case ClassType.ECHO -> {
                Random rand = new Random();
                yield 0.8f + rand.nextFloat() * 0.8f;
            }
            case ClassType.HARVESTER -> 0.9f;
            case ClassType.NONE -> 0.8f;
        };
    }

    public static enum ClassType {
        MENDER("Healers and restorers, Menders feel the planet's pain like a blazing fire in their soul.\n They draw upon ancient energies and Tesseraction fragments to mend the world's wounds, stabilize volatile Rifts,\n and even heal the twisted Echoes, believing true power lies in harmony and restoration."),
        HARVESTER("Masters of raw power, Harvesters see the Great Sundering as an unparalleled opportunity. They relentlessly seek and absorb Tesseraction Core fragments,\n channeling this untamed energy for immense strength and to reshape reality to their will, believing absolute control forges destiny."),
        ECHO("Mysterious and elusive, Echoes are twisted beings born from the chaotic energies of the Sundering, guarding the most unstable regions.\n They manipulate sound and shadow to confound their foes and corrupt the world around them, embodying the lingering chaos that threatens to consume all."),
        GUARDIAN("Stalwart defenders, Guardians stand as a bulwark against the encroaching corruption and the unchecked ambition of Harvesters.\n They shield their companions and stand firm against any threat, understanding Tesseraction energy to counteract its destructive potential and defend the fragile peace of the shattered world."),
        NONE("No class selected. Choose your path to unlock unique abilities.");

        private final String lore;

        private ClassType(String lore) {
            this.lore = lore;
        }

        public String getLore() {
            return this.lore;
        }

        public int getManaColor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case MENDER -> -10034945;
                case HARVESTER -> -23296;
                case ECHO -> -5635841;
                case GUARDIAN -> -16711728;
                case NONE -> -13408513;
            };
        }

        public int getStaminaColor() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case MENDER -> -4784282;
                case HARVESTER -> -8090;
                case ECHO -> -10066330;
                case GUARDIAN -> -10027082;
                case NONE -> -154;
            };
        }
    }
}

