/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.stats;

import com.tessarected.gui.PlayerStatsHudOverlay;
import com.tessarected.stats.PlayerStats;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;

public class PlayerStatsSyncPacket {
    public static final class_2960 ID = new class_2960("tessarected", "player_stats_sync");
    private final class_2487 nbt;

    public PlayerStatsSyncPacket(PlayerStats stats) {
        this.nbt = stats.toNbt();
    }

    public PlayerStatsSyncPacket(class_2487 nbt) {
        this.nbt = nbt;
    }

    public void write(class_2540 buf) {
        buf.method_10794(this.nbt);
    }

    public static PlayerStatsSyncPacket read(class_2540 buf) {
        class_2487 nbt = buf.method_10798();
        return new PlayerStatsSyncPacket(nbt);
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    @Environment(value=EnvType.CLIENT)
    public static void registerClientReceiver() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)ID, (client, handler, buf, responseSender) -> {
            PlayerStatsSyncPacket packet = PlayerStatsSyncPacket.read(buf);
            client.execute(() -> {
                PlayerStatsHudOverlay.clientStats.fromNbt(packet.getNbt());
                PlayerStatsSyncPacket.saveClientStatsToDisk();
            });
        });
    }

    @Environment(value=EnvType.CLIENT)
    public static void saveClientStatsToDisk() {
        try {
            File file = new File(class_310.method_1551().field_1697, "tessarected_player_stats.dat");
            class_2487 nbt = PlayerStatsHudOverlay.clientStats.toNbt();
            FileOutputStream fos = new FileOutputStream(file);
            class_2507.method_10634((class_2487)nbt, (OutputStream)fos);
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void loadClientStatsFromDisk() {
        try {
            File file = new File(class_310.method_1551().field_1697, "tessarected_player_stats.dat");
            if (file.exists()) {
                FileInputStream fis = new FileInputStream(file);
                class_2487 nbt = class_2507.method_10629((InputStream)fis);
                PlayerStatsHudOverlay.clientStats.fromNbt(nbt);
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void sendTo(class_1657 player, PlayerStats stats) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10794(stats.toNbt());
        ServerPlayNetworking.send((class_3222)((class_3222)player), (class_2960)ID, (class_2540)buf);
    }
}

