/*
 * Decompiled with CFR 0.152.
 */
package com.tessarected.stats;

import com.tessarected.TessarectedPlayerStatsHolder;
import com.tessarected.abilities.SpellAbilityManager;
import com.tessarected.combat.SpellSystem;
import com.tessarected.skills.SkillTreeSystem;
import com.tessarected.stats.PlayerStats;
import com.tessarected.stats.PlayerStatsSyncPacket;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

public class PlayerStatsUpdatePacket {
    public static final class_2960 ID = new class_2960("tessarected", "player_stats_update");
    private final class_2487 nbt;
    private final String action;

    public PlayerStatsUpdatePacket(String action, class_2487 nbt) {
        this.action = action;
        this.nbt = nbt;
    }

    public void write(class_2540 buf) {
        buf.method_10814(this.action);
        buf.method_10794(this.nbt);
    }

    public static PlayerStatsUpdatePacket read(class_2540 buf) {
        String action = buf.method_19772();
        class_2487 nbt = buf.method_10798();
        return new PlayerStatsUpdatePacket(action, nbt);
    }

    public static void sendToServer(String action, class_2487 nbt) {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10814(action);
        buf.method_10794(nbt);
        ClientPlayNetworking.send((class_2960)ID, (class_2540)buf);
    }

    public static void registerServerReceiver() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)ID, (server, player, handler, buf, responseSender) -> {
            PlayerStatsUpdatePacket packet = PlayerStatsUpdatePacket.read(buf);
            server.execute(() -> {
                if (player instanceof class_3222 && player instanceof TessarectedPlayerStatsHolder) {
                    class_3222 serverPlayer = player;
                    TessarectedPlayerStatsHolder holder = (TessarectedPlayerStatsHolder)player;
                    PlayerStats stats = holder.tessarected_getStats();
                    switch (packet.action) {
                        case "use_spell_ability": {
                            PlayerStatsUpdatePacket.handleSpellAbility(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "unlock_skill_node": {
                            PlayerStatsUpdatePacket.handleSkillNodeUnlock(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "allocate_attribute_point": {
                            PlayerStatsUpdatePacket.handleAttributeAllocation(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "reset_skill_tree": {
                            PlayerStatsUpdatePacket.handleSkillTreeReset(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "select_class": {
                            PlayerStatsUpdatePacket.handleClassSelection(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "use_second_wind": {
                            PlayerStatsUpdatePacket.handleSecondWindActivation(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "ability_level_up": {
                            PlayerStatsUpdatePacket.handleAbilityLevelUp(serverPlayer, stats, packet.nbt);
                            break;
                        }
                        case "unlock_skill_tree_node": {
                            String nodeId = packet.nbt.method_10558("nodeId");
                            boolean success = stats.unlockSkill(nodeId, serverPlayer);
                            if (success) break;
                            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Cannot unlock skill: " + nodeId)).method_27692(class_124.field_1061), false);
                            break;
                        }
                        default: {
                            stats.fromNbt(packet.nbt);
                            serverPlayer.method_7353((class_2561)class_2561.method_43470((String)("Stats updated: " + packet.action)), false);
                        }
                    }
                    PlayerStatsSyncPacket.sendTo((class_1657)serverPlayer, stats);
                }
            });
        });
    }

    private static void handleSpellAbility(class_3222 player, PlayerStats stats, class_2487 nbt) {
        if (!nbt.method_10545("abilityKey")) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid ability packet - missing key"), false);
            return;
        }
        String keyStr = nbt.method_10558("abilityKey");
        if (keyStr.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid ability key"), false);
            return;
        }
        char key = keyStr.charAt(0);
        boolean success = SpellAbilityManager.useSpellAbility((class_1657)player, key);
        if (!success) {
            System.err.println("Failed to use spell ability " + key + " for player " + player.method_5477().getString());
        }
    }

    private static void handleSkillNodeUnlock(class_3222 player, PlayerStats stats, class_2487 nbt) {
        if (!nbt.method_10545("unlockNodeId")) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid skill unlock packet"), false);
            return;
        }
        String nodeId = nbt.method_10558("unlockNodeId");
        if (!PlayerStatsUpdatePacket.canUnlockSkillNode(stats, nodeId)) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Cannot unlock skill node: " + nodeId)), false);
            return;
        }
        int skillPointCost = PlayerStatsUpdatePacket.getSkillPointCost(nodeId);
        if (stats.getSkillPoints() < skillPointCost) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not enough skill points!").method_27692(class_124.field_1061), false);
            return;
        }
        if (stats.isSkillNodeUnlocked(nodeId)) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Skill node already unlocked!").method_27692(class_124.field_1054), false);
            return;
        }
        stats.setSkillPoints(stats.getSkillPoints() - skillPointCost, (class_1657)player);
        stats.unlockSkillNode(nodeId, (class_1657)player);
        String nodeName = PlayerStatsUpdatePacket.getSkillNodeDisplayName(nodeId);
        player.method_7353((class_2561)class_2561.method_43470((String)("Unlocked: " + nodeName)).method_27692(class_124.field_1060), false);
        player.method_5783(class_3417.field_15195, 1.0f, 1.2f);
    }

    private static void handleAttributeAllocation(class_3222 player, PlayerStats stats, class_2487 nbt) {
        if (!nbt.method_10545("attribute") || !nbt.method_10545("amount")) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid attribute allocation packet"), false);
            return;
        }
        String attribute = nbt.method_10558("attribute");
        int amount = nbt.method_10550("amount");
        if (stats.getAttributePoints() < amount) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Not enough attribute points!").method_27692(class_124.field_1061), false);
            return;
        }
        switch (attribute.toLowerCase()) {
            case "strength": {
                stats.setStrength(stats.getStrength() + amount, (class_1657)player);
                stats.setAttributePoints(stats.getAttributePoints() - amount, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)("Allocated " + amount + " points to Strength")).method_27692(class_124.field_1060), false);
                break;
            }
            case "agility": {
                stats.setAgility(stats.getAgility() + amount, (class_1657)player);
                stats.setAttributePoints(stats.getAttributePoints() - amount, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)("Allocated " + amount + " points to Agility")).method_27692(class_124.field_1060), false);
                break;
            }
            case "vitality": {
                stats.setVitality(stats.getVitality() + amount, (class_1657)player);
                stats.setAttributePoints(stats.getAttributePoints() - amount, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)("Allocated " + amount + " points to Vitality")).method_27692(class_124.field_1060), false);
                break;
            }
            case "intelligence": {
                stats.setIntelligence(stats.getIntelligence() + amount, (class_1657)player);
                stats.setAttributePoints(stats.getAttributePoints() - amount, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)("Allocated " + amount + " points to Intelligence")).method_27692(class_124.field_1060), false);
                break;
            }
            default: {
                player.method_7353((class_2561)class_2561.method_43470((String)("Invalid attribute: " + attribute)).method_27692(class_124.field_1061), false);
            }
        }
    }

    private static void handleSkillTreeReset(class_3222 player, PlayerStats stats, class_2487 nbt) {
        SkillTreeSystem.resetSkillTreeServer(stats, player);
    }

    private static void handleClassSelection(class_3222 player, PlayerStats stats, class_2487 nbt) {
        if (!nbt.method_10545("className")) {
            player.method_7353((class_2561)class_2561.method_43470((String)"Invalid class selection packet"), false);
            return;
        }
        String className = nbt.method_10558("className");
        try {
            PlayerStats.ClassType classType = PlayerStats.ClassType.valueOf(className.toUpperCase());
            if (stats.hasChosenClass()) {
                player.method_7353((class_2561)class_2561.method_43470((String)"You have already chosen a class!").method_27692(class_124.field_1061), false);
                return;
            }
            stats.setClassType(classType, (class_1657)player);
            stats.setHasChosenClass(true);
            stats.setSkillPoints(stats.getSkillPoints() + 3, (class_1657)player);
            stats.setAbilityUnlocked('z', true, (class_1657)player);
            stats.setAbilityUnlocked('Z', true, (class_1657)player);
            player.method_7353((class_2561)class_2561.method_43470((String)("You have chosen the " + classType.name() + " class!")).method_27692(class_124.field_1065), false);
            player.method_7353((class_2561)class_2561.method_43470((String)stats.getClassLore()).method_27692(class_124.field_1080), false);
            player.method_7353((class_2561)class_2561.method_43470((String)"Your Z ability is now unlocked!").method_27692(class_124.field_1060), false);
            player.method_7353((class_2561)class_2561.method_43470((String)"You received 3 skill points to start your journey!").method_27692(class_124.field_1060), false);
            player.method_5783(class_3417.field_15195, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            player.method_7353((class_2561)class_2561.method_43470((String)("Invalid class: " + className)).method_27692(class_124.field_1061), false);
        }
    }

    private static void handleSecondWindActivation(class_3222 player, PlayerStats stats, class_2487 nbt) {
        if (stats.canActivateSecondWind()) {
            stats.activateSecondWind((class_1657)player);
            player.method_7353((class_2561)class_2561.method_43470((String)"Second Wind activated!").method_27692(class_124.field_1065), false);
            player.method_6092(new class_1293(class_1294.field_5924, 100, 1));
            player.method_6092(new class_1293(class_1294.field_5907, 100, 0));
            player.method_5783(class_3417.field_14931, 1.0f, 1.0f);
        } else {
            int cooldownSeconds = stats.getSecondWindCooldownSeconds();
            if (cooldownSeconds > 0) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Second Wind on cooldown: " + cooldownSeconds + " seconds")).method_27692(class_124.field_1061), false);
            } else {
                player.method_7353((class_2561)class_2561.method_43470((String)"Second Wind conditions not met").method_27692(class_124.field_1061), false);
            }
        }
    }

    private static boolean canUnlockSkillNode(PlayerStats stats, String nodeId) {
        if (stats.isSkillNodeUnlocked(nodeId)) {
            return false;
        }
        int requiredPoints = PlayerStatsUpdatePacket.getSkillPointCost(nodeId);
        return stats.getSkillPoints() >= requiredPoints;
    }

    private static int getSkillPointCost(String nodeId) {
        return switch (nodeId) {
            case "root" -> 0;
            case "combat_start", "survival_start", "utility_start" -> 1;
            case "str1", "hp1", "agi1", "health1", "health2" -> 1;
            case "str2", "def1", "regen1", "mana1", "critical_hit", "damage_reduction" -> 2;
            case "str3", "hp2", "spellPower", "energy_efficiency", "healing_boost" -> 3;
            case "combat_mastery", "magic_resistance", "ability_unlock_c" -> 4;
            case "ability_unlock_x" -> 2;
            case "mining_speed", "move_speed1", "mana_regen1" -> 3;
            case "second_wind" -> 4;
            case "ult_health", "ult_strength", "ult_agility" -> 8;
            case "global_mastery" -> 10;
            default -> 1;
        };
    }

    private static String getSkillNodeDisplayName(String nodeId) {
        return switch (nodeId) {
            case "root" -> "Origin";
            case "combat_start" -> "Blade Initiate";
            case "survival_start" -> "Enduring Soul";
            case "utility_start" -> "Fleet Initiate";
            case "str1" -> "Warrior's Might";
            case "str2" -> "Champion's Power";
            case "str3" -> "Heroic Force";
            case "hp1" -> "Iron Will";
            case "hp2" -> "Titan's Endurance";
            case "agi1" -> "Quickstep";
            case "def1" -> "Stone Skin";
            case "regen1" -> "Regenerative Pulse";
            case "mana1" -> "Arcane Mind";
            case "mining_speed" -> "Excavator";
            case "move_speed1" -> "Sprinter";
            case "mana_regen1" -> "Mana Stream";
            case "second_wind" -> "Second Wind";
            case "critical_hit" -> "Critical Strike";
            case "damage_reduction" -> "Iron Skin";
            case "spell_power" -> "Arcane Mastery";
            case "energy_efficiency" -> "Energy Conservation";
            case "healing_boost" -> "Divine Blessing";
            case "combat_mastery" -> "Weapon Mastery";
            case "magic_resistance" -> "Arcane Ward";
            case "ability_unlock_x" -> "Early Mastery";
            case "ability_unlock_c" -> "Advanced Training";
            case "ult_health" -> "Eternal Vitality";
            case "ult_strength" -> "Overwhelming Force";
            case "ult_agility" -> "Lightning Reflexes";
            case "global_mastery" -> "Transcendence";
            default -> nodeId;
        };
    }

    private static void resetStatsToBase(PlayerStats stats, class_3222 player) {
        stats.setStrength(0, (class_1657)player);
        stats.setAgility(0, (class_1657)player);
        stats.setVitality(0, (class_1657)player);
        stats.setIntelligence(0, (class_1657)player);
        PlayerStats.ClassType currentClass = stats.getClassType();
        stats.setClassType(currentClass, (class_1657)player);
        stats.setAbilityUnlocked('z', true, (class_1657)player);
        stats.setAbilityUnlocked('Z', true, (class_1657)player);
        stats.setAbilityUnlocked('x', false, (class_1657)player);
        stats.setAbilityUnlocked('X', false, (class_1657)player);
        stats.setAbilityUnlocked('c', false, (class_1657)player);
        stats.setAbilityUnlocked('C', false, (class_1657)player);
        stats.setAbilityUnlocked('v', false, (class_1657)player);
        stats.setAbilityUnlocked('V', false, (class_1657)player);
        if (stats.getLevel() >= 5) {
            stats.setAbilityUnlocked('x', true, (class_1657)player);
            stats.setAbilityUnlocked('X', true, (class_1657)player);
        }
        if (stats.getLevel() >= 10) {
            stats.setAbilityUnlocked('c', true, (class_1657)player);
            stats.setAbilityUnlocked('C', true, (class_1657)player);
        }
        if (stats.getLevel() >= 15) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
        }
    }

    private static void handleAbilityLevelUp(class_3222 player, PlayerStats stats, class_2487 nbt) {
        int newLevel = stats.getLevel();
        boolean anyUnlocked = false;
        if (newLevel >= 1 && !stats.isAbilityUnlocked('z')) {
            stats.setAbilityUnlocked('z', true, (class_1657)player);
            stats.setAbilityUnlocked('Z', true, (class_1657)player);
            player.method_7353((class_2561)class_2561.method_43470((String)"Ability Z unlocked!").method_27692(class_124.field_1060), false);
            anyUnlocked = true;
        }
        if (newLevel >= 5 && !stats.isAbilityUnlocked('x')) {
            if (stats.isSkillNodeUnlocked("ability_unlock_x") && newLevel >= 3) {
                stats.setAbilityUnlocked('x', true, (class_1657)player);
                stats.setAbilityUnlocked('X', true, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)"Early Unlock: Ability X unlocked!").method_27692(class_124.field_1060), false);
                anyUnlocked = true;
            } else if (newLevel >= 5) {
                stats.setAbilityUnlocked('x', true, (class_1657)player);
                stats.setAbilityUnlocked('X', true, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)"Ability X unlocked!").method_27692(class_124.field_1060), false);
                anyUnlocked = true;
            }
        }
        if (newLevel >= 10 && !stats.isAbilityUnlocked('c')) {
            if (stats.isSkillNodeUnlocked("ability_unlock_c") && newLevel >= 7) {
                stats.setAbilityUnlocked('c', true, (class_1657)player);
                stats.setAbilityUnlocked('C', true, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)"Early Unlock: Ability C unlocked!").method_27692(class_124.field_1060), false);
                anyUnlocked = true;
            } else if (newLevel >= 10) {
                stats.setAbilityUnlocked('c', true, (class_1657)player);
                stats.setAbilityUnlocked('C', true, (class_1657)player);
                player.method_7353((class_2561)class_2561.method_43470((String)"Ability C unlocked!").method_27692(class_124.field_1060), false);
                anyUnlocked = true;
            }
        }
        if (newLevel >= 15 && !stats.isAbilityUnlocked('v')) {
            stats.setAbilityUnlocked('v', true, (class_1657)player);
            stats.setAbilityUnlocked('V', true, (class_1657)player);
            player.method_7353((class_2561)class_2561.method_43470((String)"Ability V unlocked!").method_27692(class_124.field_1060), false);
            anyUnlocked = true;
        }
        if (anyUnlocked) {
            player.method_5783(class_3417.field_15195, 1.0f, 1.2f);
            PlayerStatsUpdatePacket.showPlayerAbilities(player, stats);
        }
    }

    private static void showPlayerAbilities(class_3222 player, PlayerStats stats) {
        player.method_7353((class_2561)class_2561.method_43470((String)"=== Your Abilities ===").method_27692(class_124.field_1065), false);
        SpellSystem.SpellType[] spells = SpellSystem.getClassSpells(stats.getClassType());
        char[] keys = new char[]{'Z', 'X', 'C', 'V'};
        for (int i = 0; i < Math.min(spells.length, keys.length); ++i) {
            char key = keys[i];
            SpellSystem.SpellType spell = spells[i];
            if (stats.isAbilityUnlocked(key)) {
                player.method_7353((class_2561)class_2561.method_43470((String)String.format("  %c: %s", Character.valueOf(key), spell.getDisplayName())).method_27692(class_124.field_1060), false);
                continue;
            }
            int reqLevel = switch (i) {
                case 0 -> 1;
                case 1 -> 5;
                case 2 -> 10;
                case 3 -> 15;
                default -> 999;
            };
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("  %c: %s (Level %d)", Character.valueOf(key), spell.getDisplayName(), reqLevel)).method_27692(class_124.field_1080), false);
        }
    }

    public static void sendSkillUnlock(String nodeId) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("unlockNodeId", nodeId);
        PlayerStatsUpdatePacket.sendToServer("unlock_skill_node", nbt);
    }

    public static void sendAttributeAllocation(String attribute, int amount) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("attribute", attribute);
        nbt.method_10569("amount", amount);
        PlayerStatsUpdatePacket.sendToServer("allocate_attribute_point", nbt);
    }

    public static void sendClassSelection(String className) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("className", className);
        PlayerStatsUpdatePacket.sendToServer("select_class", nbt);
    }

    public static void sendSkillTreeReset() {
        class_2487 nbt = new class_2487();
        PlayerStatsUpdatePacket.sendToServer("reset_skill_tree", nbt);
    }

    public static void sendSecondWindActivation() {
        class_2487 nbt = new class_2487();
        PlayerStatsUpdatePacket.sendToServer("use_second_wind", nbt);
    }

    public static void sendSpellAbility(char key) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("abilityKey", String.valueOf(key));
        PlayerStatsUpdatePacket.sendToServer("use_spell_ability", nbt);
    }
}

