/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.blocks.screen_handler;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.river_quinn.init.ModScreensHandler;
import com.river_quinn.utils.EnchantmentUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EnchantingCustomScreenHandler
extends class_1703 {
    public static final int ENCHANTED_BOOK_SLOT_ROW_COUNT = 4;
    public static final int ENCHANTED_BOOK_SLOT_COLUMN_COUNT = 6;
    public static final int ENCHANTED_BOOK_SLOT_SIZE = 24;
    public static final int ENCHANTMENT_CUSTOM_TABLE_SLOT_SIZE = 26;
    public final class_1277 containerInventory = new class_1277(26);
    private static final Logger LOGGER = LogUtils.getLogger();
    public final class_1657 player;
    public final class_1661 playerInventory;
    public final class_1937 world;
    public int posX;
    public int posY;
    public int posZ;
    public final Map<Integer, class_1735> enchantedBookSlots = new HashMap<Integer, class_1735>();
    public int currentPage = 0;
    public int totalPage = 0;
    private final List<class_1799> enchantmentsOnCurrentTool = new ArrayList<class_1799>();

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        class_1799 itemStackToPut = this.method_34255();
        if (slotIndex >= 2 && slotIndex < 26 && actionType != class_1713.field_7794 && (itemStackToPut.method_7960() || this.method_7611(slotIndex).method_7680(this.method_34255()))) {
            class_1799 itemStackToReplace = this.containerInventory.method_5438(slotIndex);
            if (!itemStackToPut.method_7960() && !itemStackToReplace.method_7960()) {
                List<class_1889> enchantmentsOnNewStack = this.getEnchantmentInstanceFromEnchantedBook(itemStackToPut);
                class_1889 enchantmentOnOldStack = this.getEnchantmentInstanceFromEnchantedBook(itemStackToReplace).get(0);
                boolean hasDuplicateEnchantment = enchantmentsOnNewStack.stream().anyMatch(enchantment -> enchantment.field_9093.equals((Object)enchantmentOnOldStack.field_9093));
                if (hasDuplicateEnchantment) {
                    this.addEnchantment(itemStackToPut, slotIndex, true);
                    this.method_34254(class_1799.field_8037.method_7972());
                    return;
                }
            }
            int enchantmentIndexInCache = slotIndex - 2 + this.currentPage * 24;
            if (!itemStackToReplace.method_7960()) {
                this.method_34254(itemStackToReplace.method_7972());
                boolean hasRegenerated = this.removeEnchantment(itemStackToReplace);
                if (!hasRegenerated) {
                    this.enchantmentsOnCurrentTool.set(enchantmentIndexInCache, class_1799.field_8037);
                }
            } else {
                this.method_34254(class_1799.field_8037.method_7972());
            }
            if (!itemStackToPut.method_7960()) {
                this.addEnchantment(itemStackToPut, slotIndex);
            }
            this.updateEnchantedBookSlots();
        } else {
            super.method_7593(slotIndex, button, actionType, player);
        }
    }

    public EnchantingCustomScreenHandler(int syncId, class_1661 inventory) {
        super(ModScreensHandler.ENCHANTING_CUSTOM_SCREEN_HANDLER, syncId);
        int si;
        this.player = inventory.field_7546;
        this.playerInventory = inventory;
        this.world = this.player.method_37908();
        this.posX = this.player.method_24515().method_10263();
        this.posY = this.player.method_24515().method_10264();
        this.posZ = this.player.method_24515().method_10260();
        this.method_7621(new class_1735((class_1263)this.containerInventory, 0, 8, 8){

            public void method_7670(class_1799 newStack, class_1799 oldStack) {
                super.method_7670(newStack, oldStack);
                EnchantingCustomScreenHandler.this.clearCache();
                EnchantingCustomScreenHandler.this.clearPage();
            }

            public void method_48931(class_1799 newStack, class_1799 oldStack) {
                super.method_48931(newStack, oldStack);
                if (!newStack.method_7960()) {
                    EnchantingCustomScreenHandler.this.genEnchantedBookCache();
                    EnchantingCustomScreenHandler.this.currentPage = 0;
                    EnchantingCustomScreenHandler.this.updateEnchantedBookSlots();
                } else {
                    EnchantingCustomScreenHandler.this.clearCache();
                    EnchantingCustomScreenHandler.this.clearPage();
                }
            }
        });
        this.method_7621(new class_1735((class_1263)this.containerInventory, 1, 42, 8){
            private final int slot = 1;
            {
                this.slot = 1;
            }

            public boolean method_7680(class_1799 stack) {
                return class_1802.field_8598 == stack.method_7909() && !EnchantingCustomScreenHandler.this.containerInventory.method_5438(0).method_7960();
            }

            @Nullable
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_2960.method_12829((String)"enchantment_custom_table:item/empty_slot_book"));
            }

            public void method_48931(class_1799 newStack, class_1799 oldStack) {
                super.method_48931(newStack, oldStack);
                if (!newStack.method_7960()) {
                    EnchantingCustomScreenHandler.this.addEnchantment(newStack, 1, true);
                } else {
                    LOGGER.warn("stack 1, setByPlayer() called with newStack.isEmpty()");
                }
            }
        });
        int enchanted_book_index = 0;
        for (int row = 0; row < 4; ++row) {
            int yPos = 8 + row * 18;
            for (int col = 0; col < 6; ++col) {
                int xPos = 61 + col * 18;
                final int final_enchanted_book_index = enchanted_book_index++;
                this.enchantedBookSlots.put(final_enchanted_book_index, this.method_7621(new class_1735(this, (class_1263)this.containerInventory, final_enchanted_book_index + 2, xPos, yPos){
                    private final int slot;
                    final /* synthetic */ EnchantingCustomScreenHandler this$0;
                    {
                        this.this$0 = this$0;
                        super(inventory, index, x, y);
                        this.slot = final_enchanted_book_index + 2;
                    }

                    public boolean method_7680(class_1799 stack) {
                        return class_1802.field_8598 == stack.method_7909() && !this.this$0.containerInventory.method_5438(0).method_7960();
                    }

                    @Nullable
                    public Pair<class_2960, class_2960> method_7679() {
                        return Pair.of((Object)class_1723.field_21668, (Object)class_2960.method_12829((String)"enchantment_custom_table:item/empty_slot_book"));
                    }
                }));
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.method_7621(new class_1735((class_1263)this.playerInventory, si, 8 + si * 18, 142));
        }
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = this.method_7611(slotIndex);
        class_1799 itemStackToOperate = slot.method_7677().method_7972();
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotIndex < 26) {
                if (!this.method_7616(itemstack1, 26, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (!this.method_7616(itemstack1, 0, 26, false)) {
                if (slotIndex < 53 ? !this.method_7616(itemstack1, 53, this.field_7761.size(), true) : !this.method_7616(itemstack1, 26, 53, false)) {
                    return class_1799.field_8037;
                }
                return class_1799.field_8037;
            }
            if (itemstack1.method_7947() == 0) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
        }
        if (slotIndex > 1 && slotIndex < 26) {
            this.removeEnchantment(itemStackToOperate);
        }
        return itemstack;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    protected boolean method_7616(class_1799 targetItemStack, int startIndex, int endIndex, boolean fromLast) {
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (targetItemStack.method_7946()) {
            while (!targetItemStack.method_7960() && (fromLast ? i >= startIndex : i < endIndex)) {
                class_1799 itemstack;
                class_1735 slot = this.method_7611(i);
                if (slot.method_7680(itemstack = slot.method_7677()) && !itemstack.method_7960() && class_1799.method_31577((class_1799)targetItemStack, (class_1799)itemstack)) {
                    int k;
                    int j = itemstack.method_7947() + targetItemStack.method_7947();
                    if (j <= (k = slot.method_7676(itemstack))) {
                        targetItemStack.method_7939(0);
                        itemstack.method_7939(j);
                        slot.method_53512(itemstack);
                        flag = true;
                    } else if (itemstack.method_7947() < k) {
                        targetItemStack.method_7934(k - itemstack.method_7947());
                        itemstack.method_7939(k);
                        slot.method_53512(itemstack);
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!targetItemStack.method_7960()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (fromLast ? i >= startIndex : i < endIndex) {
                class_1735 slot1 = this.method_7611(i);
                class_1799 itemstack1 = slot1.method_7677();
                if (itemstack1.method_7960() && slot1.method_7680(targetItemStack)) {
                    int l = slot1.method_7676(targetItemStack);
                    slot1.method_53512(targetItemStack.method_7971(Math.min(targetItemStack.method_7947(), l)));
                    slot1.method_7668();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (player instanceof class_3222) {
            player.method_31548().method_7398(this.containerInventory.method_5438(0));
        }
    }

    public List<class_1889> getEnchantmentInstanceFromEnchantedBook(class_1799 enchantedBookItemStack) {
        class_9331<class_9304> componentType = EnchantmentUtils.getEnchantmentsComponentType(enchantedBookItemStack);
        class_9304 componentMap = (class_9304)enchantedBookItemStack.method_57353().method_57829(componentType);
        ArrayList<class_1889> enchantmentOfBook = new ArrayList<class_1889>();
        for (Object2IntMap.Entry entry : componentMap.method_57539()) {
            class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
            int enchantmentLevel = entry.getIntValue();
            enchantmentOfBook.add(new class_1889(class_6880.method_40223((Object)enchantment), enchantmentLevel));
        }
        return enchantmentOfBook;
    }

    public boolean checkCanPlaceEnchantedBook(class_1799 stack) {
        class_9304 itemEnchantments = (class_9304)stack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(stack));
        class_1799 itemToEnchant = this.containerInventory.method_5438(0);
        class_9304 itemEnchantmentsOnTool = (class_9304)itemToEnchant.method_57824(EnchantmentUtils.getEnchantmentsComponentType(itemToEnchant));
        if (itemEnchantmentsOnTool == null) {
            return true;
        }
        for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
            int maxLevel;
            class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
            int enchantmentLevel = entry.getIntValue();
            int enchantmentLevelOnTool = itemEnchantmentsOnTool.method_57536((class_6880)entry.getKey());
            if (enchantmentLevelOnTool + enchantmentLevel <= (maxLevel = enchantment.method_8183())) continue;
            return false;
        }
        return true;
    }

    public void exportAllEnchantments() {
        class_1799 toolItemStack = this.containerInventory.method_5438(0);
        class_9304 itemEnchantments = (class_9304)toolItemStack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack));
        if (toolItemStack.method_7909() == class_1802.field_8598) {
            this.playerInventory.method_7398(toolItemStack);
            this.containerInventory.method_5447(0, class_1799.field_8037);
            this.world.method_8396(null, this.player.method_24515(), class_3417.field_15119, class_3419.field_15245, 1.0f, 1.0f);
        } else if (!toolItemStack.method_7960() && itemEnchantments != null && !itemEnchantments.method_57543()) {
            class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
            class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598);
            for (Object2IntMap.Entry entry : itemEnchantments.method_57539()) {
                class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
                int enchantmentLevel = entry.getIntValue();
                class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                assert (enchantmentReference != null);
                mutable.method_57547(enchantmentReference, 0);
                enchantedBook.method_7978(enchantmentReference, enchantmentLevel);
            }
            toolItemStack.method_57379(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack), (Object)mutable.method_57549());
            this.playerInventory.method_7398(enchantedBook);
            this.world.method_8396(null, this.player.method_24515(), class_3417.field_15119, class_3419.field_15245, 1.0f, 1.0f);
        }
        this.clearCache();
        this.clearPage();
    }

    public void resetPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void nextPage() {
        if (this.currentPage < this.totalPage - 1) {
            this.turnPage(this.currentPage + 1);
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            this.turnPage(this.currentPage - 1);
        }
    }

    public void turnPage(int targetPage) {
        if (targetPage < 0 || targetPage >= this.totalPage) {
            return;
        }
        int indexOffset = this.currentPage * 24;
        for (int i = 0; i < 24; ++i) {
            int indexOfFullList = i + indexOffset;
            int indexOfSlot = i + 2;
            if (indexOfFullList >= this.enchantmentsOnCurrentTool.size()) continue;
            this.enchantmentsOnCurrentTool.set(indexOfFullList, this.containerInventory.method_5438(indexOfSlot));
        }
        this.currentPage = targetPage;
        this.updateEnchantedBookSlots();
    }

    public void updateEnchantedBookSlots() {
        this.containerInventory.method_5447(1, class_1799.field_8037.method_7972());
        int indexOffset = this.currentPage * 24;
        if (this.totalPage > 0) {
            for (int i = 0; i < 24; ++i) {
                int indexOfFullList = i + indexOffset;
                int indexOfSlot = i + 2;
                this.containerInventory.method_5447(indexOfSlot, this.enchantmentsOnCurrentTool.get(indexOfFullList));
            }
        }
    }

    public void clearCache() {
        for (int i = 2; i < 26; ++i) {
            this.containerInventory.method_5447(i, class_1799.field_8037);
        }
        this.genEnchantedBookCache();
    }

    public void clearPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void genEnchantedBookCache() {
        class_1799 toolItemStack = this.containerInventory.method_5438(0);
        int currentTotalPage = 1;
        this.enchantmentsOnCurrentTool.clear();
        if (!toolItemStack.method_7960()) {
            class_9304 enchantments = (class_9304)toolItemStack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack));
            currentTotalPage = Math.max((int)Math.ceil((double)enchantments.method_57539().size() / 24.0), 1);
            if (toolItemStack.method_31574(class_1802.field_8598) && enchantments.method_57539().size() == 1) {
                Object2IntMap.Entry enchantmentObj = (Object2IntMap.Entry)enchantments.method_57539().iterator().next();
                class_1887 enchantment = (class_1887)((class_6880)enchantmentObj.getKey()).comp_349();
                int enchantmentLevel = enchantmentObj.getIntValue();
                if (enchantmentLevel > 1) {
                    ArrayList<Integer> enchantmentLevelList = new ArrayList<Integer>();
                    while (enchantmentLevel > 0) {
                        if (enchantmentLevel == 2) {
                            enchantmentLevelList.add(1);
                            enchantmentLevel = 0;
                            continue;
                        }
                        int levelToAdd = (int)Math.ceil((double)enchantmentLevel / 2.0);
                        enchantmentLevelList.add(levelToAdd);
                        enchantmentLevel -= levelToAdd;
                    }
                    for (Integer level : enchantmentLevelList) {
                        class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598);
                        class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                        assert (enchantmentReference != null);
                        enchantedBook.method_7978(enchantmentReference, level.intValue());
                        this.enchantmentsOnCurrentTool.add(enchantedBook);
                    }
                }
            } else if (!toolItemStack.method_31574(class_1802.field_8598) || enchantments.method_57539().size() > 1) {
                for (Object2IntMap.Entry entry : enchantments.method_57539()) {
                    class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
                    Integer enchantmentLevel = entry.getValue();
                    class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598);
                    class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                    assert (enchantmentReference != null);
                    enchantedBook.method_7978(enchantmentReference, enchantmentLevel.intValue());
                    this.enchantmentsOnCurrentTool.add(enchantedBook);
                }
            }
        } else {
            currentTotalPage = 0;
        }
        int totalSlots = currentTotalPage * 24;
        while (this.enchantmentsOnCurrentTool.size() < totalSlots) {
            this.enchantmentsOnCurrentTool.add(class_1799.field_8037);
        }
        this.totalPage = currentTotalPage;
    }

    public class_2359<class_6880<class_1887>> getAllRegisteredEnchantments() {
        class_2378 fullEnchantmentList = this.world.method_30349().method_30530(class_7924.field_41265);
        return fullEnchantmentList.method_40295();
    }

    public void addEnchantment(class_1799 itemStack, int slotIndex) {
        this.addEnchantment(itemStack, slotIndex, false);
    }

    public void addEnchantment(class_1799 itemStackToPut, int slotIndex, boolean forceRegenerateEnchantedBookStore) {
        List<class_1889> enchantmentInstances = this.getEnchantmentInstanceFromEnchantedBook(itemStackToPut);
        boolean regenerateEnchantedBookStore = false;
        class_1799 toolItemStack = this.containerInventory.method_5438(0);
        class_9304 enchantmentsOnTool = (class_9304)toolItemStack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack));
        int sourceEnchantmentCount = enchantmentsOnTool.method_57539().size();
        class_2359<class_6880<class_1887>> allRegisteredEnchantments = this.getAllRegisteredEnchantments();
        HashMap<Integer, class_1889> resultEnchantmentMap = new HashMap<Integer, class_1889>();
        for (Object2IntMap.Entry entry : enchantmentsOnTool.method_57539()) {
            class_1887 enchantment = (class_1887)((class_6880)entry.getKey()).comp_349();
            int enchantmentId = allRegisteredEnchantments.method_10206((Object)class_6880.method_40223((Object)enchantment));
            int enchantmentLevel = entry.getIntValue();
            class_1889 enchantmentInstance = new class_1889(class_6880.method_40223((Object)enchantment), enchantmentLevel);
            resultEnchantmentMap.put(enchantmentId, enchantmentInstance);
        }
        for (class_1889 enchantmentInstance : enchantmentInstances) {
            int enchantmentId = allRegisteredEnchantments.method_10206((Object)enchantmentInstance.field_9093);
            if (resultEnchantmentMap.containsKey(enchantmentId)) {
                regenerateEnchantedBookStore = true;
                resultEnchantmentMap.put(enchantmentId, new class_1889(enchantmentInstance.field_9093, ((class_1889)resultEnchantmentMap.get((Object)Integer.valueOf((int)enchantmentId))).field_9094 + enchantmentInstance.field_9094));
                continue;
            }
            resultEnchantmentMap.put(enchantmentId, new class_1889(enchantmentInstance.field_9093, enchantmentInstance.field_9094));
        }
        int resultEnchantmentsCount = resultEnchantmentMap.size();
        class_9304 itemEnchantments = (class_9304)toolItemStack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack));
        class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
        for (class_1889 enchantmentInstance : resultEnchantmentMap.values().stream().toList()) {
            class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, (class_1887)enchantmentInstance.field_9093.comp_349());
            assert (enchantmentReference != null);
            mutable.method_57547(enchantmentReference, enchantmentInstance.field_9094);
        }
        toolItemStack.method_57379(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack), (Object)mutable.method_57549());
        this.genEnchantedBookCache();
        this.updateEnchantedBookSlots();
        this.world.method_8396(null, this.player.method_24515(), class_3417.field_15119, class_3419.field_15245, 1.0f, 1.0f);
    }

    public boolean removeEnchantment(class_1799 itemStackToRemove) {
        List<class_1889> enchantmentInstances = this.getEnchantmentInstanceFromEnchantedBook(itemStackToRemove);
        class_1799 toolItemStack = this.containerInventory.method_5438(0);
        class_9304 itemEnchantments = (class_9304)toolItemStack.method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack));
        class_9304.class_9305 mutable = new class_9304.class_9305(itemEnchantments);
        for (class_1889 enchantmentInstance : enchantmentInstances) {
            class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, (class_1887)enchantmentInstance.field_9093.comp_349());
            int enchantmentLevelSource = ((class_9304)this.containerInventory.method_5438(0).method_57824(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack))).method_57539().stream().filter(entry -> ((class_5321)enchantmentReference.method_40230().get()).method_58273() == ((class_5321)((class_6880)entry.getKey()).method_40230().get()).method_58273()).findFirst().get().getIntValue();
            int enchantmentLevelToMinus = enchantmentInstance.field_9094;
            assert (enchantmentReference != null);
            mutable.method_57547(enchantmentReference, enchantmentLevelSource - enchantmentLevelToMinus);
        }
        toolItemStack.method_57379(EnchantmentUtils.getEnchantmentsComponentType(toolItemStack), (Object)mutable.method_57549());
        int resultPageSize = Math.max((int)Math.ceil((double)mutable.method_57545().size() / 24.0), 1);
        boolean hasRegenerated = false;
        if (toolItemStack.method_31574(class_1802.field_8598) && mutable.method_57545().size() == 1 || this.totalPage != resultPageSize) {
            this.genEnchantedBookCache();
            this.currentPage = Math.min(this.currentPage, this.totalPage - 1);
            hasRegenerated = true;
        }
        this.updateEnchantedBookSlots();
        this.world.method_8396(null, this.player.method_24515(), class_3417.field_15119, class_3419.field_15245, 1.0f, 1.0f);
        return hasRegenerated;
    }

    public void initMenu() {
        this.clearPage();
        this.clearCache();
        this.enchantmentsOnCurrentTool.clear();
    }
}

