/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.blocks.screen_handler;

import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.river_quinn.init.ModScreensHandler;
import com.river_quinn.utils.EnchantmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EnchantmentConversionScreenHandler
extends class_1703 {
    public static final int ENCHANTED_BOOK_SLOT_ROW_COUNT = 4;
    public static final int ENCHANTED_BOOK_SLOT_COLUMN_COUNT = 7;
    public static final int ENCHANTED_BOOK_SLOT_SIZE = 28;
    public static final int ENCHANTMENT_CONVERSION_SLOT_SIZE = 30;
    public static final int MINIMUM_EMERALD_COST = 36;
    public static final int MINIMUM_EMERALD_BLOCK_COST = 4;
    public final class_1277 containerInventory = new class_1277(30);
    private static final Logger LOGGER = LogUtils.getLogger();
    public final class_1657 player;
    public final class_1661 playerInventory;
    public final class_1937 world;
    public int posX;
    public int posY;
    public int posZ;
    public final Map<Integer, class_1735> enchantedBookSlots = new HashMap<Integer, class_1735>();
    public static final List<Integer> allEnchantments = new ArrayList<Integer>();
    public int currentPage = 0;
    public int totalPage = 0;

    public EnchantmentConversionScreenHandler(int syncId, class_1661 inventory) {
        super(ModScreensHandler.ENCHANTMENT_CONVERSION_SCREEN_HANDLER, syncId);
        int si;
        this.player = inventory.field_7546;
        this.playerInventory = inventory;
        this.world = this.player.method_37908();
        this.posX = this.player.method_24515().method_10263();
        this.posY = this.player.method_24515().method_10264();
        this.posZ = this.player.method_24515().method_10260();
        this.method_7621(new class_1735((class_1263)this.containerInventory, 0, 16, 8){

            public boolean method_7680(class_1799 stack) {
                return class_1802.field_8529 == stack.method_7909();
            }

            public void method_48931(class_1799 newStack, class_1799 oldStack) {
                super.method_48931(newStack, oldStack);
                if (!newStack.method_7960() && !oldStack.method_7960()) {
                    EnchantmentConversionScreenHandler.this.genEnchantedBookSlot();
                } else {
                    EnchantmentConversionScreenHandler.this.regenerateEnchantedBookSlot();
                }
            }

            @Nullable
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_2960.method_12829((String)"enchantment_custom_table:item/empty_slot_book"));
            }
        });
        this.method_7621(new class_1735((class_1263)this.containerInventory, 1, 16, 26){

            public boolean method_7680(class_1799 stack) {
                return class_1802.field_8687 == stack.method_7909() || class_1802.field_8733 == stack.method_7909();
            }

            public void method_48931(class_1799 newStack, class_1799 oldStack) {
                super.method_48931(newStack, oldStack);
                if (!newStack.method_7960() && !oldStack.method_7960()) {
                    EnchantmentConversionScreenHandler.this.genEnchantedBookSlot();
                } else {
                    EnchantmentConversionScreenHandler.this.regenerateEnchantedBookSlot();
                }
            }

            @Nullable
            public Pair<class_2960, class_2960> method_7679() {
                return Pair.of((Object)class_1723.field_21668, (Object)class_2960.method_12829((String)"minecraft:item/empty_slot_emerald"));
            }
        });
        int enchanted_book_index = 0;
        for (int row = 0; row < 4; ++row) {
            int yPos = 8 + row * 18;
            for (int col = 0; col < 7; ++col) {
                int xPos = 43 + col * 18;
                final int final_enchanted_book_index = enchanted_book_index++;
                this.enchantedBookSlots.put(final_enchanted_book_index, this.method_7621(new class_1735(this, (class_1263)this.containerInventory, final_enchanted_book_index + 2, xPos, yPos){
                    private final int slot;
                    final /* synthetic */ EnchantmentConversionScreenHandler this$0;
                    {
                        this.this$0 = this$0;
                        super(inventory, index, x, y);
                        this.slot = final_enchanted_book_index + 2;
                    }

                    public boolean method_7680(class_1799 stack) {
                        return false;
                    }

                    @Nullable
                    public Pair<class_2960, class_2960> method_7679() {
                        return Pair.of((Object)class_1723.field_21668, (Object)class_2960.method_12829((String)"enchantment_custom_table:item/empty_slot_book"));
                    }

                    public void method_48931(class_1799 newStack, class_1799 oldStack) {
                        super.method_48931(newStack, oldStack);
                        this.this$0.pickEnchantedBook();
                    }
                }));
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.method_7621(new class_1735((class_1263)this.playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.method_7621(new class_1735((class_1263)this.playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public class_1799 method_7601(class_1657 player, int slotIndex) {
        class_1799 itemstack = class_1799.field_8037;
        class_1735 slot = this.method_7611(slotIndex);
        class_1799 itemStackToOperate = slot.method_7677().method_7972();
        if (slot != null && slot.method_7681()) {
            class_1799 itemstack1 = slot.method_7677();
            itemstack = itemstack1.method_7972();
            if (slotIndex < 30) {
                if (!this.method_7616(itemstack1, 30, this.field_7761.size(), true)) {
                    return class_1799.field_8037;
                }
                slot.method_7670(itemstack1, itemstack);
            } else if (!this.method_7616(itemstack1, 0, 30, false)) {
                if (slotIndex < 57 ? !this.method_7616(itemstack1, 57, this.field_7761.size(), true) : !this.method_7616(itemstack1, 30, 57, false)) {
                    return class_1799.field_8037;
                }
                return class_1799.field_8037;
            }
            if (itemstack1.method_7947() == 0) {
                slot.method_53512(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (itemstack1.method_7947() == itemstack.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, itemstack1);
        }
        if (slotIndex < 2) {
            this.genEnchantedBookSlot();
        } else if (slotIndex < 30) {
            this.pickEnchantedBook();
        }
        return itemstack;
    }

    protected boolean method_7616(class_1799 targetItemStack, int startIndex, int endIndex, boolean fromLast) {
        boolean flag = false;
        int i = startIndex;
        if (fromLast) {
            i = endIndex - 1;
        }
        if (targetItemStack.method_7946()) {
            while (!targetItemStack.method_7960() && (fromLast ? i >= startIndex : i < endIndex)) {
                class_1799 itemstack;
                class_1735 slot = this.method_7611(i);
                if (slot.method_7680(itemstack = slot.method_7677()) && !itemstack.method_7960() && class_1799.method_31577((class_1799)targetItemStack, (class_1799)itemstack)) {
                    int k;
                    int j = itemstack.method_7947() + targetItemStack.method_7947();
                    if (j <= (k = slot.method_7676(itemstack))) {
                        targetItemStack.method_7939(0);
                        itemstack.method_7939(j);
                        slot.method_53512(itemstack);
                        flag = true;
                    } else if (itemstack.method_7947() < k) {
                        targetItemStack.method_7934(k - itemstack.method_7947());
                        itemstack.method_7939(k);
                        slot.method_53512(itemstack);
                        flag = true;
                    }
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!targetItemStack.method_7960()) {
            i = fromLast ? endIndex - 1 : startIndex;
            while (fromLast ? i >= startIndex : i < endIndex) {
                class_1735 slot1 = this.method_7611(i);
                class_1799 itemstack1 = slot1.method_7677();
                if (itemstack1.method_7960() && slot1.method_7680(targetItemStack)) {
                    int l = slot1.method_7676(targetItemStack);
                    slot1.method_53512(targetItemStack.method_7971(Math.min(targetItemStack.method_7947(), l)));
                    slot1.method_7668();
                    flag = true;
                    break;
                }
                if (fromLast) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (player instanceof class_3222) {
            player.method_31548().method_7398(this.containerInventory.method_5438(0));
            player.method_31548().method_7398(this.containerInventory.method_5438(1));
        }
    }

    public void tryGetAllEnchantments() {
        if (allEnchantments.isEmpty()) {
            class_2378 fullEnchantmentList = this.world.method_30349().method_30530(class_7924.field_41265);
            class_2359 allRegisteredEnchantments = fullEnchantmentList.method_40295();
            allRegisteredEnchantments.forEach(enchantment -> allEnchantments.add(fullEnchantmentList.method_10206((Object)((class_1887)enchantment.comp_349()))));
        }
    }

    public class_1799 getEnchantedBook(int enchantmentId) {
        class_1799 enchantedBook = new class_1799((class_1935)class_1802.field_8598);
        class_1887 enchantment = (class_1887)this.world.method_30349().method_30530(class_7924.field_41265).method_10200(enchantmentId);
        int enchantmentLevel = enchantment.method_8183();
        class_6880.class_6883<class_1887> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
        assert (enchantmentReference != null);
        enchantedBook.method_7978(enchantmentReference, enchantmentLevel);
        return enchantedBook;
    }

    public void nextPage() {
        if (this.currentPage < this.totalPage - 1) {
            this.turnPage(this.currentPage + 1);
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            this.turnPage(this.currentPage - 1);
        }
    }

    public void turnPage(int page) {
        this.currentPage = page;
        this.clearEnchantedBookSlot();
        this.genEnchantedBookSlot();
    }

    public void resetPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void clearEnchantedBookSlot() {
        for (int i = 2; i < 30; ++i) {
            this.containerInventory.method_5447(i, class_1799.field_8037);
        }
    }

    public void genEnchantedBookSlot() {
        this.tryGetAllEnchantments();
        boolean hasBook = this.containerInventory.method_5438(0).method_31574(class_1802.field_8529);
        boolean hasEnoughEmerald = false;
        if (this.containerInventory.method_5438(1).method_31574(class_1802.field_8687)) {
            hasEnoughEmerald = this.containerInventory.method_5438(1).method_7947() >= 36;
        } else if (this.containerInventory.method_5438(1).method_31574(class_1802.field_8733)) {
            boolean bl = hasEnoughEmerald = this.containerInventory.method_5438(1).method_7947() >= 4;
        }
        if (!hasBook || !hasEnoughEmerald) {
            this.resetPage();
            this.clearEnchantedBookSlot();
            return;
        }
        for (int i = 0; i < 28; ++i) {
            int slotIndex = i + 2;
            int enchantmentIndex = i + this.currentPage * 28;
            if (enchantmentIndex < allEnchantments.size()) {
                if (!this.containerInventory.method_5438(slotIndex).method_7960()) continue;
                int enchantmentId = allEnchantments.get(enchantmentIndex);
                this.containerInventory.method_5447(slotIndex, this.getEnchantedBook(enchantmentId));
                continue;
            }
            this.containerInventory.method_5447(slotIndex, class_1799.field_8037);
        }
    }

    public void regenerateEnchantedBookSlot() {
        this.currentPage = 0;
        this.totalPage = (int)Math.ceil((double)allEnchantments.size() / 28.0);
        this.genEnchantedBookSlot();
    }

    public void pickEnchantedBook() {
        this.containerInventory.method_5438(0).method_7934(1);
        if (this.containerInventory.method_5438(1).method_31574(class_1802.field_8687)) {
            this.containerInventory.method_5438(1).method_7934(36);
        } else if (this.containerInventory.method_5438(1).method_31574(class_1802.field_8733)) {
            this.containerInventory.method_5438(1).method_7934(4);
        }
        this.genEnchantedBookSlot();
    }
}

