/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.block;

import com.mojang.serialization.MapCodec;
import com.river_quinn.enchantment_custom_table.block.EnchantingTableLikeBlock;
import com.river_quinn.enchantment_custom_table.block.entity.EnchantmentConversionTableBlockEntity;
import com.river_quinn.enchantment_custom_table.world.inventory.EnchantmentConversionMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class EnchantmentConversionTableBlock
extends EnchantingTableLikeBlock {
    public static final MapCodec<EnchantmentConversionTableBlock> CODEC = EnchantmentConversionTableBlock.simpleCodec(EnchantmentConversionTableBlock::new);

    public EnchantmentConversionTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public EnchantmentConversionTableBlock(ResourceLocation registryName) {
        super(registryName);
    }

    protected MapCodec<? extends EnchantmentConversionTableBlock> codec() {
        return CODEC;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EnchantmentConversionTableBlockEntity(blockPos, blockState);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player entity, BlockHitResult result) {
        super.useWithoutItem(state, level, pos, entity, result);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Enchantment Conversion Table Block");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new EnchantmentConversionMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }
}

