/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.world.inventory;

import com.river_quinn.enchantment_custom_table.Config;
import com.river_quinn.enchantment_custom_table.block.entity.EnchantmentConversionTableBlockEntity;
import com.river_quinn.enchantment_custom_table.init.ModMenus;
import com.river_quinn.enchantment_custom_table.utils.EnchantmentUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class EnchantmentConversionMenu
extends AbstractContainerMenu {
    public static final int ENCHANTED_BOOK_SLOT_ROW_COUNT = 4;
    public static final int ENCHANTED_BOOK_SLOT_COLUMN_COUNT = 7;
    public static final int ENCHANTED_BOOK_SLOT_SIZE = 28;
    public static final int ENCHANTMENT_CONVERSION_SLOT_SIZE = 30;
    private final ItemStackHandler itemHandler = new ItemStackHandler(30);
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private final Map<Integer, Slot> enchantedBookSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    public EnchantmentConversionTableBlockEntity boundBlockEntity = null;
    public static final List<Integer> allEnchantments = new ArrayList<Integer>();
    public int currentPage = 0;
    public int totalPage = 0;

    public EnchantmentConversionMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.ENCHANTMENT_CONVERSION.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            this.boundBlockEntity = (EnchantmentConversionTableBlockEntity)this.world.getBlockEntity(pos);
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 0, 16, 8){
            private final int slot = 0;
            private int x;
            private int y;
            {
                this.slot = 0;
                this.x = EnchantmentConversionMenu.this.x;
                this.y = EnchantmentConversionMenu.this.y;
            }

            public boolean mayPlace(ItemStack stack) {
                return Items.BOOK == stack.getItem();
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty() && !oldStack.isEmpty()) {
                    EnchantmentConversionMenu.this.genEnchantedBookSlot();
                } else {
                    EnchantmentConversionMenu.this.regenerateEnchantedBookSlot();
                }
            }

            public ResourceLocation getNoItemIcon() {
                return ResourceLocation.fromNamespaceAndPath((String)"enchantment_custom_table", (String)"container/slot/empty_slot_book");
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 1, 16, 26){
            private final int slot = 1;
            private int x;
            private int y;
            {
                this.slot = 1;
                this.x = EnchantmentConversionMenu.this.x;
                this.y = EnchantmentConversionMenu.this.y;
            }

            public boolean mayPlace(ItemStack stack) {
                return Items.EMERALD == stack.getItem() && Config.minimumEmeraldCost > 0 || Items.EMERALD_BLOCK == stack.getItem() && Config.minimumEmeraldBlockCost > 0;
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty() && !oldStack.isEmpty()) {
                    EnchantmentConversionMenu.this.genEnchantedBookSlot();
                } else {
                    EnchantmentConversionMenu.this.regenerateEnchantedBookSlot();
                }
            }

            public ResourceLocation getNoItemIcon() {
                return ResourceLocation.withDefaultNamespace((String)"container/slot/emerald");
            }
        });
        int enchanted_book_index = 0;
        for (int row = 0; row < 4; ++row) {
            int yPos = 8 + row * 18;
            for (int col = 0; col < 7; ++col) {
                int xPos = 43 + col * 18;
                final int final_enchanted_book_index = enchanted_book_index++;
                this.enchantedBookSlots.put(final_enchanted_book_index, this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, final_enchanted_book_index + 2, xPos, yPos){
                    private final int slot;
                    private int x;
                    private int y;
                    {
                        super(arg0, arg1, arg2, arg3);
                        this.slot = final_enchanted_book_index + 2;
                        this.x = EnchantmentConversionMenu.this.x;
                        this.y = EnchantmentConversionMenu.this.y;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return false;
                    }

                    public ResourceLocation getNoItemIcon() {
                        return ResourceLocation.fromNamespaceAndPath((String)"enchantment_custom_table", (String)"container/slot/empty_slot_book");
                    }

                    public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                        super.setByPlayer(newStack, oldStack);
                        EnchantmentConversionMenu.this.pickEnchantedBook();
                    }
                }));
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 30) {
                if (!this.moveItemStackTo(itemstack1, 30, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 30, false)) {
                if (index < 57 ? !this.moveItemStackTo(itemstack1, 57, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 30, 57, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        if (index < 2) {
            this.genEnchantedBookSlot();
        } else if (index < 30) {
            this.pickEnchantedBook();
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!this.bound && playerIn instanceof ServerPlayer) {
            playerIn.getInventory().placeItemBackInInventory(this.itemHandler.getStackInSlot(0));
            playerIn.getInventory().placeItemBackInInventory(this.itemHandler.getStackInSlot(1));
        }
    }

    public void tryGetAllEnchantments() {
        if (allEnchantments.isEmpty()) {
            Registry fullEnchantmentList = this.world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
            IdMap allRegisteredEnchantments = fullEnchantmentList.asHolderIdMap();
            allRegisteredEnchantments.forEach(enchantment -> allEnchantments.add(fullEnchantmentList.getId((Object)((Enchantment)enchantment.value()))));
        }
    }

    public ItemStack getEnchantedBook(int enchantmentId) {
        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
        Enchantment enchantment = (Enchantment)this.world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).byId(enchantmentId);
        int enchantmentLevel = Config.convertMaxLevelBook ? enchantment.getMaxLevel() : 1;
        Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
        assert (enchantmentReference != null);
        enchantedBook.enchant(enchantmentReference, enchantmentLevel);
        return enchantedBook;
    }

    public void nextPage() {
        if (this.currentPage < this.totalPage - 1) {
            this.turnPage(this.currentPage + 1);
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            this.turnPage(this.currentPage - 1);
        }
    }

    public void turnPage(int page) {
        this.currentPage = page;
        this.clearEnchantedBookSlot();
        this.genEnchantedBookSlot();
    }

    public void resetPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void clearEnchantedBookSlot() {
        for (int i = 2; i < 30; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void genEnchantedBookSlot() {
        this.tryGetAllEnchantments();
        boolean hasBook = this.itemHandler.getStackInSlot(0).is(Items.BOOK);
        boolean hasEnoughEmerald = false;
        if (this.itemHandler.getStackInSlot(1).is(Items.EMERALD) && Config.minimumEmeraldCost > 0) {
            hasEnoughEmerald = this.itemHandler.getStackInSlot(1).getCount() >= Config.minimumEmeraldCost;
        } else if (this.itemHandler.getStackInSlot(1).is(Items.EMERALD_BLOCK) && Config.minimumEmeraldBlockCost > 0) {
            boolean bl = hasEnoughEmerald = this.itemHandler.getStackInSlot(1).getCount() >= Config.minimumEmeraldBlockCost;
        }
        if (!hasBook || !hasEnoughEmerald) {
            this.resetPage();
            this.clearEnchantedBookSlot();
            return;
        }
        for (int i = 0; i < 28; ++i) {
            int slotIndex = i + 2;
            int enchantmentIndex = i + this.currentPage * 28;
            if (enchantmentIndex < allEnchantments.size()) {
                if (!this.itemHandler.getStackInSlot(slotIndex).isEmpty()) continue;
                int enchantmentId = allEnchantments.get(enchantmentIndex);
                this.itemHandler.setStackInSlot(slotIndex, this.getEnchantedBook(enchantmentId));
                continue;
            }
            this.itemHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
        }
    }

    public void regenerateEnchantedBookSlot() {
        this.currentPage = 0;
        this.totalPage = (int)Math.ceil((double)allEnchantments.size() / 28.0);
        this.genEnchantedBookSlot();
    }

    public void pickEnchantedBook() {
        this.itemHandler.getStackInSlot(0).shrink(1);
        if (this.itemHandler.getStackInSlot(1).is(Items.EMERALD)) {
            this.itemHandler.getStackInSlot(1).shrink(Config.minimumEmeraldCost);
        } else if (this.itemHandler.getStackInSlot(1).is(Items.EMERALD_BLOCK)) {
            this.itemHandler.getStackInSlot(1).shrink(Config.minimumEmeraldBlockCost);
        }
        this.genEnchantedBookSlot();
    }
}

