/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.block;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.river_quinn.enchantment_custom_table.block.entity.EnchantingCustomTableBlockEntity;
import com.river_quinn.enchantment_custom_table.world.inventory.EnchantmentCustomMenu;
import io.netty.buffer.Unpooled;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EnchantingCustomTableBlock
extends BaseEntityBlock {
    public static final MapCodec<EnchantingCustomTableBlock> CODEC = EnchantingCustomTableBlock.simpleCodec(EnchantingCustomTableBlock::new);
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);

    public EnchantingCustomTableBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public EnchantingCustomTableBlock() {
        super(BlockBehaviour.Properties.of().lightLevel(blockState -> 15).destroyTime(1.0f).explosionResistance(3600.0f));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
    }

    protected MapCodec<? extends EnchantingCustomTableBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new EnchantingCustomTableBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? (lvl, pos, blockState, t) -> {
            if (t instanceof EnchantingCustomTableBlockEntity) {
                EnchantingCustomTableBlockEntity enchantingTable = (EnchantingCustomTableBlockEntity)t;
                EnchantingCustomTableBlockEntity.bookAnimationTick(lvl, pos, blockState, enchantingTable);
            }
        } : null;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, final BlockPos pos, Player entity, BlockHitResult result) {
        super.useWithoutItem(state, level, pos, entity, result);
        LOGGER.info("EnchantingCustomTableBlock useWithoutItem");
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            player.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Enchanting Custom Table Block");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    return new EnchantmentCustomMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(pos));
                }
            }, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public MenuProvider getMenuProvider(BlockState state, Level worldIn, BlockPos pos) {
        MenuProvider menuProvider;
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        return tileEntity instanceof MenuProvider ? (menuProvider = (MenuProvider)tileEntity) : null;
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity blockEntity = world.getBlockEntity(pos);
            if (blockEntity instanceof EnchantingCustomTableBlockEntity) {
                EnchantingCustomTableBlockEntity be = (EnchantingCustomTableBlockEntity)blockEntity;
                be.DropToolInFirstSlotOnRemove();
                world.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, world, pos, newState, isMoving);
        }
    }
}

