/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.block.entity;

import com.river_quinn.enchantment_custom_table.init.ModBlockEntities;
import com.river_quinn.enchantment_custom_table.world.inventory.EnchantmentCustomMenu;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class EnchantingCustomTableBlockEntity
extends BlockEntity
implements MenuProvider {
    public static final int ENCHANTED_BOOK_SLOT_ROW_COUNT = 4;
    public static final int ENCHANTED_BOOK_SLOT_COLUMN_COUNT = 6;
    public static final int ENCHANTED_BOOK_SLOT_SIZE = 24;
    public static final int ENCHANTMENT_CUSTOM_TABLE_SLOT_SIZE = 26;
    private final ItemStackHandler itemHandler = new ItemStackHandler(26);
    public int currentPage = 0;
    public int totalPage = 0;
    public int time;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    public float tRot;
    private static final RandomSource RANDOM = RandomSource.create();
    private final List<ItemStack> enchantmentsOnCurrentTool = new ArrayList<ItemStack>();

    public EnchantingCustomTableBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ENCHANTING_CUSTOM_TABLE.get(), pos, state);
    }

    public static void bookAnimationTick(Level level, BlockPos pos, BlockState state, EnchantingCustomTableBlockEntity enchantingTable) {
        float f2;
        enchantingTable.oOpen = enchantingTable.open;
        enchantingTable.oRot = enchantingTable.rot;
        Player player = level.getNearestPlayer((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.getX() - ((double)pos.getX() + 0.5);
            double d1 = player.getZ() - ((double)pos.getZ() + 0.5);
            enchantingTable.tRot = (float)Mth.atan2((double)d1, (double)d0);
            enchantingTable.open += 0.1f;
            if (enchantingTable.open < 0.5f || RANDOM.nextInt(40) == 0) {
                float f1 = enchantingTable.flipT;
                do {
                    enchantingTable.flipT += (float)(RANDOM.nextInt(4) - RANDOM.nextInt(4));
                } while (f1 == enchantingTable.flipT);
            }
        } else {
            enchantingTable.tRot += 0.02f;
            enchantingTable.open -= 0.1f;
        }
        while (enchantingTable.rot >= (float)Math.PI) {
            enchantingTable.rot -= (float)Math.PI * 2;
        }
        while (enchantingTable.rot < (float)(-Math.PI)) {
            enchantingTable.rot += (float)Math.PI * 2;
        }
        while (enchantingTable.tRot >= (float)Math.PI) {
            enchantingTable.tRot -= (float)Math.PI * 2;
        }
        while (enchantingTable.tRot < (float)(-Math.PI)) {
            enchantingTable.tRot += (float)Math.PI * 2;
        }
        for (f2 = enchantingTable.tRot - enchantingTable.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        enchantingTable.rot += f2 * 0.4f;
        enchantingTable.open = Mth.clamp((float)enchantingTable.open, (float)0.0f, (float)1.0f);
        ++enchantingTable.time;
        enchantingTable.oFlip = enchantingTable.flip;
        float f = (enchantingTable.flipT - enchantingTable.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.clamp((float)f, (float)-0.2f, (float)0.2f);
        enchantingTable.flipA += (f - enchantingTable.flipA) * 0.9f;
        enchantingTable.flip += enchantingTable.flipA;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    public void resetPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void DropToolInFirstSlotOnRemove() {
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        Containers.dropItemStack((Level)this.level, (double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ(), (ItemStack)toolItemStack);
    }

    public Component getDisplayName() {
        return null;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new EnchantmentCustomMenu(i, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    private Holder.Reference<Enchantment> translateEnchantment(Enchantment enchantment) {
        if (this.level == null) {
            return null;
        }
        Registry fullEnchantmentRegistry = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        ResourceKey resourceKey = (ResourceKey)fullEnchantmentRegistry.getResourceKey((Object)enchantment).get();
        Optional optional = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(resourceKey);
        return (Holder.Reference)optional.get();
    }

    public void exportAllEnchantments(Player player) {
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        if (!toolItemStack.isEmpty() && itemEnchantments != null) {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                int enchantmentLevel = entry.getIntValue();
                Holder.Reference<Enchantment> enchantmentReference = this.translateEnchantment(enchantment);
                assert (enchantmentReference != null);
                mutable.set(enchantmentReference, 0);
                enchantedBook.enchant(enchantmentReference, enchantmentLevel);
            }
            toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
            player.getInventory().placeItemBackInInventory(enchantedBook);
            this.clearEnchantedBookStore();
            this.level.playSound(null, this.worldPosition, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void nextPage() {
        if (this.currentPage < this.totalPage - 1) {
            this.turnPage(this.currentPage + 1);
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            this.turnPage(this.currentPage - 1);
        }
    }

    public void turnPage(int targetPage) {
        if (targetPage < 0 || targetPage >= this.totalPage) {
            return;
        }
        int indexOffset = this.currentPage * 24;
        for (int i = 0; i < 24; ++i) {
            int indexOfFullList = i + indexOffset;
            int indexOfSlot = i + 2;
            if (indexOfFullList >= this.enchantmentsOnCurrentTool.size()) continue;
            this.enchantmentsOnCurrentTool.set(indexOfFullList, this.itemHandler.getStackInSlot(indexOfSlot));
        }
        this.currentPage = targetPage;
        this.updateEnchantedBookSlots();
    }

    public void updateEnchantedBookSlots() {
        int indexOffset = this.currentPage * 24;
        for (int i = 0; i < 24; ++i) {
            int indexOfFullList = i + indexOffset;
            int indexOfSlot = i + 2;
            if (indexOfFullList < this.enchantmentsOnCurrentTool.size()) {
                this.itemHandler.setStackInSlot(indexOfSlot, this.enchantmentsOnCurrentTool.get(indexOfFullList));
                continue;
            }
            this.itemHandler.setStackInSlot(indexOfSlot, ItemStack.EMPTY);
        }
    }

    public void genEnchantedBookStore() {
        ItemEnchantments enchantments;
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        this.enchantmentsOnCurrentTool.clear();
        if (!toolItemStack.isEmpty() && (enchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack))) != null) {
            for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                Integer enchantmentLevel = entry.getValue();
                ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                Holder.Reference<Enchantment> enchantmentReference = this.translateEnchantment(enchantment);
                assert (enchantmentReference != null);
                enchantedBook.enchant(enchantmentReference, enchantmentLevel.intValue());
                this.enchantmentsOnCurrentTool.add(enchantedBook);
            }
        }
        this.currentPage = 0;
        this.totalPage = (int)Math.ceil((double)this.enchantmentsOnCurrentTool.size() / 24.0);
        this.updateEnchantedBookSlots();
        this.itemHandler.setStackInSlot(1, ItemStack.EMPTY);
        this.setChanged();
    }

    public IdMap<Holder<Enchantment>> getAllRegisteredEnchantments() {
        Registry fullEnchantmentList = this.level.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        return fullEnchantmentList.asHolderIdMap();
    }

    public void addEnchantment(List<EnchantmentInstance> enchantmentInstances) {
        this.addEnchantment(enchantmentInstances, false);
    }

    public void addEnchantment(List<EnchantmentInstance> enchantmentInstances, boolean forceRegenerateEnchantedBookStore) {
        boolean regenerateEnchantedBookStore = false;
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments enchantmentsOnTool = toolItemStack.getTagEnchantments();
        IdMap<Holder<Enchantment>> allRegisteredEnchantments = this.getAllRegisteredEnchantments();
        HashMap<Integer, EnchantmentInstance> resultEnchantmentMap = new HashMap<Integer, EnchantmentInstance>();
        for (Object2IntMap.Entry entry : enchantmentsOnTool.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int enchantmentId = allRegisteredEnchantments.getId((Object)Holder.direct((Object)enchantment));
            int enchantmentLevel = entry.getIntValue();
            EnchantmentInstance enchantmentInstance = new EnchantmentInstance(Holder.direct((Object)enchantment), enchantmentLevel);
            resultEnchantmentMap.put(enchantmentId, enchantmentInstance);
        }
        for (EnchantmentInstance enchantmentInstance : enchantmentInstances) {
            int enchantmentId = allRegisteredEnchantments.getId((Object)enchantmentInstance.enchantment);
            if (resultEnchantmentMap.containsKey(enchantmentId)) {
                regenerateEnchantedBookStore = true;
                resultEnchantmentMap.put(enchantmentId, new EnchantmentInstance(enchantmentInstance.enchantment, ((EnchantmentInstance)resultEnchantmentMap.get((Object)Integer.valueOf((int)enchantmentId))).level + enchantmentInstance.level));
                continue;
            }
            resultEnchantmentMap.put(enchantmentId, new EnchantmentInstance(enchantmentInstance.enchantment, enchantmentInstance.level));
        }
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        for (EnchantmentInstance enchantmentInstance : resultEnchantmentMap.values().stream().toList()) {
            Holder.Reference<Enchantment> enchantmentReference = this.translateEnchantment((Enchantment)enchantmentInstance.enchantment.value());
            assert (enchantmentReference != null);
            mutable.set(enchantmentReference, 0);
            mutable.set(enchantmentReference, enchantmentInstance.level);
        }
        toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
        if (enchantmentInstances.size() > 1 || forceRegenerateEnchantedBookStore || regenerateEnchantedBookStore) {
            this.genEnchantedBookStore();
        }
        this.level.playSound(null, this.worldPosition, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        if (enchantmentsOnTool.entrySet().isEmpty()) {
            this.currentPage = 0;
            this.totalPage = 1;
        }
    }

    public void removeEnchantment(List<EnchantmentInstance> enchantmentInstances) {
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        for (EnchantmentInstance enchantmentInstance : enchantmentInstances) {
            Holder.Reference<Enchantment> enchantmentReference = this.translateEnchantment((Enchantment)enchantmentInstance.enchantment.value());
            assert (enchantmentReference != null);
            mutable.set(enchantmentReference, 0);
        }
        toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
        this.level.playSound(null, this.worldPosition, SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public void clearEnchantedBookStore() {
        for (int i = 2; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }
}

