/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.river_quinn.enchantment_custom_table.network.enchanting_custom_table.EnchantingCustomTableNetData;
import com.river_quinn.enchantment_custom_table.world.inventory.EnchantmentCustomMenu;
import java.util.HashMap;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;
import org.slf4j.Logger;

public class EnchantingCustomScreen
extends AbstractContainerScreen<EnchantmentCustomMenu> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private EnchantmentCustomMenu menuContainer;
    private static final HashMap<String, Object> guistate = EnchantmentCustomMenu.guistate;
    private final Level world;
    private final int x;
    private final int y;
    private final int z;
    private final Player entity;
    Button button_left_arrow_button;
    Button button_right_arrow_button;
    Button export_button;
    private static final ResourceLocation texture = ResourceLocation.parse((String)"enchantment_custom_table:textures/screens/enchantment_custom.png");

    public EnchantingCustomScreen(EnchantmentCustomMenu container, Inventory inventory, Component text) {
        super((AbstractContainerMenu)container, inventory, text);
        this.menuContainer = container;
        this.world = container.world;
        this.x = container.x;
        this.y = container.y;
        this.z = container.z;
        this.entity = container.entity;
        this.imageWidth = 176;
        this.imageHeight = 166;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int gx, int gy) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        guiGraphics.blit(texture, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, this.imageWidth, this.imageHeight);
        RenderSystem.disableBlend();
        guiGraphics.blit(ResourceLocation.parse((String)"enchantment_custom_table:textures/screens/left_arrow.png"), this.leftPos + 27, this.topPos + 12, 0.0f, 0.0f, 12, 9, 12, 9);
    }

    public boolean keyPressed(int key, int b, int c) {
        if (key == 256) {
            this.minecraft.player.closeContainer();
            return true;
        }
        return super.keyPressed(key, b, c);
    }

    public String generatePageText() {
        int currentPage = this.menuContainer.boundBlockEntity.currentPage;
        int totalPage = this.menuContainer.boundBlockEntity.totalPage;
        if (totalPage == 0) {
            return "-/-";
        }
        return currentPage + 1 + "/" + totalPage;
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawCenteredString(this.font, this.generatePageText(), 35, 33, -1);
    }

    public void init() {
        super.init();
        this.button_left_arrow_button = Button.builder((Component)Component.translatable((String)"gui.enchantment_custom_table.enchantment_custom.button_left_arrow"), e -> this.menuContainer.boundBlockEntity.previousPage()).bounds(this.leftPos + 7, this.topPos + 43, 26, 18).build();
        guistate.put("button:button_left_arrow_button", this.button_left_arrow_button);
        this.addRenderableWidget((GuiEventListener)this.button_left_arrow_button);
        this.button_right_arrow_button = Button.builder((Component)Component.translatable((String)"gui.enchantment_custom_table.enchantment_custom.button_right_arrow"), e -> this.menuContainer.boundBlockEntity.nextPage()).bounds(this.leftPos + 33, this.topPos + 43, 26, 18).build();
        guistate.put("button:button_right_arrow_button", this.button_right_arrow_button);
        this.addRenderableWidget((GuiEventListener)this.button_right_arrow_button);
        this.export_button = Button.builder((Component)Component.translatable((String)"gui.enchantment_custom_table.enchantment_custom.button_export"), e -> PacketDistributor.sendToServer((CustomPacketPayload)new EnchantingCustomTableNetData(this.x, this.y, this.z, EnchantingCustomTableNetData.OperateType.EXPORT_ALL_ENCHANTMENTS.toString()), (CustomPacketPayload[])new CustomPacketPayload[0])).bounds(this.leftPos + 7, this.topPos + 61, 52, 18).build();
        guistate.put("button:export_button", this.export_button);
        this.addRenderableWidget((GuiEventListener)this.export_button);
    }

    public void ShowEnchantmentCustomPage() {
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        super.mouseReleased(mouseX, mouseY, button);
        return true;
    }
}

