/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.world.inventory;

import com.mojang.logging.LogUtils;
import com.river_quinn.enchantment_custom_table.block.entity.EnchantingCustomTableBlockEntity;
import com.river_quinn.enchantment_custom_table.init.ModMenus;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.slf4j.Logger;

public class EnchantmentCustomMenu
extends AbstractContainerMenu {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private ItemStackHandler internal;
    private Slot enchantableItemSlot;
    private Slot enchantedBookToAppendSlot;
    private final Map<Integer, Slot> enchantedBookSlots = new HashMap<Integer, Slot>();
    private boolean bound = false;
    private Supplier<Boolean> boundItemMatcher = null;
    private Entity boundEntity = null;
    public EnchantingCustomTableBlockEntity boundBlockEntity = null;
    private ItemStackHandler boundInv = null;

    public EnchantmentCustomMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.ENCHANTMENT_CUSTOM.get(), id);
        int si;
        EnchantingCustomTableBlockEntity enchantingCustomTableBlockEntity;
        this.entity = inv.player;
        this.world = inv.player.level();
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null && (enchantingCustomTableBlockEntity = (this.boundBlockEntity = (EnchantingCustomTableBlockEntity)this.world.getBlockEntity(pos))) instanceof EnchantingCustomTableBlockEntity) {
            EnchantingCustomTableBlockEntity baseContainerBlockEntity = enchantingCustomTableBlockEntity;
            this.internal = baseContainerBlockEntity.getItemHandler();
            this.boundInv = this.boundBlockEntity.getItemHandler();
        }
        this.enchantableItemSlot = this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.internal, 0, 8, 8){
            private final int slot = 0;
            private int x;
            private int y;
            {
                this.slot = 0;
                this.x = EnchantmentCustomMenu.this.x;
                this.y = EnchantmentCustomMenu.this.y;
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty()) {
                    EnchantmentCustomMenu.this.boundBlockEntity.genEnchantedBookStore();
                } else {
                    EnchantmentCustomMenu.this.boundBlockEntity.clearEnchantedBookStore();
                    EnchantmentCustomMenu.this.boundBlockEntity.resetPage();
                }
            }
        });
        this.enchantedBookToAppendSlot = this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.internal, 1, 42, 8){
            private final int slot = 1;
            private int x;
            private int y;
            {
                this.slot = 1;
                this.x = EnchantmentCustomMenu.this.x;
                this.y = EnchantmentCustomMenu.this.y;
            }

            public boolean mayPlace(ItemStack stack) {
                return Items.ENCHANTED_BOOK == stack.getItem() && !this.getItemHandler().getStackInSlot(0).isEmpty();
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty()) {
                    EnchantmentCustomMenu.this.boundBlockEntity.addEnchantment(EnchantmentCustomMenu.this.getEnchantmentInstanceFromEnchantedBook(newStack), true);
                } else {
                    LOGGER.warn("stack 1, setByPlayer() called with newStack.isEmpty()");
                }
            }
        });
        int enchanted_book_index = 0;
        for (int row = 0; row < 4; ++row) {
            int yPos = 8 + row * 18;
            for (int col = 0; col < 6; ++col) {
                int xPos = 61 + col * 18;
                final int final_enchanted_book_index = enchanted_book_index++;
                this.enchantedBookSlots.put(final_enchanted_book_index, this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.internal, final_enchanted_book_index + 2, xPos, yPos){
                    private final int slot;
                    private int x;
                    private int y;
                    {
                        super(arg0, arg1, arg2, arg3);
                        this.slot = final_enchanted_book_index + 2;
                        this.x = EnchantmentCustomMenu.this.x;
                        this.y = EnchantmentCustomMenu.this.y;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return Items.ENCHANTED_BOOK == stack.getItem() && !this.getItemHandler().getStackInSlot(0).isEmpty();
                    }

                    public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                        super.setByPlayer(newStack, oldStack);
                        if (!newStack.isEmpty() && oldStack.isEmpty()) {
                            EnchantmentCustomMenu.this.boundBlockEntity.addEnchantment(EnchantmentCustomMenu.this.getEnchantmentInstanceFromEnchantedBook(newStack));
                        } else if (newStack.isEmpty() && !oldStack.isEmpty()) {
                            EnchantmentCustomMenu.this.boundBlockEntity.removeEnchantment(EnchantmentCustomMenu.this.getEnchantmentInstanceFromEnchantedBook(oldStack));
                        }
                    }
                }));
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 26) {
                if (!this.moveItemStackTo(itemstack1, 26, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 26, false)) {
                if (index < 53 ? !this.moveItemStackTo(itemstack1, 53, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 26, 53, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
        if (!this.bound && playerIn instanceof ServerPlayer) {
            playerIn.getInventory().placeItemBackInInventory(this.internal.getStackInSlot(0));
            for (int i = 0; i < this.internal.getSlots(); ++i) {
                ItemStackHandler itemStackHandler = this.internal;
                if (!(itemStackHandler instanceof IItemHandlerModifiable)) continue;
                ItemStackHandler ihm = itemStackHandler;
                ihm.setStackInSlot(i, ItemStack.EMPTY);
            }
        }
    }

    public List<EnchantmentInstance> getEnchantmentInstanceFromEnchantedBook(ItemStack enchantedBookItemStack) {
        DataComponentType componentType = EnchantmentHelper.getComponentType((ItemStack)enchantedBookItemStack);
        ItemEnchantments componentMap = (ItemEnchantments)enchantedBookItemStack.getComponents().get(componentType);
        ArrayList<EnchantmentInstance> enchantmentOfBook = new ArrayList<EnchantmentInstance>();
        for (Object2IntMap.Entry entry : componentMap.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int enchantmentLevel = entry.getIntValue();
            enchantmentOfBook.add(new EnchantmentInstance(Holder.direct((Object)enchantment), enchantmentLevel));
        }
        return enchantmentOfBook;
    }
}

