/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table;

import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="enchantment_custom_table")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    private static final ModConfigSpec.IntValue MINIMUM_LAPIS_COST = BUILDER.comment("Minimum lapis cost when using enchantment conversion table, when set to 0, emerald will be banned on the table").defineInRange("minimumEmeraldCost", 36, 0, 64);
    private static final ModConfigSpec.IntValue MINIMUM_LAPIS_BLOCK_COST = BUILDER.comment("Minimum lapis block cost when using enchantment conversion table, when set to 0, emerald block will be banned on the table").defineInRange("minimumEmeraldBlockCost", 4, 0, 64);
    private static final ModConfigSpec.BooleanValue IGNORE_ENCHANTMENT_LEVEL_LIMIT = BUILDER.comment("Ignore enchantment level limit when using enchantment conversion table").define("ignoreEnchantmentLevelLimit", true);
    private static final ModConfigSpec.BooleanValue CONVERT_MAX_LEVEL_BOOK = BUILDER.comment("if set to true, enchantment conversion table will use emerald to exchange max level book").comment("if set to false, enchantment conversion table will use emerald to exchange 1-level book").define("convert_max_level_book", true);
    static final ModConfigSpec SPEC = BUILDER.build();
    public static int minimumEmeraldCost;
    public static int minimumEmeraldBlockCost;
    public static boolean ignoreEnchantmentLevelLimit;
    public static boolean enableXpRequirement;
    public static boolean convertMaxLevelBook;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        minimumEmeraldCost = (Integer)MINIMUM_LAPIS_COST.get();
        minimumEmeraldBlockCost = (Integer)MINIMUM_LAPIS_BLOCK_COST.get();
        ignoreEnchantmentLevelLimit = (Boolean)IGNORE_ENCHANTMENT_LEVEL_LIMIT.get();
        convertMaxLevelBook = (Boolean)CONVERT_MAX_LEVEL_BOOK.get();
    }
}

