/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.utils;

import com.river_quinn.enchantment_custom_table.Config;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.Level;

public class EnchantmentUtils {
    public static Holder.Reference<Enchantment> translateEnchantment(Level level, Enchantment enchantment) {
        if (level == null) {
            return null;
        }
        Registry fullEnchantmentRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ResourceKey resourceKey = (ResourceKey)fullEnchantmentRegistry.getResourceKey((Object)enchantment).get();
        Optional optional = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(resourceKey);
        return (Holder.Reference)optional.get();
    }

    public static int getEnchantCost(ItemStack toolItemStack) {
        if (!Config.enableXpRequirement) {
            return 0;
        }
        int xpLevelToCost = 0;
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            Holder enchantment = (Holder)entry.getKey();
            Integer level = entry.getValue();
            xpLevelToCost += ((Enchantment)enchantment.value()).getAnvilCost() * level;
        }
        return xpLevelToCost;
    }

    public static boolean checkSatisfyXpRequirement(ItemStack toolItemStack, Player player) {
        if (!Config.enableXpRequirement) {
            return true;
        }
        int xpLevelToCost = EnchantmentUtils.getEnchantCost(toolItemStack);
        return xpLevelToCost <= player.experienceLevel;
    }
}

