/*
 * Decompiled with CFR 0.152.
 */
package com.river_quinn.enchantment_custom_table.world.inventory;

import com.mojang.logging.LogUtils;
import com.river_quinn.enchantment_custom_table.Config;
import com.river_quinn.enchantment_custom_table.block.entity.EnchantingCustomTableBlockEntity;
import com.river_quinn.enchantment_custom_table.init.ModMenus;
import com.river_quinn.enchantment_custom_table.utils.EnchantmentUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class EnchantingCustomMenu
extends AbstractContainerMenu {
    public static final int ENCHANTED_BOOK_SLOT_ROW_COUNT = 4;
    public static final int ENCHANTED_BOOK_SLOT_COLUMN_COUNT = 6;
    public static final int ENCHANTED_BOOK_SLOT_SIZE = 24;
    public static final int ENCHANTMENT_CUSTOM_TABLE_SLOT_SIZE = 26;
    private final ItemStackHandler itemHandler = new ItemStackHandler(this, 26){

        public int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }
    };
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final HashMap<String, Object> guistate = new HashMap();
    public final Level world;
    public final Player entity;
    public int x;
    public int y;
    public int z;
    private ContainerLevelAccess access = ContainerLevelAccess.NULL;
    private final Map<Integer, Slot> enchantedBookSlots = new HashMap<Integer, Slot>();
    public EnchantingCustomTableBlockEntity boundBlockEntity = null;
    public int currentPage = 0;
    public int totalPage = 0;
    private final List<ItemStack> enchantmentsOnCurrentTool = new ArrayList<ItemStack>();

    public void clicked(int slotId, int button, ClickType clickType, Player player) {
        ItemStack itemStackToPut = this.entity.containerMenu.getCarried();
        if (slotId >= 2 && slotId < 26 && clickType != ClickType.QUICK_MOVE && (itemStackToPut.isEmpty() || this.getSlot(slotId).mayPlace(this.entity.containerMenu.getCarried()))) {
            ItemStack itemStackToReplace = this.itemHandler.getStackInSlot(slotId);
            if (!itemStackToPut.isEmpty() && !itemStackToReplace.isEmpty()) {
                List<EnchantmentInstance> enchantmentsOnNewStack = this.getEnchantmentInstanceFromEnchantedBook(itemStackToPut);
                EnchantmentInstance enchantmentOnOldStack = this.getEnchantmentInstanceFromEnchantedBook(itemStackToReplace).get(0);
                boolean hasDuplicateEnchantment = enchantmentsOnNewStack.stream().anyMatch(enchantment -> enchantment.enchantment().equals((Object)enchantmentOnOldStack.enchantment()));
                if (hasDuplicateEnchantment) {
                    this.addEnchantment(itemStackToPut, slotId, true);
                    this.entity.containerMenu.setCarried(ItemStack.EMPTY.copy());
                    return;
                }
            }
            int enchantmentIndexInCache = slotId - 2 + this.currentPage * 24;
            if (!itemStackToReplace.isEmpty()) {
                this.entity.containerMenu.setCarried(itemStackToReplace.copy());
                boolean hasRegenerated = this.removeEnchantment(itemStackToReplace);
                if (!hasRegenerated) {
                    this.enchantmentsOnCurrentTool.set(enchantmentIndexInCache, ItemStack.EMPTY);
                }
            } else {
                this.entity.containerMenu.setCarried(ItemStack.EMPTY.copy());
            }
            if (!itemStackToPut.isEmpty()) {
                this.addEnchantment(itemStackToPut, slotId);
            }
            this.updateEnchantedBookSlots();
        } else {
            super.clicked(slotId, button, clickType, player);
        }
    }

    public EnchantingCustomMenu(int id, Inventory inv, FriendlyByteBuf extraData) {
        super((MenuType)ModMenus.ENCHANTING_CUSTOM.get(), id);
        int si;
        this.entity = inv.player;
        this.world = inv.player.level();
        BlockPos pos = null;
        if (extraData != null) {
            pos = extraData.readBlockPos();
            this.x = pos.getX();
            this.y = pos.getY();
            this.z = pos.getZ();
            this.access = ContainerLevelAccess.create((Level)this.world, (BlockPos)pos);
        }
        if (pos != null) {
            this.boundBlockEntity = (EnchantingCustomTableBlockEntity)this.world.getBlockEntity(pos);
        }
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 0, 8, 8){
            private final int slot = 0;
            private int x;
            private int y;
            {
                this.slot = 0;
                this.x = EnchantingCustomMenu.this.x;
                this.y = EnchantingCustomMenu.this.y;
            }

            public void onQuickCraft(ItemStack newStack, ItemStack oldStack) {
                super.onQuickCraft(newStack, oldStack);
                EnchantingCustomMenu.this.clearCache();
                EnchantingCustomMenu.this.clearPage();
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty()) {
                    EnchantingCustomMenu.this.genEnchantedBookCache();
                    EnchantingCustomMenu.this.currentPage = 0;
                    EnchantingCustomMenu.this.updateEnchantedBookSlots();
                } else {
                    EnchantingCustomMenu.this.clearCache();
                    EnchantingCustomMenu.this.clearPage();
                }
            }
        });
        this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, 1, 42, 8){
            private final int slot = 1;
            private int x;
            private int y;
            {
                this.slot = 1;
                this.x = EnchantingCustomMenu.this.x;
                this.y = EnchantingCustomMenu.this.y;
            }

            public boolean mayPlace(ItemStack stack) {
                return Items.ENCHANTED_BOOK == stack.getItem() && !this.getItemHandler().getStackInSlot(0).isEmpty() && (Config.ignoreEnchantmentLevelLimit || EnchantingCustomMenu.this.checkCanPlaceEnchantedBook(stack));
            }

            public ResourceLocation getNoItemIcon() {
                return ResourceLocation.fromNamespaceAndPath((String)"enchantment_custom_table", (String)"container/slot/empty_slot_book");
            }

            public void setByPlayer(ItemStack newStack, ItemStack oldStack) {
                super.setByPlayer(newStack, oldStack);
                if (!newStack.isEmpty()) {
                    EnchantingCustomMenu.this.addEnchantment(newStack, 1, true);
                } else {
                    LOGGER.warn("stack 1, setByPlayer() called with newStack.isEmpty()");
                }
            }
        });
        int enchanted_book_index = 0;
        for (int row = 0; row < 4; ++row) {
            int yPos = 8 + row * 18;
            for (int col = 0; col < 6; ++col) {
                int xPos = 61 + col * 18;
                final int final_enchanted_book_index = enchanted_book_index++;
                this.enchantedBookSlots.put(final_enchanted_book_index, this.addSlot((Slot)new SlotItemHandler((IItemHandler)this.itemHandler, final_enchanted_book_index + 2, xPos, yPos){
                    private final int slot;
                    private int x;
                    private int y;
                    {
                        super(arg0, arg1, arg2, arg3);
                        this.slot = final_enchanted_book_index + 2;
                        this.x = EnchantingCustomMenu.this.x;
                        this.y = EnchantingCustomMenu.this.y;
                    }

                    public boolean mayPlace(ItemStack stack) {
                        return Items.ENCHANTED_BOOK == stack.getItem() && !this.getItemHandler().getStackInSlot(0).isEmpty() && (Config.ignoreEnchantmentLevelLimit || EnchantingCustomMenu.this.checkCanPlaceEnchantedBook(stack));
                    }

                    public ResourceLocation getNoItemIcon() {
                        return ResourceLocation.fromNamespaceAndPath((String)"enchantment_custom_table", (String)"container/slot/empty_slot_book");
                    }
                }));
            }
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.addSlot(new Slot((Container)inv, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.addSlot(new Slot((Container)inv, si, 8 + si * 18, 142));
        }
        this.initMenu();
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        ItemStack itemStackToOperate = slot.getItem().copy();
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            if (index < 26) {
                if (!this.moveItemStackTo(itemstack1, 26, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot.onQuickCraft(itemstack1, itemstack);
            } else if (!this.moveItemStackTo(itemstack1, 0, 26, false)) {
                if (index < 53 ? !this.moveItemStackTo(itemstack1, 53, this.slots.size(), true) : !this.moveItemStackTo(itemstack1, 26, 53, false)) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (itemstack1.getCount() == 0) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        if (index > 1 && index < 26) {
            this.removeEnchantment(itemStackToOperate);
        }
        return itemstack;
    }

    protected boolean moveItemStackTo(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        if (p_38904_.isStackable()) {
            while (!p_38904_.isEmpty() && (p_38907_ ? i >= p_38905_ : i < p_38906_)) {
                ItemStack itemstack;
                Slot slot = (Slot)this.slots.get(i);
                if (slot.mayPlace(itemstack = slot.getItem()) && !itemstack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)p_38904_, (ItemStack)itemstack)) {
                    int k;
                    int j = itemstack.getCount() + p_38904_.getCount();
                    if (j <= (k = slot.getMaxStackSize(itemstack))) {
                        p_38904_.setCount(0);
                        itemstack.setCount(j);
                        slot.set(itemstack);
                        flag = true;
                    } else if (itemstack.getCount() < k) {
                        p_38904_.shrink(k - itemstack.getCount());
                        itemstack.setCount(k);
                        slot.set(itemstack);
                        flag = true;
                    }
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        if (!p_38904_.isEmpty()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (p_38907_ ? i >= p_38905_ : i < p_38906_) {
                Slot slot1 = (Slot)this.slots.get(i);
                ItemStack itemstack1 = slot1.getItem();
                if (itemstack1.isEmpty() && slot1.mayPlace(p_38904_)) {
                    int l = slot1.getMaxStackSize(p_38904_);
                    slot1.setByPlayer(p_38904_.split(Math.min(p_38904_.getCount(), l)));
                    slot1.setChanged();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    public void removed(@NotNull Player playerIn) {
        super.removed(playerIn);
        if (playerIn instanceof ServerPlayer) {
            playerIn.getInventory().placeItemBackInInventory(this.itemHandler.getStackInSlot(0));
        }
    }

    public List<EnchantmentInstance> getEnchantmentInstanceFromEnchantedBook(ItemStack enchantedBookItemStack) {
        DataComponentType componentType = EnchantmentHelper.getComponentType((ItemStack)enchantedBookItemStack);
        ItemEnchantments componentMap = (ItemEnchantments)enchantedBookItemStack.getComponents().get(componentType);
        ArrayList<EnchantmentInstance> enchantmentOfBook = new ArrayList<EnchantmentInstance>();
        for (Object2IntMap.Entry entry : componentMap.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int enchantmentLevel = entry.getIntValue();
            enchantmentOfBook.add(new EnchantmentInstance(Holder.direct((Object)enchantment), enchantmentLevel));
        }
        return enchantmentOfBook;
    }

    public boolean checkCanPlaceEnchantedBook(ItemStack stack) {
        ItemEnchantments itemEnchantments = (ItemEnchantments)stack.get(EnchantmentHelper.getComponentType((ItemStack)stack));
        ItemStack itemToEnchant = this.itemHandler.getStackInSlot(0);
        ItemEnchantments itemEnchantmentsOnTool = (ItemEnchantments)itemToEnchant.get(EnchantmentHelper.getComponentType((ItemStack)itemToEnchant));
        if (itemEnchantmentsOnTool == null) {
            return true;
        }
        for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
            int maxLevel;
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int enchantmentLevel = entry.getIntValue();
            int enchantmentLevelOnTool = itemEnchantmentsOnTool.getLevel((Holder)entry.getKey());
            if (enchantmentLevelOnTool + enchantmentLevel <= (maxLevel = enchantment.getMaxLevel())) continue;
            return false;
        }
        return true;
    }

    public void exportAllEnchantments() {
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        if (toolItemStack.getItem() == Items.ENCHANTED_BOOK) {
            this.entity.getInventory().placeItemBackInInventory(toolItemStack);
            this.itemHandler.setStackInSlot(0, ItemStack.EMPTY);
            this.world.playSound(null, this.boundBlockEntity.getWorldPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (!toolItemStack.isEmpty() && itemEnchantments != null && !itemEnchantments.isEmpty()) {
            ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
            ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
            for (Object2IntMap.Entry entry : itemEnchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                int enchantmentLevel = entry.getIntValue();
                Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                assert (enchantmentReference != null);
                mutable.set(enchantmentReference, 0);
                enchantedBook.enchant(enchantmentReference, enchantmentLevel);
            }
            toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
            this.entity.getInventory().placeItemBackInInventory(enchantedBook);
            this.world.playSound(null, this.boundBlockEntity.getWorldPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        this.clearCache();
        this.clearPage();
    }

    public void resetPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void nextPage() {
        if (this.currentPage < this.totalPage - 1) {
            this.turnPage(this.currentPage + 1);
        }
    }

    public void previousPage() {
        if (this.currentPage > 0) {
            this.turnPage(this.currentPage - 1);
        }
    }

    public void turnPage(int targetPage) {
        if (targetPage < 0 || targetPage >= this.totalPage) {
            return;
        }
        int indexOffset = this.currentPage * 24;
        for (int i = 0; i < 24; ++i) {
            int indexOfFullList = i + indexOffset;
            int indexOfSlot = i + 2;
            if (indexOfFullList >= this.enchantmentsOnCurrentTool.size()) continue;
            this.enchantmentsOnCurrentTool.set(indexOfFullList, this.itemHandler.getStackInSlot(indexOfSlot));
        }
        this.currentPage = targetPage;
        this.updateEnchantedBookSlots();
    }

    public void updateEnchantedBookSlots() {
        this.itemHandler.setStackInSlot(1, ItemStack.EMPTY.copy());
        int indexOffset = this.currentPage * 24;
        if (this.totalPage > 0) {
            for (int i = 0; i < 24; ++i) {
                int indexOfFullList = i + indexOffset;
                int indexOfSlot = i + 2;
                this.itemHandler.setStackInSlot(indexOfSlot, this.enchantmentsOnCurrentTool.get(indexOfFullList));
            }
        }
    }

    public void clearCache() {
        for (int i = 2; i < 26; ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        this.genEnchantedBookCache();
    }

    public void clearPage() {
        this.currentPage = 0;
        this.totalPage = 0;
    }

    public void genEnchantedBookCache() {
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        int currentTotalPage = 1;
        this.enchantmentsOnCurrentTool.clear();
        if (!toolItemStack.isEmpty()) {
            ItemEnchantments enchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
            currentTotalPage = Math.max((int)Math.ceil((double)enchantments.entrySet().size() / 24.0), 1);
            if (toolItemStack.is(Items.ENCHANTED_BOOK) && enchantments.entrySet().size() == 1) {
                Object2IntMap.Entry enchantmentObj = (Object2IntMap.Entry)enchantments.entrySet().iterator().next();
                Enchantment enchantment = (Enchantment)((Holder)enchantmentObj.getKey()).value();
                int enchantmentLevel = enchantmentObj.getIntValue();
                if (enchantmentLevel > 1) {
                    ArrayList<Integer> enchantmentLevelList = new ArrayList<Integer>();
                    while (enchantmentLevel > 0) {
                        if (enchantmentLevel == 2) {
                            enchantmentLevelList.add(1);
                            enchantmentLevel = 0;
                            continue;
                        }
                        int levelToAdd = (int)Math.ceil((double)enchantmentLevel / 2.0);
                        enchantmentLevelList.add(levelToAdd);
                        enchantmentLevel -= levelToAdd;
                    }
                    for (Integer level : enchantmentLevelList) {
                        ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                        Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                        assert (enchantmentReference != null);
                        enchantedBook.enchant(enchantmentReference, level.intValue());
                        this.enchantmentsOnCurrentTool.add(enchantedBook);
                    }
                }
            } else if (!toolItemStack.is(Items.ENCHANTED_BOOK) || enchantments.entrySet().size() > 1) {
                for (Object2IntMap.Entry entry : enchantments.entrySet()) {
                    Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
                    Integer enchantmentLevel = entry.getValue();
                    ItemStack enchantedBook = new ItemStack((ItemLike)Items.ENCHANTED_BOOK);
                    Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, enchantment);
                    assert (enchantmentReference != null);
                    enchantedBook.enchant(enchantmentReference, enchantmentLevel.intValue());
                    this.enchantmentsOnCurrentTool.add(enchantedBook);
                }
            }
        } else {
            currentTotalPage = 0;
        }
        int totalSlots = currentTotalPage * 24;
        while (this.enchantmentsOnCurrentTool.size() < totalSlots) {
            this.enchantmentsOnCurrentTool.add(ItemStack.EMPTY);
        }
        this.totalPage = currentTotalPage;
    }

    public IdMap<Holder<Enchantment>> getAllRegisteredEnchantments() {
        Registry fullEnchantmentList = this.world.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        return fullEnchantmentList.asHolderIdMap();
    }

    public void addEnchantment(ItemStack itemStack, int slotIndex) {
        this.addEnchantment(itemStack, slotIndex, false);
    }

    public void addEnchantment(ItemStack itemStackToPut, int slotIndex, boolean forceRegenerateEnchantedBookStore) {
        List<EnchantmentInstance> enchantmentInstances = this.getEnchantmentInstanceFromEnchantedBook(itemStackToPut);
        boolean regenerateEnchantedBookStore = false;
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments enchantmentsOnTool = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        int sourceEnchantmentCount = enchantmentsOnTool.entrySet().size();
        IdMap<Holder<Enchantment>> allRegisteredEnchantments = this.getAllRegisteredEnchantments();
        HashMap<Integer, EnchantmentInstance> resultEnchantmentMap = new HashMap<Integer, EnchantmentInstance>();
        for (Object2IntMap.Entry entry : enchantmentsOnTool.entrySet()) {
            Enchantment enchantment = (Enchantment)((Holder)entry.getKey()).value();
            int enchantmentId = allRegisteredEnchantments.getId((Object)Holder.direct((Object)enchantment));
            int enchantmentLevel = entry.getIntValue();
            EnchantmentInstance enchantmentInstance = new EnchantmentInstance(Holder.direct((Object)enchantment), enchantmentLevel);
            resultEnchantmentMap.put(enchantmentId, enchantmentInstance);
        }
        for (EnchantmentInstance enchantmentInstance : enchantmentInstances) {
            int enchantmentId = allRegisteredEnchantments.getId((Object)enchantmentInstance.enchantment());
            if (resultEnchantmentMap.containsKey(enchantmentId)) {
                regenerateEnchantedBookStore = true;
                resultEnchantmentMap.put(enchantmentId, new EnchantmentInstance(enchantmentInstance.enchantment(), ((EnchantmentInstance)resultEnchantmentMap.get(enchantmentId)).level() + enchantmentInstance.level()));
                continue;
            }
            resultEnchantmentMap.put(enchantmentId, new EnchantmentInstance(enchantmentInstance.enchantment(), enchantmentInstance.level()));
        }
        int resultEnchantmentsCount = resultEnchantmentMap.size();
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        for (EnchantmentInstance enchantmentInstance : resultEnchantmentMap.values().stream().toList()) {
            Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, (Enchantment)enchantmentInstance.enchantment().value());
            assert (enchantmentReference != null);
            mutable.set(enchantmentReference, enchantmentInstance.level());
        }
        toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
        this.genEnchantedBookCache();
        this.updateEnchantedBookSlots();
        this.world.playSound(null, this.boundBlockEntity.getWorldPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    public boolean removeEnchantment(ItemStack itemStackToRemove) {
        List<EnchantmentInstance> enchantmentInstances = this.getEnchantmentInstanceFromEnchantedBook(itemStackToRemove);
        ItemStack toolItemStack = this.itemHandler.getStackInSlot(0);
        ItemEnchantments itemEnchantments = (ItemEnchantments)toolItemStack.get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack));
        ItemEnchantments.Mutable mutable = new ItemEnchantments.Mutable(itemEnchantments);
        for (EnchantmentInstance enchantmentInstance : enchantmentInstances) {
            Holder.Reference<Enchantment> enchantmentReference = EnchantmentUtils.translateEnchantment(this.world, (Enchantment)enchantmentInstance.enchantment().value());
            int enchantmentLevelSource = ((ItemEnchantments)this.itemHandler.getStackInSlot(0).get(EnchantmentHelper.getComponentType((ItemStack)toolItemStack))).entrySet().stream().filter(entry -> enchantmentReference.getKey().registryKey() == ((Holder)entry.getKey()).getKey().registryKey()).findFirst().get().getIntValue();
            int enchantmentLevelToMinus = enchantmentInstance.level();
            assert (enchantmentReference != null);
            mutable.set(enchantmentReference, enchantmentLevelSource - enchantmentLevelToMinus);
        }
        toolItemStack.set(EnchantmentHelper.getComponentType((ItemStack)toolItemStack), (Object)mutable.toImmutable());
        int resultPageSize = Math.max((int)Math.ceil((double)mutable.keySet().size() / 24.0), 1);
        boolean hasRegenerated = false;
        if (toolItemStack.is(Items.ENCHANTED_BOOK) && mutable.keySet().size() == 1 || this.totalPage != resultPageSize) {
            this.genEnchantedBookCache();
            this.currentPage = Math.min(this.currentPage, this.totalPage - 1);
            hasRegenerated = true;
        }
        this.updateEnchantedBookSlots();
        this.world.playSound(null, this.boundBlockEntity.getWorldPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
        return hasRegenerated;
    }

    public void initMenu() {
        this.clearPage();
        this.clearCache();
        this.enchantmentsOnCurrentTool.clear();
    }
}

