/*
 * Decompiled with CFR 0.152.
 */
package net.mgstudios.els.client.mixin;

import net.mgstudios.els.client.util.BackgroundRenderer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LevelLoadingScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.LevelLoadTracker;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={LevelLoadingScreen.class})
public class LevelLoadingScreenMixin
extends Screen {
    @Shadow
    private LevelLoadTracker loadTracker;
    @Unique
    private long lastNarration = -1L;

    private LevelLoadingScreenMixin() {
        super(null);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        long l = Util.getMillis();
        if (l - this.lastNarration > 2000L) {
            this.lastNarration = l;
            this.triggerImmediateNarration(true);
        }
        BackgroundRenderer.renderBackground(guiGraphics, this.width, this.height);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.getBarTexture(), 5, Minecraft.getInstance().getWindow().getGuiScaledHeight() - 30, 0.0f, 0.0f, 75, 25, 75, 25);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)"loading.progress", (Object[])new Object[]{(int)(this.loadTracker.serverProgress() * 100.0f)}), 85, this.height - 18, ARGB.color((float)1.0f, (int)-1));
    }

    @Unique
    private ResourceLocation getBarTexture() {
        int percentage = (int)(this.loadTracker.serverProgress() * 100.0f);
        int fillLevel = (percentage + 10) / 10;
        if (fillLevel == 11) {
            --fillLevel;
        }
        return ResourceLocation.fromNamespaceAndPath((String)"els", (String)"textures/bar/bar_%s.png".formatted(fillLevel));
    }
}

