/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.components.experience;

import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.components.experience.IExperienceDataComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import net.minecraft.class_2487;
import net.minecraft.class_2791;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0017\u001a\u0004\b\u0018\u0010\u0019R\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001aR\u0016\u0010\u0007\u001a\u00020\u00068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lcom/bibireden/playerex/components/experience/ExperienceDataComponent;", "Lcom/bibireden/playerex/components/experience/IExperienceDataComponent;", "Lnet/minecraft/class_2791;", "chunk", "", "_ticks", "", "_expNegationFactor", "<init>", "(Lnet/minecraft/class_2791;IF)V", "amount", "", "updateExperienceNegationFactor", "(I)Z", "", "resetExperienceNegationFactor", "()V", "Lnet/minecraft/class_2487;", "tag", "readFromNbt", "(Lnet/minecraft/class_2487;)V", "writeToNbt", "serverTick", "Lnet/minecraft/class_2791;", "getChunk", "()Lnet/minecraft/class_2791;", "I", "F", "playerex-directors-cut"})
public final class ExperienceDataComponent
implements IExperienceDataComponent {
    @NotNull
    private final class_2791 chunk;
    private int _ticks;
    private float _expNegationFactor;

    public ExperienceDataComponent(@NotNull class_2791 chunk, int _ticks, float _expNegationFactor) {
        Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
        this.chunk = chunk;
        this._ticks = _ticks;
        this._expNegationFactor = _expNegationFactor;
    }

    public /* synthetic */ ExperienceDataComponent(class_2791 class_27912, int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        if ((n2 & 4) != 0) {
            f = 1.0f;
        }
        this(class_27912, n, f);
    }

    @NotNull
    public final class_2791 getChunk() {
        return this.chunk;
    }

    @Override
    public boolean updateExperienceNegationFactor(int amount) {
        if (Random.Default.nextFloat() > this._expNegationFactor) {
            return true;
        }
        int negFactor = PlayerEX.CONFIG.getAdvancedSettings().getExpNegationFactor();
        float dynamicMultiplier = (float)negFactor + (1.0f - (float)negFactor) * (1.0f - 0.1f * (float)amount);
        this._expNegationFactor = Math.max(this._expNegationFactor * dynamicMultiplier, 0.0f);
        this.chunk.method_12008(true);
        return false;
    }

    @Override
    public void resetExperienceNegationFactor() {
        PlayerEX.CONFIG.getAdvancedSettings().setExpNegationFactor(1);
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this._expNegationFactor = tag.method_10583("exp_factor");
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10548("exp_factor", this._expNegationFactor);
    }

    public void serverTick() {
        if (this._expNegationFactor == 1.0f) {
            return;
        }
        if (this._ticks < PlayerEX.CONFIG.getAdvancedSettings().getRestorativeForceTicks()) {
            int n = this._ticks;
            this._ticks = n + 1;
        } else {
            this._ticks = 0;
            this._expNegationFactor = Math.min(this._expNegationFactor * (float)PlayerEX.CONFIG.getAdvancedSettings().getRestorativeForceMultiplier(), 1.0f);
            this.chunk.method_12008(true);
        }
    }
}

