/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.mixin;

import com.bibireden.data_attributes.api.item.ItemFields;
import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.PlayerEXTags;
import com.bibireden.playerex.config.PlayerEXConfigModel;
import com.bibireden.playerex.ext.ItemStackKt;
import com.bibireden.playerex.util.PlayerEXUtil;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.fabric_extras.ranged_weapon.api.EntityAttributes_RangedWeapon;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1799.class})
abstract class ItemStackMixin {
    ItemStackMixin() {
    }

    @Shadow
    public abstract boolean method_7970(int var1, class_5819 var2, @Nullable class_3222 var3);

    @Shadow
    public abstract class_2487 method_7948();

    @Inject(method={"use(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/player/Player;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResultHolder;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventUse(class_1937 level, class_1657 player, class_1268 usedHand, CallbackInfoReturnable<class_1271<class_1799>> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (PlayerEXUtil.isBroken(stack)) {
            cir.setReturnValue((Object)class_1271.method_22431((Object)stack));
        }
    }

    @Inject(method={"useOn(Lnet/minecraft/world/item/context/UseOnContext;)Lnet/minecraft/world/InteractionResult;"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventUseOnBlock(class_1838 context, CallbackInfoReturnable<class_1269> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (PlayerEXUtil.isBroken(stack)) {
            cir.setReturnValue((Object)class_1269.field_5814);
        }
    }

    @Inject(method={"hurt(ILnet/minecraft/util/RandomSource;Lnet/minecraft/server/level/ServerPlayer;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    public void preventDamage(int amount, class_5819 random, class_3222 user, CallbackInfoReturnable<Boolean> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (PlayerEXUtil.isBroken(stack)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"hurtAndBreak(ILnet/minecraft/world/entity/LivingEntity;Ljava/util/function/Consumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;shrink(I)V")}, cancellable=true)
    public <T extends class_1309> void preventBreak(int amount, T entity, Consumer<T> onBroken, CallbackInfo ci) {
        class_1799 stack = (class_1799)this;
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled() || PlayerEXUtil.isArmor(stack) && PlayerEX.CONFIG.getArmorLevelingSettings().getDestroyCurseOfBinding() && class_1890.method_8224((class_1799)stack)) {
            return;
        }
        if (stack.method_41409().method_40220(PlayerEXTags.UNBREAKABLE_ITEMS)) {
            if (!PlayerEXUtil.isBroken(stack)) {
                class_2487 tag = stack.method_7948();
                int timesBroken = ItemStackKt.getTimesBroken(stack);
                if (!PlayerEX.CONFIG.getFeatureSettings().getInfiniteItemBreakingEnabled()) {
                    ItemStackKt.setTimesBroken(stack, timesBroken + 1);
                }
                if (ItemStackKt.getTimesBroken(stack) > PlayerEX.CONFIG.getFeatureSettings().getTimesItemCanBreak()) {
                    return;
                }
                tag.method_10556("broken", true);
                if (PlayerEX.CONFIG.getFeatureSettings().getMessageOnItemBreak()) {
                    if (PlayerEXUtil.isArmor(stack)) {
                        entity.method_43496((class_2561)class_2561.method_43469((String)"playerex.armor.broke", (Object[])new Object[]{stack.method_7954()}).method_27692(class_124.field_1061));
                    } else {
                        entity.method_43496((class_2561)class_2561.method_43469((String)"playerex.item.broke", (Object[])new Object[]{stack.method_7954()}).method_27692(class_124.field_1061));
                    }
                }
                stack.method_7980(tag);
            }
            ci.cancel();
        }
    }

    @Inject(method={"setDamageValue(I)V"}, at={@At(value="HEAD")})
    public void removeBrokenOnRepair(int damage, CallbackInfo ci) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        if (PlayerEXUtil.isBroken(stack) && damage < stack.method_7919()) {
            class_2487 tag = stack.method_7948();
            tag.method_10556("broken", false);
            stack.method_7980(tag);
        }
    }

    @Inject(method={"getAttributeModifiers(Lnet/minecraft/world/entity/EquipmentSlot;)Lcom/google/common/collect/Multimap;"}, at={@At(value="RETURN")}, cancellable=true)
    public void modifyAttributeModifiers(class_1304 slot, CallbackInfoReturnable<Multimap<class_1320, class_1322>> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) {
            return;
        }
        class_1799 stack = (class_1799)this;
        HashMultimap hashmap = HashMultimap.create((Multimap)((Multimap)cir.getReturnValue()));
        if (PlayerEX.CONFIG.getWeaponLevelingSettings().getEnabled() && PlayerEXUtil.isWeapon(stack)) {
            PlayerEXUtil.addToModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23721, (double)this.getLevel() * PlayerEX.CONFIG.getWeaponLevelingSettings().getDamagePerLevel());
            if (hashmap.containsKey((Object)EntityAttributes_RangedWeapon.DAMAGE.attribute)) {
                PlayerEXUtil.addToModifier((Multimap<class_1320, class_1322>)hashmap, EntityAttributes_RangedWeapon.DAMAGE.attribute, (double)this.getLevel() * PlayerEX.CONFIG.getWeaponLevelingSettings().getDamagePerLevel());
            }
        }
        if (PlayerEX.CONFIG.getArmorLevelingSettings().getEnabled() && PlayerEXUtil.isArmor(stack)) {
            PlayerEXUtil.addToModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23724, (double)this.getLevel() * PlayerEX.CONFIG.getArmorLevelingSettings().getArmorPerLevel());
        }
        if (PlayerEXUtil.isBroken(stack)) {
            PlayerEXUtil.removeModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23724);
            PlayerEXUtil.removeModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23725);
            PlayerEXUtil.removeModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23718);
            PlayerEXUtil.removeModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23721);
            PlayerEXUtil.removeModifier((Multimap<class_1320, class_1322>)hashmap, class_5134.field_23723);
        }
        cir.setReturnValue((Object)hashmap);
    }

    @Unique
    private double playerex$modifyValue(double val, @Nullable class_1657 player, class_1320 attribute, UUID uuid) {
        if (player == null || PlayerEX.CONFIG.getVisualSettings().getTooltip() == PlayerEXConfigModel.Tooltip.Default) {
            return val;
        }
        double valSubBase = val - player.method_26826(attribute);
        class_1324 instance = player.method_5996(attribute);
        if (instance == null) {
            return val;
        }
        class_1322 modifier = instance.method_6199(uuid);
        double value = player.method_26825(attribute) + valSubBase;
        if (modifier != null) {
            value -= modifier.method_6186();
        }
        return PlayerEX.CONFIG.getVisualSettings().getTooltip() == PlayerEXConfigModel.Tooltip.Vanilla ? valSubBase : value;
    }

    @Unique
    private String playerex$value(double e, Map.Entry<class_1320, class_1322> entry, class_1322 modifier) {
        if (modifier.method_6182() != class_1322.class_1323.field_6328) {
            return class_1799.field_8029.format(e);
        }
        return class_1799.field_8029.format(e);
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=1), ordinal=0)
    private double playerex$modifyAttackDamage(double original, class_1657 player) {
        return this.playerex$modifyValue(original, player, class_5134.field_23721, ItemFields.attackDamageModifierID());
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=3), ordinal=0)
    private double playerex$modifyAttackSpeed(double original, class_1657 player) {
        return this.playerex$modifyValue(original, player, class_5134.field_23723, ItemFields.attackDamageModifierID());
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=1), ordinal=0)
    private boolean playerex$flagAttackDamage(boolean original) {
        return PlayerEX.CONFIG.getVisualSettings().getTooltip() != PlayerEXConfigModel.Tooltip.Vanilla && original;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=2), ordinal=0)
    private boolean playerex$flagAttackSpeed(boolean original) {
        return PlayerEX.CONFIG.getVisualSettings().getTooltip() != PlayerEXConfigModel.Tooltip.Vanilla && original;
    }

    @ModifyVariable(method={"getTooltipLines"}, at=@At(value="STORE", ordinal=1), ordinal=1)
    private double playerex$modifyAdditionAttributeKnockback(double original) {
        return original / 10.0;
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=7, shift=At.Shift.AFTER)})
    private void playerex$insertModifierEqualsTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> info, @Local List<class_2561> list, @Local Map.Entry<class_1320, class_1322> entry, @Local class_1322 modifier, @Local(ordinal=1) double e) {
        list.set(list.size() - 1, (class_2561)class_2561.method_43470((String)" ").method_10852((class_2561)class_2561.method_43469((String)("attribute.modifier.equals." + modifier.method_6182().method_6191()), (Object[])new Object[]{this.playerex$value(e, entry, modifier), class_2561.method_43471((String)entry.getKey().method_26830())})).method_27692(class_124.field_1077));
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=8, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void playerex$insertModifierPlusTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> info, List<class_2561> list, class_5250 arg3, int arg4, class_1304[] arg5, int arg6, int arg7, class_1304 arg8, Multimap<?, ?> arg9, Iterator<?> arg10, Map.Entry<class_1320, class_1322> entry, class_1322 entityAttributeModifier, double arg13, double e) {
        list.set(list.size() - 1, (class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + entityAttributeModifier.method_6182().method_6191()), (Object[])new Object[]{this.playerex$value(e, entry, entityAttributeModifier), class_2561.method_43471((String)entry.getKey().method_26830())}).method_27692(class_124.field_1078));
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=9, shift=At.Shift.AFTER)})
    private void playerex$insertModifierTakeTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> info, @Local List<class_2561> list, @Local Map.Entry<class_1320, class_1322> entry, @Local class_1322 modifier, @Local(ordinal=1) double e) {
        list.set(list.size() - 1, (class_2561)class_2561.method_43469((String)("attribute.modifier.take." + modifier.method_6182().method_6191()), (Object[])new Object[]{this.playerex$value(e, entry, modifier), class_2561.method_43471((String)entry.getKey().method_26830())}).method_27692(class_124.field_1061));
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0, shift=At.Shift.AFTER)})
    private void playerex$insertBrokenTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> info, @Local List<class_2561> list) {
        class_1799 itemStack = (class_1799)this;
        if (PlayerEXUtil.isBroken(itemStack)) {
            if (PlayerEX.CONFIG.getFeatureSettings().getInfiniteItemBreakingEnabled()) {
                list.add((class_2561)class_2561.method_43471((String)"playerex.broken").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
            } else {
                list.add((class_2561)class_2561.method_43469((String)"playerex.broken.numbered", (Object[])new Object[]{ItemStackKt.getTimesBroken(itemStack), PlayerEX.CONFIG.getFeatureSettings().getTimesItemCanBreak()}).method_27692(class_124.field_1061).method_27692(class_124.field_1067));
            }
        }
    }

    @Unique
    private int getLevel() {
        class_1799 itemStack = (class_1799)this;
        return itemStack.method_7985() ? itemStack.method_7969().method_10550("Level") : 0;
    }

    @Unique
    private int getXp() {
        class_1799 itemStack = (class_1799)this;
        return itemStack.method_7985() ? itemStack.method_7969().method_10550("Experience") : 0;
    }

    @Unique
    private double getReduction() {
        return Math.min((double)this.getLevel() * PlayerEX.CONFIG.getArmorLevelingSettings().getReductionPerLevel(), PlayerEX.CONFIG.getArmorLevelingSettings().getMaxReduction());
    }

    @Inject(method={"getTooltipLines"}, at={@At(value="INVOKE", target="Ljava/util/List;add(Ljava/lang/Object;)Z", ordinal=0, shift=At.Shift.AFTER)})
    private void playerex$insertLevelTooltip(class_1657 player, class_1836 context, CallbackInfoReturnable<List<class_2561>> info, @Local List<class_2561> list) {
        class_1799 itemStack = (class_1799)this;
        if (PlayerEXUtil.isLevelable(itemStack)) {
            list.add((class_2561)class_2561.method_43469((String)"playerex.item.level", (Object[])new Object[]{this.getLevel(), PlayerEXUtil.getMaxLevel(itemStack)}));
            list.add((class_2561)class_2561.method_43469((String)"playerex.item.experience", (Object[])new Object[]{this.getXp(), PlayerEXUtil.getRequiredXpForNextLevel(itemStack)}));
            if (PlayerEXUtil.isArmor(itemStack)) {
                list.add((class_2561)class_2561.method_43469((String)"playerex.item.reduction", (Object[])new Object[]{String.format("%.2f", this.getReduction())}));
            }
        }
    }
}

