/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.registry;

import com.bibireden.playerex.ui.components.MenuComponent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kotlin.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class PlayerEXMenuRegistry {
    @NotNull
    private static final ArrayList<Pair<class_2960, Class<? extends MenuComponent>>> ENTRIES = new ArrayList();
    @NotNull
    private static final HashMap<String, Integer> PRIORITY_ORDER = new HashMap();

    public static void register(class_2960 id, @NotNull Class<? extends MenuComponent> menu) {
        Pair pair = new Pair((Object)id, menu);
        Integer insertingPriority = PRIORITY_ORDER.get(id.method_12836());
        if (!ENTRIES.isEmpty() && insertingPriority != null) {
            int size = ENTRIES.size();
            for (int i = 0; i < size; ++i) {
                Pair<class_2960, Class<? extends MenuComponent>> entry = ENTRIES.get(i);
                Integer priority = PRIORITY_ORDER.get(((class_2960)entry.getFirst()).method_12836());
                if (priority != null && priority <= insertingPriority) continue;
                ENTRIES.add(i, (Pair<class_2960, Class<? extends MenuComponent>>)pair);
                return;
            }
        }
        ENTRIES.add((Pair<class_2960, Class<? extends MenuComponent>>)pair);
    }

    @NotNull
    public static List<Pair<class_2960, Class<? extends MenuComponent>>> get() {
        return ENTRIES;
    }

    @NotNull
    public static List<class_2960> getIds() {
        return ENTRIES.stream().map(Pair::component1).toList();
    }

    @NotNull
    public static List<Class<? extends MenuComponent>> getComponents() {
        return ENTRIES.stream().map(Pair::component2).collect(Collectors.toUnmodifiableList());
    }

    static {
        PRIORITY_ORDER.put("playerex", 0);
        PRIORITY_ORDER.put("relicex", 1);
        PRIORITY_ORDER.put("wizardex", 2);
    }
}

