/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.util;

import com.bibireden.data_attributes.api.util.Maths;
import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.PlayerEXTags;
import com.bibireden.playerex.ext.ItemStackKt;
import com.bibireden.playerex.ext.PlayerEntityKt;
import com.bibireden.playerex.util.PlayerEXUtil;
import com.google.common.collect.Multimap;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1753;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_2487;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import net.objecthunter.exp4j.function.Function;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000_\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\n*\u00011\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0003\u00a2\u0006\u0004\b\b\u0010\u0006J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u000e\u0010\u0014J\u0017\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0015J\u0017\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0015J\u0017\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0017\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b\u001c\u0010\u001aJ+\u0010#\u001a\u00020\"2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\u0006\u0010!\u001a\u00020\u001eH\u0007\u00a2\u0006\u0004\b#\u0010$J3\u0010&\u001a\u00020\"2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001d2\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0012H\u0007\u00a2\u0006\u0004\b(\u0010\u001aJ'\u0010,\u001a\u00020\"2\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\r2\u0006\u0010+\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b,\u0010-R\u0014\u0010/\u001a\u00020.8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0014\u00102\u001a\u0002018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0014\u00105\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u0010\u0006R\u0014\u00107\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\u0006R\u0014\u00109\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b8\u0010\u0006\u00a8\u0006:"}, d2={"Lcom/bibireden/playerex/util/PlayerEXUtil;", "", "<init>", "()V", "Lnet/objecthunter/exp4j/Expression;", "createExpression", "()Lnet/objecthunter/exp4j/Expression;", "createWeaponExpression", "createArmorExpression", "Lnet/minecraft/class_1657;", "player", "", "target", "", "getRequiredXpForLevel", "(Lnet/minecraft/class_1657;D)I", "getRequiredXpForNextLevel", "(Lnet/minecraft/class_1657;)I", "Lnet/minecraft/class_1799;", "item", "(Lnet/minecraft/class_1799;I)I", "(Lnet/minecraft/class_1799;)I", "getMaxLevel", "stack", "", "isBroken", "(Lnet/minecraft/class_1799;)Z", "isWeapon", "isArmor", "Lcom/google/common/collect/Multimap;", "Lnet/minecraft/class_1320;", "Lnet/minecraft/class_1322;", "multimap", "attribute", "", "removeModifier", "(Lcom/google/common/collect/Multimap;Lnet/minecraft/class_1320;)V", "amount", "addToModifier", "(Lcom/google/common/collect/Multimap;Lnet/minecraft/class_1320;D)V", "isLevelable", "itemStack", "xpToAdd", "maxLevel", "levelItem", "(Lnet/minecraft/class_1799;II)V", "", "VARIABLE", "Ljava/lang/String;", "com/bibireden/playerex/util/PlayerEXUtil.STAIRCASE_FUNCTION.1", "STAIRCASE_FUNCTION", "Lcom/bibireden/playerex/util/PlayerEXUtil$STAIRCASE_FUNCTION$1;", "getExpression", "expression", "getWeaponExpression", "weaponExpression", "getArmorExpression", "armorExpression", "playerex-directors-cut"})
public final class PlayerEXUtil {
    @NotNull
    public static final PlayerEXUtil INSTANCE = new PlayerEXUtil();
    @NotNull
    private static final String VARIABLE = "x";
    @NotNull
    private static final STAIRCASE_FUNCTION.1 STAIRCASE_FUNCTION = new Function(){

        public double apply(double ... args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            return Math.min(Maths.stairs((double)args[0], (double)args[1], (double)args[2], (double)args[3], (double)args[4]), args[5]);
        }
    };

    private PlayerEXUtil() {
    }

    private final Expression getExpression() {
        return PlayerEXUtil.createExpression();
    }

    @JvmStatic
    private static final Expression createExpression() {
        Expression expression = new ExpressionBuilder(PlayerEX.CONFIG.getLevelingSettings().getLevelFormula()).variable(VARIABLE).function((Function)STAIRCASE_FUNCTION).build();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"build(...)");
        return expression;
    }

    private final Expression getWeaponExpression() {
        return PlayerEXUtil.createWeaponExpression();
    }

    @JvmStatic
    private static final Expression createWeaponExpression() {
        Expression expression = new ExpressionBuilder(PlayerEX.CONFIG.getWeaponLevelingSettings().getFormula()).variable(VARIABLE).build();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"build(...)");
        return expression;
    }

    private final Expression getArmorExpression() {
        return PlayerEXUtil.createArmorExpression();
    }

    @JvmStatic
    private static final Expression createArmorExpression() {
        Expression expression = new ExpressionBuilder(PlayerEX.CONFIG.getArmorLevelingSettings().getFormula()).variable(VARIABLE).build();
        Intrinsics.checkNotNullExpressionValue((Object)expression, (String)"build(...)");
        return expression;
    }

    @JvmStatic
    public static final int getRequiredXpForLevel(@NotNull class_1657 player, double target) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        int steps = (int)(target - PlayerEntityKt.getLevel(player));
        if (steps <= 0) {
            return 0;
        }
        int accumulator = 0;
        int x = 1;
        if (x <= steps) {
            while (true) {
                double k = (double)steps + PlayerEntityKt.getLevel(player);
                accumulator += (int)Math.abs(Math.rint(INSTANCE.getExpression().setVariable(VARIABLE, k).evaluate()));
                if (x == steps) break;
                ++x;
            }
        }
        return accumulator;
    }

    @JvmStatic
    public static final int getRequiredXpForNextLevel(@NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return PlayerEXUtil.getRequiredXpForLevel(player, PlayerEntityKt.getLevel(player) + 1.0);
    }

    @JvmStatic
    public static final int getRequiredXpForLevel(@NotNull class_1799 item, int target) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (target <= ItemStackKt.getLevel(item)) {
            return 0;
        }
        int acc = 0;
        int x = ItemStackKt.getLevel(item) + 1;
        if (x <= target) {
            while (true) {
                if (PlayerEXUtil.isWeapon(item)) {
                    acc += (int)Math.abs(Math.rint(INSTANCE.getWeaponExpression().setVariable(VARIABLE, (double)x).evaluate()));
                } else if (PlayerEXUtil.isArmor(item)) {
                    acc += (int)Math.abs(Math.rint(INSTANCE.getArmorExpression().setVariable(VARIABLE, (double)x).evaluate()));
                }
                if (x == target) break;
                ++x;
            }
        }
        return acc;
    }

    @JvmStatic
    public static final int getRequiredXpForNextLevel(@NotNull class_1799 item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return PlayerEXUtil.getRequiredXpForLevel(item, ItemStackKt.getLevel(item) + 1);
    }

    @JvmStatic
    public static final int getMaxLevel(@NotNull class_1799 item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return PlayerEXUtil.isWeapon(item) ? PlayerEX.CONFIG.getWeaponLevelingSettings().getMaxLevel() : (PlayerEXUtil.isArmor(item) ? PlayerEX.CONFIG.getArmorLevelingSettings().getMaxLevel() : 0);
    }

    @JvmStatic
    public static final boolean isBroken(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (stack.method_7969() != null) {
            class_2487 class_24872 = stack.method_7969();
            Intrinsics.checkNotNull((Object)class_24872);
            return class_24872.method_10577("broken");
        }
        return false;
    }

    @JvmStatic
    public static final boolean isWeapon(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return stack.method_7909() instanceof class_1753 || stack.method_7909() instanceof class_1764 || stack.method_7909() instanceof class_1829 || stack.method_31573(PlayerEXTags.WEAPONS);
    }

    @JvmStatic
    public static final boolean isArmor(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        return (stack.method_7909() instanceof class_1738 || stack.method_31573(PlayerEXTags.ARMOR)) && !stack.method_31573(PlayerEXTags.ARMOR_BLACKLIST);
    }

    @JvmStatic
    public static final void removeModifier(@NotNull Multimap<class_1320, class_1322> multimap, @NotNull class_1320 attribute) {
        Intrinsics.checkNotNullParameter(multimap, (String)"multimap");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Optional optional = multimap.get((Object)attribute).stream().findFirst();
        if (optional.isPresent()) {
            Object e = optional.get();
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            class_1322 modifier = (class_1322)e;
            class_1322 newModifier = new class_1322(modifier.method_6189(), modifier.method_6185(), 0.0, modifier.method_6182());
            multimap.remove((Object)attribute, (Object)modifier);
            multimap.put((Object)attribute, (Object)newModifier);
        }
    }

    @JvmStatic
    public static final void addToModifier(@NotNull Multimap<class_1320, class_1322> multimap, @NotNull class_1320 attribute, double amount) {
        Intrinsics.checkNotNullParameter(multimap, (String)"multimap");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Optional optional = multimap.get((Object)attribute).stream().findFirst();
        if (optional.isPresent()) {
            Object e = optional.get();
            Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
            class_1322 modifier = (class_1322)e;
            class_1322 newModifier = new class_1322(modifier.method_6189(), modifier.method_6185(), modifier.method_6186() + amount, modifier.method_6182());
            multimap.remove((Object)attribute, (Object)modifier);
            multimap.put((Object)attribute, (Object)newModifier);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    public static final boolean isLevelable(@NotNull class_1799 stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (PlayerEXUtil.isWeapon(stack)) {
            if (PlayerEX.CONFIG.getWeaponLevelingSettings().getEnabled()) return true;
        }
        if (!PlayerEXUtil.isArmor(stack)) return false;
        if (!PlayerEX.CONFIG.getArmorLevelingSettings().getEnabled()) return false;
        return true;
    }

    @JvmStatic
    public static final void levelItem(@NotNull class_1799 itemStack, int xpToAdd, int maxLevel) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"itemStack");
        if (PlayerEXUtil.isLevelable(itemStack)) {
            int nextLevel = PlayerEXUtil.getRequiredXpForNextLevel(itemStack);
            ItemStackKt.setXp(itemStack, ItemStackKt.getXp(itemStack) + xpToAdd);
            while (ItemStackKt.getXp(itemStack) >= nextLevel && ItemStackKt.getLevel(itemStack) < maxLevel) {
                ItemStackKt.setXp(itemStack, ItemStackKt.getXp(itemStack) - nextLevel);
                ItemStackKt.setLevel(itemStack, ItemStackKt.getLevel(itemStack) + 1);
                nextLevel = PlayerEXUtil.getRequiredXpForNextLevel(itemStack);
            }
        }
    }
}

