
package com.bibireden.playerex.config

import blue.endless.jankson.Jankson
import io.wispforest.owo.config.ConfigWrapper
import io.wispforest.owo.config.Option
import io.wispforest.owo.util.Observable
import kotlin.reflect.KProperty

class PlayerEXConfig private constructor(janksonBuilder: (Jankson.Builder) -> Unit) : ConfigWrapper<PlayerEXConfigModel>(PlayerEXConfigModel::class.java, janksonBuilder) {
    private val parentKey = Option.Key.ROOT
    
    constructor(): this({})
    
    companion object {
        fun createAndLoad(janksonBuilder: (Jankson.Builder) -> Unit = {}): PlayerEXConfig {
            return PlayerEXConfig(janksonBuilder).apply {
                load()
            }
        }
    }
    
    val levelingSettings = LevelingSettings(parentKey.child("levelingSettings"))
    
    val featureSettings = FeatureSettings(parentKey.child("featureSettings"))
    
    val lifecycleSettings = LifecycleSettings(parentKey.child("lifecycleSettings"))
    
    val advancedSettings = AdvancedSettings(parentKey.child("advancedSettings"))
    
    val weaponLevelingSettings = WeaponXpSettings(parentKey.child("weaponLevelingSettings"))
    
    val armorLevelingSettings = ArmorXpSettings(parentKey.child("armorLevelingSettings"))
    
    val visualSettings = VisualSettings(parentKey.child("visualSettings"))
    
    val soundSettings = SoundSettings(parentKey.child("soundSettings"))
    
    
    inner class LevelingSettings(parentKey: Option.Key) {
        
        var skillPointsPerLevelUp: kotlin.Int by optionForKey(parentKey.child("skillPointsPerLevelUp"))!!
        
        
        var levelFormula: kotlin.String by optionForKey(parentKey.child("levelFormula"))!!
        
        fun subscribeToLevelFormula(subscriber: (kotlin.String) -> Unit) {
            optionForKey<kotlin.String>(Option.Key("levelFormula"))!!.observe(subscriber)
        }
        
        
    }
    
    inner class FeatureSettings(parentKey: Option.Key) {
        
        var resetOnDeath: kotlin.Boolean by optionForKey(parentKey.child("resetOnDeath"))!!
        
        
        var itemBreakingEnabled: kotlin.Boolean by optionForKey(parentKey.child("itemBreakingEnabled"))!!
        
        
        var infiniteItemBreakingEnabled: kotlin.Boolean by optionForKey(parentKey.child("infiniteItemBreakingEnabled"))!!
        
        
        var timesItemCanBreak: kotlin.Int by optionForKey(parentKey.child("timesItemCanBreak"))!!
        
        
        var messageOnItemBreak: kotlin.Boolean by optionForKey(parentKey.child("messageOnItemBreak"))!!
        
        
        var disableUI: kotlin.Boolean by optionForKey(parentKey.child("disableUI"))!!
        
        
        
    }
    
    inner class LifecycleSettings(parentKey: Option.Key) {
        
        var healthRegeneration: com.bibireden.playerex.config.PlayerEXConfigModel.Lifecycle by optionForKey(parentKey.child("healthRegeneration"))!!
        
        
        
    }
    
    inner class AdvancedSettings(parentKey: Option.Key) {
        
        var restorativeForceTicks: kotlin.Int by optionForKey(parentKey.child("restorativeForceTicks"))!!
        
        
        var restorativeForceMultiplier: kotlin.Int by optionForKey(parentKey.child("restorativeForceMultiplier"))!!
        
        
        var expNegationFactor: kotlin.Int by optionForKey(parentKey.child("expNegationFactor"))!!
        
        
        
    }
    
    inner class WeaponXpSettings(parentKey: Option.Key) {
        
        var enabled: kotlin.Boolean by optionForKey(parentKey.child("enabled"))!!
        
        
        var damagePerLevel: kotlin.Double by optionForKey(parentKey.child("damagePerLevel"))!!
        
        
        var formula: kotlin.String by optionForKey(parentKey.child("formula"))!!
        
        
        var xpFromPassive: kotlin.Int by optionForKey(parentKey.child("xpFromPassive"))!!
        
        
        var xpFromHostile: kotlin.Int by optionForKey(parentKey.child("xpFromHostile"))!!
        
        
        var xpFromMiniboss: kotlin.Int by optionForKey(parentKey.child("xpFromMiniboss"))!!
        
        
        var xpFromBoss: kotlin.Int by optionForKey(parentKey.child("xpFromBoss"))!!
        
        
        var maxLevel: kotlin.Int by optionForKey(parentKey.child("maxLevel"))!!
        
        
        
    }
    
    inner class ArmorXpSettings(parentKey: Option.Key) {
        
        var enabled: kotlin.Boolean by optionForKey(parentKey.child("enabled"))!!
        
        
        var armorPerLevel: kotlin.Double by optionForKey(parentKey.child("armorPerLevel"))!!
        
        
        var reductionPerLevel: kotlin.Double by optionForKey(parentKey.child("reductionPerLevel"))!!
        
        
        var maxReduction: kotlin.Double by optionForKey(parentKey.child("maxReduction"))!!
        
        
        var formula: kotlin.String by optionForKey(parentKey.child("formula"))!!
        
        
        var xpFromPassive: kotlin.Int by optionForKey(parentKey.child("xpFromPassive"))!!
        
        
        var xpFromHostile: kotlin.Int by optionForKey(parentKey.child("xpFromHostile"))!!
        
        
        var xpFromMiniboss: kotlin.Int by optionForKey(parentKey.child("xpFromMiniboss"))!!
        
        
        var xpFromBoss: kotlin.Int by optionForKey(parentKey.child("xpFromBoss"))!!
        
        
        var maxLevel: kotlin.Int by optionForKey(parentKey.child("maxLevel"))!!
        
        
        var destroyCurseOfBinding: kotlin.Boolean by optionForKey(parentKey.child("destroyCurseOfBinding"))!!
        
        
        
    }
    
    inner class VisualSettings(parentKey: Option.Key) {
        
        var showLevelOnNameplates: kotlin.Boolean by optionForKey(parentKey.child("showLevelOnNameplates"))!!
        
        
        var nameplateColor: io.wispforest.owo.ui.core.Color by optionForKey(parentKey.child("nameplateColor"))!!
        
        
        var tooltip: com.bibireden.playerex.config.PlayerEXConfigModel.Tooltip by optionForKey(parentKey.child("tooltip"))!!
        
        
        
    }
    
    inner class SoundSettings(parentKey: Option.Key) {
        
        var levelUpVolume: kotlin.Int by optionForKey(parentKey.child("levelUpVolume"))!!
        
        
        var skillUpVolume: kotlin.Int by optionForKey(parentKey.child("skillUpVolume"))!!
        
        
        var refundVolume: kotlin.Int by optionForKey(parentKey.child("refundVolume"))!!
        
        
        
    }
    
}

private operator fun <T> Option<T>.getValue(hisRef: Any?, property: KProperty<*>): T = this.value()
private operator fun <T> Option<T>.setValue(hisRef: Any?, property: KProperty<*>, value: T): Unit = this.set(value)

