package com.bibireden.playerex.mixin;

import com.bibireden.data_attributes.api.DataAttributesAPI;
import com.bibireden.playerex.api.attribute.PlayerEXAttributes;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_3966;

@Mixin(class_1665.class)
public abstract class AbstractArrowMixin extends class_1676 {
    @Shadow public abstract void setCritArrow(boolean critical);

    @Shadow public abstract boolean isCritArrow();

    private AbstractArrowMixin(class_1299<? extends class_1676> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(method = "onHitEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/projectile/AbstractArrow;isCritArrow()Z"))
    private void playerex$onEntityHit(class_3966 entityHitResult, CallbackInfo info) {
        if (this.method_24921() instanceof class_1309 entity) {
            DataAttributesAPI.getValue(PlayerEXAttributes.RANGED_CRITICAL_CHANCE, entity).ifPresent((chance) ->
                this.setCritArrow(false)
            );
        }
    }

    @ModifyArg(method = "onHitEntity", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"))
    private float playerex$onEntityHit(float original) {
        if (this.method_24921() instanceof class_1309 entity) {
            final float damage = original;

            boolean isCritical = DataAttributesAPI.getValue(PlayerEXAttributes.RANGED_CRITICAL_CHANCE, entity)
                .map((chance) -> {
                    boolean shouldCritical = entity.getRandom().nextFloat() < chance;
                    this.setCritArrow(shouldCritical);
                    return shouldCritical;
                }
            ).orElse(this.isCritArrow());

            if (isCritical) {
                return DataAttributesAPI.getValue(PlayerEXAttributes.RANGED_CRITICAL_DAMAGE, entity)
                    .map((v) -> (float) (damage * (1.0 + (10.0 * v))))
                    .orElseGet(() -> {
                        final long offset = this.random.nextInt(Math.round(original) / 2 + 2);
                        return Math.min(offset + original, Integer.MAX_VALUE);
                    });
            }
        }
        return original;
    }
}
