package com.bibireden.playerex.mixin;

import com.bibireden.data_attributes.api.DataAttributesAPI;
import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.attribute.PlayerEXAttributes;
import com.llamalad7.mixinextras.sugar.Local;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_897;

@Mixin(class_897.class)
abstract class EntityRendererMixin<T extends class_1297> {
    @Unique
    private boolean playerex$shouldRenderLevel() { return PlayerEX.CONFIG.getVisualSettings().getShowLevelOnNameplates(); }

    @ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/entity/EntityRenderer;renderNameTag(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/network/chat/Component;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;I)V"), index = 1)
    private class_2561 playerex$renderLabelIfPresent(class_2561 text, @Local(argsOnly = true) class_1297 entity) {
        if (playerex$shouldRenderLevel() && entity instanceof class_1657 livingEntity) {
            Optional<Double> maybeLevel = DataAttributesAPI.getValue(PlayerEXAttributes.LEVEL, livingEntity);
            if (maybeLevel.isPresent()) {
                text = text.method_27661().method_27693(" ").method_10852(
                    class_2561.method_43469("playerex.ui.nameplate.level", maybeLevel.get().intValue())
                        .method_27694((style) -> style.method_27703(PlayerEX.CONFIG.getVisualSettings().getNameplateColor().rgb()))
                );
            }
        }
        return text;
    }
}
