package com.bibireden.playerex.mixin;

import com.bibireden.playerex.components.PlayerEXComponents;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1303.class)
public abstract class ExperienceOrbMixin extends class_1297 {
    public ExperienceOrbMixin(class_1299<?> entityType, class_1937 level) { super(entityType, level); }

    @Inject(method = "<init>(Lnet/minecraft/world/level/Level;DDDI)V", at = @At("TAIL"))
    private void playerex$init(class_1937 world, double x, double y, double z, int amount, CallbackInfo ci) {
        class_2338 pos = class_2338.method_49637(x, y, z);
        class_2791 chunk = world.method_22350(pos);
        PlayerEXComponents.EXPERIENCE_DATA.maybeGet(chunk).ifPresent(data -> {
            if (data.updateExperienceNegationFactor(amount)) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        });
    }
}
