package com.bibireden.playerex.mixin;

import com.bibireden.playerex.util.PlayerEXUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_332.class)
abstract class GuiGraphicsMixin {
    @Shadow
    abstract void innerBlit(class_2960 atlasLocation, int x1, int x2, int y1, int y2, int blitOffset, float minU, float maxU, float minV, float maxV, float red, float green, float blue, float alpha);

    @Shadow
    @Final
    private class_4587 pose;

    @Inject(method = "renderItem(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/item/ItemStack;IIII)V", at = @At(value = "TAIL"))
    public void renderBrokenItem(class_1309 entity, class_1937 level, class_1799 stack, int x, int y, int seed, int guiOffset, CallbackInfo ci) {
        if (PlayerEXUtil.isBroken(stack)) {
            this.pose.method_22903();
            int size = 8;
            this.pose.method_46416(15 - size, 1, 300);
            innerBlit(
                    new class_2960("playerex", "textures/gui/broken.png"),
                    x, x + size, y, y + size,
                    0, 0, 1, 0, 1,
                    1f, 1f, 1f, 1f);
            this.pose.method_22909();
        }
    }
}
