package com.bibireden.playerex.mixin;

import com.bibireden.data_attributes.api.DataAttributesAPI;
import com.bibireden.playerex.api.attribute.PlayerEXAttributes;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;

@Mixin(class_1661.class)
public abstract class InventoryMixin {
    @Shadow @Final public class_1657 player;

    @ModifyReturnValue(method = "getDestroySpeed", at = @At("RETURN"))
    private float playerex$getBlockBreakingSpeed(float original) {
        return DataAttributesAPI.getValue(PlayerEXAttributes.BREAKING_SPEED, this.player).map((v) -> original + v.floatValue() - 1.0F).orElse(original);
    }
}
