package com.bibireden.playerex.mixin;

import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.event.PlayerEntityEvents;
import com.bibireden.playerex.util.PlayerEXUtil;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(class_1657.class)
public abstract class PlayerMixin {
    @Inject(method = "attack(Lnet/minecraft/world/entity/Entity;)V", at = @At(value = "HEAD"), locals = LocalCapture.CAPTURE_FAILEXCEPTION, cancellable = true)
    public void preventAttack(class_1297 target, CallbackInfo ci) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) return;

        class_1657 player = (class_1657)(Object)this;
        // TODO: BetterCombat compat
        if (PlayerEXUtil.isBroken(player.method_6047())) {
            ci.cancel();
        }
    }

    @Inject(method = "interactOn(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/InteractionResult;", at = @At(value = "HEAD"), locals = LocalCapture.CAPTURE_FAILEXCEPTION, cancellable = true)
    public void preventInteract(class_1297 entityToInteractOn, class_1268 hand, CallbackInfoReturnable<class_1269> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) return;

        class_1657 player = (class_1657)(Object)this;
        if (PlayerEXUtil.isBroken(player.method_5998(hand))) {
            cir.setReturnValue(class_1269.field_5814);
        }
    }

    @Inject(method = "blockActionRestricted(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/GameType;)Z", at = @At(value = "HEAD"), locals = LocalCapture.CAPTURE_FAILEXCEPTION, cancellable = true)
    public void preventBreakBlock(class_1937 level, class_2338 pos, class_1934 gameMode, CallbackInfoReturnable<Boolean> cir) {
        if (!PlayerEX.CONFIG.getFeatureSettings().getItemBreakingEnabled()) return;

        class_1657 player = (class_1657)(Object)this;
        if (PlayerEXUtil.isBroken(player.method_6047())) {
            cir.setReturnValue(true);
        }
    }

    @ModifyVariable(method = "attack", at = @At("STORE"), name = "bl3", ordinal = 2)
    private boolean playerex$attack(boolean bl3, class_1297 target) {
        return PlayerEntityEvents.SHOULD_CRITICAL.invoker().shouldCritical((class_1657)(Object) this, target, bl3);
    }

    @ModifyVariable(method = "attack", at = @At(value = "STORE", ordinal = 2), name = "f", ordinal = 0)
    private float playerex$attack(float f, class_1297 target) {
        return PlayerEntityEvents.ON_CRITICAL.invoker().onCriticalDamage((class_1657) (Object) this, target, f);
    }
}
