package com.bibireden.playerex.mixin;

import com.bibireden.playerex.components.PlayerEXComponents;
import com.bibireden.playerex.components.player.PlayerDataComponent;
import com.bibireden.playerex.factory.ServerNetworkingFactory;
import com.bibireden.playerex.networking.types.NotificationType;
import com.bibireden.playerex.util.PlayerEXUtil;
import com.mojang.authlib.GameProfile;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3222.class)
public abstract class ServerPlayerMixin extends class_1657 {
    public ServerPlayerMixin(class_1937 level, class_2338 pos, float yRot, GameProfile gameProfile) {
        super(level, pos, yRot, gameProfile);
    }

    @Inject(method = "giveExperienceLevels", at = @At("TAIL"))
    private void playerex$giveExperienceLevels(int levels, CallbackInfo ci) {
        PlayerDataComponent component = (PlayerDataComponent) this.getComponent(PlayerEXComponents.PLAYER_DATA);

        if (this.field_7520 >= PlayerEXUtil.getRequiredXpForNextLevel(this)) {
            if (!component.isLevelUpNotified()) {
                component.setLevelUpNotified(true);
                ServerNetworkingFactory.notify(this, NotificationType.LevelUpAvailable);
            }
        }
        else {
            component.setLevelUpNotified(false);
        }
    }
}
