/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.components.player;

import com.bibireden.data_attributes.endec.Endecs;
import com.bibireden.data_attributes.endec.nbt.NbtDeserializer;
import com.bibireden.data_attributes.endec.nbt.NbtSerializer;
import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.PlayerEXModifiers;
import com.bibireden.playerex.api.attribute.PlayerEXAttributes;
import com.bibireden.playerex.components.PlayerEXComponents;
import com.bibireden.playerex.components.player.IPlayerDataComponent;
import com.bibireden.playerex.ext.EntityAttributeKt;
import com.bibireden.playerex.factory.ServerNetworkingFactory;
import com.bibireden.playerex.networking.NetworkingChannels;
import com.bibireden.playerex.networking.NetworkingPackets;
import com.bibireden.playerex.networking.types.NotificationType;
import com.bibireden.playerex.registry.RefundConditionRegistry;
import com.bibireden.playerex.util.PlayerEXUtil;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.sync.ComponentPacketWriter;
import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u000b\u0018\u0000 W2\u00020\u00012\u00020\u0002:\u0002XWBC\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\n2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010&\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b&\u0010'J\u001f\u0010(\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b(\u0010)J\u0017\u0010*\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b*\u0010+J\u0017\u0010-\u001a\u00020\u001a2\u0006\u0010,\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b-\u0010.J\u0017\u00100\u001a\u00020\u001a2\u0006\u0010/\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b0\u0010.J\u0017\u00101\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b1\u00102J\u001f\u00105\u001a\u00020\f2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b5\u00106J'\u00108\u001a\u00020\f2\u0006\u00107\u001a\u00020\"2\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\fH\u0016\u00a2\u0006\u0004\b8\u00109J\u001f\u0010:\u001a\u00020\f2\u0006\u00107\u001a\u00020\"2\u0006\u00103\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b:\u0010;J\u0017\u0010=\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b=\u0010>J\u0017\u0010?\u001a\u00020\u001a2\u0006\u0010<\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b?\u0010>J\u0017\u0010A\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020@H\u0016\u00a2\u0006\u0004\bA\u0010BJ\u0017\u0010E\u001a\u00020\u001a2\u0006\u0010D\u001a\u00020CH\u0016\u00a2\u0006\u0004\bE\u0010FR\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010GR\u0016\u0010\u0006\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0006\u0010HR\u0016\u0010\u0007\u001a\u00020\u00058\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0007\u0010HR\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u000b\u0010IR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010J\u001a\u0004\b\r\u0010K\"\u0004\bL\u0010MR\u001d\u0010Q\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0N8F\u00a2\u0006\u0006\u001a\u0004\bO\u0010PR\u0014\u0010T\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bR\u0010SR\u0014\u0010V\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bU\u0010S\u00a8\u0006Y"}, d2={"Lcom/bibireden/playerex/components/player/PlayerDataComponent;", "Lcom/bibireden/playerex/components/player/IPlayerDataComponent;", "Ldev/onyxstudios/cca/api/v3/component/sync/AutoSyncedComponent;", "Lnet/minecraft/class_1657;", "player", "", "_refundablePoints", "_skillPoints", "", "Lnet/minecraft/class_2960;", "", "_modifiers", "", "isLevelUpNotified", "<init>", "(Lnet/minecraft/class_1657;IILjava/util/Map;Z)V", "Lnet/minecraft/class_2487;", "toPacketNbt", "()Lnet/minecraft/class_2487;", "key", "Lkotlin/Pair;", "Lnet/minecraft/class_1324;", "getInstance", "(Lnet/minecraft/class_2960;)Lkotlin/Pair;", "Ldev/onyxstudios/cca/api/v3/component/sync/ComponentPacketWriter;", "packet", "", "sync", "(Ldev/onyxstudios/cca/api/v3/component/sync/ComponentPacketWriter;)V", "value", "trySet", "(Lnet/minecraft/class_2960;D)Z", "tryRemove", "(Lnet/minecraft/class_2960;)Z", "Lnet/minecraft/class_1320;", "attribute", "get", "(Lnet/minecraft/class_1320;)D", "set", "(Lnet/minecraft/class_1320;I)V", "add", "(Lnet/minecraft/class_1320;D)V", "remove", "(Lnet/minecraft/class_1320;)V", "percent", "reset", "(I)V", "points", "addSkillPoints", "addRefundablePoints", "(I)I", "amount", "override", "levelUp", "(IZ)Z", "skill", "skillUp", "(Lnet/minecraft/class_1320;IZ)Z", "refund", "(Lnet/minecraft/class_1320;I)Z", "tag", "readFromNbt", "(Lnet/minecraft/class_2487;)V", "writeToNbt", "Lnet/minecraft/class_3222;", "shouldSyncWith", "(Lnet/minecraft/class_3222;)Z", "Lnet/minecraft/class_2540;", "buf", "applySyncPacket", "(Lnet/minecraft/class_2540;)V", "Lnet/minecraft/class_1657;", "I", "Ljava/util/Map;", "Z", "()Z", "setLevelUpNotified", "(Z)V", "", "getModifiers", "()Ljava/util/Map;", "modifiers", "getSkillPoints", "()I", "skillPoints", "getRefundablePoints", "refundablePoints", "Companion", "Packet", "playerex-directors-cut"})
@SourceDebugExtension(value={"SMAP\nPlayerDataComponent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlayerDataComponent.kt\ncom/bibireden/playerex/components/player/PlayerDataComponent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n1#2:255\n*E\n"})
public final class PlayerDataComponent
implements IPlayerDataComponent,
AutoSyncedComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_1657 player;
    private int _refundablePoints;
    private int _skillPoints;
    @NotNull
    private Map<class_2960, Double> _modifiers;
    private boolean isLevelUpNotified;
    private static final StructEndec<Packet> ENDEC = StructEndecBuilder.of((StructField)Endec.map((Endec)Endecs.IDENTIFIER, (Endec)Endec.DOUBLE).fieldOf("modifiers", PlayerDataComponent::ENDEC$lambda$10), (StructField)Endec.INT.fieldOf("refundablePoints", PlayerDataComponent::ENDEC$lambda$11), (StructField)Endec.INT.fieldOf("skillPoints", PlayerDataComponent::ENDEC$lambda$12), (StructField)Endec.BOOLEAN.fieldOf("isLevelUpNotified", PlayerDataComponent::ENDEC$lambda$13), Packet::new);

    public PlayerDataComponent(@NotNull class_1657 player, int _refundablePoints, int _skillPoints, @NotNull Map<class_2960, Double> _modifiers, boolean isLevelUpNotified) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter(_modifiers, (String)"_modifiers");
        this.player = player;
        this._refundablePoints = _refundablePoints;
        this._skillPoints = _skillPoints;
        this._modifiers = _modifiers;
        this.isLevelUpNotified = isLevelUpNotified;
    }

    public /* synthetic */ PlayerDataComponent(class_1657 class_16572, int n, int n2, Map map, boolean bl, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        if ((n3 & 8) != 0) {
            map = new LinkedHashMap();
        }
        if ((n3 & 0x10) != 0) {
            bl = false;
        }
        this(class_16572, n, n2, map, bl);
    }

    public final boolean isLevelUpNotified() {
        return this.isLevelUpNotified;
    }

    public final void setLevelUpNotified(boolean bl) {
        this.isLevelUpNotified = bl;
    }

    private final class_2487 toPacketNbt() {
        class_2487 class_24872;
        class_2487 p0 = class_24872 = new class_2487();
        boolean bl = false;
        this.writeToNbt(p0);
        return class_24872;
    }

    private final Pair<class_1324, Boolean> getInstance(class_2960 key) {
        class_1324 instance;
        class_1320 class_13202 = (class_1320)class_7923.field_41190.method_10223(key);
        if (class_13202 == null) {
            return null;
        }
        class_1320 attribute = class_13202;
        class_1324 class_13242 = this.player.method_6127().method_26842(attribute);
        if (class_13242 == null) {
            return null;
        }
        return new Pair((Object)instance, (Object)((instance = class_13242).method_6199(PlayerEXModifiers.UUID) != null ? 1 : 0));
    }

    private final void sync(ComponentPacketWriter packet) {
        block0: {
            class_1937 class_19372;
            class_1937 it = class_19372 = this.player.method_37908();
            boolean bl = false;
            Object object = !it.method_8608() ? class_19372 : null;
            if (object == null) break block0;
            class_1937 world = object;
            boolean bl2 = false;
            PlayerEXComponents.PLAYER_DATA.sync((Object)this.player, packet);
        }
    }

    private final boolean trySet(class_2960 key, double value) {
        Pair<class_1324, Boolean> pair = this.getInstance(key);
        if (pair == null) {
            return false;
        }
        Pair<class_1324, Boolean> pair2 = pair;
        class_1324 instance = (class_1324)pair2.component1();
        boolean isPlayerEXModifierPresent = (Boolean)pair2.component2();
        if (isPlayerEXModifierPresent) {
            instance.data_attributes$updateModifier(PlayerEXModifiers.UUID, value);
        } else {
            instance.method_26837(new class_1322(PlayerEXModifiers.UUID, "PlayerEX Attribute", value, class_1322.class_1323.field_6328));
        }
        Double d = value;
        this._modifiers.put(key, d);
        return true;
    }

    private final boolean tryRemove(class_2960 key) {
        Unit unit;
        Pair<class_1324, Boolean> pair = this.getInstance(key);
        if (pair != null) {
            Pair<class_1324, Boolean> pair2 = pair;
            boolean bl = false;
            class_1324 instance = (class_1324)pair2.component1();
            boolean isModifierPresent = (Boolean)pair2.component2();
            if (isModifierPresent) {
                instance.method_6200(PlayerEXModifiers.UUID);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    @Override
    public double get(@NotNull class_1320 attribute) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        return ((Number)this._modifiers.getOrDefault(EntityAttributeKt.getId(attribute), 0.0)).doubleValue();
    }

    @Override
    public void set(@NotNull class_1320 attribute, int value) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        class_2960 identifier = EntityAttributeKt.getId(attribute);
        double attributeValue = attribute.method_6165((double)value);
        if (!this.trySet(identifier, attributeValue)) {
            return;
        }
        this.sync((arg_0, arg_1) -> PlayerDataComponent.set$lambda$3(this, arg_0, arg_1));
    }

    @Override
    public void add(@NotNull class_1320 attribute, double value) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        this.set(attribute, (int)(value + this.get(attribute)));
    }

    @Override
    public void remove(@NotNull class_1320 attribute) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        class_2960 identifier = EntityAttributeKt.getId(attribute);
        boolean it = bl = this.tryRemove(identifier);
        boolean bl2 = false;
        if (it) {
            this._modifiers.remove(identifier);
        }
        if (!bl) {
            return;
        }
        this.sync((arg_0, arg_1) -> PlayerDataComponent.remove$lambda$5(this, arg_0, arg_1));
    }

    @Override
    public void reset(int percent) {
        double partition = (double)percent / 100.0;
        Map kept = new LinkedHashMap();
        for (Map.Entry<class_2960, Double> entry : this.getModifiers().entrySet()) {
            class_2960 id = entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            if (partition == 0.0) {
                this.tryRemove(id);
                continue;
            }
            double retained = value * partition;
            if (!this.trySet(id, retained)) continue;
            Double d = retained;
            kept.put(id, d);
        }
        this._modifiers = kept;
        this._refundablePoints = (int)Math.rint((double)this._refundablePoints * partition);
        this._skillPoints = (int)Math.rint((double)this._skillPoints * partition);
        this.isLevelUpNotified = false;
        this.sync((arg_0, arg_1) -> PlayerDataComponent.reset$lambda$6(this, arg_0, arg_1));
    }

    @Override
    public void addSkillPoints(int points) {
        this._skillPoints += points;
        this.sync((arg_0, arg_1) -> PlayerDataComponent.addSkillPoints$lambda$7(this, arg_0, arg_1));
    }

    @Override
    public int addRefundablePoints(int points) {
        int previous = this.getRefundablePoints();
        double maxRefundPoints = 0.0;
        for (Function2<IPlayerDataComponent, class_1657, Double> condition : RefundConditionRegistry.INSTANCE.get()) {
            maxRefundPoints += ((Number)condition.invoke((Object)this, (Object)this.player)).doubleValue();
        }
        this._refundablePoints = (int)Math.rint(class_3532.method_15350((double)(this.getRefundablePoints() + points), (double)0.0, (double)maxRefundPoints));
        this.sync((arg_0, arg_1) -> PlayerDataComponent.addRefundablePoints$lambda$8(this, arg_0, arg_1));
        return this.getRefundablePoints() - previous;
    }

    @Override
    public boolean levelUp(int amount, boolean override) {
        boolean isEnoughExperience;
        if (amount <= 0) {
            return false;
        }
        double level = this.get((class_1320)PlayerEXAttributes.LEVEL);
        double expectedLevel = level + (double)amount;
        if (expectedLevel > PlayerEXAttributes.LEVEL.method_35062()) {
            return false;
        }
        int required = PlayerEXUtil.getRequiredXpForLevel(this.player, expectedLevel);
        boolean bl = isEnoughExperience = this.player.field_7520 >= required || override;
        if (isEnoughExperience) {
            int skillPoints = PlayerEX.CONFIG.getLevelingSettings().getSkillPointsPerLevelUp() * amount;
            if (!override) {
                this.player.method_7316(-required);
            }
            this.addSkillPoints(skillPoints);
            this.set((class_1320)PlayerEXAttributes.LEVEL, (int)expectedLevel);
            ServerNetworkingFactory.notify(this.player, NotificationType.Spent);
            return true;
        }
        return false;
    }

    @Override
    public boolean skillUp(@NotNull class_1320 skill, int amount, boolean override) {
        Intrinsics.checkNotNullParameter((Object)skill, (String)"skill");
        if (amount <= 0) {
            return false;
        }
        double current = ((Number)this._modifiers.getOrDefault(EntityAttributeKt.getId(skill), 0.0)).doubleValue();
        double expected = current + (double)amount;
        if (expected > skill.data_attributes$max()) {
            return false;
        }
        if (!override) {
            if (this.getSkillPoints() < amount) {
                return false;
            }
            this._skillPoints -= amount;
        }
        this.set(skill, (int)expected);
        NetworkingChannels.NOTIFICATIONS.serverHandle(this.player).send((Record)new NetworkingPackets.Notify(NotificationType.Spent));
        return true;
    }

    @Override
    public boolean refund(@NotNull class_1320 skill, int amount) {
        Intrinsics.checkNotNullParameter((Object)skill, (String)"skill");
        if (amount <= 0 || this.getRefundablePoints() < amount) {
            return false;
        }
        double value = ((Number)this._modifiers.getOrDefault(EntityAttributeKt.getId(skill), 0.0)).doubleValue();
        if ((double)amount > value) {
            return false;
        }
        this.addRefundablePoints(-amount);
        this.addSkillPoints(amount);
        this.set(skill, (int)(value - (double)amount));
        ServerNetworkingFactory.notify(this.player, NotificationType.Refunded);
        return true;
    }

    @NotNull
    public final Map<class_2960, Double> getModifiers() {
        return this._modifiers;
    }

    @Override
    public int getSkillPoints() {
        return this._skillPoints;
    }

    @Override
    public int getRefundablePoints() {
        return this._refundablePoints;
    }

    public void readFromNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Object object = ENDEC.decodeFully(NbtDeserializer::of, (Object)tag.method_10580("DART"));
        Packet it = (Packet)object;
        boolean bl = false;
        this._modifiers = MapsKt.toMutableMap(it.getModifiers());
        this._refundablePoints = it.getRefundablePoints();
        this._skillPoints = it.getSkillPoints();
        this.isLevelUpNotified = it.isLevelUpNotified();
    }

    public void writeToNbt(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10566("DART", (class_2520)ENDEC.encodeFully(NbtSerializer::of, (Object)new Packet(this._modifiers, this.getRefundablePoints(), this.getSkillPoints(), this.isLevelUpNotified)));
    }

    public boolean shouldSyncWith(@NotNull class_3222 player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return Intrinsics.areEqual((Object)player, (Object)this.player);
    }

    public void applySyncPacket(@NotNull class_2540 buf) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        class_2487 class_24872 = buf.method_10798();
        if (class_24872 == null) {
            return;
        }
        this.readFromNbt(class_24872);
    }

    private static final void set$lambda$3(PlayerDataComponent this$0, class_2540 buf, class_3222 player) {
        buf.method_10794(this$0.toPacketNbt());
    }

    private static final void remove$lambda$5(PlayerDataComponent this$0, class_2540 buf, class_3222 player) {
        buf.method_10794(this$0.toPacketNbt());
    }

    private static final void reset$lambda$6(PlayerDataComponent this$0, class_2540 buf, class_3222 class_32222) {
        buf.method_10794(this$0.toPacketNbt());
    }

    private static final void addSkillPoints$lambda$7(PlayerDataComponent this$0, class_2540 buf, class_3222 player) {
        buf.method_10794(this$0.toPacketNbt());
    }

    private static final void addRefundablePoints$lambda$8(PlayerDataComponent this$0, class_2540 buf, class_3222 class_32222) {
        buf.method_10794(this$0.toPacketNbt());
    }

    private static final Map ENDEC$lambda$10(Packet it) {
        return it.getModifiers();
    }

    private static final Integer ENDEC$lambda$11(Packet it) {
        return it.getRefundablePoints();
    }

    private static final Integer ENDEC$lambda$12(Packet it) {
        return it.getSkillPoints();
    }

    private static final Boolean ENDEC$lambda$13(Packet it) {
        return it.isLevelUpNotified();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R;\u0010\u0007\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/bibireden/playerex/components/player/PlayerDataComponent$Companion;", "", "<init>", "()V", "Lio/wispforest/endec/StructEndec;", "Lcom/bibireden/playerex/components/player/PlayerDataComponent$Packet;", "kotlin.jvm.PlatformType", "ENDEC", "Lio/wispforest/endec/StructEndec;", "getENDEC", "()Lio/wispforest/endec/StructEndec;", "playerex-directors-cut"})
    public static final class Companion {
        private Companion() {
        }

        public final StructEndec<Packet> getENDEC() {
            return ENDEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u00002\u00020\u0001B3\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\tH\u00c6\u0003\u00a2\u0006\u0004\b\u0012\u0010\u0013JD\u0010\u0014\u001a\u00020\u00002\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\n\u001a\u00020\tH\u00c6\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u001a\u0010\u0017\u001a\u00020\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001\u00a2\u0006\u0004\b\u0019\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001aH\u00d6\u0001\u00a2\u0006\u0004\b\u001b\u0010\u001cR#\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001d\u001a\u0004\b\u001e\u0010\u000eR\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001f\u001a\u0004\b \u0010\u0010R\u0017\u0010\b\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001f\u001a\u0004\b!\u0010\u0010R\u0017\u0010\n\u001a\u00020\t8\u0006\u00a2\u0006\f\n\u0004\b\n\u0010\"\u001a\u0004\b\n\u0010\u0013\u00a8\u0006#"}, d2={"Lcom/bibireden/playerex/components/player/PlayerDataComponent$Packet;", "", "", "Lnet/minecraft/class_2960;", "", "modifiers", "", "refundablePoints", "skillPoints", "", "isLevelUpNotified", "<init>", "(Ljava/util/Map;IIZ)V", "component1", "()Ljava/util/Map;", "component2", "()I", "component3", "component4", "()Z", "copy", "(Ljava/util/Map;IIZ)Lcom/bibireden/playerex/components/player/PlayerDataComponent$Packet;", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getModifiers", "I", "getRefundablePoints", "getSkillPoints", "Z", "playerex-directors-cut"})
    public static final class Packet {
        @NotNull
        private final Map<class_2960, Double> modifiers;
        private final int refundablePoints;
        private final int skillPoints;
        private final boolean isLevelUpNotified;

        public Packet(@NotNull Map<class_2960, Double> modifiers, int refundablePoints, int skillPoints, boolean isLevelUpNotified) {
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            this.modifiers = modifiers;
            this.refundablePoints = refundablePoints;
            this.skillPoints = skillPoints;
            this.isLevelUpNotified = isLevelUpNotified;
        }

        @NotNull
        public final Map<class_2960, Double> getModifiers() {
            return this.modifiers;
        }

        public final int getRefundablePoints() {
            return this.refundablePoints;
        }

        public final int getSkillPoints() {
            return this.skillPoints;
        }

        public final boolean isLevelUpNotified() {
            return this.isLevelUpNotified;
        }

        @NotNull
        public final Map<class_2960, Double> component1() {
            return this.modifiers;
        }

        public final int component2() {
            return this.refundablePoints;
        }

        public final int component3() {
            return this.skillPoints;
        }

        public final boolean component4() {
            return this.isLevelUpNotified;
        }

        @NotNull
        public final Packet copy(@NotNull Map<class_2960, Double> modifiers, int refundablePoints, int skillPoints, boolean isLevelUpNotified) {
            Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
            return new Packet(modifiers, refundablePoints, skillPoints, isLevelUpNotified);
        }

        public static /* synthetic */ Packet copy$default(Packet packet, Map map, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 1) != 0) {
                map = packet.modifiers;
            }
            if ((n3 & 2) != 0) {
                n = packet.refundablePoints;
            }
            if ((n3 & 4) != 0) {
                n2 = packet.skillPoints;
            }
            if ((n3 & 8) != 0) {
                bl = packet.isLevelUpNotified;
            }
            return packet.copy(map, n, n2, bl);
        }

        @NotNull
        public String toString() {
            return "Packet(modifiers=" + this.modifiers + ", refundablePoints=" + this.refundablePoints + ", skillPoints=" + this.skillPoints + ", isLevelUpNotified=" + this.isLevelUpNotified + ")";
        }

        public int hashCode() {
            int result = ((Object)this.modifiers).hashCode();
            result = result * 31 + Integer.hashCode(this.refundablePoints);
            result = result * 31 + Integer.hashCode(this.skillPoints);
            result = result * 31 + Boolean.hashCode(this.isLevelUpNotified);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Packet)) {
                return false;
            }
            Packet packet = (Packet)other;
            if (!Intrinsics.areEqual(this.modifiers, packet.modifiers)) {
                return false;
            }
            if (this.refundablePoints != packet.refundablePoints) {
                return false;
            }
            if (this.skillPoints != packet.skillPoints) {
                return false;
            }
            return this.isLevelUpNotified == packet.isLevelUpNotified;
        }
    }
}

