/*
 * Decompiled with CFR 0.152.
 */
package com.bibireden.playerex.factory;

import com.bibireden.data_attributes.api.DataAttributesAPI;
import com.bibireden.playerex.PlayerEX;
import com.bibireden.playerex.api.attribute.PlayerEXAttributes;
import com.bibireden.playerex.api.damage.DamageFunction;
import com.bibireden.playerex.api.damage.DamagePredicate;
import com.bibireden.playerex.components.player.IPlayerDataComponent;
import com.bibireden.playerex.components.player.PlayerDataComponent;
import com.bibireden.playerex.config.PlayerEXConfig;
import com.bibireden.playerex.ext.PlayerEntityKt;
import com.bibireden.playerex.predicate.FilterCheck;
import com.bibireden.playerex.registry.DamageModificationRegistry;
import com.bibireden.playerex.util.PlayerEXUtil;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEntityTypeTags;
import net.minecraft.class_117;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3300;
import net.minecraft.class_52;
import net.minecraft.class_60;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0012\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0018\u0010\u0019J%\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ%\u0010 \u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b \u0010!J%\u0010\"\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\u0007\u00a2\u0006\u0004\b\"\u0010#J%\u0010'\u001a\u00020\t2\u0006\u0010%\u001a\u00020$2\u0006\u0010\r\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001e\u00a2\u0006\u0004\b'\u0010(J+\u0010.\u001a\u00020\t2\u0006\u0010*\u001a\u00020)2\n\u0010-\u001a\u00060+R\u00020,2\u0006\u0010&\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b.\u0010/J+\u0010.\u001a\u00020\t2\u0006\u0010*\u001a\u00020)2\n\u0010-\u001a\u000600R\u00020,2\u0006\u0010&\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b.\u00101JG\u0010.\u001a\u00020\t2\u0006\u0010*\u001a\u00020)2\u0006\u00102\u001a\u00020\u00072\u0006\u00104\u001a\u0002032\u0006\u00105\u001a\u0002032\u0006\u00106\u001a\u0002032\u0006\u00107\u001a\u0002032\u0006\u0010&\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b.\u00108J5\u0010B\u001a\u00020\t2\u0006\u0010:\u001a\u0002092\u0006\u0010<\u001a\u00020;2\u0006\u0010>\u001a\u00020=2\u0006\u0010@\u001a\u00020?2\u0006\u0010\u0016\u001a\u00020A\u00a2\u0006\u0004\bB\u0010C\u00a8\u0006D"}, d2={"Lcom/bibireden/playerex/factory/EventFactory;", "", "<init>", "()V", "Lnet/minecraft/class_3222;", "oldPlayer", "newPlayer", "", "isAlive", "", "reset", "(Lnet/minecraft/class_3222;Lnet/minecraft/class_3222;Z)V", "Lnet/minecraft/class_1309;", "entity", "", "amount", "healed", "(Lnet/minecraft/class_1309;F)F", "healthRegeneration", "(Lnet/minecraft/class_1309;)V", "livingEntity", "Lnet/minecraft/class_1282;", "source", "original", "onDamage", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1282;F)F", "shouldDamage", "(Lnet/minecraft/class_1309;Lnet/minecraft/class_1282;F)Z", "Lnet/minecraft/class_1657;", "player", "Lnet/minecraft/class_1297;", "target", "onCritAttack", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1297;F)F", "attackIsCrit", "(Lnet/minecraft/class_1657;Lnet/minecraft/class_1297;Z)Z", "Lnet/minecraft/class_1937;", "level", "killedEntity", "entityWasKilled", "(Lnet/minecraft/class_1937;Lnet/minecraft/class_1297;Lnet/minecraft/class_1297;)V", "Lnet/minecraft/class_1799;", "item", "Lcom/bibireden/playerex/config/PlayerEXConfig$ArmorXpSettings;", "Lcom/bibireden/playerex/config/PlayerEXConfig;", "xpSettings", "tryLevelItem", "(Lnet/minecraft/class_1799;Lcom/bibireden/playerex/config/PlayerEXConfig$ArmorXpSettings;Lnet/minecraft/class_1297;)V", "Lcom/bibireden/playerex/config/PlayerEXConfig$WeaponXpSettings;", "(Lnet/minecraft/class_1799;Lcom/bibireden/playerex/config/PlayerEXConfig$WeaponXpSettings;Lnet/minecraft/class_1297;)V", "enabled", "", "xpFromPassive", "xpFromBoss", "xpFromHostile", "maxLevel", "(Lnet/minecraft/class_1799;ZIIIILnet/minecraft/class_1297;)V", "Lnet/minecraft/class_3300;", "resourceManager", "Lnet/minecraft/class_60;", "lootManager", "Lnet/minecraft/class_2960;", "id", "Lnet/minecraft/class_52$class_53;", "builder", "Lnet/fabricmc/fabric/api/loot/v2/LootTableSource;", "onModifyLootTable", "(Lnet/minecraft/class_3300;Lnet/minecraft/class_60;Lnet/minecraft/class_2960;Lnet/minecraft/class_52$class_53;Lnet/fabricmc/fabric/api/loot/v2/LootTableSource;)V", "playerex-directors-cut"})
@SourceDebugExtension(value={"SMAP\nEventFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventFactory.kt\ncom/bibireden/playerex/factory/EventFactory\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n216#2,2:190\n*S KotlinDebug\n*F\n+ 1 EventFactory.kt\ncom/bibireden/playerex/factory/EventFactory\n*L\n35#1:190,2\n*E\n"})
public final class EventFactory {
    @NotNull
    public static final EventFactory INSTANCE = new EventFactory();

    private EventFactory() {
    }

    public final void reset(@NotNull class_3222 oldPlayer, @NotNull class_3222 newPlayer, boolean isAlive) {
        Intrinsics.checkNotNullParameter((Object)oldPlayer, (String)"oldPlayer");
        Intrinsics.checkNotNullParameter((Object)newPlayer, (String)"newPlayer");
        int factor = PlayerEX.CONFIG.getFeatureSettings().getResetOnDeath() ? 0 : 100;
        IPlayerDataComponent iPlayerDataComponent = PlayerEntityKt.getComponent((class_1657)oldPlayer);
        Intrinsics.checkNotNull((Object)iPlayerDataComponent, (String)"null cannot be cast to non-null type com.bibireden.playerex.components.player.PlayerDataComponent");
        Map<class_2960, Double> $this$forEach$iv = ((PlayerDataComponent)iPlayerDataComponent).getModifiers();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<class_2960, Double>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            class_1320 attr;
            Map.Entry<class_2960, Double> element$iv;
            Map.Entry<class_2960, Double> entry = element$iv = iterator.next();
            boolean bl = false;
            class_2960 rl = entry.getKey();
            double value = ((Number)entry.getValue()).doubleValue();
            if ((class_1320)class_7923.field_41190.method_10223(rl) == null) continue;
            PlayerEntityKt.getComponent((class_1657)newPlayer).set(attr, (int)value);
        }
        PlayerEntityKt.getComponent((class_1657)newPlayer).reset(factor);
    }

    public final float healed(@NotNull class_1309 entity, float amount) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Float f = DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.HEAL_AMPLIFICATION), (class_1309)entity).map(arg_0 -> EventFactory.healed$lambda$2(arg_0 -> EventFactory.healed$lambda$1(amount, arg_0), arg_0)).orElse(Float.valueOf(amount));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"orElse(...)");
        return ((Number)f).floatValue();
    }

    public final void healthRegeneration(@NotNull class_1309 entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!entity.method_37908().method_8608()) {
            DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.HEALTH_REGENERATION), (class_1309)entity).ifPresent(arg_0 -> EventFactory.healthRegeneration$lambda$4(arg_0 -> EventFactory.healthRegeneration$lambda$3(entity, arg_0), arg_0));
        }
    }

    public final float onDamage(@NotNull class_1309 livingEntity, @NotNull class_1282 source, float original) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        float amount = original;
        for (DamageModificationRegistry.DamageModification condition : DamageModificationRegistry.get()) {
            float damage = amount;
            amount = condition.provide((Function2<? super DamagePredicate, ? super DamageFunction, Float>)((Function2)(arg_0, arg_1) -> EventFactory.onDamage$lambda$5(livingEntity, source, damage, arg_0, arg_1)));
        }
        return amount;
    }

    public final boolean shouldDamage(@NotNull class_1309 livingEntity, @NotNull class_1282 source, float original) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (original == 0.0f) {
            return true;
        }
        class_1297 origin = source.method_5526();
        class_1297 attacker = source.method_5529();
        if (attacker instanceof class_1309 && (origin instanceof class_1309 || origin instanceof class_1665)) {
            DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.LIFESTEAL), (class_1309)((class_1309)attacker)).ifPresent(arg_0 -> EventFactory.shouldDamage$lambda$7(arg_0 -> EventFactory.shouldDamage$lambda$6(attacker, original, arg_0), arg_0));
        }
        Boolean bl = DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.EVASION), (class_1309)livingEntity).map(arg_0 -> EventFactory.shouldDamage$lambda$9(arg_0 -> EventFactory.shouldDamage$lambda$8(livingEntity, origin, arg_0), arg_0)).orElse(true);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"orElse(...)");
        return bl;
    }

    public final float onCritAttack(@NotNull class_1657 player, @NotNull class_1297 target, float amount) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(target instanceof class_1309)) {
            return amount;
        }
        Float f = DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.MELEE_CRITICAL_DAMAGE), (class_1309)((class_1309)player)).map(arg_0 -> EventFactory.onCritAttack$lambda$11(arg_0 -> EventFactory.onCritAttack$lambda$10(amount, arg_0), arg_0)).orElse(Float.valueOf(amount));
        Intrinsics.checkNotNullExpressionValue((Object)f, (String)"orElse(...)");
        return ((Number)f).floatValue();
    }

    public final boolean attackIsCrit(@NotNull class_1657 player, @NotNull class_1297 target, boolean original) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!(target instanceof class_1309)) {
            return original;
        }
        Optional critChanceOptional = DataAttributesAPI.getValue((class_1320)((class_1320)PlayerEXAttributes.MELEE_CRITICAL_CHANCE), (class_1309)((class_1309)player));
        if (critChanceOptional.isPresent()) {
            float chance = player.method_6051().method_43057();
            return (double)chance < ((Number)critChanceOptional.get()).doubleValue() && !player.method_6101() && !player.method_6059(class_1294.field_5919) && !player.method_5765();
        }
        return original;
    }

    public final void entityWasKilled(@NotNull class_1937 level, @NotNull class_1297 entity, @NotNull class_1297 killedEntity) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        if (entity instanceof class_1657) {
            class_1799 class_17992 = ((class_1657)entity).method_6047();
            Intrinsics.checkNotNullExpressionValue((Object)class_17992, (String)"getMainHandItem(...)");
            class_1799 mainHandItem = class_17992;
            this.tryLevelItem(mainHandItem, PlayerEX.CONFIG.getWeaponLevelingSettings(), killedEntity);
            for (class_1799 item : ((class_1657)entity).method_5661()) {
                Intrinsics.checkNotNull((Object)item);
                this.tryLevelItem(item, PlayerEX.CONFIG.getArmorLevelingSettings(), killedEntity);
            }
        }
    }

    private final void tryLevelItem(class_1799 item, PlayerEXConfig.ArmorXpSettings xpSettings, class_1297 killedEntity) {
        this.tryLevelItem(item, xpSettings.getEnabled(), xpSettings.getXpFromPassive(), xpSettings.getXpFromBoss(), xpSettings.getXpFromHostile(), xpSettings.getMaxLevel(), killedEntity);
    }

    private final void tryLevelItem(class_1799 item, PlayerEXConfig.WeaponXpSettings xpSettings, class_1297 killedEntity) {
        this.tryLevelItem(item, xpSettings.getEnabled(), xpSettings.getXpFromPassive(), xpSettings.getXpFromBoss(), xpSettings.getXpFromHostile(), xpSettings.getMaxLevel(), killedEntity);
    }

    private final void tryLevelItem(class_1799 item, boolean enabled, int xpFromPassive, int xpFromBoss, int xpFromHostile, int maxLevel, class_1297 killedEntity) {
        if (PlayerEXUtil.isLevelable(item) && enabled) {
            PlayerEXUtil.levelItem(item, killedEntity.method_5864().method_5891().method_6136() ? xpFromPassive : (killedEntity.method_5864().method_5891() == class_1311.field_6302 ? (killedEntity.method_5864().method_20210(ConventionalEntityTypeTags.BOSSES) ? xpFromBoss : xpFromHostile) : 0), maxLevel);
        }
    }

    public final void onModifyLootTable(@NotNull class_3300 resourceManager, @NotNull class_60 lootManager, @NotNull class_2960 id, @NotNull class_52.class_53 builder, @NotNull LootTableSource source) {
        Intrinsics.checkNotNullParameter((Object)resourceManager, (String)"resourceManager");
        Intrinsics.checkNotNullParameter((Object)lootManager, (String)"lootManager");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        builder.method_335(EventFactory::onModifyLootTable$lambda$12);
    }

    private static final Float healed$lambda$1(float $amount, Double it) {
        double d = $amount;
        double d2 = 1.0;
        Intrinsics.checkNotNull((Object)it);
        return Float.valueOf((float)(d * (d2 + it)));
    }

    private static final Float healed$lambda$2(Function1 $tmp0, Object p0) {
        return (Float)$tmp0.invoke(p0);
    }

    private static final Unit healthRegeneration$lambda$3(class_1309 $entity, Double value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value > 0.0 && $entity.method_6032() < $entity.method_6063()) {
            $entity.method_6025((float)value.doubleValue());
        }
        return Unit.INSTANCE;
    }

    private static final void healthRegeneration$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final float onDamage$lambda$5(class_1309 $livingEntity, class_1282 $source, float $damage, DamagePredicate predicate, DamageFunction function) {
        Intrinsics.checkNotNullParameter((Object)predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        return predicate.test($livingEntity, $source, $damage) ? function.apply($livingEntity, $source, $damage) : $damage;
    }

    private static final Unit shouldDamage$lambda$6(class_1297 $attacker, float $original, Double it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        ((class_1309)$attacker).method_6025((float)((double)$original * it));
        return Unit.INSTANCE;
    }

    private static final void shouldDamage$lambda$7(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Boolean shouldDamage$lambda$8(class_1309 $livingEntity, class_1297 $origin, Double it) {
        return !((double)$livingEntity.method_6051().method_43057() < it) || !($origin instanceof class_1665);
    }

    private static final Boolean shouldDamage$lambda$9(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Float onCritAttack$lambda$10(float $amount, Double it) {
        double d = (double)$amount / 1.5;
        Intrinsics.checkNotNull((Object)it);
        return Float.valueOf((float)(d * (1.5 + it)));
    }

    private static final Float onCritAttack$lambda$11(Function1 $tmp0, Object p0) {
        return (Float)$tmp0.invoke(p0);
    }

    private static final class_117 onModifyLootTable$lambda$12() {
        return new FilterCheck();
    }
}

