/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.ultraleafdecay.config;

import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    private final JavaPlugin plugin;
    private int maxLogDistance;
    private String reloadPermission;
    private Component noPermissionToReload;
    private Component configReloaded;

    public Config(JavaPlugin plugin) {
        this.plugin = plugin;
        plugin.saveDefaultConfig();
        this.reload();
    }

    public void reload() {
        this.plugin.reloadConfig();
        FileConfiguration config = this.plugin.getConfig();
        this.maxLogDistance = config.getInt("max-log-distance", 6);
        this.reloadPermission = config.getString("reload-permission", "ultraLeafDecay.reload");
        this.noPermissionToReload = MiniMessage.miniMessage().deserialize((Object)config.getString("no-permission-to-reload", "<red>\u2718 <white>You don't have permission to reload Config!"));
        this.configReloaded = MiniMessage.miniMessage().deserialize((Object)config.getString("config-reloaded", "<green>\u2714 <white>Config reloaded!"));
    }

    public int getMaxLogDistance() {
        return this.maxLogDistance;
    }

    public String getReloadPermission() {
        return this.reloadPermission;
    }

    public Component getNoPermissionToReload() {
        return this.noPermissionToReload;
    }

    public Component getConfigReloaded() {
        return this.configReloaded;
    }
}

