/*
 * Decompiled with CFR 0.152.
 */
package me.stokmenn.ultraleafdecay.listeners;

import me.stokmenn.ultraleafdecay.config.Config;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.LeavesDecayEvent;

public record BlockBreakListener(Config config) implements Listener
{
    private static final BlockFace[] NEIGHBOURS = new BlockFace[]{BlockFace.NORTH, BlockFace.EAST, BlockFace.SOUTH, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN};

    @EventHandler
    public void onLeavesDecay(LeavesDecayEvent event) {
        Block block = event.getBlock();
        if (this.isInvalidLeaf(block)) {
            return;
        }
        this.handleLeafDecay(block);
    }

    private void handleLeafDecay(Block block) {
        for (BlockFace face : NEIGHBOURS) {
            Block neighbour = block.getRelative(face);
            if (this.isInvalidLeaf(neighbour)) continue;
            neighbour.breakNaturally();
            this.handleLeafDecay(neighbour);
        }
    }

    private boolean isInvalidLeaf(Block block) {
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Leaves)) {
            return true;
        }
        Leaves leaves = (Leaves)blockData;
        return leaves.isPersistent() || leaves.getDistance() < this.config.getMaxLogDistance();
    }
}

