/*
 * Decompiled with CFR 0.152.
 */
package club.iananderson.pocketgps.config;

import club.iananderson.pocketgps.energy.EnergyUnit;
import net.minecraftforge.common.ForgeConfigSpec;

public class PocketGpsConfig {
    public static final ForgeConfigSpec GENERAL_SPEC;
    private static ForgeConfigSpec.ConfigValue<EnergyUnit> energyUnit;
    private static ForgeConfigSpec.BooleanValue gpsNeedPower;
    private static ForgeConfigSpec.IntValue gpsEnergyCapacity;
    private static ForgeConfigSpec.IntValue gpsMaxInput;
    private static ForgeConfigSpec.IntValue gpsMaxOutput;
    private static ForgeConfigSpec.IntValue gpsEnergyCost;

    private PocketGpsConfig() {
    }

    private static void setupConfig(ForgeConfigSpec.Builder builder) {
        builder.push("PocketGps");
        builder.push("Power");
        energyUnit = builder.comment("Which energy unit to display for Forge?\nDefault is FE.").defineEnum("energy_unit", (Enum)EnergyUnit.FE);
        gpsNeedPower = builder.comment("Require the Gps to have power in order to display the minimap?\n(true/false)\nDefault is false.").define("need_power", false);
        gpsEnergyCapacity = builder.comment("How much the power the GPS can hold.\nDefault 40000").defineInRange("gps_capacity", 40000, 0, Integer.MAX_VALUE);
        gpsMaxInput = builder.comment("The maximum input the GPS can receive when charging.\nDefault 128").defineInRange("gps_max_input", 128, 0, Integer.MAX_VALUE);
        gpsMaxOutput = builder.comment("How much power the GPS can output.\nDefault 128").defineInRange("gps_max_output", 128, 0, Integer.MAX_VALUE);
        gpsEnergyCost = builder.comment("Power cost of the GPS while moving (per tick).\nDefault 2").defineInRange("gps_energy_cost", 2, 0, Integer.MAX_VALUE);
        builder.pop();
        builder.pop();
    }

    public static EnergyUnit getEnergyUnit() {
        return (EnergyUnit)((Object)energyUnit.get());
    }

    public static void setEnergyUnit(EnergyUnit unit) {
        energyUnit.set((Object)unit);
    }

    public static boolean getGpsNeedPower() {
        return (Boolean)gpsNeedPower.get();
    }

    public static void setGpsNeedPower(boolean enable) {
        gpsNeedPower.set((Object)enable);
    }

    public static int getGpsEnergyCapacity() {
        return (Integer)gpsEnergyCapacity.get();
    }

    public static void setGpsEnergyCapacity(int power) {
        gpsEnergyCapacity.set((Object)power);
    }

    public static int getGpsMaxInput() {
        return (Integer)gpsMaxInput.get();
    }

    public static void setGpsMaxInput(int power) {
        gpsMaxInput.set((Object)power);
    }

    public static int getGpsMaxOutput() {
        return (Integer)gpsMaxOutput.get();
    }

    public static void setGpsMaxOutput(int power) {
        gpsMaxOutput.set((Object)power);
    }

    public static int getGpsEnergyCost() {
        return (Integer)gpsEnergyCost.get();
    }

    public static void setGpsEnergyCost(int power) {
        gpsEnergyCost.set((Object)power);
    }

    static {
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        PocketGpsConfig.setupConfig(builder);
        GENERAL_SPEC = builder.build();
    }
}

